/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mock-network-menu.h"

static NetworkMenu *object;

G_DEFINE_TYPE (NetworkMenu, network_menu, DBUSMENU_TYPE_MENUITEM)

#define GET_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NETWORK_MENU, NetworkMenuPrivate))

typedef struct _NetworkMenuPrivate NetworkMenuPrivate;

struct _NetworkMenuPrivate {
  gboolean enabled;
};

static void
network_menu_dispose (GObject *object)
{
  G_OBJECT_CLASS (network_menu_parent_class)->dispose (object);
}

static void
network_menu_finalize (GObject *object)
{
  G_OBJECT_CLASS (network_menu_parent_class)->finalize (object);
}

static void
network_menu_class_init (NetworkMenuClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private (klass, sizeof (NetworkMenuPrivate));

  object_class->dispose = network_menu_dispose;
  object_class->finalize = network_menu_finalize;
}

static void
network_menu_init (NetworkMenu *self)
{
  NetworkMenuPrivate *priv = GET_PRIVATE(self);

  priv->enabled = FALSE;
}

void network_menu_disable(NetworkMenu *self)
{
  NetworkMenuPrivate *priv = GET_PRIVATE(self);

  priv->enabled = FALSE;
}

void network_menu_enable(NetworkMenu *self)
{
  NetworkMenuPrivate *priv = GET_PRIVATE(self);

  priv->enabled = TRUE;
}

NetworkMenu *network_menu_new(Manager *ns)
{
  object = g_object_new(TYPE_NETWORK_MENU, NULL);
  return object;
}

/* mock functions */

NetworkMenu *network_menu_mock_get_object()
{
  return object;
}

gboolean network_menu_mock_get_enabled(NetworkMenu *self)
{
  NetworkMenuPrivate *priv = GET_PRIVATE(self);

  return priv->enabled;
}

