/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "service-manager.h"

#include <glib.h>

#include "service.h"
#include "connman.h"
#include "manager.h"
#include "marshal.h"

G_DEFINE_TYPE (ServiceManager, service_manager, G_TYPE_OBJECT)

#define GET_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERVICE_MANAGER, 	\
				ServiceManagerPrivate))

typedef struct _ServiceManagerPrivate ServiceManagerPrivate;

struct _ServiceManagerPrivate {
  gint padding;
};

enum {
  STATE_CHANGED,
  STRENGTH_UPDATED,
  SERVICES_UPDATED,
  DEFAULT_SERVICE_CHANGED,
  LAST_SIGNAL,
};

static guint signals[LAST_SIGNAL] = { 0 };

static void service_manager_dispose(GObject *object)
{
  G_OBJECT_CLASS (service_manager_parent_class)->dispose (object);
}

static void service_manager_finalize(GObject *object)
{
  G_OBJECT_CLASS (service_manager_parent_class)->finalize (object);
}

static void service_manager_class_init(ServiceManagerClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private (klass, sizeof (ServiceManagerPrivate));

  object_class->dispose = service_manager_dispose;
  object_class->finalize = service_manager_finalize;

  signals[STATE_CHANGED] = g_signal_new("state-changed",
					G_TYPE_FROM_CLASS(klass),
					G_SIGNAL_RUN_LAST,
					0, NULL, NULL,
					_marshal_VOID__VOID,
					G_TYPE_NONE, 0);

  signals[STRENGTH_UPDATED] = g_signal_new("strength-updated",
					G_TYPE_FROM_CLASS(klass),
					G_SIGNAL_RUN_LAST,
					0, NULL, NULL,
					_marshal_VOID__UINT,
					G_TYPE_NONE, 1,
					G_TYPE_UINT);

  signals[SERVICES_UPDATED] = g_signal_new("services-updated",
					   G_TYPE_FROM_CLASS(klass),
					   G_SIGNAL_RUN_LAST,
					   0, NULL, NULL,
					   _marshal_VOID__VOID,
					   G_TYPE_NONE, 0);

  signals[DEFAULT_SERVICE_CHANGED] = g_signal_new("default-service-changed",
					   G_TYPE_FROM_CLASS(klass),
					   G_SIGNAL_RUN_LAST,
					   0, NULL, NULL,
					   _marshal_VOID__VOID,
					   G_TYPE_NONE, 0);
}

static void service_manager_init(ServiceManager *self)
{
}

ServiceManager *service_manager_new(Manager *ns)
{
  return g_object_new (TYPE_SERVICE_MANAGER, NULL);
}

void service_manager_remove_all(ServiceManager *self)
{
}

void service_manager_update_services(ServiceManager *self,
				     ConnmanService **services)
{
}

GList *service_manager_get_wired(ServiceManager *self)
{
  return NULL;
}

GList *service_manager_get_wireless(ServiceManager *self)
{
  return NULL;
}

GList *service_manager_get_cellular(ServiceManager *self)
{
  return NULL;
}

gboolean service_manager_is_connecting(ServiceManager *self)
{
  return FALSE;
}

gboolean service_manager_is_connected(ServiceManager *self)
{
  return FALSE;
}

guint service_manager_get_connected(ServiceManager *self)
{
  return 0;
}
