/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "ui-proxy.h"

#include "indicator-network-agent-xml.h"
#include "dbus-shared-names.h"

G_DEFINE_TYPE(UIProxy, ui_proxy, G_TYPE_OBJECT)

#define GET_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE((o), TYPE_UI_PROXY, \
			       UIProxyPrivate))

typedef struct _UIProxyPrivate UIProxyPrivate;

struct _UIProxyPrivate {
  gboolean connected;
};

enum
{
  /* reserved */
  PROP_0,

  PROP_CONNECTED,
};

void ui_proxy_start(UIProxy *self)
{
}

void ui_proxy_stop(UIProxy *self)
{
}

void ui_proxy_show_connect_error(UIProxy *self, const gchar *error_id)
{
}

void ui_proxy_show_wireless_connect(UIProxy *self)
{
}

void ui_proxy_set_debug(UIProxy *self, guint level)
{
}

void ui_proxy_ask_pin(UIProxy *self, const gchar *type,
		      GCancellable *cancellable, GAsyncReadyCallback callback,
		      gpointer user_data)
{
}

gchar *ui_proxy_ask_pin_finish(UIProxy *self, GAsyncResult *res, GError **error)
{
  return "1234";
}

gboolean ui_proxy_is_connected(UIProxy *self)
{
  UIProxyPrivate *priv = GET_PRIVATE(self);

  return priv->connected;
}

static void ui_proxy_set_property(GObject *object, guint property_id,
				  const GValue *value, GParamSpec *pspec)
{
  UIProxy *self = UI_PROXY(object);
  UIProxyPrivate *priv = GET_PRIVATE(self);

  g_return_if_fail(priv != NULL);

  switch(property_id) {
  case PROP_CONNECTED:
    priv->connected = g_value_get_boolean(value);
    break;
  default:
    /* We don't have any other property... */
    G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
    break;
  }
}

static void ui_proxy_get_property(GObject *object, guint property_id,
				  GValue *value, GParamSpec *pspec)
{
  UIProxy *self = UI_PROXY(object);
  UIProxyPrivate *priv = GET_PRIVATE(self);

  g_return_if_fail(priv != NULL);

  switch(property_id) {
  case PROP_CONNECTED:
    g_value_set_boolean(value, priv->connected);
    break;
  default:
    /* We don't have any other property... */
    G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
    break;
  }
}

static void ui_proxy_dispose(GObject *object)
{
  G_OBJECT_CLASS(ui_proxy_parent_class)->dispose(object);
}

static void ui_proxy_finalize(GObject *object)
{
  G_OBJECT_CLASS(ui_proxy_parent_class)->finalize(object);
}

static void ui_proxy_class_init(UIProxyClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
  GParamSpec *pspec;

  g_type_class_add_private(klass, sizeof(UIProxyPrivate));

  gobject_class->dispose = ui_proxy_dispose;
  gobject_class->finalize = ui_proxy_finalize;
  gobject_class->set_property = ui_proxy_set_property;
  gobject_class->get_property = ui_proxy_get_property;

  pspec = g_param_spec_boolean("connected",
			       "UiProxy's connected property",
			       "Informs when object is connected for use",
			       FALSE,
			       G_PARAM_READABLE);
  g_object_class_install_property(gobject_class, PROP_CONNECTED, pspec);
}

static void ui_proxy_init(UIProxy *self)
{
}

UIProxy *ui_proxy_new(void)
{
  return  g_object_new(TYPE_UI_PROXY, NULL);
}
