#!/usr/bin/env python

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#  CompositeTogglerScreenlet (c) Whise 2007 

import screenlets
from screenlets.options import ColorOption
from screenlets import DefaultMenuItem
import pango
import gobject
import random
import gtk
import cairo
import gconf
#use gettext for translation
import gettext

_ = screenlets.utils.get_translator(__file__)

def tdoc(obj):
	obj.__doc__ = _(obj.__doc__)
	return obj

@tdoc

class CompositeTogglerScreenlet (screenlets.Screenlet):
	"""A Screenlet that allows to instantly change metacity's composite state"""
	
	# default meta-info for Screenlets (should be removed and put into metainfo)
	__name__	= 'CompositeTogglerScreenlet'
	__version__	= '0.1.2'
	__author__	= 'Helder Fraga aka Whise'
	__desc__	= __doc__	# set description to docstring of class
	
	# editable options (options that are editable through the UI)
	use_gradient = True

	font = "Sans Normal 12"
	color_text = (1,1,1,0.8)
	frame_color = (1,1,1,0.8)
	toggle_color = (0,1,0,0.8)

	composite_enabled = None
	
	def __init__ (self, **keyword_args):
		"""Constructor"""
		#call super (width/height MUST match the size of graphics in the theme)
		screenlets.Screenlet.__init__(self, width=100, height=70, 
			uses_theme=True,ask_on_option_override=False, **keyword_args)
		
		# add option group and options
		self.add_options_group(_('Options'), _('Options'))
		self.add_option(ColorOption(_('Options'),'frame_color', 
			(1, 1, 1, 1), _('Frame color'), 
			_('Frame color')))
		self.add_option(ColorOption(_('Options'),'toggle_color', 
			(0, 0, 0, 0.6), _('Toggle color'), 
			_('Toggle color')))
		
		self.add_default_menuitems()
		
		self.gconf_client = gconf.client_get_default() 
		self.gconf_key = "/apps/metacity/general/compositing_manager" #
		self.gconf_client.notify_add(self.gconf_key, self.update) 
		self.update()

	def update (self):
		self.composite_enabled = bool(self.gconf_client.get_bool(self.gconf_key))
		self.redraw_canvas()
		return True # keep running this event	
	
	# ONLY FOR TESTING!!!!!!!!!
	def init_options_from_metadata (self):
		"""Try to load metadata-file with options. The file has to be named
		like the Screenlet, with the extension ".xml" and needs to be placed
		in the Screenlet's personal directory. 
		NOTE: This function always uses the metadata-file relative to the 
			  Screenlet's location, not the ones in SCREENLETS_PATH!!!"""
		print __file__
		p = __file__.rfind('/')
		mypath = __file__[:p]
		print mypath
		self.add_options_from_file( mypath + '/' + \
			self.__class__.__name__ + '.xml')	

	def on_mouse_down(self,event):
		x = event.x / self.scale
		y = event.y / self.scale
		
		if event.button == 1 and y >= 28 and x >= 72 and x <= 87:
			if y <= 43 and y >= 28:
				print 'setting composite to true'
				self.gconf_client.set_bool(self.gconf_key, True) 
				self.composite_enabled = True
				self.redraw_canvas()
				
			elif y >= 45 and y <60:
				print 'setting composite to false'
				self.gconf_client.set_bool(self.gconf_key, False) 
				self.composite_enabled = False
				self.redraw_canvas()
	
	def on_draw (self, ctx):
		"""Called automatically by the Screenlet baseclass
		to (re)draw the screenlet."""
		ctx.scale(self.scale,self.scale)
		if self.use_gradient:
			gradient = cairo.LinearGradient(0, self.height*2,0, 0)
			gradient.add_color_stop_rgba(1,*self.frame_color)
			gradient.add_color_stop_rgba(0.7, self.frame_color[0],
				self.frame_color[1], self.frame_color[2], 1-self.frame_color[3]+0.5)

			ctx.set_source(gradient)
		else:
			ctx.set_source(self.frame_color)
		self.draw_rectangle_advanced (ctx, 0, 0, self.width-12, self.height-12,
			rounded_angles=(5,5,5,5), fill=True, border_size=2, border_color=(0,0,0,0.5),
			shadow_size=6, shadow_color=(0,0,0,0.5))
		ctx.set_source_rgba(*self.toggle_color)
		self.draw_text(ctx, _('Composite'), 0, 10,  'FreeSans', 10, self.width, pango.ALIGN_CENTER)
		self.draw_text(ctx, _('On'), 17, 28,  'FreeSans', 10, self.width)
		self.draw_text(ctx, _('Off'), 17, 45,  'FreeSans', 10, self.width)
		self.draw_circle (ctx, self.width-28, 28, 14, 12,fill=False)
		if self.composite_enabled:
			self.draw_circle (ctx, self.width-25, 30, 8, 8,fill=True)
		else:
			self.draw_circle (ctx, self.width-25, 47, 8, 8,fill=True)
		self.draw_circle (ctx, self.width-28, 45, 14, 12,fill=False)
				
	def on_draw_shape (self, ctx):
		self.on_draw(ctx)
	
# If the program is run directly or passed as an argument to the python
# interpreter then create a Screenlet instance and show it
if __name__ == "__main__":
	# create new session
	import screenlets.session
	screenlets.session.create_session(CompositeTogglerScreenlet)

