/*
 * Copyright (C) 2011-2012 Daniel Scharrer
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author(s) be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

#include "setup/ini.hpp"

#include <stdint.h>

#include "setup/version.hpp"
#include "util/load.hpp"
#include "util/storedenum.hpp"

namespace setup {

namespace {

STORED_FLAGS_MAP(stored_ini_flags,
	ini_entry::CreateKeyIfDoesntExist,
	ini_entry::UninsDeleteEntry,
	ini_entry::UninsDeleteEntireSection,
	ini_entry::UninsDeleteSectionIfEmpty,
	ini_entry::HasValue,
);

} // anonymous namespace

void ini_entry::load(std::istream & is, const version & version) {
	
	if(version < INNO_VERSION(1, 3, 21)) {
		::load<uint32_t>(is); // uncompressed size of the ini entry structure
	}
	
	is >> encoded_string(inifile, version.codepage());
	if(inifile.empty()) {
		inifile = "{windows}/WIN.INI";
	}
	is >> encoded_string(section, version.codepage());
	is >> encoded_string(key, version.codepage());
	is >> encoded_string(value, version.codepage());
	
	load_condition_data(is, version);
	
	load_version_data(is, version);
	
	if(version.bits != 16) {
		options = stored_flags<stored_ini_flags>(is).get();
	} else {
		options = stored_flags<stored_ini_flags, 16>(is).get();
	}
}

} // namespace setup

NAMES(setup::ini_entry::flags, "Ini Option",
	"create key if doesn't exist",
	"uninstall delete entry",
	"uninstall delete section",
	"uninstall delete section if empty",
	"has value",
)
