/***************************************************************************
                         MD2file.cpp  -  description
                            -------------------
   begin                : Sun Aug 20 2000
   copyright            : (C) 2000 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "md2file.h"
#include <vector>
#include <iostream.h>
#include <basecontroller.h>

extern "C"
{
   FilePlugin * i3d_createInstance()
   {
      return new MD2File();
   }
}

MD2File::MD2File() : FilePlugin( "MD2", "md2" )
{
   setImportable( true );
   //setExportable(true);
   setBinary( true );

}

MD2File::~MD2File()
{}

void MD2File::importData( ifstream &in )
{

   uvs.clear();
   verts.clear();
   triangles.clear();

   readHeader( in );

   readSkins( header.offsetSkins, in );
   readTexCoords( header.offsetTexCoords, in );
   readTriangles( header.offsetTriangles, in );
   readFrames( header.offsetFrames, in );
   readGlCommands( header.offsetGlCommands, in );

   createObject();


}

void MD2File::createObject()
{
   int frms = 3;
   Mesh * m = new Mesh();

   //create the vertices for the first frame;
   Vector4 pos;

   for ( int i = 0; i < header.numVertices; i++ )
   {
      Vertex *v;
      pos = verts[ 0 ][ i ];
      v = m -> createVertex( pos.x, pos.y, pos.z );
      //save a keyframe every 2 frames for each MD2 frame
      v -> setAnimatable( true );
      Controller *c = v -> getController();
      c -> saveTime( 1 );

      for ( int j = 1; j < header.numFrames; j++ )
      {
         pos = verts[ j ][ i ];
         v -> setPosition( pos.x, pos.y, pos.z );
         c -> saveTime( 1 + j*frms );
      }
   }

   //BaseController::getInstance()->setMaxTime( ( header.numFrames ) );
   //create the triangles for the mesh
   for ( int i = 0; i < header.numTriangles; i++ )
   {

      Face *f = m -> createFace( triangles[ i ].vertexIndices[ 0 ], triangles[ i ].vertexIndices[ 1 ], triangles[ i ].vertexIndices[ 2 ] );

      f->setUVCoord( 0, uvs[ triangles[ i ].textureIndices[ 0 ] ] );
      f->setUVCoord( 1, uvs[ triangles[ i ].textureIndices[ 1 ] ] );
      f->setUVCoord( 2, uvs[ triangles[ i ].textureIndices[ 2 ] ] );

   }

   m->normalize();
   addEntity( m );

}

void MD2File::readHeader( ifstream &in )
{
   in.read( &header, sizeof( model_t ) );
}

void MD2File::readFrames( int offset, ifstream &in )
{


   in.seekg( offset );

   frame_t frame;
   vertex_t fverts[ header.numVertices ];
   vertex_t temp_vert;

   Vector4 pos;

   for ( int i = 0; i < header.numFrames; i++ )
   {
      vector<Vector4> frame_verts;
      frame_verts.reserve( header.numFrames );
      in.read( &frame, sizeof( frame_t ) );
      in.read( fverts, sizeof( vertex_t ) * header.numVertices );

      for ( int j = 0; j < header.numVertices; j++ )
      {
         int x = fverts[ j ].vertex[ 0 ];
         int y = fverts[ j ].vertex[ 1 ];
         int z = fverts[ j ].vertex[ 2 ];

         //swap the y and z axis.
         pos.x = ( ( float ) x ) * frame.scale[ 0 ] + frame.translate[ 0 ];
         pos.z = ( ( float ) y ) * frame.scale[ 1 ] + frame.translate[ 1 ];
         pos.y = ( ( float ) z ) * frame.scale[ 2 ] + frame.translate[ 2 ];
         frame_verts.push_back( pos );
      }

      verts.push_back( frame_verts );
   }

}

void MD2File::readTexCoords( int offset, ifstream &in )
{

   in.seekg( offset );

   tcoord_t uv;
   Vector4 pos;

   for ( int i = 0; i < header.numTexCoords; i++ )
   {
      in.read( &uv, sizeof( uv ) );
      pos.x = ( ( float ) uv.s ) / header.skinWidth;
      pos.y = 1 - ( ( float ) uv.t ) / header.skinHeight;
      uvs.push_back( pos );
   }
}

void MD2File::readTriangles( int offset, ifstream &in )
{
   in.seekg( offset );

   triangle_t triangle;

   for ( int i = 0; i < header.numTriangles; i++ )
   {
      in.read( &triangle, sizeof( triangle_t ) );
      triangles.push_back( triangle );
   }
}

void MD2File::readSkins( int offset, ifstream &in )
{
   in.seekg( offset );

}

void MD2File::readGlCommands( int offset, ifstream &in )
{
   in.seekg( offset );

}




void MD2File::exportData( ofstream &out )
{
}

void MD2File::writeHeader( ofstream & )
{}

