#
# CONFIGURE_GLUT([ACTION-IF-FOUND [,ACTION-IF-NOT-FOUND]])
#
AC_DEFUN(CONFIGURE_GLUT,
[
  GLUT_CFLAGS=""
  GLUT_LIBS=""
  glut_includes="/usr/include"
  glut_libraries="/usr/lib"

  AC_ARG_WITH(glut-prefix,
    [  --with-glut-prefix=PFX     Prefix where GLUT is installed],
    [
      glut_includes="$withval/include"
      glut_libraries="$withval/lib"
    ])

  AC_ARG_WITH(glut-includes,
    [  --with-glut-includes=DIR   where the GLUT includes are installed],
    [
      glut_includes="$withval"
    ])

  AC_ARG_WITH(glut-libraries,
    [  --with-glut-libraries=DIR  where the GLUT libraries are installed],
    [
      glut_libraries="$withval"
    ])

  GLUT_CFLAGS="-I$glut_includes"
  GLUT_LIBS="-L$glut_libraries"

  saved_CFLAGS="$CFLAGS"
  saved_LIBS="$LIBS"
  AC_LANG_SAVE
  AC_LANG_C
  have_GLUT=no

  # test for GLUT
  if test "$have_GLUT" = no; then
    AC_MSG_CHECKING([for GLUT ($glut_libraries) ])
    CFLAGS="$saved_CFLAGS $GLUT_CFLAGS $X11_CFLAGS"
    LIBS="$saved_LIBS -lGLU -lGL -lglut $X11_LIBS"
    AC_TRY_LINK(,[glutSwapBuffers(); ], have_GLUT=yes, have_GLUT=no)
    AC_MSG_RESULT($have_GLUT)
    if test "$have_GLUT" = yes; then
      GLUT_LIBS="-lglut"
    fi
  fi


  LIBS="$saved_LIBS"
  CFLAGS="$saved_CFLAGS"
  AC_LANG_RESTORE

  if test "$have_GLUT" = "yes"; then
     ifelse([$1], , :, [$1])
  else
     GLUT_CFLAGS=""
     GLUT_LIBS=""
     ifelse([$2], , :, [$2])
  fi
  AC_SUBST(GLUT_CFLAGS)
  AC_SUBST(GLUT_LIBS)
])



