/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Instantbird messenging client, released
 * 2008.
 *
 * The Initial Developer of the Original Code is
 * Florian QUEZE <florian@instantbird.org>.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "purpleTooltipInfo.h"
#include <nsIClassInfoImpl.h>
#include <nsIProgrammingLanguage.h>
#include <nsMemory.h>

// 630ABD2A-D50B-4F32-81E7-E7D3981D9296
#define PURPLE_TOOLTIP_INFO_CID                        \
  { 0x630ABD2A, 0xD50B, 0x4F32,                        \
    { 0x81, 0xE7, 0xE7, 0xD3, 0x98, 0x1D, 0x92, 0x96 } \
  }

NS_IMPL_CLASSINFO(purpleTooltipInfo, NULL, 0, PURPLE_TOOLTIP_INFO_CID)
NS_IMPL_THREADSAFE_CI(purpleTooltipInfo)
NS_IMPL_ISUPPORTS1_CI(purpleTooltipInfo, purpleITooltipInfo)

purpleTooltipInfo::purpleTooltipInfo()
{
  /* member initializers and constructor code */
  mType = -1;
}

purpleTooltipInfo::~purpleTooltipInfo()
{
  /* destructor code */
}

void purpleTooltipInfo::Init(PurpleNotifyUserInfoEntry *aEntry)
{
  mType = purple_notify_user_info_entry_get_type(aEntry);
  mLabel = purple_notify_user_info_entry_get_label(aEntry);
  char *value =
    purple_unescape_html(purple_notify_user_info_entry_get_value(aEntry));
  mValue = value;
  g_free(value);
}

/* readonly attribute short type; */
NS_IMETHODIMP purpleTooltipInfo::GetType(PRInt16 *aType)
{
  NS_ENSURE_TRUE(mType != -1, NS_ERROR_NOT_INITIALIZED);

  *aType = mType;
  return NS_OK;
}

/* readonly attribute AUTF8String label; */
NS_IMETHODIMP purpleTooltipInfo::GetLabel(nsACString& aLabel)
{
  NS_ENSURE_TRUE(mType != -1, NS_ERROR_NOT_INITIALIZED);

  aLabel = mLabel;
  return NS_OK;
}

/* readonly attribute AUTF8String value; */
NS_IMETHODIMP purpleTooltipInfo::GetValue(nsACString& aValue)
{
  NS_ENSURE_TRUE(mType != -1, NS_ERROR_NOT_INITIALIZED);

  aValue = mValue;
  return NS_OK;
}
