/*
integrit - file integrity verification system
Copyright (C) 2005 Ed L. Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef	ELC_MD5_H
#define	ELC_MD5_H

/* size of the MD5 checksum is in md5.c's md5_get_info routine */
#define	MD5_DIGEST_LENGTH 16

typedef struct {
    uint32_t A,B,C,D;	  /* chaining variables */
    uint32_t  nblocks;
    uint8_t buf[64];
    int  count;
} MD5_CONTEXT;

void md5_init( MD5_CONTEXT *ctx );

/* (md5_write is the equivalent of what others call md5_update) */
void md5_write( MD5_CONTEXT *hd, uint8_t *inbuf, size_t inlen);

void md5_final( MD5_CONTEXT *hd );

uint8_t *md5_read( MD5_CONTEXT *hd );

#endif
