/*========================== begin_copyright_notice ============================

Copyright (C) 2020-2022 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//===- ZEInfoYAML.cpp -----------------------------------------------*- C++ -*-===//
// ZE Binary Utilitis
//
// file
//===----------------------------------------------------------------------===//

// ******************** DO NOT MODIFY DIRECTLY *********************************
// This file is auto-generated by ZEAutoTool/fileparser.py

#include <ZEInfoYAML.hpp>
using namespace zebin;
using namespace llvm::yaml;

void MappingTraits<zeInfoContainer>::mapping(IO& io, zeInfoContainer& info)
{
    io.mapRequired("version", info.version);
    io.mapRequired("kernels", info.kernels);
    io.mapOptional("functions", info.functions, FunctionsTy());
    io.mapOptional("global_host_access_table", info.global_host_access_table, HostAccessesTy());
}
void MappingTraits<zeInfoKernel>::mapping(IO& io, zeInfoKernel& info)
{
    io.mapRequired("name", info.name);
    io.mapRequired("execution_env", info.execution_env);
    io.mapOptional("payload_arguments", info.payload_arguments, PayloadArgumentsTy());
    io.mapOptional("per_thread_payload_arguments", info.per_thread_payload_arguments, PerThreadPayloadArgumentsTy());
    io.mapOptional("binding_table_indices", info.binding_table_indices, BindingTableIndicesTy());
    io.mapOptional("per_thread_memory_buffers", info.per_thread_memory_buffers, PerThreadMemoryBuffersTy());
    io.mapOptional("experimental_properties", info.experimental_properties, zeInfoExperimentalProperties());
    io.mapOptional("debug_env", info.debug_env, zeInfoDebugEnv());
}
void MappingTraits<zeInfoFunction>::mapping(IO& io, zeInfoFunction& info)
{
    io.mapRequired("name", info.name);
    io.mapRequired("execution_env", info.execution_env);
}
void MappingTraits<zeInfoExecutionEnv>::mapping(IO& io, zeInfoExecutionEnv& info)
{
    io.mapOptional("barrier_count", info.barrier_count, 0);
    io.mapOptional("disable_mid_thread_preemption", info.disable_mid_thread_preemption, false);
    io.mapRequired("grf_count", info.grf_count);
    io.mapOptional("has_4gb_buffers", info.has_4gb_buffers, false);
    io.mapOptional("has_device_enqueue", info.has_device_enqueue, false);
    io.mapOptional("has_dpas", info.has_dpas, false);
    io.mapOptional("has_fence_for_image_access", info.has_fence_for_image_access, false);
    io.mapOptional("has_global_atomics", info.has_global_atomics, false);
    io.mapOptional("has_multi_scratch_spaces", info.has_multi_scratch_spaces, false);
    io.mapOptional("has_no_stateless_write", info.has_no_stateless_write, false);
    io.mapOptional("has_stack_calls", info.has_stack_calls, false);
    io.mapOptional("require_disable_eufusion", info.require_disable_eufusion, false);
    io.mapOptional("inline_data_payload_size", info.inline_data_payload_size, 0);
    io.mapOptional("offset_to_skip_per_thread_data_load", info.offset_to_skip_per_thread_data_load, 0);
    io.mapOptional("offset_to_skip_set_ffid_gp", info.offset_to_skip_set_ffid_gp, 0);
    io.mapOptional("required_sub_group_size", info.required_sub_group_size, 0);
    io.mapOptional("required_work_group_size", info.required_work_group_size);
    io.mapRequired("simd_size", info.simd_size);
    io.mapOptional("slm_size", info.slm_size, 0);
    io.mapOptional("subgroup_independent_forward_progress", info.subgroup_independent_forward_progress, false);
    io.mapOptional("thread_scheduling_mode", info.thread_scheduling_mode, std::string());
    io.mapOptional("work_group_walk_order_dimensions", info.work_group_walk_order_dimensions);
}
void MappingTraits<zeInfoPayloadArgument>::mapping(IO& io, zeInfoPayloadArgument& info)
{
    io.mapRequired("arg_type", info.arg_type);
    io.mapRequired("offset", info.offset);
    io.mapRequired("size", info.size);
    io.mapOptional("arg_index", info.arg_index, -1);
    io.mapOptional("addrmode", info.addrmode, std::string());
    io.mapOptional("addrspace", info.addrspace, std::string());
    io.mapOptional("access_type", info.access_type, std::string());
    io.mapOptional("sampler_index", info.sampler_index, -1);
    io.mapOptional("source_offset", info.source_offset, -1);
    io.mapOptional("slm_alignment", info.slm_alignment, 0);
}
void MappingTraits<zeInfoPerThreadPayloadArgument>::mapping(IO& io, zeInfoPerThreadPayloadArgument& info)
{
    io.mapRequired("arg_type", info.arg_type);
    io.mapRequired("offset", info.offset);
    io.mapRequired("size", info.size);
}
void MappingTraits<zeInfoBindingTableIndex>::mapping(IO& io, zeInfoBindingTableIndex& info)
{
    io.mapRequired("bti_value", info.bti_value);
    io.mapRequired("arg_index", info.arg_index);
}
void MappingTraits<zeInfoPerThreadMemoryBuffer>::mapping(IO& io, zeInfoPerThreadMemoryBuffer& info)
{
    io.mapRequired("type", info.type);
    io.mapRequired("usage", info.usage);
    io.mapRequired("size", info.size);
    io.mapOptional("slot", info.slot, 0);
    io.mapOptional("is_simt_thread", info.is_simt_thread, false);
}
void MappingTraits<zeInfoExperimentalProperties>::mapping(IO& io, zeInfoExperimentalProperties& info)
{
    io.mapOptional("has_non_kernel_arg_load", info.has_non_kernel_arg_load, -1);
    io.mapOptional("has_non_kernel_arg_store", info.has_non_kernel_arg_store, -1);
    io.mapOptional("has_non_kernel_arg_atomic", info.has_non_kernel_arg_atomic, -1);
}
void MappingTraits<zeInfoDebugEnv>::mapping(IO& io, zeInfoDebugEnv& info)
{
    io.mapOptional("sip_surface_bti", info.sip_surface_bti, -1);
    io.mapOptional("sip_surface_offset", info.sip_surface_offset, -1);
}
void MappingTraits<zeInfoHostAccess>::mapping(IO& io, zeInfoHostAccess& info)
{
    io.mapRequired("device_name", info.device_name);
    io.mapRequired("host_name", info.host_name);
}
