/*===================== begin_copyright_notice ==================================

# Copyright (c) 2019-2022, Intel Corporation

# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.

======================= end_copyright_notice ==================================*/


//! \file     mhw_vdbox_vdenc_xe_hpm.h
//! \details  Defines functions for constructing Vdbox Vdenc commands on Xe_HPM platform
//!

#ifndef __MHW_VDBOX_VDENC_XE_HPM_H__
#define __MHW_VDBOX_VDENC_XE_HPM_H__

#ifdef IGFX_VDENC_INTERFACE_EXT_SUPPORT
#include "mhw_vdbox_vdenc_hwcmd_ext.h"
#endif
#include "mhw_vdbox_vdenc_hwcmd_xe_hpm.h"
#include "mhw_vdbox_vdenc_g12_X.h"
#include "mhw_vdbox_xe_xpm.h"
#include "mos_solo_generic.h"
#include "mhw_vdbox_vdenc_impl_xe_hpm.h"

using PMHW_VDBOX_AVC_IMG_PARAMS_XE_HPM = MHW_VDBOX_AVC_IMG_PARAMS_XE_XPM *;

static const uint32_t tableCmd3[5][2][52][22] = {
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x200000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x20003,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x240000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x30004,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x2c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x30005,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x300000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x40006,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1a0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x40008,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1e0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x5000a,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x200000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x5000d,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x240000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x60010,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1a0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x70014,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1e0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x8001a,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1e0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x90021,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x180000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xa0029,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x1c0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xb0034,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x180000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xd0042,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x180000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xe0053,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x140000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x100068,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x140000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x120084,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x160000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x1400a6,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x140000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x1700d1,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x140000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x1a0108,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x140000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x1d014c,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x120000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x2101a3,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x120000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x250210,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x290299,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x2e0346,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x340420,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x3a0533,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x42068d,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x4a0841,
    0x5010000, 0x1f1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x530a66,
    0x5010000, 0x2a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x5d0d1a,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x681082,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x7514cc,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0x100000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x841a34,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0xe0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0x942104,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0xe0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xa62999,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0xe0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xba3469,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0xe0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xd14209,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc240400, 0x0, 0xe0000, 0xc0e2406, 0x0, 0x0, 0x0, 0x0, 0xeb5333,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20002,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x20003,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30004,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30005,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40006,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40008,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x5000a,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x5000d,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x60010,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x70014,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x8001a,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x90021,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xa0029,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xb0034,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xd0042,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xe0053,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x100068,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x120084,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1400a6,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1700d1,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1a0108,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1d014c,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x2101a3,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x250210,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x290299,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x2e0346,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x340420,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x3a0533,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x42068d,
    0x5010000, 0x1a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x4a0841,
    0x5010000, 0x1f1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x530a66,
    0x5010000, 0x2a1a0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x5d0d1a,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x681082,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x7514cc,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x841a34,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x942104,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xa62999,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xba3469,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xd14209,
    0x5010000, 0x2d1f0a0a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b00009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xeb5333,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0x100000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0x120000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0x140000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x40005,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xa0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x50006,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x60008,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x6000a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0x100000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x7000c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x80010,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x90014,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xa0019,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xc0020,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xd0028,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xf0032,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x100040,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x130050,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xc0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x150065,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x180080,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x1a00a1,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x1e00cb,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x210100,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x260142,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x2a0196,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x300200,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x350285,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x3c032c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x430400,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x4c050a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x550659,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x600800,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x6b0a14,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x780cb2,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x871000,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x981428,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xab1965,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xc02000,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xd72851,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0xf132cb,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x4040002, 0xc240400, 0x0, 0xe0000, 0x12102c06, 0x0, 0x0, 0x0, 0x0, 0x10f4000,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30002,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40005,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x50006,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x60008,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x6000a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x7000c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x80010,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x90014,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xa0019,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xc0020,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xd0028,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xf0032,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x100040,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x130050,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x150065,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x180080,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1a00a1,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1e00cb,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x210100,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x260142,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x2a0196,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x300200,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x350285,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x3c032c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x430400,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x4c050a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x550659,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x600800,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x6b0a14,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x780cb2,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x871000,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x981428,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xab1965,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xc02000,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xd72851,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xf132cb,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0xd150617, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x10f4000,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0x100000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x40005,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0x120000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x50006,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0x140000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x50008,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xa0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x6000a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x7000c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x80010,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0x100000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x90014,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xa0019,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xb0020,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xc0028,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xe0033,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x100040,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x120051,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x140066,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x160081,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xc0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x1900a2,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x1c00cc,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x200102,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x240145,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x280199,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x2d0204,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x33028a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x390333,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x400408,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x480514,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x510666,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x5b0810,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x660a28,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x730ccc,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x811020,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x911451,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xa21999,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xb62041,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xcd28a3,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0xe63333,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x1024082,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x1225146,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0xc040000, 0xc240400, 0x0, 0xe0000, 0x20103506, 0x0, 0x0, 0x0, 0x0, 0x1456666,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40005,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x50006,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x50008,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x6000a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x7000c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x80010,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x90014,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xa0019,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xb0020,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xc0028,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xe0033,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x100040,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x120051,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x140066,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x160081,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1900a2,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1c00cc,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x200102,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x240145,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x280199,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x2d0204,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x33028a,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x390333,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x400408,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x480514,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x510666,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x5b0810,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x660a28,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x730ccc,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x811020,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x911451,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xa21999,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xb62041,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xcd28a3,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xe63333,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1024082,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1225146,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0x16100a03, 0x302a231d, 0x4a433d36, 0x0, 0x0, 0x0, 0x101a061d, 0x9b04009b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1456666,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40006,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x50007,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x60009,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x6000c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x7000f,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x80013,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x90018,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xb001e,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xc0026,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xd0030,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xf003c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x11004c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x130060,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x160079,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x180099,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1b00c1,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1f00f3,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x230133,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x270183,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x2c01e7,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x310266,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x370306,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x3e03cf,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x4604cc,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x4f060c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x58079e,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x630999,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x6f0c18,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x7d0f3d,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x8c1333,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x9e1830,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xb11e7a,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xc72666,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xdf3061,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xfa3cf4,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1194ccc,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x13c60c3,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x16279e9,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x18e9999,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40006,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x50007,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x60009,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x6000c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x7000f,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x80013,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x90018,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xb001e,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xc0026,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xd0030,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xf003c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x11004c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x130060,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x160079,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x180099,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1b00c1,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1f00f3,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x230133,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x270183,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x2c01e7,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x310266,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x370306,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x3e03cf,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x4604cc,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x4f060c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x58079e,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x630999,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x6f0c18,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x7d0f3d,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x8c1333,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x9e1830,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xb11e7a,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xc72666,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xdf3061,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xfa3cf4,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1194ccc,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x13c60c3,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x16279e9,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x18e9999,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x40005,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x50007,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x50009,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x6000b,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x7000e,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x80012,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x90016,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xa001c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xb0024,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xc002d,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xe0039,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x100048,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x12005b,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x140073,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x160091,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1900b6,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1c00e6,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x200122,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x24016d,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x2801cc,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x2d0244,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x3302db,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x390399,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x400489,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x4805b6,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x510733,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x5b0912,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x660b6d,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x730e66,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x811224,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x9116db,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xa21ccc,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xb62449,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xcd2db7,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0xe63999,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1024892,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1225b6f,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x4040402, 0xc240400, 0x0, 0xe0000, 0x16102a06, 0x0, 0x0, 0x0, 0x0, 0x1457333,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x30003,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40004,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x40005,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x50007,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x50009,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x6000b,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x7000e,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x80012,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x90016,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xa001c,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xb0024,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xc002d,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xe0039,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x100048,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x12005b,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x140073,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x160091,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1900b6,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1c00e6,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x200122,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x24016d,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x2801cc,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x2d0244,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x3302db,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x390399,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x400489,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x4805b6,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x510733,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x5b0912,
    0x5010000, 0x1a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x660b6d,
    0x5010000, 0x1f1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x730e66,
    0x5010000, 0x2a1a0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x811224,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x9116db,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xa21ccc,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xb62449,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xcd2db7,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0xe63999,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1024892,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1225b6f,
    0x5010000, 0x2d1f0a0a, 0x1c140c04, 0x3c342c24, 0x5c544c44, 0xb080502, 0x1714110e, 0x23201d1a, 0x0, 0x0, 0x0, 0x18230c24, 0x9b04049b, 0x9b9b9b00, 0x9b9b9b00, 0x9b0000, 0x9b9b9b9b, 0x0, 0x0, 0x9b9b, 0x0, 0x1457333
};

static const uint32_t tableAvcImgState[7][4][3][2][2][2][19] = {
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029400, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028480, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70029407, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028487, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72029207, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028287, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028244, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028240, 0x0, 0x0, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xf000000, 0x6400002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0xbd0088, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028243, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028247, 0x0, 0x0, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xf000000, 0x4b00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00000, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028160, 0x0, 0x800, 0x0, 0x0, 0xffff0000, 0x2000, 0x0, 0x3e80000, 0xbb807d0, 0xf000000, 0x7d00002, 0xff200000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x3200000, 0x9600640, 0xfff0000, 0x6400002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x70028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028164, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0xbd0888, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028162, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00000, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012,
    0x301, 0x72028264, 0x0, 0x800, 0x80000000, 0x0, 0xffff0000, 0x2000, 0x0, 0x2580000, 0x70804b0, 0xfff0000, 0x4b00002, 0xffe00000, 0xbb80002, 0xe100004, 0x13880006, 0x1f40000a, 0x23280012
};

static const uint32_t tableAvcImgState_DW8[53] = {
    0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000,
    0x2000000, 0x1000000, 0x1000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000,
    0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x4000000, 0x4000000, 0x2000000,
    0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x4000000, 0x8000000,
    0x8000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000,
    0x8000000, 0x8000000, 0x8000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000, 0x2000000,
    0x2000000, 0x2000000, 0x8000000, 0x8000000, 0x8000000
};

template<> inline uint32_t
MhwVdboxVdencInterfaceGeneric<mhw::vdbox::vdenc::xe_hpm::Cmd>::GetVdencCmd3Size()
{
    return mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_CMD3_CMD::byteSize;
}

template<> inline MOS_STATUS
MhwVdboxVdencInterfaceGeneric<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencConstQPStateCmd(
    PMOS_COMMAND_BUFFER                cmdBuffer,
    PMHW_VDBOX_VDENC_CQPT_STATE_PARAMS params)
{
    return MOS_STATUS_SUCCESS;
}

//!
//! \brief  Explictly instantiate AddVdencPipeModeSelectCmd of MhwVdboxVdencInterfaceG12 for mhw::vdbox::vdenc::xe_hpm::Cmd
//!         to because programming of DW1.PakChromaSubSamplingType has changed
//!
template<> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencPipeModeSelectCmd(
    PMOS_COMMAND_BUFFER                cmdBuffer,
    PMHW_VDBOX_PIPE_MODE_SELECT_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(cmdBuffer);
    MHW_MI_CHK_NULL(params);
    MHW_MI_CHK_NULL(m_osInterface);

    auto paramsG12 = dynamic_cast<PMHW_VDBOX_PIPE_MODE_SELECT_PARAMS_G12>(params);
    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_MODE_SELECT_CMD cmd;
    MEDIA_WA_TABLE *pWaTable = m_osInterface->pfnGetWaTable(m_osInterface);
    MHW_CHK_NULL_RETURN(pWaTable);

    cmd.DW1.StandardSelect  = CodecHal_GetStandardFromMode(params->Mode);
    cmd.DW1.ScalabilityMode = !(paramsG12->MultiEngineMode == MHW_VDBOX_HCP_MULTI_ENGINE_MODE_FE_LEGACY);
    if (CODECHAL_ENCODE_MODE_HEVC == params->Mode || CODECHAL_ENCODE_MODE_AVC == params->Mode)
    {
        cmd.DW1.FrameStatisticsStreamOutEnable = paramsG12->bBRCEnabled || paramsG12->bAdaptiveRounding || paramsG12->bLookaheadPass;
    }
    else
    {
        cmd.DW1.FrameStatisticsStreamOutEnable = 1;
    }
    cmd.DW1.VdencPakObjCmdStreamOutEnable = params->bVdencPakObjCmdStreamOutEnable;
    cmd.DW1.TlbPrefetchEnable             = 0;
    cmd.DW1.PakThresholdCheckEnable       = params->bDynamicSliceEnable;
    cmd.DW1.VdencStreamInEnable           = params->bVdencStreamInEnable;
    cmd.DW1.BitDepth                      = params->ucVdencBitDepthMinus8;
    cmd.DW1.PakChromaSubSamplingType      = params->ChromaType;

    // by default RGB to YUV using full to studio range
    // can add a DDI flag to control if needed
    cmd.DW1.OutputRangeControlAfterColorSpaceConversion = 1;

    // for tile encoding
    cmd.DW1.TileReplayEnable = paramsG12->bTileBasedReplayMode;
    cmd.DW1.IsRandomAccess = paramsG12->bIsRandomAccess;

    // When this pre-fetch is enabled,TLB Prefetch Enable in VDENC_PIPE_MODE select (DW 1 bit 7) should be disabled.
    cmd.DW2.HmeRegionPreFetchenable                      = 1;
    if (MEDIA_IS_WA(pWaTable, Wa_22011549751) && !m_osInterface->bSimIsActive && !Mos_Solo_Extension(m_osInterface->pOsContext) &&
        (((CODECHAL_ENCODE_MODE_HEVC == params->Mode) && !params->bIBCEnabled) || CODECHAL_ENCODE_MODE_VP9 == params->Mode))
    {
        cmd.DW2.HmeRegionPreFetchenable = !(params->isIFrame);
    }
    cmd.DW2.Topprefetchenablemode                        = 0;
    cmd.DW2.LeftpreFetchatwraparound                     = 1;
    cmd.DW2.Verticalshift32Minus1                        = 2;
    cmd.DW2.Hzshift32Minus1                              = 3;
    cmd.DW2.NumVerticalReqMinus1                         = 6;
    cmd.DW2.Numhzreqminus1                               = 2;
    cmd.DW2.PreFetchOffsetForReferenceIn16PixelIncrement = 0;

    if(cmd.DW1.StandardSelect == CODECHAL_AVC && paramsG12->tuSettingsRevision == 1)
    {
        // override perf settings for AVC codec on B-stepping
        cmd.DW2.Verticalshift32Minus1            = 0;
        cmd.DW2.Hzshift32Minus1                  = 15;
        cmd.DW2.NumVerticalReqMinus1             = 5;
        cmd.DW2.Numhzreqminus1                   = 0;
        cmd.DW5.VDENC_PIPE_MODE_SELECT_DW5_BIT8  = 1;
        cmd.DW5.VDENC_PIPE_MODE_SELECT_DW5_BIT17 = 1;
    }

    // For RGB encoding
    if (paramsG12->bRGBEncodingMode)
    {
        cmd.DW1.RgbEncodingEnable = 1;
    }

    // For parallel encode from display
    if (paramsG12->bWirelessEncodeEnabled)
    {
        cmd.DW5.CaptureMode                       = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_MODE_SELECT_CMD::CAPTURE_MODE_UNNAMED1;
        cmd.DW5.ParallelCaptureAndEncodeSessionId = paramsG12->ucWirelessSessionId;
        cmd.DW5.TailPointerReadFrequency          = 0x50;
    }

    if (paramsG12->bStreamingBufferEnabled)
    {
        cmd.DW1.StreamingBufferConfig = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_MODE_SELECT_CMD::STREAMING_BUFFER_64;
        cmd.DW5.CaptureMode           = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_MODE_SELECT_CMD::CAPTURE_MODE_CAMERA;
    }

    MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}

template<> inline uint32_t
MhwVdboxVdencInterfaceGeneric<mhw::vdbox::vdenc::xe_hpm::Cmd>::GetVdencAvcImgStateSize()
{
    return mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_AVC_IMG_STATE_CMD::byteSize;
}

template <> inline uint32_t
MhwVdboxVdencInterfaceGeneric<mhw::vdbox::vdenc::xe_hpm::Cmd>::GetVdencAvcSlcStateSize()
{
    return mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_AVC_SLICE_STATE_CMD::byteSize;
}

template<> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencAvcWeightsOffsetsStateCmd(
    PMOS_COMMAND_BUFFER                cmdBuffer,
    PMHW_VDBOX_AVC_WEIGHTOFFSET_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(cmdBuffer);
    MHW_MI_CHK_NULL(params);
    MHW_MI_CHK_NULL(params->pAvcPicParams);

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WEIGHTSOFFSETS_STATE_CMD cmd;
    auto avcPicParams = params->pAvcPicParams;

    if (avcPicParams->weighted_pred_flag)
    {
        cmd.DW1.WeightsForwardReference0  = params->Weights[0][0][0][0];
        cmd.DW1.OffsetForwardReference0   = params->Weights[0][0][0][1];
        cmd.DW1.WeightsForwardReference1  = params->Weights[0][1][0][0];
        cmd.DW1.OffsetForwardReference1   = params->Weights[0][1][0][1];
        cmd.DW2.WeightsForwardReference2  = params->Weights[0][2][0][0];
        cmd.DW2.OffsetForwardReference2   = params->Weights[0][2][0][1];
    }

    if (avcPicParams->weighted_bipred_idc == EXPLICIT_WEIGHTED_INTER_PRED_MODE)
    {
        cmd.DW2.WeightsBackwardReference0 = params->Weights[1][0][0][0];
        cmd.DW2.OffsetBackwardReference0  = params->Weights[1][0][0][1];
    }

    MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}

template<> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencWeightsOffsetsStateCmd(
    PMOS_COMMAND_BUFFER                   cmdBuffer,
    PMHW_BATCH_BUFFER                     batchBuffer,
    PMHW_VDBOX_VDENC_WEIGHT_OFFSET_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(params);

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WEIGHTSOFFSETS_STATE_CMD cmd;

    // Luma Offsets and Weights
    if (params->bWeightedPredEnabled)
    {
        uint32_t  refPicListNum = 0;
        cmd.DW1.WeightsForwardReference0 = CodecHal_Clip3(-128, 127,
            params->LumaWeights[refPicListNum][0] + params->dwDenom);
        cmd.DW1.OffsetForwardReference0  = params->LumaOffsets[refPicListNum][0];
        cmd.DW1.WeightsForwardReference1 = CodecHal_Clip3(-128, 127,
            params->LumaWeights[refPicListNum][1] + params->dwDenom);
        cmd.DW1.OffsetForwardReference1  = params->LumaOffsets[refPicListNum][1];
        cmd.DW2.WeightsForwardReference2 = CodecHal_Clip3(-128, 127,
            params->LumaWeights[refPicListNum][2] + params->dwDenom);
        cmd.DW2.OffsetForwardReference2  = params->LumaOffsets[refPicListNum][2];

        cmd.DW2.WeightsBackwardReference0 = 0;
        cmd.DW2.OffsetBackwardReference0  = 0;
        if (!params->isLowDelay)
        {
            refPicListNum = 1;
            cmd.DW2.WeightsBackwardReference0 = CodecHal_Clip3(-128, 127,
                params->LumaWeights[refPicListNum][0] + params->dwDenom);
            cmd.DW2.OffsetBackwardReference0 = params->LumaOffsets[refPicListNum][0];
        }
        else
        {
            cmd.DW2.WeightsBackwardReference0 = cmd.DW1.WeightsForwardReference0;
            cmd.DW2.OffsetBackwardReference0 = cmd.DW1.OffsetForwardReference0;
        }

        // DWORD 3
        refPicListNum = 0;
        cmd.DW3.CbWeightsForwardReference0 = CodecHal_Clip3(-128, 127,
            params->ChromaWeights[refPicListNum][0][0] + params->dwChromaDenom);
        cmd.DW3.CbOffsetForwardReference0 = params->ChromaOffsets[refPicListNum][0][0];
        cmd.DW3.CbWeightsForwardReference1 = CodecHal_Clip3(-128, 127,
            params->ChromaWeights[refPicListNum][1][0] + params->dwChromaDenom);
        cmd.DW3.CbOffsetForwardReference1 = params->ChromaOffsets[refPicListNum][1][0];

        // DWORD 4
        cmd.DW4.CbWeightsForwardReference2 = CodecHal_Clip3(-128, 127,
            params->ChromaWeights[refPicListNum][2][0] + params->dwChromaDenom);
        cmd.DW4.CbOffsetForwardReference2 = params->ChromaOffsets[refPicListNum][2][0];
        if (!params->isLowDelay)
        {
            refPicListNum = 1;
            cmd.DW4.CbWeightsBackwardReference0 = CodecHal_Clip3(-128, 127,
                params->ChromaWeights[refPicListNum][0][0] + params->dwChromaDenom);
            cmd.DW4.CbOffsetBackwardReference0 = params->ChromaOffsets[refPicListNum][0][0];
        }
        else
        {
            cmd.DW4.CbWeightsBackwardReference0 = cmd.DW3.CbWeightsForwardReference0;
            cmd.DW4.CbOffsetBackwardReference0 = cmd.DW3.CbOffsetForwardReference0;
        }

        // DWORD 5
        refPicListNum = 0;
        cmd.DW5.CrWeightsForwardReference0 = CodecHal_Clip3(-128, 127,
            params->ChromaWeights[refPicListNum][0][1] + params->dwChromaDenom);
        cmd.DW5.CrOffsetForwardReference0 = params->ChromaOffsets[refPicListNum][0][1];
        cmd.DW5.CrWeightsForwardReference1 = CodecHal_Clip3(-128, 127,
            params->ChromaWeights[refPicListNum][1][1] + params->dwChromaDenom);
        cmd.DW5.CrOffsetForwardReference1 = params->ChromaOffsets[refPicListNum][1][1];

        // DWORD 6
        cmd.DW6.CrWeightsForwardReference2 = CodecHal_Clip3(-128, 127,
            params->ChromaWeights[refPicListNum][2][1] + params->dwChromaDenom);
        cmd.DW6.CrOffsetForwardReference2 = params->ChromaOffsets[refPicListNum][2][1];
        if (!params->isLowDelay)
        {
            refPicListNum = 1;
            cmd.DW6.CrWeightsBackwardReference0 = CodecHal_Clip3(-128, 127,
                params->ChromaWeights[refPicListNum][0][1] + params->dwChromaDenom);
            cmd.DW6.CrOffsetBackwardReference0 = params->ChromaOffsets[refPicListNum][0][1];
        }
        else
        {
            cmd.DW6.CrWeightsBackwardReference0 = cmd.DW5.CrWeightsForwardReference0;
            cmd.DW6.CrOffsetBackwardReference0 = cmd.DW5.CrOffsetForwardReference0;
        }
    }
    if (cmdBuffer == nullptr && batchBuffer == nullptr)
    {
        MHW_ASSERTMESSAGE("There was no valid buffer to add the HW command to.");
        return MOS_STATUS_NULL_POINTER;
    }

    MHW_MI_CHK_STATUS(Mhw_AddCommandCmdOrBB(cmdBuffer, batchBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}

template<> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencImgStateCmd(
    PMOS_COMMAND_BUFFER       cmdBuffer,
    PMHW_BATCH_BUFFER         batchBuffer,
    PMHW_VDBOX_AVC_IMG_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(params);
    MHW_MI_CHK_NULL(params->pEncodeAvcSeqParams);
    MHW_MI_CHK_NULL(params->pEncodeAvcPicParams);

    if (cmdBuffer == nullptr && batchBuffer == nullptr)
    {
        MHW_ASSERTMESSAGE("There was no valid buffer to add the HW command to.");
        return MOS_STATUS_NULL_POINTER;
    }

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_AVC_IMG_STATE_CMD cmd;

    auto paramsG12 = static_cast<PMHW_VDBOX_AVC_IMG_PARAMS_XE_HPM>(params);
    auto seqParams = params->pEncodeAvcSeqParams;
    auto picParams = params->pEncodeAvcPicParams;
    auto slcParams = params->pEncodeAvcSliceParams;

    auto waTable = m_osInterface->pfnGetWaTable(m_osInterface);
    MHW_MI_CHK_NULL(waTable);

    auto tuMinus1       = seqParams->TargetUsage - 1;
    auto codingType     = picParams->CodingType;
    auto pictureType    = codingType - 1;
    auto type           = codingType == I_TYPE ? 0 : codingType == P_TYPE ? 1 : picParams->RefPicFlag ? 3 : 2;
    auto ir             = picParams->EnableRollingIntraRefresh > ROLLING_I_ROW ? ROLLING_I_ROW : picParams->EnableRollingIntraRefresh;
    auto aStep          = MEDIA_IS_WA(waTable, WaEnableOnlyASteppingFeatures);
    auto wa_18011246551 = MEDIA_IS_WA(waTable, Wa_18011246551);
    uint32_t refPoc[2][3] = {};

    MHW_ASSERT(tuMinus1 < 7);
    MHW_ASSERT(pictureType < NUM_PIC_TYPES);

    MOS_SecureMemcpy((uint8_t*)&cmd + sizeof(uint32_t),
                     cmd.byteSize - sizeof(uint32_t),
                     tableAvcImgState[tuMinus1][type][ir][aStep][wa_18011246551][params->bVdencStreamInEnabled],
                     19 * sizeof(uint32_t));

    cmd.DW1.PictureType      = pictureType;
    cmd.DW1.Transform8X8Flag = picParams->transform_8x8_mode_flag;
    cmd.DW1.SubpelMode       = 3;
    cmd.DW1.colloc_mv_wr_en  = paramsG12->colMVWriteEnable;

    if (codingType == B_TYPE)
    {
        if (params->pEncodeAvcPicParams->weighted_bipred_idc == 2)
        {
            cmd.DW2.BidirectionalWeight = params->biWeight;
        }
        else
        {
            cmd.DW2.BidirectionalWeight = 0x20;
        }
    }
    cmd.DW2.colloc_mv_rd_en = paramsG12->colMVReadEnable;

    cmd.DW3.PictureHeightMinusOne = params->wPicHeightInMb - 1;
    cmd.DW3.PictureWidth          = params->wPicWidthInMb;

    if (codingType != I_TYPE)
    {
        cmd.DW5.NumberOfL0ReferencesMinusOne = slcParams->num_ref_idx_l0_active_minus1;
        cmd.DW5.NumberOfL1ReferencesMinusOne = slcParams->num_ref_idx_l1_active_minus1;

        if (!paramsG12->oneOnOneMapping)
        {
            MHW_CHK_STATUS_RETURN(slcParams->num_ref_idx_l0_active_minus1 > 2);
            uint8_t fwdRefIdx[3] = {0xf, 0xf, 0xf};
            for (auto i = 0; i < slcParams->num_ref_idx_l0_active_minus1 + 1; i++)
            {
                auto id = slcParams->RefPicList[LIST_0][i].FrameIdx;
                id = params->pPicIdx[id].ucPicIdx;
                fwdRefIdx[i] = params->ppRefList[id]->ucFrameId;
                refPoc[0][i] = params->ppRefList[id]->iFieldOrderCnt[0];
            }
            cmd.DW5.FwdRefIdx0ReferencePicture = fwdRefIdx[0];
            cmd.DW5.FwdRefIdx1ReferencePicture = fwdRefIdx[1];
            cmd.DW5.FwdRefIdx2ReferencePicture = fwdRefIdx[2];

            if (codingType == B_TYPE)
            {
                auto id = slcParams->RefPicList[LIST_1][0].FrameIdx;
                id = params->pPicIdx[id].ucPicIdx;
                cmd.DW5.BwdRefIdx0ReferencePicture = params->ppRefList[id]->ucFrameId;
                refPoc[1][0]                       = params->ppRefList[id]->iFieldOrderCnt[0];
            }
        }
    }

    // Rolling-I settings
    if (codingType != I_TYPE && picParams->EnableRollingIntraRefresh != ROLLING_I_DISABLED)
    {
        cmd.DW6.IntraRefreshMbPos                = picParams->IntraRefreshMBNum;
        cmd.DW6.IntraRefreshMbSizeMinusOne       = picParams->IntraRefreshUnitinMB;
        cmd.DW6.IntraRefreshEnableRollingIEnable = picParams->EnableRollingIntraRefresh != ROLLING_I_DISABLED ? 1 : 0;
        cmd.DW6.IntraRefreshMode                 = picParams->EnableRollingIntraRefresh == ROLLING_I_ROW ? 0 : 1;
        cmd.DW6.QpAdjustmentForRollingI          = picParams->IntraRefreshQPDelta;
    }

    cmd.DW8.Value = (cmd.DW8.Value & 0xffff) | tableAvcImgState_DW8[seqParams->Level];

    cmd.DW9.RoiQpAdjustmentForZone0 = 0;
    cmd.DW9.RoiQpAdjustmentForZone1 = 0;
    cmd.DW9.RoiQpAdjustmentForZone2 = 0;
    cmd.DW9.RoiQpAdjustmentForZone3 = 0;

    cmd.DW12.MinQp = 0xa;
    cmd.DW12.MaxQp = 0x33;

    // VDEnc CQP case ROI settings, BRC ROI will be handled in HuC FW
    if (!params->bVdencBRCEnabled && picParams->NumROI && picParams->bNativeROI)
    {
        int8_t priorityLevelOrDQp[ENCODE_VDENC_AVC_MAX_ROI_NUMBER_ADV] = {0};

        for (uint8_t i = 0; i < picParams->NumROI; i++)
        {
            // clip delta qp roi to VDEnc supported range
            if (picParams->ROIDistinctDeltaQp[i] == 0)
            {
                break;
            }
            priorityLevelOrDQp[i] = (char)CodecHal_Clip3(
                ENCODE_VDENC_AVC_MIN_ROI_DELTA_QP_G9, ENCODE_VDENC_AVC_MAX_ROI_DELTA_QP_G9, picParams->ROIDistinctDeltaQp[i]);
        }

        cmd.DW13.RoiEnable = true;

        // Zone0 is reserved for non-ROI region
        cmd.DW9.RoiQpAdjustmentForZone1 = priorityLevelOrDQp[0];
        cmd.DW9.RoiQpAdjustmentForZone2 = priorityLevelOrDQp[1];
        cmd.DW9.RoiQpAdjustmentForZone3 = priorityLevelOrDQp[2];
    }

    cmd.DW13.RoiEnable = params->bVdencStreamInEnabled && picParams->EnableRollingIntraRefresh == ROLLING_I_DISABLED &&
        (picParams->NumDirtyROI && params->bVdencBRCEnabled || picParams->NumROI && picParams->bNativeROI ||
         (picParams->TargetFrameSize > 0 && !seqParams->LookaheadDepth));

    cmd.DW13.MbLevelQpEnable = params->bVdencStreamInEnabled && picParams->EnableRollingIntraRefresh == ROLLING_I_DISABLED &&
        (picParams->NumROI && !picParams->bNativeROI || paramsG12->bStreamInMbQpEnabled);

    cmd.DW13.MbLevelDeltaQpEnable = paramsG12->bStreamInMbQpEnabled && picParams->NumDeltaQpForNonRectROI;

    const uint8_t refFrameId = slcParams->RefPicList[1][0].FrameIdx;
    cmd.DW13.LongtermReferenceFrameBwdRef0Indicator = (refFrameId >= CODEC_AVC_MAX_NUM_REF_FRAME) ? 0 : CodecHal_PictureIsLongTermRef(picParams->RefFrameList[refFrameId]);

    cmd.DW14.QpPrimeY       = picParams->QpY + slcParams->slice_qp_delta;
    cmd.DW14.TrellisQuantEn = params->dwTqEnabled;

    cmd.DW15.PocNumberForCurrentPicture = paramsG12->ppRefList[paramsG12->pEncodeAvcPicParams->CurrReconstructedPic.FrameIdx]->iFieldOrderCnt[0];
    cmd.DW16.PocNumberForFwdRef0        = refPoc[0][0];
    cmd.DW17.PocNumberForFwdRef1        = refPoc[0][1];
    cmd.DW18.PocNumberForFwdRef2        = refPoc[0][2];
    cmd.DW19.PocNumberForBwdRef0        = refPoc[1][0];

    MHW_MI_CHK_STATUS(Mhw_AddCommandCmdOrBB(cmdBuffer, batchBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}

//!
//! \brief  Explictly instantiate GetAvcMaxSize of MhwVdboxVdencInterfaceG12 for mhw::vdbox::vdenc::xe_hpm::Cmd
//!         because there is no VDENC_CONST_QPT_STATE_CMD and VDENC_IMG_STATE has been changed to VDENC_AVC_IMG_STATE_CMD for Xe_HPM
//!
template<> inline uint32_t
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::GetAvcMaxSize(uint32_t waAddDelayInVDEncDynamicSlice)
{
    uint32_t maxSize =
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_MODE_SELECT_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_SRC_SURFACE_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_REF_SURFACE_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_DS_REF_SURFACE_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_BUF_ADDR_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_AVC_IMG_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WALKER_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VD_PIPELINE_FLUSH_CMD::byteSize +
        GetVdencCmd3Size() +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_AVC_SLICE_STATE_CMD::byteSize;

    if (waAddDelayInVDEncDynamicSlice)
    {
        maxSize += mhw::vdbox::vdenc::xe_hpm::Cmd::VD_PIPELINE_FLUSH_CMD::byteSize * MHW_VDBOX_VDENC_DYNAMIC_SLICE_WA_COUNT;
    }

    return maxSize;
}

//!
//! \brief  Explictly instantiate GetAvcSliceMaxSize of MhwVdboxVdencInterfaceG12 for mhw::vdbox::vdenc::xe_hpm::Cmd,
//!         because there is VDENC_AVC_SLICE_STATE_CMD for Xe_HPM
//!
template<> inline uint32_t
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::GetAvcSliceMaxSize()
{
    uint32_t maxSize =
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WEIGHTSOFFSETS_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_AVC_SLICE_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WALKER_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VD_PIPELINE_FLUSH_CMD::byteSize;

    return maxSize;
}

template<> inline uint32_t
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::GetReserved0TileMaxSize()
{
    uint32_t maxSize = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_HEVC_VP9_TILE_SLICE_STATE_CMD::byteSize +
        GetVdencCmd1Size() +
        GetVdencCmd2Size() +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WALKER_STATE_CMD::byteSize;

    return maxSize;
}

template<> inline uint32_t
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::GetReserved0MaxSize()
{
    uint32_t maxSize =
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_CONTROL_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_MODE_SELECT_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_SRC_SURFACE_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_REF_SURFACE_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_DS_REF_SURFACE_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_BUF_ADDR_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WALKER_STATE_CMD::byteSize +
        mhw::vdbox::vdenc::xe_hpm::Cmd::VD_PIPELINE_FLUSH_CMD::byteSize;;

    return maxSize;
}

template<> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencPipeBufAddrCmd(
    PMOS_COMMAND_BUFFER             cmdBuffer,
    PMHW_VDBOX_PIPE_BUF_ADDR_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(cmdBuffer);
    MHW_MI_CHK_NULL(params);
    MHW_MI_CHK_NULL(m_osInterface);

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_BUF_ADDR_STATE_CMD cmd;

    MOS_SURFACE details;
    uint8_t     refIdx;

    MOS_MEMCOMP_STATE mmcMode = MOS_MEMCOMP_DISABLED;
    MHW_RESOURCE_PARAMS resourceParams;
    MOS_ZeroMemory(&resourceParams, sizeof(resourceParams));
    resourceParams.dwLsbNum = MHW_VDBOX_MFX_GENERAL_STATE_SHIFT;
    resourceParams.HwCommandType = MOS_VDENC_PIPE_BUF_ADDR;
    MEDIA_WA_TABLE *pWaTable     = m_osInterface->pfnGetWaTable(m_osInterface);
    MHW_CHK_NULL_RETURN(pWaTable);

    if (params->psRawSurface != nullptr)
    {
        cmd.OriginalUncompressedPicture.PictureFields.DW0.MemoryCompressionEnable = MmcEnable(params->RawSurfMmcState) ? 1 : 0;
        cmd.OriginalUncompressedPicture.PictureFields.DW0.CompressionType         = MmcIsRc(params->RawSurfMmcState) ? 1 : 0;
        cmd.OriginalUncompressedPicture.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_ORIGINAL_UNCOMPRESSED_PICTURE_ENCODE].Gen12_7.Index;
        cmd.OriginalUncompressedPicture.PictureFields.DW0.CompressionFormat = params->pRawSurfParam->dwCompressionFormat;

        resourceParams.presResource = &params->psRawSurface->OsResource;
        resourceParams.dwOffset = params->psRawSurface->dwOffset;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.OriginalUncompressedPicture.LowerAddress);
        resourceParams.dwLocationInCmd = 10;
        resourceParams.bIsWritable = false;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (this->m_vdencRowStoreCache.bEnabled)
    {
        cmd.RowStoreScratchBuffer.BufferPictureFields.DW0.CacheSelect = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Surface_Control_Bits_CMD::CACHE_SELECT_UNNAMED1;
        cmd.RowStoreScratchBuffer.LowerAddress.DW0.Value = this->m_vdencRowStoreCache.dwAddress << 6;
    }
    else if (params->presVdencIntraRowStoreScratchBuffer != nullptr)
    {
        cmd.RowStoreScratchBuffer.BufferPictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_VDENC_ROW_STORE_BUFFER_CODEC].Gen12_7.Index;

        resourceParams.presResource = params->presVdencIntraRowStoreScratchBuffer;
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.RowStoreScratchBuffer.LowerAddress);
        resourceParams.dwLocationInCmd = 16;
        resourceParams.bIsWritable = true;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (params->presVdencStreamOutBuffer != nullptr)
    {
        cmd.VdencStatisticsStreamout.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_STREAMOUT_DATA_CODEC].Gen12_7.Index;

        resourceParams.presResource = params->presVdencStreamOutBuffer;
        resourceParams.dwOffset = params->dwVdencStatsStreamOutOffset;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.VdencStatisticsStreamout.LowerAddress);
        resourceParams.dwLocationInCmd = 34;
        resourceParams.bIsWritable = true;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (params->presVdencStreamInBuffer != nullptr)
    {
        cmd.StreaminDataPicture.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_VDENC_STREAMIN_CODEC].Gen12_7.Index;

        resourceParams.presResource = params->presVdencStreamInBuffer;
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.StreaminDataPicture.LowerAddress);
        resourceParams.dwLocationInCmd = 13;
        resourceParams.bIsWritable = false;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Reference_Picture_CMD *FwdBwdRefs[] = { &cmd.FwdRef0, &cmd.FwdRef1, &cmd.FwdRef2, &cmd.BwdRef0 };
    mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Down_Scaled_Reference_Picture_CMD *DsFwdRefs[] = { &cmd.DsFwdRef0, &cmd.DsFwdRef1 };
    mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Down_Scaled_Reference_Picture_CMD *DsFwdRefs4X[] = {&cmd.DsFwdRef04X, &cmd.DsFwdRef14X, &cmd.Additional4xDsFwdRef};
    PMOS_SURFACE DsSurfStage1, DsSurfStage2;

    if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
    {
        DsSurfStage1 = params->ps4xDsSurface;
        DsSurfStage2 = nullptr;
    }
    else
    {
        DsSurfStage1 = params->ps8xDsSurface;
        DsSurfStage2 = params->ps4xDsSurface;
    }

    for (refIdx = 0; refIdx <= params->dwNumRefIdxL0ActiveMinus1; refIdx++)
    {
        if (params->presVdencReferences[refIdx])
        {
            MOS_ZeroMemory(&details, sizeof(details));
            details.Format = Format_Invalid;
            MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetResourceInfo(this->m_osInterface, params->presVdencReferences[refIdx], &details));

            resourceParams.presResource = params->presVdencReferences[refIdx];
            resourceParams.dwOffset = details.RenderOffset.YUV.Y.BaseOffset;
            resourceParams.dwLocationInCmd = (refIdx * 3) + 22;
            resourceParams.bIsWritable = false;
            resourceParams.pdwCmd = (uint32_t*)&FwdBwdRefs[refIdx]->LowerAddress;

            if (params->bMmcEnabled)
            {
                MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetMemoryCompressionMode(
                    this->m_osInterface, params->presVdencReferences[refIdx], &mmcMode));
            }
            else
            {
                mmcMode = MOS_MEMCOMP_DISABLED;
            }
            FwdBwdRefs[refIdx]->PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
            FwdBwdRefs[refIdx]->PictureFields.DW0.CompressionType         = MmcIsRc(mmcMode) ? 1 : 0;
            FwdBwdRefs[refIdx]->PictureFields.DW0.MemoryObjectControlState =
                this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;
            FwdBwdRefs[refIdx]->PictureFields.DW0.CompressionFormat = params->pDecodedReconParam->dwCompressionFormat;

            MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                this->m_osInterface,
                cmdBuffer,
                &resourceParams));
        }
        PMOS_RESOURCE dsFwdRefsSurf, dsFwdRefs4XSurf;
        if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
        {
            dsFwdRefsSurf = params->presVdenc4xDsSurface[refIdx];
            dsFwdRefs4XSurf = nullptr;
        }
        else
        {
            if (MEDIA_IS_WA(pWaTable, Wa_22011549751) && params->isIFrame && !this->m_osInterface->bSimIsActive && !Mos_Solo_Extension(this->m_osInterface->pOsContext) &&
                (((CODECHAL_ENCODE_MODE_HEVC == params->Mode) && !params->bIBCEnabled) || CODECHAL_ENCODE_MODE_VP9 == params->Mode))
            {
                dsFwdRefsSurf   = &DsSurfStage1->OsResource;
                dsFwdRefs4XSurf = &DsSurfStage2->OsResource;
            }
            else
            {
                dsFwdRefsSurf   = params->presVdenc8xDsSurface[refIdx];
                dsFwdRefs4XSurf = params->presVdenc4xDsSurface[refIdx];
            }
        }
        if (refIdx <= 1 && dsFwdRefsSurf)
        {
            MOS_ZeroMemory(&details, sizeof(details));
            details.Format = Format_Invalid;
            MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetResourceInfo(this->m_osInterface, dsFwdRefsSurf, &details));

            resourceParams.presResource = dsFwdRefsSurf;
            resourceParams.dwOffset = details.RenderOffset.YUV.Y.BaseOffset;
            resourceParams.dwLocationInCmd = (refIdx * 3) + 1;
            resourceParams.bIsWritable = false;
            resourceParams.pdwCmd = (uint32_t *)&(DsFwdRefs[refIdx]->LowerAddress);

            if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
            {
                mmcMode = params->Ps4xDsSurfMmcState;
            }
            else
            {
                mmcMode = params->Ps8xDsSurfMmcState;
            }

            DsFwdRefs[refIdx]->PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
            DsFwdRefs[refIdx]->PictureFields.DW0.CompressionType         = MmcIsRc(mmcMode) ? 1 : 0;
            DsFwdRefs[refIdx]->PictureFields.DW0.MemoryObjectControlState =
                this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

            MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                this->m_osInterface,
                cmdBuffer,
                &resourceParams));
        }

        if (refIdx <= 2 && dsFwdRefs4XSurf)
        {
            MOS_ZeroMemory(&details, sizeof(details));
            details.Format = Format_Invalid;
            MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetResourceInfo(this->m_osInterface, dsFwdRefs4XSurf, &details));

            resourceParams.presResource = dsFwdRefs4XSurf;
            resourceParams.dwOffset = details.RenderOffset.YUV.Y.BaseOffset;

            if (!params->isLowDelayB && params->dwNumRefIdxL0ActiveMinus1 == 1 && params->dwNumRefIdxL1ActiveMinus1 == 0 && refIdx == 1 && params->presVdenc4xDsSurface[2] != nullptr)
            {
                resourceParams.dwLocationInCmd = 86;
                resourceParams.bIsWritable = false;
                resourceParams.pdwCmd      = (uint32_t *)&(DsFwdRefs4X[2]->LowerAddress);

                mmcMode = params->Ps4xDsSurfMmcState;

                DsFwdRefs4X[2]->PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
                DsFwdRefs4X[2]->PictureFields.DW0.CompressionType         = MmcIsRc(mmcMode) ? 1 : 0;
                DsFwdRefs4X[2]->PictureFields.DW0.MemoryObjectControlState =
                    this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

                MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                    this->m_osInterface,
                    cmdBuffer,
                    &resourceParams));
            }
            else
            {
                if (refIdx == 2)
                {
                    resourceParams.dwLocationInCmd = 86;
                }
                else
                {
                    resourceParams.dwLocationInCmd = (refIdx * 3) + 37;
                }
                resourceParams.bIsWritable = false;
                resourceParams.pdwCmd = (uint32_t *)&(DsFwdRefs4X[refIdx]->LowerAddress);

                mmcMode = params->Ps4xDsSurfMmcState;

                DsFwdRefs4X[refIdx]->PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
                DsFwdRefs4X[refIdx]->PictureFields.DW0.CompressionType         = MmcIsRc(mmcMode) ? 1 : 0;
                DsFwdRefs4X[refIdx]->PictureFields.DW0.MemoryObjectControlState =
                    this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

                MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                    this->m_osInterface,
                    cmdBuffer,
                    &resourceParams));
            }
        }
    }

    if (params->Mode == CODECHAL_ENCODE_MODE_HEVC && (!params->isLowDelayB || params->isPFrame) || params->Mode == CODECHAL_ENCODE_MODE_AVC)
    {
        if (params->presVdencReferences[refIdx])
        {
            MOS_ZeroMemory(&details, sizeof(details));
            details.Format = Format_Invalid;
            MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetResourceInfo(this->m_osInterface, params->presVdencReferences[refIdx], &details));

            resourceParams.presResource = params->presVdencReferences[refIdx];
            resourceParams.dwOffset = details.RenderOffset.YUV.Y.BaseOffset;
            resourceParams.dwLocationInCmd = OFFSET_OF(typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_BUF_ADDR_STATE_CMD, BwdRef0) / sizeof(uint32_t);
            resourceParams.bIsWritable = false;
            resourceParams.pdwCmd = (uint32_t *)&(cmd.BwdRef0.LowerAddress);

            if (params->bMmcEnabled)
            {
                MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetMemoryCompressionMode(
                    this->m_osInterface, params->presVdencReferences[refIdx], &mmcMode));
            }
            else
            {
                mmcMode = MOS_MEMCOMP_DISABLED;
            }

            cmd.BwdRef0.PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
            cmd.BwdRef0.PictureFields.DW0.CompressionType         = MmcIsRc(mmcMode) ? 1 : 0;
            cmd.BwdRef0.PictureFields.DW0.MemoryObjectControlState =
                this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;
            cmd.BwdRef0.PictureFields.DW0.CompressionFormat = params->pDecodedReconParam->dwCompressionFormat;

            MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                this->m_osInterface,
                cmdBuffer,
                &resourceParams));
        }
        PMOS_RESOURCE DsBwdRef0Surf, DsBwdRef04XSurf;
        if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
        {
            DsBwdRef0Surf = params->presVdenc4xDsSurface[refIdx];
            DsBwdRef04XSurf = nullptr;
        }
        else
        {
            DsBwdRef0Surf = params->presVdenc8xDsSurface[refIdx];
            DsBwdRef04XSurf = params->presVdenc4xDsSurface[refIdx];
        }
        if (DsBwdRef0Surf)
        {
            MOS_ZeroMemory(&details, sizeof(details));
            details.Format = Format_Invalid;
            MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetResourceInfo(this->m_osInterface, DsBwdRef0Surf, &details));

            resourceParams.presResource = DsBwdRef0Surf;
            resourceParams.dwOffset = details.RenderOffset.YUV.Y.BaseOffset;
            resourceParams.dwLocationInCmd = OFFSET_OF(typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_BUF_ADDR_STATE_CMD, DsBwdRef0) / sizeof(uint32_t);
            resourceParams.bIsWritable = false;
            resourceParams.pdwCmd = (uint32_t *)&(cmd.DsBwdRef0.LowerAddress);

            if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
            {
                mmcMode = params->Ps4xDsSurfMmcState;
            }
            else
            {
                mmcMode = params->Ps8xDsSurfMmcState;
            }

            cmd.DsBwdRef0.PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
            cmd.DsBwdRef0.PictureFields.DW0.CompressionType         = MmcIsRc(mmcMode) ? 1 : 0;
            cmd.DsBwdRef0.PictureFields.DW0.MemoryObjectControlState =
                this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

            MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                this->m_osInterface,
                cmdBuffer,
                &resourceParams));
        }

        if (DsBwdRef04XSurf)
        {
            MOS_ZeroMemory(&details, sizeof(details));
            details.Format = Format_Invalid;
            MHW_MI_CHK_STATUS(this->m_osInterface->pfnGetResourceInfo(this->m_osInterface, DsBwdRef04XSurf, &details));

            resourceParams.presResource = DsBwdRef04XSurf;
            resourceParams.dwOffset = details.RenderOffset.YUV.Y.BaseOffset;
            resourceParams.dwLocationInCmd = OFFSET_OF(typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_PIPE_BUF_ADDR_STATE_CMD, DsBwdRef04X) / sizeof(uint32_t);
            resourceParams.bIsWritable = false;
            resourceParams.pdwCmd = (uint32_t*)&(cmd.DsBwdRef04X.LowerAddress);

            mmcMode = params->Ps4xDsSurfMmcState;

            cmd.DsBwdRef04X.PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
            cmd.DsBwdRef04X.PictureFields.DW0.CompressionType         = MmcIsRc(mmcMode) ? 1 : 0;
            cmd.DsBwdRef04X.PictureFields.DW0.MemoryObjectControlState =
                this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

            MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                this->m_osInterface,
                cmdBuffer,
                &resourceParams));
        }
    }

    if (params->presVdencColocatedMVReadBuffer != nullptr)
    {
        resourceParams.presResource    = params->presVdencColocatedMVReadBuffer;
        resourceParams.dwOffset        = 0;
        resourceParams.pdwCmd          = (uint32_t *)&(cmd.ColocatedMv.LowerAddress);
        resourceParams.dwLocationInCmd = 19;
        resourceParams.bIsWritable     = false;

        cmd.ColocatedMv.PictureFields.DW0.MemoryCompressionEnable = 0;
        cmd.ColocatedMv.PictureFields.DW0.CompressionType         = 0;
        cmd.ColocatedMv.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (params->presColMvTempBuffer[0] != nullptr && !params->isPFrame)
    {
        resourceParams.presResource = params->presColMvTempBuffer[0];
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.ColocatedMv.LowerAddress);
        resourceParams.dwLocationInCmd = 19;
        resourceParams.bIsWritable = true;

        cmd.ColocatedMv.PictureFields.DW0.MemoryCompressionEnable = 0;
        cmd.ColocatedMv.PictureFields.DW0.CompressionType = 0;
        cmd.ColocatedMv.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (DsSurfStage1 != nullptr)
    {
        resourceParams.presResource = &DsSurfStage1->OsResource;
        resourceParams.dwOffset = DsSurfStage1->dwOffset;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.ScaledReferenceSurfaceStage1.LowerAddress);
        resourceParams.dwLocationInCmd = 49;
        resourceParams.bIsWritable = true;

        if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
        {
            mmcMode = params->Ps4xDsSurfMmcState;
        }
        else
        {
            mmcMode = params->Ps8xDsSurfMmcState;
        }

        cmd.ScaledReferenceSurfaceStage1.PictureFields.DW0.MemoryCompressionEnable = MmcEnable(mmcMode) ? 1 : 0;
        cmd.ScaledReferenceSurfaceStage1.PictureFields.DW0.CompressionType = MmcIsRc(mmcMode) ? 1 : 0;
        cmd.ScaledReferenceSurfaceStage1.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (DsSurfStage2 != nullptr)
    {
        resourceParams.presResource = &DsSurfStage2->OsResource;
        resourceParams.dwOffset = DsSurfStage2->dwOffset;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.ScaledReferenceSurfaceStage2.LowerAddress);
        resourceParams.dwLocationInCmd = 52;
        resourceParams.bIsWritable = true;

        cmd.ScaledReferenceSurfaceStage2.PictureFields.DW0.MemoryCompressionEnable = MmcEnable(params->Ps4xDsSurfMmcState) ? 1 : 0;
        cmd.ScaledReferenceSurfaceStage2.PictureFields.DW0.CompressionType         = MmcIsRc(params->Ps4xDsSurfMmcState) ? 1 : 0;
        cmd.ScaledReferenceSurfaceStage2.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (params->presVdencPakObjCmdStreamOutBuffer)
    {
        resourceParams.presResource = params->presVdencPakObjCmdStreamOutBuffer;
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.VdencLcuPakObjCmdBuffer.LowerAddress);
        resourceParams.dwLocationInCmd = 46;
        resourceParams.bIsWritable = true;

        cmd.VdencLcuPakObjCmdBuffer.PictureFields.DW0.MemoryCompressionEnable = 0;
        cmd.VdencLcuPakObjCmdBuffer.PictureFields.DW0.CompressionType = 0;
        cmd.VdencLcuPakObjCmdBuffer.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (params->presSegmentMapStreamOut)
    {
        if (params->presSegmentMapStreamIn)
        {
            resourceParams.presResource    = params->presSegmentMapStreamIn;
        }
        else
        {
            resourceParams.presResource    = params->presSegmentMapStreamOut;
        }
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.Vp9SegmentationMapStreaminBuffer.LowerAddress);
        resourceParams.dwLocationInCmd = 55;
        resourceParams.bIsWritable = true;

        cmd.Vp9SegmentationMapStreaminBuffer.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));

        resourceParams.presResource = params->presSegmentMapStreamOut;
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.Vp9SegmentationMapStreamoutBuffer.LowerAddress);
        resourceParams.dwLocationInCmd = 58;
        resourceParams.bIsWritable = true;

        cmd.Vp9SegmentationMapStreamoutBuffer.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_STREAMOUT_DATA_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    // The first 2 CLs(cacheline=64bytes) are ENC frame statistics data.
    // The 3rd CL is for VDL1* stats.
    // Hence it's a dummy CL for us. Histogram stats start from 4th CL onwards.
    cmd.DW61.WeightsHistogramStreamoutOffset = 3 * MHW_CACHELINE_SIZE;

    if (params->presVdencTileRowStoreBuffer != nullptr)
    {
        cmd.VdencTileRowStoreBuffer.BufferPictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_VDENC_ROW_STORE_BUFFER_CODEC].Gen12_7.Index;

        resourceParams.presResource = params->presVdencTileRowStoreBuffer;
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t*)&(cmd.VdencTileRowStoreBuffer.LowerAddress);
        resourceParams.dwLocationInCmd = 62;
        resourceParams.bIsWritable = true;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (this->m_vdencRowStoreCache.bEnabled && params->Mode == CODECHAL_ENCODE_MODE_AVC)
    {
        cmd.IntraPredictionRowstoreBaseAddress.BufferPictureFields.DW0.CacheSelect = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Surface_Control_Bits_CMD::CACHE_SELECT_UNNAMED1;
        cmd.IntraPredictionRowstoreBaseAddress.LowerAddress.DW0.Value = m_vdencIpdlRowstoreCache.dwAddress << 6;
    }

    else if (Mos_ResourceIsNull(params->presMfdIntraRowStoreScratchBuffer) == false)
    {
        cmd.IntraPredictionRowstoreBaseAddress.BufferPictureFields.DW0.MemoryObjectControlState =
            m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_INTRA_ROWSTORE_SCRATCH_BUFFER_CODEC].Gen12_7.Index;
        cmd.IntraPredictionRowstoreBaseAddress.BufferPictureFields.DW0.MemoryCompressionEnable = MHW_MEDIA_MEMCOMP_DISABLED;

        resourceParams.presResource = params->presMfdIntraRowStoreScratchBuffer;
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t *)&(cmd.IntraPredictionRowstoreBaseAddress);
        resourceParams.dwLocationInCmd = 77;
        resourceParams.bIsWritable = true;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (params->presVdencCumulativeCuCountStreamoutSurface != nullptr)
    {
        resourceParams.presResource = params->presVdencCumulativeCuCountStreamoutSurface;
        resourceParams.dwOffset = 0;
        resourceParams.pdwCmd = (uint32_t *)&(cmd.VdencCumulativeCuCountStreamoutSurface.LowerAddress);
        resourceParams.dwLocationInCmd = 65;
        resourceParams.bIsWritable = true;

        cmd.VdencCumulativeCuCountStreamoutSurface.PictureFields.DW0.MemoryObjectControlState =
            this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_STREAMOUT_DATA_CODEC].Gen12_7.Index;

        MHW_MI_CHK_STATUS(this->AddResourceToCmd(
            this->m_osInterface,
            cmdBuffer,
            &resourceParams));
    }

    if (params->presVdencColocatedMVWriteBuffer != nullptr)
    {
        if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
        {
            resourceParams.presResource    = params->presVdencColocatedMVWriteBuffer;
            resourceParams.dwOffset        = 0;
            resourceParams.pdwCmd          = (uint32_t *)&(cmd.ColocatedMvAvcWriteBuffer.LowerAddress);
            resourceParams.dwLocationInCmd = 83;
            resourceParams.bIsWritable     = true;

            cmd.ColocatedMvAvcWriteBuffer.PictureFields.DW0.MemoryCompressionEnable = 0;
            cmd.ColocatedMvAvcWriteBuffer.PictureFields.DW0.CompressionType         = 0;
            cmd.ColocatedMvAvcWriteBuffer.PictureFields.DW0.MemoryObjectControlState =
                this->m_cacheabilitySettings[MOS_CODEC_RESOURCE_USAGE_REFERENCE_PICTURE_CODEC].Gen12_7.Index;

            MHW_MI_CHK_STATUS(this->AddResourceToCmd(
                this->m_osInterface,
                cmdBuffer,
                &resourceParams));
        }
    }

    MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}
template<> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencWalkerStateCmd(
    PMOS_COMMAND_BUFFER                  cmdBuffer,
    PMHW_VDBOX_VDENC_WALKER_STATE_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(cmdBuffer);
    MHW_MI_CHK_NULL(params);

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_WALKER_STATE_CMD cmd;

    if (params->Mode == CODECHAL_ENCODE_MODE_AVC)
    {
        auto avcSeqParams = params->pAvcSeqParams;
        auto avcSlcParams = params->pAvcSlcParams;
        MHW_MI_CHK_NULL(avcSeqParams);
        MHW_MI_CHK_NULL(avcSlcParams);

        auto frameHeight = static_cast<uint32_t>(CODECHAL_GET_HEIGHT_IN_MACROBLOCKS(avcSeqParams->FrameHeight));
        auto frameWidth = static_cast<uint32_t>(CODECHAL_GET_WIDTH_IN_MACROBLOCKS(avcSeqParams->FrameWidth));

        cmd.DW1.MbLcuStartYPosition = avcSlcParams->first_mb_in_slice / frameWidth;
        cmd.DW1.FirstSuperSlice = 1;

        auto nextsliceMbStartYPosition = (avcSlcParams->first_mb_in_slice + avcSlcParams->NumMbsForSlice) / frameWidth;
        cmd.DW2.NextsliceMbStartYPosition = nextsliceMbStartYPosition > frameHeight ? frameHeight : nextsliceMbStartYPosition;
    }
    else if (params->Mode == CODECHAL_ENCODE_MODE_HEVC)
    {
        auto paramsG12 = dynamic_cast<PMHW_VDBOX_VDENC_WALKER_STATE_PARAMS_G12>(params);
        MHW_MI_CHK_NULL(paramsG12);

        MHW_MI_CHK_NULL(params->pHevcEncSeqParams);
        MHW_MI_CHK_NULL(params->pHevcEncPicParams);
        MHW_MI_CHK_NULL(params->pEncodeHevcSliceParams);

        auto seqParams   = params->pHevcEncSeqParams;
        auto picParams   = params->pHevcEncPicParams;
        auto sliceParams = params->pEncodeHevcSliceParams;

        uint32_t ctbSize     = 1 << (seqParams->log2_max_coding_block_size_minus3 + 3);
        uint32_t widthInPix  = (1 << (seqParams->log2_min_coding_block_size_minus3 + 3)) * (seqParams->wFrameWidthInMinCbMinus1 + 1);
        uint32_t widthInCtb  = (widthInPix / ctbSize) + ((widthInPix % ctbSize) ? 1 : 0);  // round up
        uint32_t heightInPix = (1 << (seqParams->log2_min_coding_block_size_minus3 + 3)) * (seqParams->wFrameHeightInMinCbMinus1 + 1);
        uint32_t heightInCtb = (heightInPix / ctbSize) + ((heightInPix % ctbSize) ? 1 : 0);  // round up
        uint32_t shift       = seqParams->log2_max_coding_block_size_minus3 - seqParams->log2_min_coding_block_size_minus3;

        if (paramsG12->pTileCodingParams == nullptr)
        {
            // No tiling support
            cmd.DW1.MbLcuStartYPosition          = sliceParams->slice_segment_address / widthInCtb;
            cmd.DW2.NextsliceMbLcuStartXPosition = (sliceParams->slice_segment_address + sliceParams->NumLCUsInSlice) / heightInCtb;
            cmd.DW2.NextsliceMbStartYPosition    = (sliceParams->slice_segment_address + sliceParams->NumLCUsInSlice) / widthInCtb;
        }
        else
        {
            cmd.DW1.MbLcuStartXPosition = paramsG12->pTileCodingParams->TileStartLCUX;
            cmd.DW1.MbLcuStartYPosition = paramsG12->pTileCodingParams->TileStartLCUY;

            // In HEVC vdnec, always first super slice in each tile
            cmd.DW1.FirstSuperSlice = 1;

            cmd.DW2.NextsliceMbLcuStartXPosition = paramsG12->pTileCodingParams->TileStartLCUX + (paramsG12->pTileCodingParams->TileWidthInMinCbMinus1 >> shift) + 1;
            cmd.DW2.NextsliceMbStartYPosition    = paramsG12->pTileCodingParams->TileStartLCUY + (paramsG12->pTileCodingParams->TileHeightInMinCbMinus1 >> shift) + 1;
        }
    }
    else if (params->Mode == CODECHAL_ENCODE_MODE_VP9)
    {
        auto paramsG12 = dynamic_cast<PMHW_VDBOX_VDENC_WALKER_STATE_PARAMS_G12>(params);
        MHW_MI_CHK_NULL(paramsG12);
        MHW_MI_CHK_NULL(params->pVp9EncPicParams);
        auto vp9PicParams = params->pVp9EncPicParams;
        auto tileCodingParams = paramsG12->pTileCodingParams;

        if (tileCodingParams == nullptr)
        {
            cmd.DW2.NextsliceMbLcuStartXPosition = CODECHAL_GET_WIDTH_IN_BLOCKS(vp9PicParams->SrcFrameWidthMinus1, CODEC_VP9_SUPER_BLOCK_WIDTH);
            cmd.DW2.NextsliceMbStartYPosition = CODECHAL_GET_HEIGHT_IN_BLOCKS(vp9PicParams->SrcFrameHeightMinus1, CODEC_VP9_SUPER_BLOCK_HEIGHT);
            cmd.DW1.FirstSuperSlice = 1;
        }
        else
        {
            auto tileStartCtbX = tileCodingParams->TileStartLCUX * CODEC_VP9_SUPER_BLOCK_WIDTH;
            auto tileStartCtbY = tileCodingParams->TileStartLCUY * CODEC_VP9_SUPER_BLOCK_HEIGHT;

            auto tileWidth = ((tileCodingParams->TileWidthInMinCbMinus1 + 1) * CODEC_VP9_MIN_BLOCK_WIDTH) - 1;
            auto tileHeight = ((tileCodingParams->TileHeightInMinCbMinus1 + 1) * CODEC_VP9_MIN_BLOCK_HEIGHT) - 1;

            cmd.DW1.MbLcuStartXPosition = tileCodingParams->TileStartLCUX;
            cmd.DW1.MbLcuStartYPosition = tileCodingParams->TileStartLCUY;
            cmd.DW1.FirstSuperSlice     = 1;

            cmd.DW2.NextsliceMbLcuStartXPosition = CODECHAL_GET_WIDTH_IN_BLOCKS((tileStartCtbX + tileWidth + 1), CODEC_VP9_SUPER_BLOCK_WIDTH);
            cmd.DW2.NextsliceMbStartYPosition = CODECHAL_GET_HEIGHT_IN_BLOCKS((tileStartCtbY + tileHeight + 1), CODEC_VP9_SUPER_BLOCK_HEIGHT);
        }
    }

     MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

     return MOS_STATUS_SUCCESS;
}

//!
//! \brief  Explictly instantiate AddVdencSrcSurfaceStateCmd of MhwVdboxVdencInterfaceG12 for mhw::vdbox::vdenc::xe_hpm::Cmd
//!         because VDENC_SRC_SURFACE_STATE_CMD has been changed for Xe_HPM
//!
template <> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencSrcSurfaceStateCmd(
    PMOS_COMMAND_BUFFER       cmdBuffer,
    PMHW_VDBOX_SURFACE_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(cmdBuffer);
    MHW_MI_CHK_NULL(params);
    MHW_MI_CHK_NULL(params->psSurface);

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_SRC_SURFACE_STATE_CMD cmd;

    cmd.Dwords25.DW0.Width               = params->dwActualWidth - 1;
    cmd.Dwords25.DW0.Height              = params->dwActualHeight - 1;
    cmd.Dwords25.DW0.ColorSpaceSelection = params->bColorSpaceSelection;

    cmd.Dwords25.DW0.CrVCbUPixelOffsetVDirection = params->ucVDirection;

    uint32_t tilemode         = GetHWTileType(params->psSurface->TileType, params->psSurface->TileModeGMM, params->psSurface->bGMMTileEnabled);
    cmd.Dwords25.DW1.TileMode = tilemode;

    cmd.Dwords25.DW1.SurfaceFormat            = MosFormatToVdencSurfaceRawFormat(params->psSurface->Format);
    cmd.Dwords25.DW0.SurfaceFormatByteSwizzle = params->bDisplayFormatSwizzle;
    cmd.Dwords25.DW1.SurfacePitch             = params->psSurface->dwPitch - 1;
    cmd.Dwords25.DW2.YOffsetForUCb            = cmd.Dwords25.DW3.YOffsetForVCr =
        MOS_ALIGN_CEIL((params->psSurface->UPlaneOffset.iSurfaceOffset - params->psSurface->dwOffset) / params->psSurface->dwPitch + params->psSurface->RenderOffset.YUV.U.YOffset, MHW_VDBOX_MFX_RAW_UV_PLANE_ALIGNMENT_GEN9);

    cmd.Dwords25.DW1.ChromaDownsampleFilterControl = 7;

    MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}

//!
//! \brief  Explictly instantiate AddVdencRefSurfaceStateCmd of MhwVdboxVdencInterfaceG12 for mhw::vdbox::vdenc::xe_hpm::Cmd
//!         because VDENC_REF_SURFACE_STATE_CMD has been changed for Xe_HPM
//!
template <> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencRefSurfaceStateCmd(
    PMOS_COMMAND_BUFFER       cmdBuffer,
    PMHW_VDBOX_SURFACE_PARAMS params)
{
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(cmdBuffer);
    MHW_MI_CHK_NULL(params);
    MHW_MI_CHK_NULL(params->psSurface);

    auto waTable = this->m_osInterface->pfnGetWaTable(this->m_osInterface);
    MHW_MI_CHK_NULL(waTable);

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_REF_SURFACE_STATE_CMD cmd;

    if (params->bVdencDynamicScaling)
    {
        if (params->ucSurfaceStateId == CODECHAL_HCP_LAST_SURFACE_ID)
        {
            cmd.DW1.SurfaceId = 4;
        }
        else if (params->ucSurfaceStateId == CODECHAL_HCP_GOLDEN_SURFACE_ID)
        {
            cmd.DW1.SurfaceId = 5;
        }
        else if (params->ucSurfaceStateId == CODECHAL_HCP_ALTREF_SURFACE_ID)
        {
            cmd.DW1.SurfaceId = 6;
        }
    }

    if (params->Mode == CODECHAL_ENCODE_MODE_HEVC)
    {
        cmd.Dwords25.DW0.Width  = params->dwActualWidth - 1;
        cmd.Dwords25.DW0.Height = params->dwActualHeight - 1;
    }
    else
    {
        cmd.Dwords25.DW0.Width  = params->psSurface->dwWidth - 1;
        cmd.Dwords25.DW0.Height = params->psSurface->dwHeight - 1;
    }

    cmd.Dwords25.DW0.CrVCbUPixelOffsetVDirection = params->ucVDirection;

    uint32_t tilemode         = GetHWTileType(params->psSurface->TileType, params->psSurface->TileModeGMM, params->psSurface->bGMMTileEnabled);
    cmd.Dwords25.DW1.TileMode = tilemode;

    cmd.Dwords25.DW1.SurfaceFormat = MosFormatToVdencSurfaceReconFormat(params->psSurface->Format);

    if (cmd.Dwords25.DW1.SurfaceFormat == mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Surface_State_Fields_CMD::SURFACE_FORMAT_P010)
    {
        cmd.Dwords25.DW1.SurfaceFormat = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Surface_State_Fields_CMD::SURFACE_FORMAT_P010_VARIANT;
    }

    cmd.Dwords25.DW1.SurfacePitch  = params->psSurface->dwPitch - 1;
    cmd.Dwords25.DW2.YOffsetForUCb = cmd.Dwords25.DW3.YOffsetForVCr =
        (params->psSurface->UPlaneOffset.iSurfaceOffset - params->psSurface->dwOffset) / params->psSurface->dwPitch + params->psSurface->RenderOffset.YUV.U.YOffset;

    if (cmd.Dwords25.DW1.SurfaceFormat == vdencSurfaceFormatY416Variant ||
        cmd.Dwords25.DW1.SurfaceFormat == vdencSurfaceFormatAyuvVariant)
    {
        /* Y410/Y416 Reconstructed format handling */
        if (cmd.Dwords25.DW1.SurfaceFormat == vdencSurfaceFormatY416Variant)
            cmd.Dwords25.DW1.SurfacePitch = params->psSurface->dwPitch / 2 - 1;
        /* AYUV Reconstructed format handling */
        if (cmd.Dwords25.DW1.SurfaceFormat == vdencSurfaceFormatAyuvVariant)
            cmd.Dwords25.DW1.SurfacePitch = params->psSurface->dwPitch / 4 - 1;

        cmd.Dwords25.DW2.YOffsetForUCb = params->dwReconSurfHeight;
        cmd.Dwords25.DW3.YOffsetForVCr = params->dwReconSurfHeight << 1;
    }
    else if (cmd.Dwords25.DW1.SurfaceFormat == vdencSurfaceFormatY216Variant ||
             cmd.Dwords25.DW1.SurfaceFormat == vdencSurfaceFormatYuyvVariant)
    {
        cmd.Dwords25.DW2.YOffsetForUCb = cmd.Dwords25.DW3.YOffsetForVCr = params->dwReconSurfHeight;
    }

    MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}

//!
//! \brief  Explictly instantiate AddVdencDsRefSurfaceStateCmd of MhwVdboxVdencInterfaceG12 for mhw::vdbox::vdenc::xe_hpm::Cmd
//!         because VDENC_DS_REF_SURFACE_STATE_CMD has been changed for Xe_HPM
//!
template <> inline MOS_STATUS
MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>::AddVdencDsRefSurfaceStateCmd(
    PMOS_COMMAND_BUFFER       cmdBuffer,
    PMHW_VDBOX_SURFACE_PARAMS params,
    uint8_t                   numSurfaces)
{
    uint32_t tilemode = 0;
    MHW_FUNCTION_ENTER;

    MHW_MI_CHK_NULL(cmdBuffer);
    MHW_MI_CHK_NULL(params);
    MHW_MI_CHK_NULL(params->psSurface);

    typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_DS_REF_SURFACE_STATE_CMD cmd;

    if (params->Mode == CODECHAL_ENCODE_MODE_HEVC)
    {
        cmd.Dwords25.DW0.Width  = params->dwActualWidth - 1;
        cmd.Dwords25.DW0.Height = params->dwActualHeight - 1;
    }
    else
    {
        cmd.Dwords25.DW0.Width  = params->psSurface->dwWidth - 1;
        cmd.Dwords25.DW0.Height = params->psSurface->dwHeight - 1;
    }
    cmd.Dwords25.DW0.CrVCbUPixelOffsetVDirection = params->ucVDirection;

    tilemode                  = GetHWTileType(params->psSurface->TileType, params->psSurface->TileModeGMM, params->psSurface->bGMMTileEnabled);
    cmd.Dwords25.DW1.TileMode = tilemode;

    cmd.Dwords25.DW1.SurfaceFormat = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Surface_State_Fields_CMD::SURFACE_FORMAT_PLANAR_420_8;
    cmd.Dwords25.DW1.SurfacePitch  = params->psSurface->dwPitch - 1;
    cmd.Dwords25.DW2.YOffsetForUCb = cmd.Dwords25.DW3.YOffsetForVCr =
        (params->psSurface->UPlaneOffset.iSurfaceOffset - params->psSurface->dwOffset) / params->psSurface->dwPitch + params->psSurface->RenderOffset.YUV.U.YOffset;

    // 2nd surface
    if (numSurfaces > 1)
    {
        params = params + 1;  // Increment pointer to move from 1st surface to 2nd surface.
        MHW_MI_CHK_NULL(params);
        MHW_MI_CHK_NULL(params->psSurface);

        if (params->Mode == CODECHAL_ENCODE_MODE_HEVC)
        {
            cmd.Dwords69.DW0.Width  = params->dwActualWidth - 1;
            cmd.Dwords69.DW0.Height = params->dwActualHeight - 1;
        }
        else
        {
            cmd.Dwords69.DW0.Width  = params->psSurface->dwWidth - 1;
            cmd.Dwords69.DW0.Height = params->psSurface->dwHeight - 1;
        }
        cmd.Dwords69.DW0.CrVCbUPixelOffsetVDirection = params->ucVDirection;

        tilemode                  = GetHWTileType(params->psSurface->TileType, params->psSurface->TileModeGMM, params->psSurface->bGMMTileEnabled);
        cmd.Dwords69.DW1.TileMode = tilemode;

        cmd.Dwords69.DW1.SurfaceFormat = mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_Surface_State_Fields_CMD::SURFACE_FORMAT_PLANAR_420_8;
        cmd.Dwords69.DW1.SurfacePitch  = params->psSurface->dwPitch - 1;
        cmd.Dwords69.DW2.YOffsetForUCb = cmd.Dwords69.DW3.YOffsetForVCr =
            (params->psSurface->UPlaneOffset.iSurfaceOffset - params->psSurface->dwOffset) / params->psSurface->dwPitch + params->psSurface->RenderOffset.YUV.U.YOffset;
    }

    MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

    return MOS_STATUS_SUCCESS;
}

class MhwVdboxVdencInterfaceXe_Hpm : public MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>
{
public:

    //!
    //! \brief  Constructor
    //!
    MhwVdboxVdencInterfaceXe_Hpm(PMOS_INTERFACE osInterface) : MhwVdboxVdencInterfaceG12<mhw::vdbox::vdenc::xe_hpm::Cmd>(osInterface)
    {
        MHW_FUNCTION_ENTER;

        m_rhoDomainStatsEnabled = false;
        m_perfModeSupported = false;
    }

    //!
    //! \brief    Destructor
    //!
    virtual ~MhwVdboxVdencInterfaceXe_Hpm()
    {
        MHW_FUNCTION_ENTER;
    }

    MOS_STATUS AddVdencCmd3Cmd(
        PMOS_COMMAND_BUFFER       cmdBuffer,
        PMHW_BATCH_BUFFER         batchBuffer,
        PMHW_VDBOX_AVC_IMG_PARAMS params) override
    {
        MHW_FUNCTION_ENTER;

        MHW_MI_CHK_NULL(params);
        MHW_MI_CHK_NULL(params->pEncodeAvcPicParams);
        MHW_MI_CHK_NULL(params->pEncodeAvcSeqParams);

        typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_CMD3_CMD cmd;
        auto paramsXeHpm = dynamic_cast<PMHW_VDBOX_AVC_IMG_PARAMS_XE_HPM>(params);
        auto pictureType = paramsXeHpm->pEncodeAvcPicParams->CodingType - 1;
        auto codingType  = paramsXeHpm->pEncodeAvcPicParams->CodingType;
        auto isIPGOP     = paramsXeHpm->pEncodeAvcSeqParams->GopRefDist == 1;
        auto qp          = paramsXeHpm->pEncodeAvcPicParams->QpY + paramsXeHpm->pEncodeAvcSliceParams->slice_qp_delta;

        int minQP = 10;
        int maxQP = 51;
        qp = qp > minQP ? qp : minQP;
        qp = qp < maxQP ? qp : maxQP;

        // Only do this lambda offset for lower resolution and high QP range.
        uint16_t gopP = (paramsXeHpm->pEncodeAvcSeqParams->GopRefDist) ?
            ((paramsXeHpm->pEncodeAvcSeqParams->GopPicSize - 1) / paramsXeHpm->pEncodeAvcSeqParams->GopRefDist) : 0;
        uint16_t gopB = paramsXeHpm->pEncodeAvcSeqParams->GopPicSize - 1 - gopP;
        uint16_t numB = ((gopP > 0) ? (gopB / gopP) : 0);
        if ((paramsXeHpm->bVdencBRCEnabled == false) && (numB != 0))
        {
            int lambdaOffset = 0;
            if ((paramsXeHpm->wPicWidthInMb * 16 < 1920) &&
                (paramsXeHpm->wPicHeightInMb * 16 < 1080) &&
                (qp >= 32))
            {
                if (pictureType == 0)
                {
                    lambdaOffset = 0;
                }
                else if (pictureType == 1)
                {
                    lambdaOffset = 1;
                }
                else if (pictureType == 2)
                {
                    lambdaOffset = (paramsXeHpm->pEncodeAvcPicParams->RefPicFlag) ? 1 : 2;
                }
            }
            qp += lambdaOffset;
            qp = CodecHal_Clip3(0, 51, qp);
        }

        if ((qp < 0) || (qp >= 52))
        {
            MHW_ASSERTMESSAGE("Invalid qp");
            return MOS_STATUS_INVALID_PARAMETER;
        }

        uint8_t type = 0;
        if (codingType == P_TYPE)
        {
            type = isIPGOP ? 2 : 1;
        }
        else if (codingType == B_TYPE)
        {
            type = paramsXeHpm->pEncodeAvcPicParams->RefPicFlag ? 4 : 3;
        }

        MOS_SecureMemcpy((uint8_t*)&cmd + sizeof(uint32_t),
                         cmd.byteSize - sizeof(uint32_t),
                         tableCmd3[type][params->bPerMBStreamOut][qp],
                         22 * sizeof(uint32_t));

        if (codingType == I_TYPE && paramsXeHpm->pEncodeAvcSliceParams->num_ref_idx_l0_active_minus1 == 0)
        {
            uint32_t* value = (uint32_t*)&cmd + 13;
            *value &= 0xf0ff;
        }

        MHW_MI_CHK_STATUS(Mhw_AddCommandCmdOrBB(cmdBuffer, batchBuffer, &cmd, sizeof(cmd)));

        return MOS_STATUS_SUCCESS;
    }

    MOS_STATUS AddVdencSliceStateCmd(
        PMOS_COMMAND_BUFFER        cmdBuffer,
        PMHW_VDBOX_AVC_SLICE_STATE params) override
    {
        MHW_FUNCTION_ENTER;

        MHW_MI_CHK_NULL(params);
        MHW_MI_CHK_NULL(params->pEncodeAvcSliceParams);

        typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_AVC_SLICE_STATE_CMD cmd;

        auto sliceParams = params->pEncodeAvcSliceParams;
        auto picParams   = params->pEncodeAvcPicParams;

        cmd.DW1.RoundIntra       = params->dwRoundingIntraValue;
        cmd.DW1.RoundIntraEnable = 1;
        if (sliceParams->slice_type == 2 || sliceParams->slice_type == 4
            || sliceParams->slice_type == 7 || sliceParams->slice_type == 9) // I slice
        {
            cmd.DW1.RoundInter       = 2;
            cmd.DW1.RoundInterEnable = 0;
        }
        else // P/B slice
        {
            cmd.DW1.RoundInter       = params->dwRoundingValue;
            cmd.DW1.RoundInterEnable = params->bRoundingInterEnable;
        }

        cmd.DW3.Log2WeightDenomLuma = sliceParams->luma_log2_weight_denom;
        if (sliceParams->slice_type == 1 || sliceParams->slice_type == 6) // B slice
        {
            if (picParams->weighted_bipred_idc == IMPLICIT_WEIGHTED_INTER_PRED_MODE)
            {
                cmd.DW3.Log2WeightDenomLuma = 0;
            }
        }

        MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

        return MOS_STATUS_SUCCESS;
    }

    MOS_STATUS AddVdencControlStateCmd(
        PMOS_COMMAND_BUFFER cmdBuffer) override
    {
        typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_CONTROL_STATE_CMD cmd;

        cmd.DW1.VdencInitialization = 1;

        MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));

        return MOS_STATUS_SUCCESS;
    }

    MOS_STATUS AddVdencVp9TileSliceStateCmd(
        PMOS_COMMAND_BUFFER cmdBuffer,
        PMHW_VDBOX_VDENC_WALKER_STATE_PARAMS_G12 params
    )
    {
        MHW_FUNCTION_ENTER;
        typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_HEVC_VP9_TILE_SLICE_STATE_CMD cmd;

        auto paramsG12 = dynamic_cast<PMHW_VDBOX_VDENC_WALKER_STATE_PARAMS_G12>(params);
        MHW_MI_CHK_NULL(paramsG12);

        //Tile height programmed should be n * 8 + 7, where n is integer greater than or equal to 15.
        //In other words it tile height is greater than or equal to 128 and it should be multiple of 8 pixels.
        //Maximum height of a tile is 8191
        auto tileCodingParams = paramsG12->pTileCodingParams;
        MHW_MI_CHK_NULL(params->pVp9EncPicParams);
        auto vp9PicParams = params->pVp9EncPicParams;

        if (tileCodingParams == nullptr)
        {
            cmd.DW5.TileWidth = vp9PicParams->SrcFrameWidthMinus1;
            cmd.DW5.TileHeight = vp9PicParams->SrcFrameHeightMinus1;
        }
        else
        {
            cmd.DW5.TileWidth  = ((tileCodingParams->TileWidthInMinCbMinus1 + 1) * CODEC_VP9_MIN_BLOCK_WIDTH) - 1;
            cmd.DW5.TileHeight = ((tileCodingParams->TileHeightInMinCbMinus1 + 1) * CODEC_VP9_MIN_BLOCK_HEIGHT) - 1;

            cmd.DW4.TileStartCtbX = tileCodingParams->TileStartLCUX * CODEC_VP9_SUPER_BLOCK_WIDTH;
            cmd.DW4.TileStartCtbY = tileCodingParams->TileStartLCUY * CODEC_VP9_SUPER_BLOCK_HEIGHT;

            cmd.DW3.NumParEngine    = paramsG12->dwNumberOfPipes;
            cmd.DW3.TileNumber      = paramsG12->dwTileId;

            uint32_t tileLCUStreamOutOffsetInCachelines = 0;
            uint32_t tileStartXInSBs = (cmd.DW4.TileStartCtbX / CODEC_VP9_SUPER_BLOCK_WIDTH);
            uint32_t tileStartYInSBs = (cmd.DW4.TileStartCtbY / CODEC_VP9_SUPER_BLOCK_HEIGHT);
            uint32_t tileHeightInSBs = (cmd.DW5.TileHeight + 1 + (CODEC_VP9_SUPER_BLOCK_HEIGHT - 1)) / CODEC_VP9_SUPER_BLOCK_HEIGHT;
            uint32_t frameWidthInSBs = (vp9PicParams->SrcFrameWidthMinus1 + 1 + (CODEC_VP9_SUPER_BLOCK_WIDTH - 1)) / CODEC_VP9_SUPER_BLOCK_WIDTH;
            cmd.DW6.StreaminOffsetEnable = 1;
            cmd.DW6.TileStreaminOffset   = (tileStartYInSBs * frameWidthInSBs + tileStartXInSBs * tileHeightInSBs) * (4);  //StreamIn data is 4 CLs per LCU

            //Frame Stats Offset
            cmd.DW8.TileStreamoutOffsetEnable = 1;
            cmd.DW8.TileStreamoutOffset       = paramsG12->dwTileId * 19;  // 3 CLs or 48 DWs of statistics data + 16CLs or 256 DWs of Histogram data

            if (cmd.DW4.TileStartCtbY == 0)
            {
                //RowStore Offset Computation
                uint32_t num32x32sInX        = (cmd.DW4.TileStartCtbX) / 32;
                cmd.DW7.RowStoreOffsetEnable = 1;
                cmd.DW7.TileRowstoreOffset   = num32x32sInX;
            }

            if ((cmd.DW4.TileStartCtbY != 0) || (cmd.DW4.TileStartCtbX != 0))
            {
                uint32_t numOfSBs = tileStartYInSBs * frameWidthInSBs + tileStartXInSBs * tileHeightInSBs;
                //max LCU size is 64, min Cu size is 8
                uint32_t maxNumOfCUInSB = (CODEC_VP9_SUPER_BLOCK_HEIGHT / CODEC_VP9_MIN_BLOCK_HEIGHT) * (CODEC_VP9_SUPER_BLOCK_WIDTH / CODEC_VP9_MIN_BLOCK_WIDTH);
                //(num of SBs in a tile) *  (num of cachelines needed per SB)
                tileLCUStreamOutOffsetInCachelines = numOfSBs * (MOS_ROUNDUP_DIVIDE((2 * BYTES_PER_DWORD * (NUM_PAK_DWS_PER_LCU + maxNumOfCUInSB * NUM_DWS_PER_CU)), MHW_CACHELINE_SIZE));
            }
            cmd.DW9.LcuStreamOutOffsetEnable = 1;
            cmd.DW9.TileLcuStreamOutOffset   = tileLCUStreamOutOffsetInCachelines;
        }

        MHW_MI_CHK_STATUS(Mos_AddCommand(cmdBuffer, &cmd, sizeof(cmd)));
        return MOS_STATUS_SUCCESS;
    }

    MOS_STATUS AddVdencCmd2Cmd(
        PMOS_COMMAND_BUFFER         cmdBuffer,
        PMHW_BATCH_BUFFER           batchBuffer,
        PMHW_VDBOX_VDENC_CMD2_STATE params) override
    {
        MHW_FUNCTION_ENTER;

        mhw::vdbox::vdenc::xe_hpm::_VDENC_CMD2_CMD cmd;

        AddVdencCmd2Cmd(cmd, params);

        MHW_MI_CHK_STATUS(Mhw_AddCommandCmdOrBB(cmdBuffer, batchBuffer, &cmd, sizeof(cmd)));

        return MOS_STATUS_SUCCESS;
    }

    MOS_STATUS AddVdencCmd2Cmd(
        mhw::vdbox::vdenc::xe_hpm::_VDENC_CMD2_CMD& cmd,
        PMHW_VDBOX_VDENC_CMD2_STATE params)
    {
        MHW_FUNCTION_ENTER;

        cmd.DW21.QpAdjustmentForRollingI = 0;

        MHW_MI_CHK_NULL(params->pVp9EncPicParams);
        auto vp9PicParams = params->pVp9EncPicParams;
        MHW_MI_CHK_NULL(params->pVp9EncSeqParams);
        auto vp9SeqParams = params->pVp9EncSeqParams;

        MEDIA_WA_TABLE *pWaTable = m_osInterface->pfnGetWaTable(m_osInterface);
        MHW_CHK_NULL_RETURN(pWaTable);

        cmd.DW1.FrameWidthInPixelsMinusOne  = MOS_ALIGN_CEIL(vp9PicParams->SrcFrameWidthMinus1 + 1, CODEC_VP9_MIN_BLOCK_WIDTH) - 1;
        cmd.DW1.FrameHeightInPixelsMinusOne = MOS_ALIGN_CEIL(vp9PicParams->SrcFrameHeightMinus1 + 1, CODEC_VP9_MIN_BLOCK_WIDTH) - 1;

        auto frame_type = vp9PicParams->PicFlags.fields.frame_type;

        cmd.DW2.PictureType           = frame_type;
        cmd.DW2.TemporalMvpEnableFlag = params->temporalMVpEnable;
        cmd.DW2.TransformSkip         = 0;

        cmd.DW7.Value                                   = 0x4003;
        cmd.DW7.SegmentationEnable                      = (frame_type == CODEC_VP9_KEY_FRAME) ? 0 : vp9PicParams->PicFlags.fields.segmentation_enabled;
        cmd.DW7.TilingEnable                            = (vp9PicParams->log2_tile_columns != 0) || (vp9PicParams->log2_tile_rows != 0);
        cmd.DW7.PakOnlyMultiPassEnable                  = params->bPakOnlyMultipassEnable;
        cmd.DW7.VdencStreamInEnable                     = params->bStreamInEnabled;

        if (frame_type != CODEC_VP9_KEY_FRAME)
        {
            cmd.DW7.Value |= 0x80000;
        }

        cmd.DW17.TemporalMVEnableForIntegerSearch       = params->temporalMVpEnable;
        cmd.DW21.IntraRefreshEnable                     = 0;
        cmd.DW21.IntraRefreshMBSizeMinusOne             = 1;

        if (params->bSegmentationEnabled)
        {
            cmd.DW7.SegmentationEnable                      = true;
            cmd.DW7.SegmentationMapTemporalPredictionEnable = (frame_type == CODEC_VP9_KEY_FRAME) ? 0 : (params->bPrevFrameSegEnabled ? 1 : 0);
            cmd.DW7.VdencStreamInEnable                     = params->bStreamInEnabled;

            MHW_MI_CHK_NULL(params->pVp9SegmentState);
            MHW_MI_CHK_NULL(params->pVp9SegmentState->pVp9EncodeSegmentParams);

            cmd.DW24.QpForSeg0 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[0].SegmentQIndexDelta;
            cmd.DW24.QpForSeg1 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[1].SegmentQIndexDelta;
            cmd.DW24.QpForSeg2 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[2].SegmentQIndexDelta;
            cmd.DW24.QpForSeg3 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[3].SegmentQIndexDelta;

            cmd.DW25.QpForSeg4 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[4].SegmentQIndexDelta;
            cmd.DW25.QpForSeg5 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[5].SegmentQIndexDelta;
            cmd.DW25.QpForSeg6 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[6].SegmentQIndexDelta;
            cmd.DW25.QpForSeg7 = vp9PicParams->LumaACQIndex + params->pVp9SegmentState->pVp9EncodeSegmentParams->SegData[7].SegmentQIndexDelta;
        }
        else
        {
            cmd.DW24.QpForSeg0 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;
            cmd.DW24.QpForSeg1 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;
            cmd.DW24.QpForSeg2 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;
            cmd.DW24.QpForSeg3 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;

            cmd.DW25.QpForSeg4 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;
            cmd.DW25.QpForSeg5 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;
            cmd.DW25.QpForSeg6 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;
            cmd.DW25.QpForSeg7 = vp9PicParams->LumaACQIndex + vp9PicParams->LumaDCQIndexDelta;
        }

        cmd.DW26.Vp9DynamicSliceEnable = params->bDynamicScalingEnabled;

        cmd.DW27.QpPrimeYAc = vp9PicParams->LumaACQIndex;
        cmd.DW27.QpPrimeYDc = cmd.DW27.QpPrimeYAc + vp9PicParams->LumaDCQIndexDelta;

        auto data                = (uint32_t*) &cmd;
        uint32_t FrameType       = (uint32_t) frame_type;
        uint32_t TargetUsageDiv3 = (uint32_t) vp9SeqParams->TargetUsage / 3;
        uint32_t NotSimuEnv      = (uint32_t) (!m_osInterface->bSimIsActive && !Mos_Solo_Extension(m_osInterface->pOsContext));
        uint32_t Wa_22011549751  = (uint32_t) (!!MEDIA_IS_WA(pWaTable, Wa_22011549751));
        uint32_t Wa_14010476401  = (uint32_t) (!!MEDIA_IS_WA(pWaTable, Wa_14010476401));
        uint32_t Wa_22011531258  = (uint32_t) (!!MEDIA_IS_WA(pWaTable, Wa_22011531258));
        uint32_t ActiveNumRefIdxL0LargerThan2 = (uint32_t) (params->ucNumRefIdxL0ActiveMinus1 >= 1);

        if (NotSimuEnv && Wa_22011549751 && (frame_type == CODEC_VP9_KEY_FRAME))
        {
            cmd.DW2.PictureType                       = 1;
            cmd.DW17.TemporalMVEnableForIntegerSearch = 0;
        }

        if ((FrameType | NotSimuEnv | Wa_22011549751 | Wa_14010476401 | Wa_22011531258 | ActiveNumRefIdxL0LargerThan2) > 1 || TargetUsageDiv3 > 2)
        {
            MHW_ASSERTMESSAGE("Invalid LUT index provided!");
            return MOS_STATUS_INVALID_PARAMETER;
        }

        static const uint32_t dw2Lut[2][3][2][2] = { { { { 0x3, 0x3,}, { 0x3, 0x100003,},}, { { 0x3, 0x3,}, { 0x3, 0x100003,},}, { { 0x20000003, 0x20000003,}, { 0x20000003, 0x20100003,},},}, { { { 0x100003, 0x100003,}, { 0x100003, 0x100003,},}, { { 0x100003, 0x100003,}, { 0x100003, 0x100003,},}, { { 0x20100003, 0x20100003,}, { 0x20100003, 0x20100003,},},},};
        data[2] |= dw2Lut[FrameType][TargetUsageDiv3][NotSimuEnv][Wa_22011549751];

        static const uint32_t dw5Lut[3] = { 0x80ac04, 0xc0ac04, 0xc0ac04,};
        data[5] |= dw5Lut[TargetUsageDiv3];

        if (frame_type != CODEC_VP9_KEY_FRAME)
        {
            cmd.DW5.NumRefIdxL0Minus1    = params->ucNumRefIdxL0ActiveMinus1;
        }
        else
        {
            cmd.DW5.NumRefIdxL0Minus1    = 0;
        }

        static const uint32_t dw6Lut = 0x20080200;
        data[6] |= dw6Lut;

        if (params->ucNumRefIdxL0ActiveMinus1 >= 1)
        {
            cmd.DW7.Value &= 0xFFF7FFFF;
        }
        else
        {
            cmd.DW7.Value |= 0x80000;
        }

        if (Wa_22011549751 && (frame_type == CODEC_VP9_KEY_FRAME))
        {
            cmd.DW7.Value |= 0x80000;
        }

        static const uint32_t dw8Lut[3] = { 0xfffdccaa, 0xfffdccaa, 0x55550000,};
        data[8] |= dw8Lut[TargetUsageDiv3];

        static const uint32_t dw9Lut[2][3][2][2] = { { { { 0x84ffff, 0x84ffff,}, { 0x84ffff, 0x4ffff,},}, { { 0x64ffff, 0x64ffff,}, { 0x64ffff, 0x4ffff,},}, { { 0x420000, 0x420000,}, { 0x420000, 0x20000,},},}, { { { 0x84ffff, 0x84ffff,}, { 0x84ffff, 0x84ffff,},}, { { 0x64ffff, 0x64ffff,}, { 0x64ffff, 0x64ffff,},}, { { 0x420000, 0x420000,}, { 0x420000, 0x420000,},},},};
        data[9] |= dw9Lut[FrameType][TargetUsageDiv3][NotSimuEnv][Wa_22011549751];

        static const uint32_t dw14Lut = 0x1f40000;
        data[14] |= dw14Lut;

        static const uint32_t dw15Lut = 0x138807d0;
        data[15] |= dw15Lut;

        static const uint32_t dw16Lut = 0xf00ff00;
        data[16] |= dw16Lut;

        static const uint32_t dw17Lut = 0x3e8;
        data[17] |= dw17Lut;

        static const uint32_t dw18Lut = 0x80000;
        data[18] |= dw18Lut;

        static const uint32_t dw19Lut = 0x18000040;
        data[19] |= dw19Lut;

        static const uint32_t dw28Lut = 0x7d00fa0;
        data[28] |= dw28Lut;

        static const uint32_t dw29Lut = 0x2bc0bb8;
        data[29] |= dw29Lut;

        static const uint32_t dw30Lut = 0x32003e8;
        data[30] |= dw30Lut;

        static const uint32_t dw31Lut = 0x1f4012c;
        data[31] |= dw31Lut;

        static const uint32_t dw32Lut = 0x55220190;
        data[32] |= dw32Lut;

        static const uint32_t dw33Lut = 0x22552222;
        data[33] |= dw33Lut;

        static const uint32_t dw34Lut = 0x225522;
        data[34] |= dw34Lut;

        static const uint32_t dw35Lut = 0x800;
        data[35] |= dw35Lut;

        static const uint32_t dw51Lut[2][3][2][2] = { { { { 0x33331502, 0x33331502,}, { 0x33331502, 0x20001502,},}, { { 0x22333102, 0x22333102,}, { 0x22333102, 0x20003102,},}, { { 0x22227102, 0x22227102,}, { 0x22227102, 0x20007102,},},}, { { { 0x33331502, 0x33331502,}, { 0x33331502, 0x33331502,},}, { { 0x22333102, 0x22333102,}, { 0x22333102, 0x22333102,},}, { { 0x22227102, 0x22227102,}, { 0x22227102, 0x22227102,},},},};
        data[51] |= dw51Lut[FrameType][TargetUsageDiv3][NotSimuEnv][Wa_22011549751];

        static const uint32_t dw52Lut[3] = { 0x77f5bdb, 0x72d5949, 0x929595a,};
        data[52] |= dw52Lut[TargetUsageDiv3];

        static const uint32_t dw53Lut[2][3][2][2][2] = { { { { { 0xffffffff, 0xffffffff,}, { 0xffffffff, 0xffffffff,},}, { { 0xffffffff, 0xffffffff,}, { 0x80000000, 0x80000000,},},}, { { { 0xfff00000, 0xfff00000,}, { 0xfff00000, 0xfff00000,},}, { { 0xfff00000, 0xfff00000,}, { 0x80000000, 0x80000000,},},}, { { { 0x80000000, 0x80000000,}, { 0x80000000, 0x80000000,},}, { { 0x80000000, 0x80000000,}, { 0x80000000, 0x80000000,},},},}, { { { { 0xffffffff, 0xffffffff,}, { 0xffffffff, 0xffffffff,},}, { { 0xffffffff, 0xfffffff0,}, { 0xffffffff, 0xfffffff0,},},}, { { { 0xfff00000, 0xfff00000,}, { 0xfff00000, 0xfff00000,},}, { { 0xfff00000, 0xfff0fff0,}, { 0xfff00000, 0xfff0fff0,},},}, { { { 0x80000000, 0x80000000,}, { 0x80000000, 0x80000000,},}, { { 0x80000000, 0x8000fff0,}, { 0x80000000, 0x8000fff0,},},},},};
        data[53] |= dw53Lut[FrameType][TargetUsageDiv3][NotSimuEnv][Wa_22011549751][Wa_14010476401];

        static const uint32_t dw54Lut[3][2][2] = { { { 0, 0,}, { 0, 0,},}, { { 0x44000000, 0x44000000,}, { 0x44000000, 0x44000000,},}, { { 0x8c000000, 0x8c000000,}, { 0x8c000000, 0x4000000,},},};
        data[54] |= dw54Lut[TargetUsageDiv3][NotSimuEnv][Wa_22011531258];

        return MOS_STATUS_SUCCESS;
    }

 MOS_STATUS AddVdencCmd1Cmd(
        PMOS_COMMAND_BUFFER          cmdBuffer,
        PMHW_BATCH_BUFFER            batchBuffer,
        PMHW_VDBOX_VDENC_CMD1_PARAMS params) override
    {
        MHW_FUNCTION_ENTER;

        MHW_MI_CHK_NULL(params);

        if (params->Mode != CODECHAL_ENCODE_MODE_VP9)
        {
            return MOS_STATUS_UNIMPLEMENTED;
        }

        if (cmdBuffer == nullptr && batchBuffer == nullptr)
        {
            MHW_ASSERTMESSAGE("There was no valid buffer to add the HW command to.");
            return MOS_STATUS_NULL_POINTER;
        }

        typename mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_CMD1_CMD cmd;

        if (params->pHevcEncPicParams != nullptr)
        {
            if (params->pHevcEncPicParams->CodingType != I_TYPE)
            {
                cmd.DW31.Value = 0x10001000;
            }
        }

        cmd.DW23.Value = 0x10101010;
        cmd.DW24.Value = 0x10101010;
        cmd.DW25.Value = 0x10101010;
        cmd.DW26.Value = 0x10101010;
        cmd.DW27.Value = 0x10101010;
        cmd.DW28.Value = 0x10101010;
        cmd.DW29.Value = 0x10101010;
        cmd.DW30.Value = 0x10101010;
        cmd.DW32.Value = 0;

        MHW_MI_CHK_STATUS(AddVdencCmd1CmdVp9(cmd, params));
        MHW_MI_CHK_STATUS(Mhw_AddCommandCmdOrBB(cmdBuffer, batchBuffer, &cmd, sizeof(cmd)));

        return MOS_STATUS_SUCCESS;
    }

    MOS_STATUS AddVdencCmd1CmdVp9(
        mhw::vdbox::vdenc::xe_hpm::Cmd::VDENC_CMD1_CMD &cmd,
        PMHW_VDBOX_VDENC_CMD1_PARAMS                    params)
    {
        MHW_FUNCTION_ENTER;

        MHW_MI_CHK_NULL(params);

        MHW_MI_CHK_NULL(params->pVp9EncPicParams);

        auto vp9PicParams = params->pVp9EncPicParams;

        auto qp = vp9PicParams->LumaACQIndex;

        auto vp9FrameType = vp9PicParams->PicFlags.fields.frame_type;

        double DLOCAL0 = (vp9FrameType == CODEC_VP9_KEY_FRAME) ? 0.31 : 0.33;
        double DLOCAL1  = DLOCAL0 * CODECHAL_VP9_QUANT_AC[qp] / 8;

        uint16_t ULOCAL0 = (uint16_t)(DLOCAL1 * 4 + 0.5);

        cmd.DW22.VDENC_CMD1_DW22_BIT16 = ULOCAL0;
        cmd.DW22.VDENC_CMD1_DW22_BIT0  = (uint16_t)(DLOCAL1 * DLOCAL1 * 4 + 0.5);

        double DLOCAL2 = DLOCAL0 * CODECHAL_VP9_QUANT_AC[10] / 8;

        uint16_t ULOCAL1 = (uint16_t)(DLOCAL2 * 4 + 0.5);

        cmd.DW1.Value = 0x5030200;
        cmd.DW2.Value = 0xb090806;
        cmd.DW3.Value = 0x1C140C04;
        cmd.DW4.Value = 0x3C342C24;
        cmd.DW5.Value = 0x5C544C44;
        cmd.DW6.Value = 0x1C140C04;
        cmd.DW7.Value = 0x3C342C24;
        cmd.DW8.Value = 0x5C544C44;

        cmd.DW14.Value = 0;
        cmd.DW15.Value = 0;
        cmd.DW16.Value = 0;

        if (vp9FrameType == CODEC_VP9_KEY_FRAME)
        {
            cmd.DW9.Value  = 0;
            cmd.DW10.Value = 0;
            cmd.DW11.Value = 0;
            cmd.DW12.Value = 0;
            cmd.DW13.Value = 0;
            cmd.DW13.VDENC_CMD1_DW13_BIT24 = 0x1E;
            cmd.DW16.VDENC_CMD1_DW16_BIT16 = 0x07;

            cmd.DW17.Value = 0x0D0E1007;
            cmd.DW18.Value = 0x143A1E32;
            
            cmd.DW31.Value &= 0xFF000000;
        }
        else
        {
            cmd.DW9.Value  = 0xC0408;
            cmd.DW10.Value = 0x1A0E170B;
            cmd.DW11.Value = 0x26141A0E;
            cmd.DW12.Value = 0x155C175C;
            cmd.DW13.Value = 0x36040017;

            cmd.DW16.VDENC_CMD1_DW16_BIT16 = 0x07;
            cmd.DW16.VDENC_CMD1_DW16_BIT24 = 0x04;

            cmd.DW17.Value = 0x14141407;
            cmd.DW18.Value = 0x1918441E;

            cmd.DW31.VDENC_CMD1_DW31_BIT16 = 0x14;
            cmd.DW31.VDENC_CMD1_DW31_BIT8  = 0x14;
            cmd.DW31.VDENC_CMD1_DW31_BIT0  = 0x14;
        }

        cmd.DW19.Value = 0x00140000;
        cmd.DW20.Value = 0x0C0C0C0C;
        cmd.DW21.Value = 0x0C0C0C0C;

        return MOS_STATUS_SUCCESS;
    }
};
#endif // __MHW_VDBOX_VDENC_XE_HPM_H__
