/*
 * ion/ioncore/property.c
 *
 * Copyright (c) Tuomo Valkonen 1999-2004. 
 *
 * Ion is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 */

#include <X11/Xmd.h>
#include <string.h>

#include "common.h"
#include "property.h"
#include "global.h"


ulong xwindow_get_property(Window win, Atom atom, Atom type, 
                           ulong n32expected, bool more, uchar **p)
{
    Atom real_type;
    int format;
    ulong n=-1, extra=0;
    int status;
    
    do{
        status=XGetWindowProperty(ioncore_g.dpy, win, atom, 0L, n32expected, 
                                  False, type, &real_type, &format, &n,
                                  &extra, p);
        
        if(status!=Success || *p==NULL)
            return -1;
    
        if(extra==0 || !more)
            break;
        
        XFree((void*)*p);
        n32expected+=extra;
        more=FALSE;
    }while(1);

    if(n==0){
        XFree((void*)*p);
        *p=NULL;
        return -1;
    }
    
    return n;
}


/* string
 */

char *xwindow_get_string_property(Window win, Atom a, int *nret)
{
    char *p;
    int n;
    
    n=xwindow_get_property(win, a, XA_STRING, 64L, TRUE, (uchar**)&p);
    
    if(nret!=NULL)
        *nret=n;
    
    return (n<=0 ? NULL : p);
}


void xwindow_set_string_property(Window win, Atom a, const char *value)
{
    if(value==NULL){
        XDeleteProperty(ioncore_g.dpy, win, a);
    }else{
        XChangeProperty(ioncore_g.dpy, win, a, XA_STRING,
                        8, PropModeReplace, (uchar*)value, strlen(value));
    }
}


/* integer
 */

bool xwindow_get_integer_property(Window win, Atom a, int *vret)
{
    long *p=NULL;
    ulong n;
    
    n=xwindow_get_property(win, a, XA_INTEGER, 1L, FALSE, (uchar**)&p);
    
    if(n>0 && p!=NULL){
        *vret=*p;
        XFree((void*)p);
        return TRUE;
    }
    
    return FALSE;
}


void xwindow_set_integer_property(Window win, Atom a, int value)
{
    CARD32 data[2];
    
    data[0]=value;
    
    XChangeProperty(ioncore_g.dpy, win, a, XA_INTEGER,
                    32, PropModeReplace, (uchar*)data, 1);
}


/* WM_STATE
 */

bool xwindow_get_state_property(Window win, int *state)
{
    CARD32 *p=NULL;
    
    if(xwindow_get_property(win, ioncore_g.atom_wm_state, 
                            ioncore_g.atom_wm_state, 
                            2L, FALSE, (uchar**)&p)<=0)
        return FALSE;
    
    *state=*p;
    
    XFree((void*)p);
    
    return TRUE;
}


void xwindow_set_state_property(Window win, int state)
{
    CARD32 data[2];
    
    data[0]=state;
    data[1]=None;
    
    XChangeProperty(ioncore_g.dpy, win,
                    ioncore_g.atom_wm_state, ioncore_g.atom_wm_state,
                    32, PropModeReplace, (uchar*)data, 2);
}


/* xwindow_get_text_property
 */

char **xwindow_get_text_property(Window win, Atom a, int *nret)
{
    XTextProperty prop;
    char **list=NULL;
    int n=0;
    Status st=0;
    
    st=XGetTextProperty(ioncore_g.dpy, win, &prop, a);

    if(nret)
        *nret=(!st ? 0 : -1);
    
    if(!st)
        return NULL;

#ifdef CF_XFREE86_TEXTPROP_BUG_WORKAROUND
    while(prop.nitems>0){
        if(prop.value[prop.nitems-1]=='\0')
            prop.nitems--;
        else
            break;
    }
#endif

    if(!ioncore_g.use_mb){
        st=XTextPropertyToStringList(&prop, &list, &n);
    }else{
        st=XmbTextPropertyToTextList(ioncore_g.dpy, &prop, &list, &n);
        st=!st;
    }

    XFree(prop.value);
    
    if(!st || n==0 || list==NULL)
        return NULL;
    
    if(nret)
        *nret=n;
    
    return list;
}


void xwindow_set_text_property(Window win, Atom a, const char *str)
{
    XTextProperty prop;
    const char *ptr[1]={NULL};
    Status st;

    ptr[0]=str;
    
    if(!ioncore_g.use_mb){
        st=XStringListToTextProperty((char **)&ptr, 1, &prop);
    }else{
#ifdef X_HAVE_UTF8_STRING        
        st=XmbTextListToTextProperty(ioncore_g.dpy, (char **)&ptr, 1,
                                     XUTF8StringStyle, &prop);
#else        
        st=XmbTextListToTextProperty(ioncore_g.dpy, (char **)&ptr, 1,
                                     XTextStyle, &prop);
#endif        
        st=!st;
    }
    
    if(!st)
        return;
    
    XSetTextProperty(ioncore_g.dpy, win, &prop, a);
    XFree(prop.value);
}
