/*
 * libtu/objlist.c
 *
 * Copyright (c) Tuomo Valkonen 1999-2004. 
 *
 * You may distribute and modify this library under the terms of either
 * the Clarified Artistic License or the GNU LGPL, version 2.1 or later.
 */

#include "obj.h"
#include "types.h"
#include "objlist.h"
#include "dlist.h"
#include "misc.h"


static ObjList *iter_next=NULL;


static void free_node(ObjList **objlist, ObjList *node)
{
    UNLINK_ITEM(*objlist, node, next, prev);
    free(node);
}

    
void watch_handler(Watch *watch, Obj *obj)
{
    ObjList *node=(ObjList*)watch;
    ObjList **list=node->list;
    
    if(iter_next==node)
        iter_next=node->next;
    
    free_node(list, node);
}



bool objlist_insert(ObjList **objlist, Obj *obj)
{
    ObjList *node;
    
    if(obj==NULL)
        return FALSE;
    
    node=ALLOC(ObjList);
    
    if(node==NULL)
        return FALSE;
        
    watch_init(&(node->watch));
    watch_setup(&(node->watch), obj, watch_handler);
    node->list=objlist;
    
    LINK_ITEM_FIRST(*objlist, node, next, prev);
    
    return TRUE;
}


void objlist_remove(ObjList **objlist, Obj *obj)
{
    ObjList *node=*objlist;
    
    while(node!=NULL){
        if(node->watch.obj==obj){
            watch_reset(&(node->watch));
            free_node(objlist, node);
            return;
        }
        node=node->next;
    }
}


void objlist_clear(ObjList **objlist)
{
    while(*objlist!=NULL){
        watch_reset(&((*objlist)->watch));
        free_node(objlist, *objlist);
    }
}


/* Warning: not thread-safe */


Obj *objlist_init_iter(ObjList *objlist)
{
    if(objlist==NULL){
        iter_next=NULL;
        return NULL;
    }
    
    iter_next=objlist->next;
    return objlist->watch.obj;
}


Obj *objlist_iter()
{
    ObjList *ret;
    
    if(iter_next==NULL)
        return NULL;
    
    ret=iter_next;
    iter_next=iter_next->next;
    
    return ret->watch.obj;
}
