// -*- C++ -*-
// --------------------------------------------------------------------
// Various utility classes
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEUTILS_H
#define IPEUTILS_H

#include "ipebitmap.h"
#include "ipevisitor.h"
#include "ipepainter.h"

// --------------------------------------------------------------------

class IpePage;

class IPE_EXPORT IpeBitmapFinder : public IpeVisitor {
 public:
  void IpeBitmapFinder::ScanPage(const IpePage *page);

  virtual void VisitGroup(const IpeGroup *obj);
  virtual void VisitImage(const IpeImage *obj);
  virtual void VisitReference(const IpeReference *obj);
public:
  std::vector<IpeBitmap> iBitmaps;
};

class IPE_EXPORT IpeBBoxPainter : public IpePainter {
public:
  IpeBBoxPainter(const IpeStyleSheet *style);
  IpeRect BBox() const { return iBBox; }

  virtual void BeginPath(const IpeVector &v);
  virtual void BeginClosedPath(const IpeVector &v);
  virtual void LineTo(const IpeVector &v);
  virtual void CurveTo(const IpeVector &v1, const IpeVector &v2,
		       const IpeVector &v3);
  virtual void DrawBitmap(IpeBitmap bitmap);
  virtual void DrawText(const IpeText *text);
private:
  void Add(const IpeVector &pos);
  IpeRect iBBox;
  IpeVector iV;
};

// --------------------------------------------------------------------
#endif
