// -*- C++ -*-
// --------------------------------------------------------------------
// The Ipe document, with PDF support.
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2004  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPEDOCPDF_H
#define IPEDOCPDF_H

#include "ipedoc.h"

#include <qstring.h>

class IpeFontPool;
class QStringList;

// --------------------------------------------------------------------

class IpePdfDocument : public IpeDocument {
public:
  //! There are two Ipe document save formats.
  enum TFormat {
    EXml,  //!< Save as XML
    EPdf,  //!< Save as PDF
    EPs,   //!< Save as Postscript
    EEps,  //!< Save as Encapsulated Postscript
    EIpe5,  //!< Old Ipe format
    EUnknown //!< Unknown file format
  };

  static IpePdfDocument *New(QString fname, TFormat format, int &reason);
  static TFormat FileFormat(QString fname);

  IpePdfDocument();
  ~IpePdfDocument();

  bool Save(QString fname, TFormat format, bool doExport = false);
  void SetFontPool(IpeFontPool *fontPool);
  //! Return the current IpeFontPool.
  inline const IpeFontPool *FontPool() const { return iFontPool; }

  //! Error codes returned by RunLatex.
  enum { ErrNone, ErrNoText, ErrNoDir, ErrWritingSource,
	 ErrOldPdfLatex, ErrLatex, ErrAlreadyHaveForm,
	 ErrLatexOutput };

  int RunLatex(bool needLatex, const QStringList &styleDirs);
  //! Return contents of log file from most recent Latex run.
  inline QString LogFile() const { return iLogFile; }
  bool AddStyleSheet(const QString &fn);

private:
  IpeFontPool *iFontPool;
  QString iLogFile;
};

// --------------------------------------------------------------------
#endif
