# -*- text -*-
# --------------------------------------------------------------------
#
# Ipe configuration
#
# --------------------------------------------------------------------
#
# Freetype location
#
# Path to "ft2build.h" (if not on standard include path)
FREETYPE_INCLUDE  = /usr/include/freetype2
# Path to "libfreetype.so" (if not in a standard library directory)
#FREETYPE_LIBPATH = /usr/lib
# --------------------------------------------------------------------
#
# Zlib location
#
# Path to "zlib.h" (if not on standard include path)
#ZLIB_INCLUDE     = /usr/include
# Path to "libz.so" (if not in a standard library directory)
#ZLIB_LIBPATH     = -L/usr/lib
# --------------------------------------------------------------------
#
# Installing Ipe:
#
IPEVERS = 6.0pre28
#
# IPEPREFIX is the global prefix for the Ipe directory structure, which
# you can override individually for any of the specific directories.
# You could choose "/usr/local" or "/opt/ipe-6.0", or
# even "/usr", or "$(HOME)/ipe-6.0" if you have to install in your home
# directory.
#
# If you are installing Ipe in a networked environment, keep in mind
# that executables, ipelets, and Ipe library are machine-dependent,
# while the documentation and fonts can be shared.
#
#IPEPREFIX  = /usr/local/ipe
#IPEPREFIX  = /usr
#IPEPREFIX  = /opt/ipe-6.0
#
!win32:isEmpty( IPEPREFIX ) {
  error( "You need to specify IPEPREFIX!")
}
#
# Where Ipe executables will be installed ('ipe', 'ipe5toxml' etc)
IPEBINDIR  = $${IPEPREFIX}/bin
#
# Where the Ipe libraries will be installed (libipe.so.*)
IPELIBDIR  = $${IPEPREFIX}/lib
#
# Where the header files for Ipelib will be installed:
IPEHEADERDIR = $${IPEPREFIX}/include
#
# Where Ipelets will be installed:
IPELETDIR = $${IPEPREFIX}/lib/ipe/$${IPEVERS}/ipelets
#
# List of paths where Ipe will search for Ipelets:
# (Paths are separated by ":" on Windows and ";" on Unix)
IPELETPATH = $${IPELETDIR}
#
# IPEDOCDIR will contain the Ipe documentation (mostly html files)
#
isEmpty( IPEDOCDIR ) {
  IPEDOCDIR  = $${IPEPREFIX}/share/ipe/$${IPEVERS}/doc
}
#
# IPELANGDIR will contain Ipe UI translations (none exist yet)
#
IPELANGDIR = $${IPEPREFIX}/share/ipe/$${IPEVERS}/languages
#
# IPEMANDIR will contain the Ipe manual pages
#
IPEMANDIR  = $${IPEPREFIX}/share/man/man1
#
# The full path to the Ipe fontmap
#
IPEFONTMAP = $${IPEPREFIX}/share/ipe/$${IPEVERS}/fontmap.xml
#
# The standard key assignment of Ipe
#
IPEKEYSFILEDIR = $${IPEPREFIX}/share/ipe/$${IPEVERS}
IPEKEYSFILE = $${IPEKEYSFILEDIR}/ipekeys.xml
#
# The HTML browser started to read the on-line Ipe documentation.
#
IPEBROWSER = mozilla
#
# --------------------------------------------------------------------
# Standard definitions --- don't change
CONFIG	    -= qt
CONFIG      += warn_on release
DEFINES     += QT_NO_CAST_FROM_ASCII
# --------------------------------------------------------------------
linux-g++:QMAKE_CXXFLAGS_WARN_ON += -Werror
# --------------------------------------------------------------------
win32 {
  DEFINES	    += WIN32
  ZLIB_INCLUDE	    = c:/Home/devel/zlib/src
  ZLIB_LIBPATH	    = c:/Home/devel/zlib/lib
  FREETYPE_INCLUDE  = c:/Home/devel/freetype/include
  FREETYPE_LIBPATH  = c:/Home/devel/freetype/lib
}
# --------------------------------------------------------------------
