/*
 * Copyright (c) 2018, Intel Corporation.
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include <Uefi.h>
#include <Library/BaseLib.h>
#include <Library/DebugLib.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/UefiDriverEntryPoint.h>

/*
 * Note: Autogen.c and Autogen.h in UEFI builds are normally automatically generated
 * files in Build/.../cli/... or Build/.../driver/... that are built from preferences set
 * in DcpmPkg.dsc and DcpmPkg.dec by the UEFI pre-processor python scripts.
 * Since we don't have that pre-processor set up yet for OS builds, we need a stop gap
 * so that the UEFI libraries we compile against are happy. So we define our own
 * Autogen.c and Autogen.h here and have a minimum of defines.
 */

GLOBAL_REMOVE_IF_UNREFERENCED GUID gEfiCallerIdGuid = {0x9ce4325e, 0x003e, 0x11e3, {0xb5, 0x82, 0xb8, 0xac, 0x6f, 0x19, 0x9a, 0x57}};

GLOBAL_REMOVE_IF_UNREFERENCED CHAR8 *gEfiCallerBaseName = "IntelDCPersistentMemoryDriver";

// Guids
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gNvmDimmCliVariableGuid = { 0x11c64219, 0xbfa2, 0x42ce,{ 0x99, 0xb1, 0x17, 0x0b, 0x4a, 0x2b, 0xe0, 0x8e } };
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiIfrTianoGuid = { 0xf0b1735, 0x87a0, 0x4193, {0xb2, 0x66, 0x53, 0x8c, 0x38, 0xaf, 0x48, 0xce }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiSmbiosTableGuid = { 0xEB9D2D31, 0x2D88, 0x11D3, { 0x9A, 0x16, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiSmbios3TableGuid = { 0xF2FD1544, 0x9794, 0x4A2C, { 0x99, 0x2E, 0xE5, 0xBB, 0xCF, 0x20, 0xE3, 0x94 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiAcpiTableGuid = { 0x8868E871, 0xE4F1, 0x11D3, { 0xBC, 0x22, 0x00, 0x80, 0xC7, 0x3C, 0x88, 0x81 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiAcpi10TableGuid = { 0xEB9D2D30, 0x2D88, 0x11D3, { 0x9A, 0x16, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiAcpi20TableGuid = { 0x8868E871, 0xE4F1, 0x11D3, { 0xBC, 0x22, 0x00, 0x80, 0xC7, 0x3C, 0x88, 0x81 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiFileInfoGuid = { 0x09576E92, 0x6D3F, 0x11D2, { 0x8E, 0x39, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gNvmDimmNgnvmVariableGuid = { 0x8986be7a, 0x212f, 0x427e, {0x81, 0xa5, 0x42, 0x0d, 0xab, 0xc7, 0x92, 0xdf}};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gNvmDimmHiiVariableGuid = {0xbac1898e, 0x751d, 0x11e6, {0x8b, 0x77, 0x86, 0xf3, 0x0c, 0xa8, 0x93, 0xd3}};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiMdePkgTokenSpaceGuid = { 0x914AEBE7, 0x4635, 0x459b, { 0xAA, 0x1C, 0x11, 0xE2, 0x19, 0xB0, 0x3A, 0x10 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiVTUTF8Guid = { 0xAD15A0D6, 0x8BEC, 0x4ACF, { 0xA0, 0x73, 0xD0, 0x1D, 0xE7, 0x7E, 0x2D, 0x88 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiVT100Guid = { 0xDFA66065, 0xB419, 0x11D3, { 0x9A, 0x2D, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiVT100PlusGuid = { 0x7BAEC70B, 0x57E0, 0x4C76, { 0x8E, 0x87, 0x2F, 0x9E, 0x28, 0x08, 0x83, 0x43 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiPcAnsiGuid = { 0xE0C14753, 0xF9BE, 0x11D2, { 0x9A, 0x0C, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiUartDevicePathGuid = { 0x37499a9d, 0x542f, 0x4c89, { 0xa0, 0x26, 0x35, 0xda, 0x14, 0x20, 0x94, 0xe4 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiSasDevicePathGuid = { 0xd487ddb4, 0x008b, 0x11d9, { 0xaf, 0xdc, 0x00, 0x10, 0x83, 0xff, 0xca, 0x4d }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiVirtualDiskGuid = { 0x77AB535A, 0x45FC, 0x624B, {0x55, 0x60, 0xF7, 0xB2, 0x81, 0xD1, 0xF9, 0x6E }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiVirtualCdGuid = { 0x3D5ABD30, 0x4175, 0x87CE, {0x6D, 0x64, 0xD2, 0xAD, 0xE5, 0x23, 0xC4, 0xBB }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiPersistentVirtualDiskGuid = { 0x5CEA02C9, 0x4D07, 0x69D3, {0x26, 0x9F ,0x44, 0x96, 0xFB, 0xE0, 0x96, 0xF9 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiPersistentVirtualCdGuid = { 0x08018188, 0x42CD, 0xBB48, {0x10, 0x0F, 0x53, 0x87, 0xD5, 0x3D, 0xED, 0x3D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiEventReadyToBootGuid = { 0x7CE88FB3, 0x4BD7, 0x4679, { 0x87, 0xA8, 0xA8, 0xD8, 0xDE, 0xE5, 0x0D, 0x2B }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiEventLegacyBootGuid = { 0x2A571201, 0x4966, 0x47F6, { 0x8B, 0x86, 0xF3, 0x1E, 0x41, 0xF3, 0x2F, 0x10 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiGlobalVariableGuid = { 0x8BE4DF61, 0x93CA, 0x11D2, { 0xAA, 0x0D, 0x00, 0xE0, 0x98, 0x03, 0x2B, 0x8C }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiShellProtocolGuid = { 0x6302d008, 0x7f9b, 0x4f30,{ 0x87, 0xac, 0x60, 0xc9, 0xfe, 0xf5, 0xda, 0x4e } };

// Protocols
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDriverBindingProtocolGuid = { 0x18A031AB, 0xB443, 0x4D1A, { 0xA5, 0xC0, 0x0C, 0x09, 0x26, 0x1E, 0x9F, 0x71 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiPciIoProtocolGuid = { 0x4CF5B200, 0x68B8, 0x4CA5, { 0x9E, 0xEC, 0xB2, 0x3E, 0x3F, 0x50, 0x02, 0x9A }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDriverSupportedEfiVersionProtocolGuid = { 0x5c198761, 0x16a8, 0x4e69, { 0x97, 0x2c, 0x89, 0xd6, 0x79, 0x54, 0xf8, 0x1d } };
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiComponentName2ProtocolGuid = { 0x6A7A5CFF, 0xE8D9, 0x4F70, { 0xBA, 0xDA, 0x75, 0xAB, 0x30, 0x25, 0xCE, 0x14 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiComponentNameProtocolGuid = { 0x107A772C, 0xD5E1, 0x11D4, { 0x9A, 0x46, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDriverDiagnostics2ProtocolGuid = { 0x4D330321, 0x025F, 0x4AAC, { 0x90, 0xD8, 0x5E, 0xD9, 0x00, 0x17, 0x3B, 0x63 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDriverDiagnosticsProtocolGuid = { 0x0784924F, 0xE296, 0x11D4, { 0x9A, 0x49, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDriverHealthProtocolGuid = { 0x2a534210, 0x9280, 0x41d8, {0xae, 0x79, 0xca, 0xda, 0x1, 0xa2, 0xb1, 0x27 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiBlockIoProtocolGuid = { 0x964E5B21, 0x6459, 0x11D2, { 0x8E, 0x39, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiBlockIo2ProtocolGuid = { 0xa77b2472, 0xe282, 0x4e9f, {0xa2, 0x45, 0xc2, 0xc0, 0xe2, 0x7b, 0xbc, 0xc1 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiFirmwareManagementProtocolGuid = { 0x86c77a67, 0xb97, 0x4633, {0xa1, 0x87, 0x49, 0x10, 0x4d, 0x6, 0x85, 0xc7 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiSimpleFileSystemProtocolGuid = { 0x964E5B22, 0x6459, 0x11D2, { 0x8E, 0x39, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDevicePathProtocolGuid = { 0x09576E91, 0x6D3F, 0x11D2, { 0x8E, 0x39, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDebugPortProtocolGuid = { 0xEBA4E8D2, 0x3858, 0x41EC, { 0xA2, 0x81, 0x26, 0x47, 0xBA, 0x96, 0x60, 0xD0 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiHiiFontProtocolGuid = {0xe9ca4775, 0x8657, 0x47fc, {0x97, 0xe7, 0x7e, 0xd6, 0x5a, 0x08, 0x43, 0x24}};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiHiiStringProtocolGuid = {0x0fd96974, 0x23aa, 0x4cdc, {0xb9, 0xcb, 0x98, 0xd1, 0x77, 0x50, 0x32, 0x2a}};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiHiiImageProtocolGuid = {0x31a6406a, 0x6bdf, 0x4e46, {0xb2, 0xa2, 0xeb, 0xaa, 0x89, 0xc4, 0x09, 0x20}};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiHiiDatabaseProtocolGuid = {0xef9fc172, 0xa1b2, 0x4693, {0xb3, 0x27, 0x6d, 0x32, 0xfc, 0x41, 0x60, 0x42}};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiHiiConfigRoutingProtocolGuid = {0x587e72d7, 0xcc50, 0x4f79, {0x82, 0x09, 0xca, 0x29, 0x1f, 0xc1, 0xa1, 0x0f}};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiSimpleTextOutProtocolGuid = { 0x387477C2, 0x69C7, 0x11D2, { 0x8E, 0x39, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiGraphicsOutputProtocolGuid = { 0x9042A9DE, 0x23DC, 0x4A38, { 0x96, 0xFB, 0x7A, 0xDE, 0xD0, 0x80, 0x51, 0x6A }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiUgaDrawProtocolGuid = { 0x982C298B, 0xF4FA, 0x41CB, { 0xB8, 0x38, 0x77, 0xAA, 0x68, 0x8F, 0xB8, 0x39 }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDriverConfigurationProtocolGuid = { 0x107A772B, 0xD5E1, 0x11D4, { 0x9A, 0x46, 0x00, 0x90, 0x27, 0x3F, 0xC1, 0x4D }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiDriverConfiguration2ProtocolGuid = { 0xBFD7DC1D, 0x24F1, 0x40D9, { 0x82, 0xE7, 0x2E, 0x09, 0xBB, 0x6B, 0x4E, 0xBE }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiLoadedImageProtocolGuid = { 0x5B1B31A1, 0x9562, 0x11D2, { 0x8E, 0x3F, 0x00, 0xA0, 0xC9, 0x69, 0x72, 0x3B }};
GLOBAL_REMOVE_IF_UNREFERENCED EFI_GUID gEfiFormBrowser2ProtocolGuid = {0xb9d4c360, 0xbcfb, 0x4f9b, {0x92, 0x98, 0x53, 0xc1, 0x36, 0x98, 0x22, 0x58}};

// Definition of PCDs used in this module
UINT64 _gPcd_BinaryPatch_PcdPciExpressBaseAddress = _PCD_PATCHABLE_VALUE_PcdPciExpressBaseAddress;
GLOBAL_REMOVE_IF_UNREFERENCED UINTN _gPcd_BinaryPatch_Size_PcdPciExpressBaseAddress = 8;

/*
 * The "tokens" here are just unique identifiers. Their value doesn't
 * matter as long as it doesn't overlap another token.
 */

#define _PCD_TOKEN_PcdVerifyNodeInList  2U
#define _PCD_SIZE_PcdVerifyNodeInList 1
#define _PCD_GET_MODE_SIZE_PcdVerifyNodeInList  _PCD_SIZE_PcdVerifyNodeInList
#define _PCD_VALUE_PcdVerifyNodeInList  ((BOOLEAN)0U)
GLOBAL_REMOVE_IF_UNREFERENCED const BOOLEAN _gPcd_FixedAtBuild_PcdVerifyNodeInList = _PCD_VALUE_PcdVerifyNodeInList;

#define _PCD_TOKEN_PcdMaximumLinkedListLength  3U
#define _PCD_SIZE_PcdMaximumLinkedListLength 4
#define _PCD_GET_MODE_SIZE_PcdMaximumLinkedListLength  _PCD_SIZE_PcdMaximumLinkedListLength
#define _PCD_VALUE_PcdMaximumLinkedListLength  1000000U
GLOBAL_REMOVE_IF_UNREFERENCED const UINT32 _gPcd_FixedAtBuild_PcdMaximumLinkedListLength = _PCD_VALUE_PcdMaximumLinkedListLength;

#define _PCD_TOKEN_PcdMaximumAsciiStringLength  4U
#define _PCD_SIZE_PcdMaximumAsciiStringLength 4
#define _PCD_GET_MODE_SIZE_PcdMaximumAsciiStringLength  _PCD_SIZE_PcdMaximumAsciiStringLength
#define _PCD_VALUE_PcdMaximumAsciiStringLength  1000000U
GLOBAL_REMOVE_IF_UNREFERENCED const UINT32 _gPcd_FixedAtBuild_PcdMaximumAsciiStringLength = _PCD_VALUE_PcdMaximumAsciiStringLength;

#define _PCD_TOKEN_PcdMaximumUnicodeStringLength  5U
#define _PCD_SIZE_PcdMaximumUnicodeStringLength 4
#define _PCD_GET_MODE_SIZE_PcdMaximumUnicodeStringLength  _PCD_SIZE_PcdMaximumUnicodeStringLength
#define _PCD_VALUE_PcdMaximumUnicodeStringLength  1000000U
GLOBAL_REMOVE_IF_UNREFERENCED const UINT32 _gPcd_FixedAtBuild_PcdMaximumUnicodeStringLength = _PCD_VALUE_PcdMaximumUnicodeStringLength;

#define _PCD_TOKEN_PcdMaximumDevicePathNodeCount  7U
#define _PCD_SIZE_PcdMaximumDevicePathNodeCount 4
#define _PCD_GET_MODE_SIZE_PcdMaximumDevicePathNodeCount  _PCD_SIZE_PcdMaximumDevicePathNodeCount
#define _PCD_VALUE_PcdMaximumDevicePathNodeCount  0U
GLOBAL_REMOVE_IF_UNREFERENCED const UINT32 _gPcd_FixedAtBuild_PcdMaximumDevicePathNodeCount = _PCD_VALUE_PcdMaximumDevicePathNodeCount;


extern EFI_STATUS EFIAPI NvmDimmDriverDriverEntryPoint(IN EFI_HANDLE ImageHandle, IN EFI_SYSTEM_TABLE *pSystemTable);
extern EFI_STATUS EFIAPI NvmDimmDriverUnload(IN EFI_HANDLE ImageHandle);

EFI_STATUS
EFIAPI
UefiBootServicesTableLibConstructor (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  );

EFI_STATUS
EFIAPI
UefiRuntimeServicesTableLibConstructor (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  );

EFI_STATUS
EFIAPI
UefiHiiServicesLibConstructor (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  );

EFI_STATUS
EFIAPI
UefiLibConstructor (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  );


VOID
EFIAPI
ProcessLibraryConstructorList (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  )
{
  EFI_STATUS  Status;

  Status = UefiBootServicesTableLibConstructor (ImageHandle, SystemTable);
  ASSERT_EFI_ERROR (Status);

  Status = UefiRuntimeServicesTableLibConstructor (ImageHandle, SystemTable);
  ASSERT_EFI_ERROR (Status);

  Status = UefiHiiServicesLibConstructor (ImageHandle, SystemTable);
  ASSERT_EFI_ERROR (Status);

  Status = UefiLibConstructor (ImageHandle, SystemTable);
  ASSERT_EFI_ERROR (Status);

}



VOID
EFIAPI
ProcessLibraryDestructorList (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  )
{

}

const UINT32 _gUefiDriverRevision = 0x00000000U;
const UINT32 _gDxeRevision = 0x00000000U;


EFI_STATUS
EFIAPI
ProcessModuleEntryPointList (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  )

{
  return NvmDimmDriverDriverEntryPoint (ImageHandle, SystemTable);
}

VOID
EFIAPI
ExitDriver (
  IN EFI_STATUS  Status
  )
{
  if (EFI_ERROR (Status)) {
    ProcessLibraryDestructorList (gImageHandle, gST);
  }
  gBS->Exit (gImageHandle, Status, 0, NULL);
}

GLOBAL_REMOVE_IF_UNREFERENCED const UINT8 _gDriverUnloadImageCount = 1U;


EFI_STATUS
EFIAPI
ProcessModuleUnloadList (
  IN EFI_HANDLE        ImageHandle
  )
{
  return NvmDimmDriverUnload (ImageHandle);
}


//
//Unicode String Pack Definition
//
unsigned char IntelDCPersistentMemoryDriverStrings[] = {

// STRGATHER_OUTPUT_HEADER
  0x3E,  0x4D,  0x00,  0x00,

// PACKAGE HEADER

  0x3A,  0x4D,  0x00,  0x04,  0x31,  0x00,  0x00,  0x00,  0x31,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,
  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x00,  0x01,  0x00,  0x65,  0x6E,
  0x00,

// PACKAGE DATA

// 0x0001: $PRINTABLE_LANGUAGE_NAME:0x0001
  0x14,  0x45,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x73,  0x00,  0x68,  0x00,  0x00,
  0x00,
// 0x0002: STR_DCPMM_DECIMAL_MARK:0x0002
  0x14,  0x2E,  0x00,  0x00,  0x00,
// 0x0003: STR_DCPMM_COLON_MARK:0x0003
  0x14,  0x3A,  0x00,  0x00,  0x00,
// 0x0004: STR_DCPMM_STATUS_SUCCESS:0x0004
  0x14,  0x53,  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x00,
  0x00,
// 0x0005: STR_DCPMM_STATUS_FAILED:0x0005
  0x14,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x0006: STR_DCPMM_STATUS_SOCKET:0x0006
  0x14,  0x20,  0x00,  0x53,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x00,  0x00,
// 0x0008: STR_DCPMM_STATUS_NAMESPACE:0x0008
  0x14,  0x20,  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,
  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x00,  0x00,
// 0x0009: STR_DCPMM_STATUS_POOL:0x0009
  0x14,  0x20,  0x00,  0x50,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x00,  0x00,
// 0x000A: STR_DCPMM_STATUS_ERROR:0x000A
  0x14,  0x45,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x00,  0x00,
// 0x000B: STR_DCPMM_STATUS_EXECUTE_SUCCESS:0x000B
  0x14,  0x65,  0x00,  0x78,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,
  0x00,  0x66,  0x00,  0x75,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x79,  0x00,  0x00,  0x00,
// 0x000C: STR_DCPMM_STATUS_CONTROLLER_OUT_OF_RANGE:0x000C
  0x14,  0x47,  0x00,  0x69,  0x00,  0x76,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x74,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6F,  0x00,  0x75,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x20,  0x00,  0x72,
  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,  0x00,  0x3C,  0x00,  0x25,  0x00,  0x64,
  0x00,  0x2C,  0x00,  0x25,  0x00,  0x64,  0x00,  0x3E,  0x00,  0x00,  0x00,
// 0x000D: STR_DCPMM_STATUS_MEDIA_OUT_OF_RANGE:0x000D
  0x14,  0x47,  0x00,  0x69,  0x00,  0x76,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x69,  0x00,  0x61,  0x00,  0x20,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x70,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x66,  0x00,  0x20,  0x00,  0x72,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x3C,  0x00,  0x25,  0x00,  0x64,  0x00,  0x2C,  0x00,  0x25,  0x00,  0x64,  0x00,  0x3E,  0x00,  0x00,
  0x00,
// 0x000E: STR_DCPMM_STATUS_CAPACITY_OUT_OF_RANGE:0x000E
  0x14,  0x47,  0x00,  0x69,  0x00,  0x76,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,  0x00,  0x3C,
  0x00,  0x25,  0x00,  0x64,  0x00,  0x2C,  0x00,  0x25,  0x00,  0x64,  0x00,  0x3E,  0x00,  0x00,  0x00,
// 0x000F: STR_DCPMM_STATUS_SUCCESS_FW_RESET_REQUIRED:0x000F
  0x14,  0x53,  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x2C,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x79,  0x00,  0x63,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x76,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x46,  0x00,  0x57,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0010: STR_DCPMM_STATUS_ERR_OPERATION_NOT_STARTED:0x0010
  0x14,  0x43,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x72,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x00,
  0x00,
// 0x0011: STR_DCPMM_STATUS_ERR_OPERATION_FAILED:0x0011
  0x14,  0x43,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x0012: STR_DCPMM_STATUS_ERR_INVALID_PARAMETER:0x0012
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x70,  0x00,  0x61,  0x00,  0x72,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x00,  0x00,
// 0x0013: STR_DCPMM_STATUS_ERR_FORCE_REQUIRED:0x0013
  0x14,  0x54,  0x00,  0x68,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x70,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x70,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x00,  0x00,
// 0x0014: STR_DCPMM_STATUS_ERR_DIMM_NOT_FOUND:0x0014
  0x14,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x0015: STR_DCPMM_STATUS_ERR_MANAGEABLE_DIMM_NOT_FOUND:0x0015
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x67,
  0x00,  0x65,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x79,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0016: STR_DCPMM_STATUS_ERR_FIRMWARE_API_NOT_VALID:0x0016
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x61,
  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x69,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x77,  0x00,  0x69,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x76,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x73,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x66,  0x00,  0x20,  0x00,  0x73,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x74,  0x00,  0x77,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0017: STR_DCPMM_STATUS_ERR_FIRMWARE_DOWNGRADE:0x0017
  0x14,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,
  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0018: STR_DCPMM_STATUS_ERR_FIRMWARE_ALREADY_LOADED:0x0018
  0x14,  0x41,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x61,  0x00,  0x64,  0x00,  0x79,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x67,
  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x65,
  0x00,  0x78,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x2E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x20,  0x00,  0x63,  0x00,  0x79,  0x00,  0x63,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x66,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x62,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0019: STR_DCPMM_STATUS_ERR_FIRMWARE_FAILED_TO_STAGE:0x0019
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,
  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6D,
  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x001A: STR_DCPMM_STATUS_ERR_DIMM_ID_DUPLICATED:0x001A
  0x14,  0x44,  0x00,  0x75,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x44,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x49,
  0x00,  0x44,  0x00,  0x00,  0x00,
// 0x001B: STR_DCPMM_STATUS_ERR_SOCKET_ID_NOT_VALID:0x001B
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x53,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x65,  0x00,  0x74,  0x00,  0x49,  0x00,  0x44,
  0x00,  0x00,  0x00,
// 0x001C: STR_DCPMM_STATUS_ERR_SOCKET_ID_DUPLICATED:0x001C
  0x14,  0x44,  0x00,  0x75,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x53,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x65,
  0x00,  0x74,  0x00,  0x49,  0x00,  0x44,  0x00,  0x00,  0x00,
// 0x001D: STR_DCPMM_STATUS_ERR_INVALID_PASSPHRASE:0x001D
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x70,  0x00,  0x61,  0x00,  0x73,  0x00,  0x73,  0x00,  0x70,  0x00,  0x68,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x73,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x001E: STR_DCPMM_STATUS_ERR_COMMAND_NOT_SUPPORTED_BY_THIS_SKU:0x001E
  0x14,  0x43,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x62,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x53,  0x00,  0x4B,
  0x00,  0x55,  0x00,  0x00,  0x00,
// 0x001F: STR_DCPMM_STATUS_ERR_CONFIG_NOT_SUPPORTED_BY_CURRENT_SKU:0x001F
  0x14,  0x43,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x20,  0x00,  0x6E,
  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x62,  0x00,  0x79,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x53,  0x00,  0x4B,  0x00,  0x55,  0x00,  0x00,  0x00,
// 0x0020: STR_DCPMM_STATUS_ERR_SECURITY_COUNT_EXPIRED:0x0020
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x78,  0x00,  0x69,
  0x00,  0x6D,  0x00,  0x75,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x70,  0x00,  0x61,  0x00,  0x73,  0x00,  0x73,
  0x00,  0x70,  0x00,  0x68,  0x00,  0x72,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x75,  0x00,  0x62,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x73,  0x00,  0x73,  0x00,  0x69,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x68,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x00,  0x00,
// 0x0021: STR_DCPMM_STATUS_ERR_RECOVERY_ACCESS_NOT_ENABLED:0x0021
  0x14,  0x52,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x76,  0x00,  0x65,  0x00,  0x72,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x20,  0x00,  0x55,
  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,
  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x75,  0x00,  0x70,  0x00,  0x64,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x61,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x0022: STR_DCPMM_STATUS_ERR_SECURE_ERASE_NAMESPACE_EXISTS:0x0022
  0x14,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x65,  0x00,  0x78,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x69,  0x00,  0x66,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x2E,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x79,  0x00,  0x20,
  0x00,  0x6D,  0x00,  0x75,  0x00,  0x73,  0x00,  0x74,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x76,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x62,  0x00,  0x65,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x0023: STR_DCPMM_STATUS_ERR_PASSPHRASE_TOO_LONG:0x0023
  0x14,  0x50,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x76,  0x00,  0x69,  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x70,  0x00,  0x61,  0x00,  0x73,  0x00,  0x73,  0x00,  0x70,  0x00,  0x68,  0x00,  0x72,
  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x00,
  0x00,
// 0x0024: STR_DCPMM_STATUS_ERR_PASSPHRASE_NOT_PROVIDED:0x0024
  0x14,  0x50,  0x00,  0x61,  0x00,  0x73,  0x00,  0x73,  0x00,  0x70,  0x00,  0x68,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x70,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x76,  0x00,  0x69,  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x0025: STR_DCPMM_STATUS_ERR_PASSPHRASES_DO_NOT_MATCH:0x0025
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x77,  0x00,  0x20,
  0x00,  0x70,  0x00,  0x61,  0x00,  0x73,  0x00,  0x73,  0x00,  0x70,  0x00,  0x68,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x72,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x70,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x73,  0x00,  0x70,  0x00,  0x68,  0x00,  0x72,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x64,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6D,
  0x00,  0x61,  0x00,  0x74,  0x00,  0x63,  0x00,  0x68,  0x00,  0x00,  0x00,
// 0x0026: STR_DCPMM_STATUS_ERR_SENSOR_NOT_VALID:0x0026
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x00,  0x00,
// 0x0027: STR_DCPMM_STATUS_ERR_SENSOR_ENABLED_STATE_INVALID_VALUE:0x0027
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x45,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x53,
  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x75,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x0028: STR_DCPMM_STATUS_ERR_MEDIA_DISABLED_VALUE:0x0028
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,
  0x00,  0x61,  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x64,  0x00,  0x69,  0x00,  0x73,  0x00,  0x61,  0x00,  0x62,
  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x0029: STR_DCPMM_STATUS_ERR_AIT_DRAM_NOT_READY:0x0029
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x49,  0x00,  0x54,  0x00,  0x20,
  0x00,  0x44,  0x00,  0x52,  0x00,  0x41,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,
  0x00,  0x79,  0x00,  0x00,  0x00,
// 0x002A: STR_DCPMM_STATUS_ERR_MEDIA_INTERFACE_ENGINE_STALLED:0x002A
  0x14,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,  0x00,  0x61,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x66,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x00,
  0x00,
// 0x002B: STR_DCPMM_STATUS_ERR_ENABLE_SECURITY_NOT_ALLOWED:0x002B
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,
  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x77,  0x00,  0x68,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x63,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x70,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x002C: STR_DCPMM_STATUS_ERR_CREATE_GOAL_NOT_ALLOWED:0x002C
  0x14,  0x50,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x76,  0x00,  0x69,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,
  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x27,  0x00,  0x64,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x27,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x72,  0x00,  0x79,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x67,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x002D: STR_DCPMM_STATUS_ERR_INVALID_SECURITY_STATE:0x002D
  0x14,  0x43,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x62,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x72,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,
  0x00,  0x79,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x002E: STR_DCPMM_STATUS_ERR_INVALID_SECURITY_OPERATION:0x002E
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x67,  0x00,  0x6E,
  0x00,  0x69,  0x00,  0x7A,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,
  0x00,  0x6F,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x002F: STR_DCPMM_STATUS_ERR_UNABLE_TO_GET_SECURITY_STATE:0x002F
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x67,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,
  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x0030: STR_DCPMM_STATUS_ERR_INCONSISTENT_SECURITY_STATE:0x0030
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x73,  0x00,  0x00,  0x00,
// 0x0031: STR_DCPMM_STATUS_WARN_2LM_MODE_OFF:0x0031
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,
  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x77,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x20,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x75,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x4D,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x4D,  0x00,  0x6F,  0x00,  0x64,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x61,  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x75,
  0x00,  0x6E,  0x00,  0x75,  0x00,  0x73,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x77,  0x00,  0x69,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,
  0x00,  0x6C,  0x00,  0x79,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x42,  0x00,  0x49,  0x00,  0x4F,
  0x00,  0x53,  0x00,  0x20,  0x00,  0x76,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x64,  0x00,  0x65,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x0032: STR_DCPMM_STATUS_WARN_REDUCED_CAPACITY_DUE_TO_SKU:0x0032
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x75,
  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,
  0x00,  0x70,  0x00,  0x70,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6D,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,  0x00,  0x20,  0x00,  0x77,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x62,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x53,  0x00,  0x4B,  0x00,  0x55,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x75,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x75,  0x00,  0x6E,
  0x00,  0x2D,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x70,  0x00,  0x70,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0033: STR_DCPMM_STATUS_ERR_NAMESPACE_TOO_SMALL_FOR_BTT:0x0033
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x69,  0x00,  0x66,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x69,
  0x00,  0x7A,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x73,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x4F,
  0x00,  0x70,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,
  0x00,  0x63,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x0034: STR_DCPMM_STATUS_ERR_POOL_GOAL_CONF_AFFECTS_UNSPEC_DIMM:0x0034
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,  0x00,  0x69,  0x00,  0x66,
  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x66,  0x00,  0x66,  0x00,  0x65,  0x00,  0x63,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x62,  0x00,  0x79,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0035: STR_DCPMM_STATUS_ERR_POOL_CURR_CONF_AFFECTS_UNSPEC_DIMM:0x0035
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,  0x00,  0x69,  0x00,  0x66,
  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x66,  0x00,  0x66,  0x00,  0x65,  0x00,  0x63,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x62,  0x00,  0x79,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x0036: STR_DCPMM_STATUS_ERR_POOL_GOAL_CURR_CONF_AFFECTS_UNSPEC_DIMM:0x0036
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,  0x00,  0x69,  0x00,  0x66,
  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x66,  0x00,  0x66,  0x00,  0x65,  0x00,  0x63,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x62,  0x00,  0x79,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x0037: STR_DCPMM_STATUS_ERR_POOL_CONF_APPLYING_FAILED:0x0037
  0x14,  0x44,  0x00,  0x65,  0x00,  0x76,  0x00,  0x69,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x2D,  0x00,  0x20,  0x00,  0x63,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6E,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x41,
  0x00,  0x45,  0x00,  0x50,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0038: STR_DCPMM_STATUS_ERR_POOL_CONF_UNSUPPORTED_CONFIG:0x0038
  0x14,  0x41,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x75,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,  0x00,  0x67,  0x00,  0x69,  0x00,  0x76,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x68,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,
  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0039: STR_DCPMM_STATUS_ERR_POOL_NOT_FOUND:0x0039
  0x14,  0x50,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x003A: STR_DCPMM_STATUS_ERR_PLATFORM_NOT_SUPPORT_MANAGEMENT_SOFT:0x003A
  0x14,  0x50,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x67,  0x00,  0x68,
  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x6D,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x74,
  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x003B: STR_DCPMM_STATUS_ERR_PLATFORM_NOT_SUPPORT_2LM_MODE:0x003B
  0x14,  0x50,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x4D,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x4D,  0x00,  0x6F,  0x00,  0x64,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x003C: STR_DCPMM_STATUS_ERR_PLATFORM_NOT_SUPPORT_PM_MODE:0x003C
  0x14,  0x50,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x41,  0x00,  0x70,  0x00,  0x70,  0x00,  0x20,  0x00,  0x44,  0x00,  0x69,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,  0x00,  0x74,  0x00,  0x20,  0x00,  0x4D,  0x00,  0x6F,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x003D: STR_DCPMM_STATUS_ERR_POOL_CURR_CONF_EXISTS:0x003D
  0x14,  0x41,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x65,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,
  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,  0x00,  0x79,  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,
  0x00,  0x61,  0x00,  0x6C,  0x00,  0x2E,  0x00,  0x20,  0x00,  0x44,  0x00,  0x65,  0x00,  0x6C,  0x00,  0x65,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x65,  0x00,  0x78,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,
  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,
  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x65,  0x00,  0x77,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x003E: STR_DCPMM_STATUS_ERR_POOL_SIZE_TOO_SMALL_FOR_INT_SET_ALIGNMENT:0x003E
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x73,  0x00,  0x6D,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x70,
  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x67,  0x00,  0x6E,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x74,  0x00,  0x00,  0x00,
// 0x003F: STR_DCPMM_STATUS_ERR_PLATFORM_NOT_SUPPORT_SPECIFIED_INT_SIZES:0x003F
  0x14,  0x50,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,  0x00,  0x69,  0x00,  0x66,
  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x4D,  0x00,  0x43,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x43,
  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0040: STR_DCPMM_STATUS_ERR_PLATFORM_NOT_SUPPORT_DEFAULT_INT_SIZES:0x0040
  0x14,  0x50,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x66,  0x00,  0x61,  0x00,  0x75,  0x00,  0x6C,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6C,
  0x00,  0x65,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x4D,  0x00,  0x43,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x43,  0x00,  0x68,  0x00,  0x61,
  0x00,  0x6E,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x73,  0x00,  0x69,  0x00,  0x7A,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,  0x00,  0x69,  0x00,  0x66,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x0041: STR_DCPMM_STATUS_ERR_POOL_NOT_HEALTHY:0x0041
  0x14,  0x50,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x79,  0x00,  0x00,  0x00,
// 0x0042: STR_DCPMM_STATUS_ERR_POOL_NOT_ENOUGH_SPACE_FOR_BLOCK_NAMESPACE:0x0042
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x75,
  0x00,  0x67,  0x00,  0x68,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x63,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x53,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,  0x00,  0x4D,  0x00,  0x6F,  0x00,  0x64,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0043: STR_DCPMM_STATUS_ERR_POOL_NOT_ENOUGH_SPACE_FOR_PM_NAMESPACE:0x0043
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x75,
  0x00,  0x67,  0x00,  0x68,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x63,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x70,  0x00,  0x70,  0x00,  0x20,  0x00,  0x44,
  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,  0x00,  0x74,  0x00,  0x20,  0x00,  0x4E,  0x00,  0x61,
  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x0044: STR_DCPMM_STATUS_ERR_POOL_GOAL_NO_EXISTS_ON_DIMM:0x0044
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0045: STR_DCPMM_STATUS_ERR_RESERVE_DIMM_REQUIRES_AT_LEAST_TWO_DIMMS:0x0045
  0x14,  0x41,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x32,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,
  0x00,  0x69,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x73,  0x00,  0x20,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x65,  0x00,  0x72,  0x00,  0x76,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x70,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0046: STR_DCPMM_STATUS_ERR_POOL_GOAL_NAMESPACE_EXISTS:0x0046
  0x14,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x65,  0x00,  0x78,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x69,  0x00,  0x66,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,
  0x00,  0x76,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x66,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x72,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x6E,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x2E,
  0x00,  0x0D,  0x00,  0x0A,  0x00,  0x57,  0x00,  0x41,  0x00,  0x52,  0x00,  0x4E,  0x00,  0x49,  0x00,  0x4E,
  0x00,  0x47,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x52,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x76,
  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,
  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x77,
  0x00,  0x69,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x65,  0x00,  0x78,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x64,  0x00,  0x61,  0x00,  0x74,  0x00,  0x61,  0x00,  0x2E,
  0x00,  0x20,  0x00,  0x50,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6B,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,  0x00,  0x62,
  0x00,  0x61,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x75,  0x00,  0x70,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x72,  0x00,  0x73,  0x00,  0x74,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0047: STR_DCPMM_STATUS_ERR_POOL_REMAINING_SIZE_NOT_IN_LAST_PROPERTY:0x0047
  0x14,  0x52,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x20,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x75,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,  0x00,  0x75,
  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x6C,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x74,
  0x00,  0x79,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x6C,  0x00,  0x79,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x73,  0x00,  0x74,  0x00,  0x20,  0x00,  0x41,
  0x00,  0x70,  0x00,  0x70,  0x00,  0x20,  0x00,  0x44,  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x53,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x74,  0x00,  0x79,  0x00,  0x00,
  0x00,
// 0x0048: STR_DCPMM_STATUS_ERR_PERS_MEM_MUST_BE_APPLIED_TO_ALL_DIMMS:0x0048
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x20,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6D,
  0x00,  0x61,  0x00,  0x70,  0x00,  0x70,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x0049: STR_DCPMM_STATUS_ERR_OPEN_FILE_WITH_WRITE_MODE_FAILED:0x0049
  0x14,  0x4F,  0x00,  0x70,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x77,  0x00,  0x69,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x77,  0x00,  0x72,  0x00,  0x69,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x64,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x004A: STR_DCPMM_STATUS_ERR_DUMP_NO_CONFIGURED_DIMMS:0x004A
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,
  0x00,  0x64,  0x00,  0x75,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x004B: STR_DCPMM_STATUS_ERR_DUMP_FILE_OPERATION_FAILED:0x004B
  0x14,  0x46,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x70,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x004C: STR_DCPMM_STATUS_ERR_LOAD_VERSION:0x004C
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x64,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x76,  0x00,  0x65,  0x00,  0x72,  0x00,  0x73,
  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x00,  0x00,
// 0x004D: STR_DCPMM_STATUS_ERR_LOAD_INVALID_DATA_IN_FILE:0x004D
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x004E: STR_DCPMM_STATUS_ERR_LOAD_IMPROPER_CONFIG_IN_FILE:0x004E
  0x14,  0x49,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x004F: STR_DCPMM_STATUS_ERR_LOAD_DIMM_COUNT_MISMATCH:0x004F
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x65,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0050: STR_DCPMM_STATUS_ERR_IMAGE_EXAMINE_INVALID:0x0050
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x0051: STR_DCPMM_STATUS_SUCCESS_IMAGE_EXAMINE_OK:0x0051
  0x14,  0x56,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x0052: STR_DCPMM_STATUS_ERR_IMAGE_EXAMINE_LOWER_VERSION:0x0052
  0x14,  0x44,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x72,  0x00,  0x61,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x28,  0x00,  0x77,  0x00,  0x69,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x70,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x29,  0x00,  0x00,  0x00,
// 0x0053: STR_DCPMM_STATUS_ERR_IMAGE_FILE_NOT_VALID:0x0053
  0x14,  0x49,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x0054: STR_DCPMM_STATUS_ERR_DIMM_SKU_DIE_SPARING_MISMATCH:0x0054
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x44,  0x00,  0x69,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x53,  0x00,  0x70,  0x00,  0x61,  0x00,  0x72,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x70,  0x00,  0x61,  0x00,  0x62,  0x00,  0x69,  0x00,  0x6C,
  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,
  0x00,  0x73,  0x00,  0x00,  0x00,
// 0x0055: STR_DCPMM_STATUS_ERR_DIMM_SKU_MODE_MISMATCH:0x0055
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x4D,  0x00,  0x6F,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x70,  0x00,  0x61,  0x00,  0x62,  0x00,  0x69,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x66,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x73,  0x00,  0x00,  0x00,
// 0x0056: STR_DCPMM_STATUS_ERR_DIMM_SKU_SECURITY_MISMATCH:0x0056
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x53,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x70,  0x00,  0x61,  0x00,  0x62,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x73,  0x00,  0x00,  0x00,
// 0x0057: STR_DCPMM_STATUS_ERR_OPERATION_NOT_SUPPORTED_BY_MIXED_SKU:0x0057
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x6D,
  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,
  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x78,  0x00,  0x74,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0058: STR_DCPMM_STATUS_ERR_NONE_DIMM_FULFILLS_CRITERIA:0x0058
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x50,  0x00,  0x6F,
  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x66,  0x00,  0x75,  0x00,  0x6C,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x73,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,
  0x00,  0x6F,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,  0x00,  0x65,  0x00,  0x73,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0059: STR_DCPMM_STATUS_ERR_STORAGE_NAMESPACE_ON_MIRRORED_POOL:0x0059
  0x14,  0x53,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x4D,
  0x00,  0x69,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x50,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x00,  0x00,
// 0x005A: STR_DCPMM_STATUS_ERR_UNSUPPORTED_BLOCK_SIZE:0x005A
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x42,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,
  0x00,  0x6B,  0x00,  0x53,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,
  0x00,  0x65,  0x00,  0x63,  0x00,  0x69,  0x00,  0x66,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x005B: STR_DCPMM_STATUS_ERR_INVALID_NAMESPACE_CAPACITY:0x005B
  0x14,  0x52,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x69,
  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x65,
  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x6D,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x75,  0x00,  0x6D,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x005C: STR_DCPMM_STATUS_ERR_NAMESPACE_DOES_NOT_EXIST:0x005C
  0x14,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x6E,  0x00,  0x27,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x78,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,  0x00,  0x00,
  0x00,
// 0x005D: STR_DCPMM_STATUS_ERR_NAMESPACE_CONFIGURATION_BROKEN:0x005D
  0x14,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x62,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x6B,  0x00,  0x65,
  0x00,  0x6E,  0x00,  0x00,  0x00,
// 0x005E: STR_DCPMM_STATUS_ERR_NOT_ENOUGH_FREE_SPACE:0x005E
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x66,  0x00,  0x72,  0x00,  0x65,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x70,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x005F: STR_DCPMM_STATUS_ERR_NOT_ENOUGH_FREE_SPACE_BTT:0x005F
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x75,
  0x00,  0x67,  0x00,  0x68,  0x00,  0x20,  0x00,  0x66,  0x00,  0x72,  0x00,  0x65,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x20,  0x00,  0x4F,
  0x00,  0x70,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,
  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,
  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,
  0x00,  0x75,  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x0060: STR_DCPMM_STATUS_ERR_FAILED_TO_UPDATE_BTT:0x0060
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x4F,  0x00,  0x70,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6D,
  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x20,
  0x00,  0x50,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,
  0x00,  0x6E,  0x00,  0x75,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x79,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x0061: STR_DCPMM_STATUS_ERR_PLATFORM_NOT_SUPPORT_BLOCK_MODE:0x0061
  0x14,  0x50,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x53,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x61,  0x00,  0x67,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x4D,  0x00,  0x6F,  0x00,  0x64,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x0062: STR_DCPMM_STATUS_WARN_BLOCK_MODE_DISABLED:0x0062
  0x14,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x62,  0x00,  0x75,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x62,
  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x61,  0x00,  0x63,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x69,  0x00,  0x73,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,
  0x00,  0x45,  0x00,  0x50,  0x00,  0x00,  0x00,
// 0x0063: STR_DCPMM_STATUS_ERR_BADALIGNMENT:0x0063
  0x14,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x70,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x69,  0x00,  0x66,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x69,
  0x00,  0x7A,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,
  0x00,  0x75,  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x69,  0x00,  0x67,  0x00,  0x6E,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x0064: STR_DCPMM_STATUS_ERR_RENAME_NAMESPACE_NOT_SUPPORTED:0x0064
  0x14,  0x52,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,
  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0065: STR_DCPMM_STATUS_ERR_FAILED_TO_INIT_NS_LABELS:0x0065
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x6D,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6C,
  0x00,  0x61,  0x00,  0x62,  0x00,  0x65,  0x00,  0x6C,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0066: STR_DCPMM_STATUS_ERR_SMART_FAILED_TO_GET_SMART_INFO:0x0066
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x66,  0x00,  0x65,  0x00,  0x74,  0x00,  0x63,  0x00,  0x68,  0x00,  0x20,
  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x53,  0x00,  0x4D,  0x00,  0x41,  0x00,  0x52,
  0x00,  0x54,  0x00,  0x20,  0x00,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x00,  0x00,
// 0x0067: STR_DCPMM_STATUS_WARN_SMART_NONCRITICAL_HEALTH_ISSUE:0x0067
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2D,  0x00,  0x63,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,
  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x0068: STR_DCPMM_STATUS_ERR_SMART_CRITICAL_HEALTH_ISSUE:0x0068
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x65,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x66,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x67,  0x00,  0x72,  0x00,  0x61,  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x0069: STR_DCPMM_STATUS_ERR_SMART_FATAL_HEALTH_ISSUE:0x0069
  0x14,  0x46,  0x00,  0x61,  0x00,  0x74,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x68,  0x00,  0x65,
  0x00,  0x61,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x64,  0x00,  0x61,  0x00,  0x74,  0x00,  0x61,
  0x00,  0x20,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x74,  0x00,  0x00,  0x00,
// 0x006A: STR_DCPMM_STATUS_ERR_SMART_UNKNOWN_HEALTH_ISSUE:0x006A
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x006B: STR_DCPMM_STATUS_ERR_FAILED_TO_GET_DIMM_INFO:0x006B
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x67,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x49,
  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x00,  0x00,
// 0x006C: STR_DCPMM_STATUS_ERR_FW_SET_OPTIONAL_DATA_POLICY_FAILED:0x006C
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,  0x00,  0x4F,  0x00,  0x70,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x43,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x44,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x61,  0x00,  0x20,  0x00,  0x50,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x69,  0x00,  0x63,  0x00,  0x79,
  0x00,  0x00,  0x00,
// 0x006D: STR_DCPMM_STATUS_ERR_FAILED_TO_GET_DIMM_REGISTERS:0x006D
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x67,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x52,  0x00,  0x65,  0x00,  0x67,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x73,  0x00,  0x00,  0x00,
// 0x006E: STR_DCPMM_STATUS_ERR_SMBIOS_DIMM_ENTRY_NOT_FOUND_IN_NFIT:0x006E
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x53,  0x00,  0x4D,  0x00,  0x42,  0x00,  0x49,  0x00,  0x4F,
  0x00,  0x53,  0x00,  0x00,  0x00,
// 0x006F: STR_DCPMM_STATUS_OPERATION_IN_PROGRESS:0x006F
  0x14,  0x4F,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,
  0x00,  0x67,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x00,  0x00,
// 0x0070: STR_DCPMM_STATUS_ERR_GET_PCD_FAILED:0x0070
  0x14,  0x47,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,  0x00,  0x50,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x43,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x20,  0x00,  0x44,  0x00,  0x61,  0x00,  0x74,  0x00,  0x61,
  0x00,  0x20,  0x00,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x0071: STR_DCPMM_STATUS_ERR_ARS_IN_PROGRESS:0x0071
  0x14,  0x41,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x61,  0x00,  0x64,  0x00,  0x64,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x72,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x63,  0x00,  0x72,  0x00,  0x75,  0x00,  0x62,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x6C,  0x00,  0x79,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x67,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,
  0x00,  0x73,  0x00,  0x00,  0x00,
// 0x0072: STR_DCPMM_STATUS_ERR_APPDIRECT_IN_SYSTEM:0x0072
  0x14,  0x41,  0x00,  0x70,  0x00,  0x70,  0x00,  0x44,  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x74,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x73,  0x00,  0x20,  0x00,  0x61,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x79,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x2D,
  0x00,  0x77,  0x00,  0x69,  0x00,  0x64,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x69,  0x00,  0x74,
  0x00,  0x79,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,
  0x00,  0x79,  0x00,  0x20,  0x00,  0x65,  0x00,  0x78,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,  0x00,  0x73,
  0x00,  0x00,  0x00,
// 0x0073: STR_DCPMM_STATUS_ERR_FW_GET_FA_UNSUPPORTED:0x0073
  0x14,  0x52,  0x00,  0x65,  0x00,  0x74,  0x00,  0x72,  0x00,  0x69,  0x00,  0x65,  0x00,  0x76,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x76,  0x00,  0x69,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x64,  0x00,  0x61,  0x00,  0x74,  0x00,  0x61,  0x00,  0x20,  0x00,  0x6E,
  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x78,  0x00,  0x74,  0x00,  0x2E,
  0x00,  0x20,  0x00,  0x50,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x62,  0x00,  0x75,  0x00,  0x67,  0x00,  0x20,  0x00,  0x66,  0x00,  0x65,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x0074: STR_DCPMM_STATUS_ERR_FW_GET_FA_DATA_FAILED:0x0074
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x74,  0x00,  0x72,  0x00,  0x69,  0x00,  0x65,
  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x76,  0x00,  0x69,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x64,  0x00,  0x61,  0x00,  0x74,  0x00,  0x61,  0x00,  0x00,  0x00,
// 0x0075: STR_DCPMM_STATUS_DEFAULT:0x0075
  0x14,  0x4F,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x72,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x00,  0x00,
// 0x0076: STR_DCPMM_SECSTATE_UNKNOWN:0x0076
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x00,
  0x00,
// 0x0077: STR_DCPMM_SECSTATE_DISABLED:0x0077
  0x14,  0x44,  0x00,  0x69,  0x00,  0x73,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x00,  0x00,
// 0x0078: STR_DCPMM_SECSTATE_UNLOCKED:0x0078
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x00,  0x00,
// 0x0079: STR_DCPMM_SECSTATE_LOCKED:0x0079
  0x14,  0x4C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x007A: STR_DCPMM_SECSTATE_FROZEN:0x007A
  0x14,  0x46,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x00,  0x00,
// 0x007B: STR_DCPMM_SECSTATE_NOT_SUPPORTED:0x007B
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x53,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x007C: STR_DCPMM_SECSTATE_PW_MAX:0x007C
  0x14,  0x45,  0x00,  0x78,  0x00,  0x63,  0x00,  0x65,  0x00,  0x65,  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x00,  0x00,
// 0x007D: STR_DCPMM_BOOT_STATUS_UNKNOWN:0x007D
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x00,
  0x00,
// 0x007E: STR_DCPMM_BOOT_STATUS_SUCCESS:0x007E
  0x14,  0x53,  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x00,
  0x00,
// 0x007F: STR_DCPMM_BOOT_STATUS_MEDIA_NOT_READY:0x007F
  0x14,  0x4D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,  0x00,  0x61,  0x00,  0x20,  0x00,  0x4E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x52,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,  0x00,  0x79,  0x00,  0x00,
  0x00,
// 0x0080: STR_DCPMM_BOOT_STATUS_MEDIA_ERROR:0x0080
  0x14,  0x4D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,  0x00,  0x61,  0x00,  0x20,  0x00,  0x45,  0x00,  0x72,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x00,  0x00,
// 0x0081: STR_DCPMM_BOOT_STATUS_MEDIA_DISABLED:0x0081
  0x14,  0x4D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,  0x00,  0x61,  0x00,  0x20,  0x00,  0x44,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x0083: STR_DCPMM_BOOT_STATUS_DDRT_NOT_READY:0x0083
  0x14,  0x44,  0x00,  0x44,  0x00,  0x52,  0x00,  0x54,  0x00,  0x20,  0x00,  0x4E,  0x00,  0x6F,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x52,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,  0x00,  0x79,  0x00,  0x00,  0x00,
// 0x0084: STR_DCPMM_BOOT_STATUS_MAILBOX_NOT_READY:0x0084
  0x14,  0x4D,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x62,  0x00,  0x6F,  0x00,  0x78,  0x00,  0x20,
  0x00,  0x4E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x52,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,
  0x00,  0x79,  0x00,  0x00,  0x00,
// 0x0085: STR_DCPMM_FW_UPDATE_STATUS_STAGED:0x0085
  0x14,  0x53,  0x00,  0x74,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x66,  0x00,  0x75,
  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x79,  0x00,  0x00,  0x00,
// 0x0086: STR_DCPMM_FW_UPDATE_STATUS_SUCCESS:0x0086
  0x14,  0x55,  0x00,  0x70,  0x00,  0x64,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6C,
  0x00,  0x6F,  0x00,  0x61,  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,
  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x66,  0x00,  0x75,  0x00,  0x6C,
  0x00,  0x6C,  0x00,  0x79,  0x00,  0x00,  0x00,
// 0x0087: STR_DCPMM_FW_UPDATE_STATUS_FAIL:0x0087
  0x14,  0x55,  0x00,  0x70,  0x00,  0x64,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x64,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x65,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x62,  0x00,  0x61,  0x00,  0x63,  0x00,  0x6B,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x65,  0x00,  0x76,
  0x00,  0x69,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x73,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,
  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x0088: STR_DCPMM_FW_UPDATE_STATUS_UNKNOWN:0x0088
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x00,
  0x00,
// 0x0089: STR_DCPMM_POOLS_FORM_GOAL_STATUS_UNKNOWN:0x0089
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x6E,
  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x008A: STR_DCPMM_POOLS_FORM_GOAL_STATUS_REBOOT_REQUIRED:0x008A
  0x14,  0x4E,  0x00,  0x65,  0x00,  0x77,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x20,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x62,  0x00,  0x6F,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x62,  0x00,  0x79,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x42,  0x00,  0x49,  0x00,  0x4F,  0x00,  0x53,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x008B: STR_DCPMM_POOLS_FORM_GOAL_STATUS_INVALID_GOAL:0x008B
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x2D,
  0x00,  0x20,  0x00,  0x42,  0x00,  0x61,  0x00,  0x64,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x71,
  0x00,  0x75,  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x42,  0x00,  0x49,  0x00,  0x4F,  0x00,  0x53,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6D,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x6F,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x67,
  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x74,  0x00,  0x20,  0x00,  0x77,
  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x76,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x69,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x008C: STR_DCPMM_POOLS_FORM_GOAL_STATUS_NOT_ENOUGH_RESOURCES:0x008C
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x2D,
  0x00,  0x20,  0x00,  0x4E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x75,  0x00,  0x67,  0x00,  0x68,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x6F,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x77,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x6F,  0x00,  0x75,  0x00,  0x67,  0x00,  0x68,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,
  0x00,  0x6F,  0x00,  0x75,  0x00,  0x72,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x42,
  0x00,  0x49,  0x00,  0x4F,  0x00,  0x53,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x70,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x79,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x008D: STR_DCPMM_POOLS_FORM_GOAL_STATUS_FIRMWARE_ERROR:0x008D
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x2D,
  0x00,  0x20,  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x42,  0x00,  0x49,  0x00,  0x4F,
  0x00,  0x53,  0x00,  0x20,  0x00,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x63,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x75,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,
  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x008E: STR_DCPMM_POOLS_FORM_GOAL_STATUS_UNKNOWN_ERROR:0x008E
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x2D,
  0x00,  0x20,  0x00,  0x55,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x42,  0x00,  0x49,
  0x00,  0x4F,  0x00,  0x53,  0x00,  0x20,  0x00,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,
  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x63,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,
  0x00,  0x64,  0x00,  0x75,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x008F: STR_DCPMM_STATUS_ERR_FW_SET_LOG_LEVEL_FAILED:0x008F
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x74,  0x00,  0x20,  0x00,  0x46,  0x00,  0x57,
  0x00,  0x20,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x67,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x76,
  0x00,  0x65,  0x00,  0x6C,  0x00,  0x00,  0x00,
// 0x0090: STR_DIAGNOSTIC_TEST_NAME_HEADER:0x0090
  0x14,  0x54,  0x00,  0x65,  0x00,  0x73,  0x00,  0x74,  0x00,  0x4E,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,
  0x00,  0x00,  0x00,
// 0x0091: STR_DIAGNOSTIC_STATE_HEADER:0x0091
  0x14,  0x53,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x0092: STR_DIAGNOSTIC_MESSAGE_HEADER:0x0092
  0x14,  0x4D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x00,
  0x00,
// 0x0093: STR_DIAGNOSTIC_QUICK_NAME:0x0093
  0x14,  0x51,  0x00,  0x75,  0x00,  0x69,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x00,  0x00,
// 0x0094: STR_DIAGNOSTIC_CONFIG_NAME:0x0094
  0x14,  0x43,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x00,  0x00,
// 0x0095: STR_DIAGNOSTIC_SECURITY_NAME:0x0095
  0x14,  0x53,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,
  0x00,  0x00,  0x00,
// 0x0096: STR_DIAGNOSTIC_FW_NAME:0x0096
  0x14,  0x46,  0x00,  0x57,  0x00,  0x00,  0x00,
// 0x0097: STR_DIAGNOSTIC_STATE_OK:0x0097
  0x14,  0x4F,  0x00,  0x6B,  0x00,  0x00,  0x00,
// 0x0098: STR_DIAGNOSTIC_STATE_WARNING:0x0098
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x00,
  0x00,
// 0x0099: STR_DIAGNOSTIC_STATE_FAILED:0x0099
  0x14,  0x46,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,  0x00,
// 0x009A: STR_DIAGNOSTIC_STATE_ABORTED:0x009A
  0x14,  0x41,  0x00,  0x62,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x00,
  0x00,
// 0x009B: STR_DIAGNOSTIC_NOT_AVAILABLE:0x009B
  0x14,  0x4E,  0x00,  0x2F,  0x00,  0x41,  0x00,  0x00,  0x00,
// 0x009C: STR_DIAGNOSTIC_NO_MANAGEABLE_DIMMS:0x009C
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x61,  0x00,  0x67,
  0x00,  0x65,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x73,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x009D: STR_DIAGNOSTIC_QUICK_SUCCESS:0x009D
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x63,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x63,
  0x00,  0x63,  0x00,  0x65,  0x00,  0x65,  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x009E: STR_DIAGNOSTIC_UNMANAGEBALE_DIMM_SUBSYSTEM_VENDOR_ID:0x009E
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x67,  0x00,  0x65,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x20,
  0x00,  0x53,  0x00,  0x75,  0x00,  0x62,  0x00,  0x73,  0x00,  0x79,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x6D,  0x00,  0x20,  0x00,  0x76,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x20,  0x00,  0x49,  0x00,  0x44,  0x00,  0x20,  0x00,  0x30,  0x00,  0x78,  0x00,  0x25,  0x00,  0x30,
  0x00,  0x34,  0x00,  0x78,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x009F: STR_DIAGNOSTIC_UNMANAGEBALE_DIMM_SUBSYSTEM_DEVICE_ID:0x009F
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x67,  0x00,  0x65,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x20,
  0x00,  0x53,  0x00,  0x75,  0x00,  0x62,  0x00,  0x73,  0x00,  0x79,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x6D,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x76,  0x00,  0x69,  0x00,  0x63,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x49,  0x00,  0x44,  0x00,  0x20,  0x00,  0x30,  0x00,  0x78,  0x00,  0x25,  0x00,  0x30,
  0x00,  0x34,  0x00,  0x78,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00A0: STR_DIAGNOSTIC_UNMANAGEBALE_DIMM_FW_API_VERSION:0x00A0
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x67,  0x00,  0x65,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x20,
  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x50,  0x00,  0x49,  0x00,  0x20,  0x00,  0x76,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x73,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x75,  0x00,  0x70,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00A1: STR_DIAGNOSTIC_BAD_HEALTH_STATE:0x00A1
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,  0x00,  0x62,  0x00,  0x61,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x00A2: STR_DIAGNOSTIC_MEDIA_TEMP_EXCEEDS_ALARM_THR:0x00A2
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x69,  0x00,  0x61,  0x00,  0x20,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x25,  0x00,  0x64,  0x00,  0x20,  0x00,  0x43,  0x00,  0x2C,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x62,  0x00,  0x6F,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x68,  0x00,  0x6F,  0x00,  0x6C,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x25,  0x00,  0x64,  0x00,  0x20,  0x00,  0x43,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x00A3: STR_DIAGNOSTIC_SPARE_CAPACITY_BELOW_ALARM_THR:0x00A3
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6D,
  0x00,  0x61,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x70,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x61,  0x00,  0x70,
  0x00,  0x61,  0x00,  0x63,  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x25,  0x00,  0x64,  0x00,  0x25,  0x00,  0x25,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x6C,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,
  0x00,  0x68,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x64,  0x00,  0x20,  0x00,  0x25,  0x00,  0x64,  0x00,  0x25,
  0x00,  0x25,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00A4: STR_DIAGNOSTIC_PERCENTAGE_USED_EXCEEDS_THR:0x00A4
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x63,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x61,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x25,  0x00,  0x64,  0x00,  0x25,  0x00,  0x25,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x61,  0x00,  0x62,
  0x00,  0x6F,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x73,  0x00,  0x68,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x64,  0x00,  0x20,  0x00,  0x25,  0x00,  0x64,
  0x00,  0x25,  0x00,  0x25,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00A5: STR_DIAGNOSTIC_CONTROLLER_TEMP_EXCEEDS_ALARM_THR:0x00A5
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,
  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x74,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x43,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6F,
  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x73,  0x00,  0x68,  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x64,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x43,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00A6: STR_DIAGNOSTIC_VIRAL_STATE:0x00A6
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x61,  0x00,  0x20,  0x00,  0x76,  0x00,  0x69,  0x00,  0x72,
  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x2E,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x61,  0x00,  0x64,  0x00,  0x2D,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x6C,  0x00,  0x79,  0x00,  0x2E,
  0x00,  0x00,  0x00,
// 0x00A7: STR_DIAGNOSTIC_NO_SPARE_DIE_AVAILABLE:0x00A7
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x69,  0x00,  0x6D,
  0x00,  0x6D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x30,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,  0x00,  0x69,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x61,  0x00,  0x76,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x61,
  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00A8: STR_DIAGNOSTIC_AIT_DRAM_NOT_READY:0x00A8
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x49,  0x00,  0x54,  0x00,  0x20,  0x00,  0x44,  0x00,  0x72,
  0x00,  0x61,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,  0x00,  0x79,  0x00,  0x20,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,
  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x00A9: STR_DIAGNOSTIC_AIT_DRAM_DISABLED:0x00A9
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x49,  0x00,  0x54,  0x00,  0x20,  0x00,  0x44,  0x00,  0x72,
  0x00,  0x61,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x64,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00AA: STR_DIAGNOSTIC_FW_LOAD_FAILED:0x00AA
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,
  0x00,  0x66,  0x00,  0x75,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x79,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00AB: STR_DIAGNOSTIC_BSR_NOT_READABLE:0x00AB
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x62,  0x00,  0x6F,
  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x67,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,
  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00AD: STR_DIAGNOSTIC_BSR_DDRT_IO_NOT_COMPLETE:0x00AD
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x44,  0x00,  0x44,  0x00,  0x52,  0x00,  0x54,
  0x00,  0x20,  0x00,  0x49,  0x00,  0x4F,  0x00,  0x20,  0x00,  0x49,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00AE: STR_DIAGNOSTIC_BSR_MAILBOX_NOT_READY:0x00AE
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,
  0x00,  0x62,  0x00,  0x6F,  0x00,  0x78,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x66,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,
  0x00,  0x64,  0x00,  0x79,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00AF: STR_DIAGNOSTIC_BSR_MEDIA_ERROR:0x00AF
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,  0x00,  0x61,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00B0: STR_DIAGNOSTIC_BSR_MEDIA_NOT_READY:0x00B0
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,
  0x00,  0x61,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x64,  0x00,  0x79,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x00B1: STR_DIAGNOSTIC_BSR_MEDIA_DISABLED:0x00B1
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x61,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x64,  0x00,  0x69,
  0x00,  0x61,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x64,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00B2: STR_DIAGNOSTIC_BSR_MEDIA_ENGINE_STALLED:0x00B2
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x69,  0x00,  0x61,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x66,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,  0x00,  0x65,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00B3: STR_DIAGNOSTIC_BSR_FW_NOT_INITIALIZED:0x00B3
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,
  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x73,  0x00,  0x73,  0x00,  0x66,  0x00,  0x75,  0x00,  0x6C,
  0x00,  0x6C,  0x00,  0x79,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x4D,
  0x00,  0x61,  0x00,  0x6A,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x3A,  0x00,  0x4D,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x43,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6B,
  0x00,  0x70,  0x00,  0x6F,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x30,  0x00,  0x78,  0x00,  0x25,  0x00,  0x78,  0x00,  0x3A,  0x00,  0x30,  0x00,  0x78,
  0x00,  0x25,  0x00,  0x78,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00B4: STR_DIAGNOSTIC_BSR_CPU_EXCEPTION:0x00B4
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,
  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x61,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x43,  0x00,  0x50,  0x00,  0x55,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x20,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x4D,  0x00,  0x61,  0x00,  0x6A,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x3A,  0x00,  0x4D,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x43,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x6B,  0x00,  0x70,  0x00,  0x6F,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x30,  0x00,  0x78,  0x00,  0x25,  0x00,  0x78,  0x00,  0x3A,  0x00,  0x30,
  0x00,  0x78,  0x00,  0x25,  0x00,  0x78,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00B5: STR_DIAGNOSTIC_BSR_BIOS_POST_TRAINING_FAILED:0x00B5
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x66,  0x00,  0x61,
  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x69,
  0x00,  0x7A,  0x00,  0x65,  0x00,  0x20,  0x00,  0x42,  0x00,  0x49,  0x00,  0x4F,  0x00,  0x53,  0x00,  0x20,
  0x00,  0x50,  0x00,  0x4F,  0x00,  0x53,  0x00,  0x54,  0x00,  0x20,  0x00,  0x74,  0x00,  0x65,  0x00,  0x73,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00B6: STR_DIAGNOSTIC_QUICK_ABORTED_INTERNAL_ERROR:0x00B6
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x63,  0x00,  0x6B,
  0x00,  0x20,  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x2E,  0x00,  0x00,
  0x00,
// 0x00B7: STR_DIAGNOSTIC_QUICK_ABORTED_DIMM_INTERNAL_ERROR:0x00B7
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x71,  0x00,  0x75,  0x00,  0x69,  0x00,  0x63,  0x00,  0x6B,
  0x00,  0x20,  0x00,  0x68,  0x00,  0x65,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00B8: STR_DCPMM_HEALTH_NON_CRITICAL_FAILURE:0x00B8
  0x14,  0x4D,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,  0x00,  0x66,  0x00,  0x61,
  0x00,  0x69,  0x00,  0x6C,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,  0x00,  0x00,  0x00,
// 0x00B9: STR_DCPMM_HEALTH_CRITICAL_FAILURE:0x00B9
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x20,  0x00,  0x66,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x75,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x00,  0x00,
// 0x00BA: STR_DCPMM_HEALTH_FATAL_FAILURE:0x00BA
  0x14,  0x4E,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x2D,  0x00,  0x72,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6F,
  0x00,  0x76,  0x00,  0x65,  0x00,  0x72,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x00,  0x00,
// 0x00BB: STR_DCPMM_HEALTH_UNKNOWN:0x00BB
  0x14,  0x55,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x6E,  0x00,  0x00,
  0x00,
// 0x00BC: STR_DIAGNOSTIC_CONFIG_SUCCESS:0x00BC
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,
  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x65,  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00BD: STR_DIAGNOSTIC_CONFIG_ABORTED_INTERNAL_ERROR:0x00BD
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,
  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,
  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00BE: STR_DIAGNOSTIC_CONFIG_DUPLICATE_DIMM_UID:0x00BE
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x25,  0x00,  0x64,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,
  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x70,  0x00,  0x6C,  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x68,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x61,  0x00,  0x6D,  0x00,  0x65,  0x00,  0x20,  0x00,  0x44,
  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x55,  0x00,  0x49,  0x00,  0x44,  0x00,  0x20,
  0x00,  0x6E,  0x00,  0x75,  0x00,  0x6D,  0x00,  0x62,  0x00,  0x65,  0x00,  0x72,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00BF: STR_DIAGNOSTIC_CONFIG_NO_OS_PROVISIONING:0x00BF
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x42,  0x00,  0x49,  0x00,  0x4F,  0x00,  0x53,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,
  0x00,  0x74,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x73,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x6F,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x63,  0x00,  0x75,
  0x00,  0x72,  0x00,  0x72,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x6C,  0x00,  0x79,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x6C,  0x00,  0x6C,  0x00,  0x6F,  0x00,  0x77,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x65,
  0x00,  0x6D,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x79,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x6F,
  0x00,  0x76,  0x00,  0x69,  0x00,  0x73,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x20,  0x00,  0x66,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x73,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x74,
  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C0: STR_DIAGNOSTIC_CONFIG_DIMM_FAILED_TO_INITIALIZE:0x00C0
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x77,  0x00,  0x69,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,
  0x00,  0x44,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x6D,  0x00,  0x48,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,
  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x30,  0x00,  0x78,  0x00,  0x25,  0x00,  0x30,  0x00,  0x34,
  0x00,  0x78,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x65,
  0x00,  0x73,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x79,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x62,  0x00,  0x75,  0x00,  0x74,  0x00,  0x20,  0x00,  0x66,
  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x69,  0x00,  0x7A,  0x00,  0x65,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C1: STR_DIAGNOSTIC_CONFIG_UNABLE_TO_READ_NS_INFO:0x00C1
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6C,
  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x63,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,
  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x77,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x75,
  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x74,  0x00,  0x72,  0x00,  0x69,  0x00,  0x65,  0x00,  0x76,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6D,  0x00,  0x65,  0x00,  0x73,  0x00,  0x70,  0x00,  0x61,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x69,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x74,
  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,
  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,
  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C2: STR_DIAGNOSTIC_CONFIG_UNABLE_TO_READ_POOL_INFO:0x00C2
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6C,
  0x00,  0x61,  0x00,  0x74,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x63,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,
  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x77,  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x75,
  0x00,  0x6E,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,
  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x74,  0x00,  0x72,  0x00,  0x69,  0x00,  0x65,  0x00,  0x76,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x70,  0x00,  0x6F,
  0x00,  0x6F,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,
  0x00,  0x6D,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,
  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C3: STR_DIAGNOSTIC_CONFIG_GOAL_FAILED_FIRMWARE:0x00C3
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x43,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x77,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x61,  0x00,  0x70,  0x00,  0x70,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,
  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x2E,
  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x74,
  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,
  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C4: STR_DIAGNOSTIC_CONFIG_GOAL_FAILED_DATA:0x00C4
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x43,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x77,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x61,  0x00,  0x70,  0x00,  0x70,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,
  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x66,  0x00,  0x20,  0x00,  0x65,
  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x64,  0x00,  0x61,  0x00,  0x74,  0x00,  0x61,  0x00,  0x2E,  0x00,  0x20,
  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x74,  0x00,  0x61,
  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,
  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C5: STR_DIAGNOSTIC_CONFIG_GOAL_FAILED_INSUFFICIENT_RESOURCES:0x00C5
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x43,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x77,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x61,  0x00,  0x70,  0x00,  0x70,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,
  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x62,  0x00,  0x65,  0x00,  0x63,  0x00,  0x61,
  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x79,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,  0x00,  0x20,  0x00,  0x68,
  0x00,  0x61,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x75,  0x00,  0x66,
  0x00,  0x66,  0x00,  0x69,  0x00,  0x63,  0x00,  0x69,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x20,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x73,  0x00,  0x6F,  0x00,  0x75,  0x00,  0x72,  0x00,  0x63,  0x00,  0x65,
  0x00,  0x73,  0x00,  0x2E,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x74,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C6: STR_DIAGNOSTIC_CONFIG_GOAL_FAILED_UNKNOWN:0x00C6
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x43,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x69,  0x00,  0x67,
  0x00,  0x75,  0x00,  0x72,  0x00,  0x61,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x67,  0x00,  0x6F,  0x00,  0x61,  0x00,  0x6C,  0x00,  0x20,  0x00,  0x77,  0x00,  0x61,  0x00,  0x73,
  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x74,  0x00,  0x20,  0x00,  0x61,  0x00,  0x70,  0x00,  0x70,
  0x00,  0x6C,  0x00,  0x69,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,
  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,
  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x20,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x75,  0x00,  0x6E,  0x00,  0x6B,  0x00,  0x6E,  0x00,  0x6F,
  0x00,  0x77,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x72,  0x00,  0x65,  0x00,  0x61,  0x00,  0x73,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x2E,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x74,  0x00,  0x61,  0x00,  0x69,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C7: STR_DIAGNOSTIC_CONFIG_DETAILED_STATUS:0x00C7
  0x14,  0x43,  0x00,  0x4F,  0x00,  0x55,  0x00,  0x54,  0x00,  0x20,  0x00,  0x74,  0x00,  0x61,  0x00,  0x62,
  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,
  0x00,  0x73,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x28,  0x00,  0x25,  0x00,  0x64,  0x00,  0x29,  0x00,  0x2C,
  0x00,  0x20,  0x00,  0x50,  0x00,  0x61,  0x00,  0x72,  0x00,  0x74,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x3A,  0x00,  0x20,
  0x00,  0x28,  0x00,  0x25,  0x00,  0x73,  0x00,  0x29,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x49,  0x00,  0x6E,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x31,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x3A,  0x00,  0x20,
  0x00,  0x28,  0x00,  0x25,  0x00,  0x73,  0x00,  0x29,  0x00,  0x2C,  0x00,  0x20,  0x00,  0x49,  0x00,  0x6E,
  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,
  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x61,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x74,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6C,  0x00,  0x65,  0x00,  0x20,  0x00,  0x32,  0x00,  0x20,
  0x00,  0x73,  0x00,  0x74,  0x00,  0x61,  0x00,  0x74,  0x00,  0x75,  0x00,  0x73,  0x00,  0x3A,  0x00,  0x20,
  0x00,  0x28,  0x00,  0x25,  0x00,  0x73,  0x00,  0x29,  0x00,  0x00,  0x00,
// 0x00C8: STR_DIAGNOSTIC_CONFIG_IS_BROKEN_DIMMS_MISSING:0x00C8
  0x14,  0x43,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,  0x00,  0x69,  0x00,  0x63,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x49,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6C,
  0x00,  0x65,  0x00,  0x61,  0x00,  0x76,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x74,
  0x00,  0x20,  0x00,  0x25,  0x00,  0x64,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x62,
  0x00,  0x72,  0x00,  0x6F,  0x00,  0x6B,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x64,  0x00,  0x75,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x6D,  0x00,  0x69,  0x00,  0x73,
  0x00,  0x73,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,
  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x28,  0x00,  0x73,  0x00,  0x29,
  0x00,  0x3A,  0x00,  0x20,  0x00,  0x25,  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00C9: STR_DIAGNOSTIC_SECURITY_SUCCESS:0x00C9
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,
  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,  0x00,  0x6B,
  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x65,  0x00,  0x64,
  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00CA: STR_DIAGNOSTIC_SECURITY_INCONSISTENT:0x00CA
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x53,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,  0x00,  0x69,  0x00,  0x74,
  0x00,  0x79,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x74,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6E,
  0x00,  0x67,  0x00,  0x73,  0x00,  0x20,  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,
  0x00,  0x65,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x00,  0x00,
// 0x00CB: STR_DIAGNOSTIC_SECURITY_ABORTED_INTERNAL_ERROR:0x00CB
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x63,  0x00,  0x75,  0x00,  0x72,
  0x00,  0x69,  0x00,  0x74,  0x00,  0x79,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x6B,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x61,  0x00,  0x62,  0x00,  0x6F,
  0x00,  0x72,  0x00,  0x74,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00CC: STR_DIAGNOSTIC_FW_SUCCESS:0x00CC
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x54,  0x00,  0x68,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x73,  0x00,  0x69,
  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x79,  0x00,  0x20,  0x00,  0x61,
  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x74,  0x00,  0x74,  0x00,  0x69,
  0x00,  0x6E,  0x00,  0x67,  0x00,  0x73,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,  0x00,  0x63,
  0x00,  0x6B,  0x00,  0x20,  0x00,  0x73,  0x00,  0x75,  0x00,  0x63,  0x00,  0x63,  0x00,  0x65,  0x00,  0x65,
  0x00,  0x64,  0x00,  0x65,  0x00,  0x64,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00CD: STR_DIAGNOSTIC_FW_INCONSISTENT:0x00CD
  0x14,  0x57,  0x00,  0x61,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x3A,
  0x00,  0x20,  0x00,  0x46,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,  0x00,  0x61,  0x00,  0x72,
  0x00,  0x65,  0x00,  0x20,  0x00,  0x76,  0x00,  0x65,  0x00,  0x72,  0x00,  0x73,  0x00,  0x69,  0x00,  0x6F,
  0x00,  0x6E,  0x00,  0x20,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x41,  0x00,  0x45,  0x00,  0x50,
  0x00,  0x20,  0x00,  0x44,  0x00,  0x49,  0x00,  0x4D,  0x00,  0x4D,  0x00,  0x73,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x20,  0x00,  0x77,  0x00,  0x69,  0x00,  0x74,  0x00,  0x68,  0x00,  0x20,  0x00,  0x73,
  0x00,  0x75,  0x00,  0x62,  0x00,  0x73,  0x00,  0x79,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6D,
  0x00,  0x20,  0x00,  0x64,  0x00,  0x65,  0x00,  0x76,  0x00,  0x69,  0x00,  0x63,  0x00,  0x65,  0x00,  0x20,
  0x00,  0x49,  0x00,  0x44,  0x00,  0x20,  0x00,  0x30,  0x00,  0x78,  0x00,  0x25,  0x00,  0x30,  0x00,  0x34,
  0x00,  0x78,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x6E,  0x00,  0x6F,  0x00,  0x6E,
  0x00,  0x2D,  0x00,  0x6F,  0x00,  0x70,  0x00,  0x74,  0x00,  0x69,  0x00,  0x6D,  0x00,  0x61,  0x00,  0x6C,
  0x00,  0x2C,  0x00,  0x20,  0x00,  0x70,  0x00,  0x72,  0x00,  0x65,  0x00,  0x66,  0x00,  0x65,  0x00,  0x72,
  0x00,  0x72,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x76,  0x00,  0x65,  0x00,  0x72,  0x00,  0x73,
  0x00,  0x69,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x20,  0x00,  0x69,  0x00,  0x73,  0x00,  0x20,  0x00,  0x25,
  0x00,  0x73,  0x00,  0x2E,  0x00,  0x00,  0x00,
// 0x00CE: STR_DIAGNOSTIC_FW_ABORTED_INTERNAL_ERROR:0x00CE
  0x14,  0x49,  0x00,  0x6E,  0x00,  0x66,  0x00,  0x6F,  0x00,  0x3A,  0x00,  0x20,  0x00,  0x41,  0x00,  0x6E,
  0x00,  0x20,  0x00,  0x69,  0x00,  0x6E,  0x00,  0x74,  0x00,  0x65,  0x00,  0x72,  0x00,  0x6E,  0x00,  0x61,
  0x00,  0x6C,  0x00,  0x20,  0x00,  0x65,  0x00,  0x72,  0x00,  0x72,  0x00,  0x6F,  0x00,  0x72,  0x00,  0x20,
  0x00,  0x63,  0x00,  0x61,  0x00,  0x75,  0x00,  0x73,  0x00,  0x65,  0x00,  0x64,  0x00,  0x20,  0x00,  0x74,
  0x00,  0x68,  0x00,  0x65,  0x00,  0x20,  0x00,  0x66,  0x00,  0x69,  0x00,  0x72,  0x00,  0x6D,  0x00,  0x77,
  0x00,  0x61,  0x00,  0x72,  0x00,  0x65,  0x00,  0x20,  0x00,  0x63,  0x00,  0x6F,  0x00,  0x6E,  0x00,  0x73,
  0x00,  0x69,  0x00,  0x73,  0x00,  0x74,  0x00,  0x65,  0x00,  0x6E,  0x00,  0x63,  0x00,  0x79,  0x00,  0x20,
  0x00,  0x61,  0x00,  0x6E,  0x00,  0x64,  0x00,  0x20,  0x00,  0x73,  0x00,  0x65,  0x00,  0x74,  0x00,  0x74,
  0x00,  0x69,  0x00,  0x6E,  0x00,  0x67,  0x00,  0x73,  0x00,  0x20,  0x00,  0x63,  0x00,  0x68,  0x00,  0x65,
  0x00,  0x63,  0x00,  0x6B,  0x00,  0x20,  0x00,  0x74,  0x00,  0x6F,  0x00,  0x20,  0x00,  0x61,  0x00,  0x62,
  0x00,  0x6F,  0x00,  0x72,  0x00,  0x74,  0x00,  0x2E,  0x00,  0x00,  0x00,
  0x00,

};

