# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: compatibility.py,v 1.2 2005/09/14 13:41:19 sgrayban Exp $

# Various helper code for compatibility with versions of iPodder.

import logging
import os, sys

log = logging.getLogger('iPodder')

def migrate_2x_tmp_downloads(basepath,state):

    result = []

    try:
        #This path should not be part of a zip file.
        path = os.path.join(basepath,"compat","2x")
        sys.path.append(path)
        encinfolist = state['tmp_downloads']
        sys.path.remove(path)
        from ipodder.core import Enclosure
        for i in range(len(encinfolist)):
            encinfo = encinfolist[i]
            try:
                compatible_enclosure = Enclosure(
                    encinfo.url, \
                    encinfo.feed, \
                    encinfo.length, \
                    encinfo.marked, \
                    encinfo.item_title, \
                    encinfo.description, \
                    encinfo.item_link)
                compatible_enclosure.status = encinfo.status
                compatible_enclosure.creation_time = encinfo.creation_time
                compatible_enclosure.download_started = encinfo.download_started
                compatible_enclosure.download_completed = encinfo.download_completed
                result.append(compatible_enclosure)
            except:
                log.exception("Error migrating 2x-style tmp_downloads entry %d." % i)
                pass
        #Now save the fruits of our labor.
        state['tmp_downloads'] = result
        state.sync()
    except:
        log.exception("Error migrating 2x-style tmp_downloads.")
        pass

    return result
