STRIPE_ODD_COLOR = '#EDF3FE'
STRIPE_EVEN_COLOR = '#FFFFFF'
PRODUCT_NAME = 'iPodder'
# CURRENT_VERSION_URL = "http://ipodder.sourceforge.net/update/current_version.xml"
CURRENT_VERSION_URL = "http://www.borgnet.us/current_version_linux.xml"

DEFAULT_SUBS = [('Default Channel', \
                 'http://radio.weblogs.com/0001014/categories/ipodderTestChannel/rss.xml'), \
                ('iPodder News', 'http://ipodder.sf.net/podcasts/ipodder-users.xml')]

PODCAST_DIRECTORY_ROOTS = [
        ('http://homepage.mac.com/dailysourcecode/DSC/ipodderDirectory.opml', 'iPodder.org: Podcasting Central'),
        ('http://homepage.mac.com/dailysourcecode/opml/podSquad.opml', "Adam Curry's Pod Squad"),
        ('http://ipodder.sf.net/opml/ipodder.opml', 'iPodder Team Directory'),
        ('http://directory.ipodderx.com/opml/iPodderX_Picks.opml', 'iPodderX Top Picks'),
        ('http://directory.ipodderx.com/opml/iPodderX_Popular.opml', 'iPodderX Most Popular'),
        ('http://www.podcastalley.com/PodcastAlleyTop50.opml', 'Podcast Alley Top 50'),
        ('http://www.podcastalley.com/PodcastAlley10Newest.opml', 'Podcast Alley 10 Newest'),
        ('http://www.gigadial.net/public/opml/dial25.opml', 'GigaDial 25 Latest'),
        ('http://sportspodnet.com/opml/spn.opml', 'Sports Podcast Network'),
        ]

SPLASH_LIFETIME = 90000
SPLASH_DESTROY = True

DIRECTORY_LINK_SCANNED = '#7F007F'
DIRECTORY_LINK_UNSCANNED = '#00007F'
DIRECTORY_LINK_SCANNING = '#7F0000'

SEARCHBOXFEEDS_FG = None
SEARCHBOXFEEDS_BG = None
SUBSCTRL_FG = None
SUBSCTRL_BG = None
EPISODES_FG = None
EPISODES_BG = None
DOWNLOADS_FG = None
DOWNLOADS_BG = None
CLEANUP_FG = None
CLEANUP_BG = None
DIRECTORY_FG = None
DIRECTORY_BG = None

def set_skin_opts(gui):

    if SEARCHBOXFEEDS_FG:
        gui.searchboxfeeds.SetBackgroundColour(SEARCHBOXFEEDS_BG)
    if SEARCHBOXFEEDS_BG:
        gui.searchboxfeeds.SetForegroundColour(SEARCHBOXFEEDS_FG)

    if SUBSCTRL_BG:
        gui.feedslist.SetBackgroundColour(SUBSCTRL_BG)
    if SUBSCTRL_FG:
        gui.feedslist.SetForegroundColour(SUBSCTRL_FG)


    if EPISODES_BG:
        gui.episodes.SetBackgroundColour(EPISODES_BG)
    if EPISODES_FG:
        gui.episodes.SetForegroundColour(EPISODES_FG)

    if DOWNLOADS_BG:
        gui.downloads.SetBackgroundColour(DOWNLOADS_BG)
    if DOWNLOADS_FG:
        gui.downloads.SetForegroundColour(DOWNLOADS_FG)

    if CLEANUP_BG:
        gui.cleanupepisodes.SetBackgroundColour(CLEANUP_BG)
    if CLEANUP_FG:
        gui.cleanupepisodes.SetForegroundColour(CLEANUP_FG)

    if DIRECTORY_BG:
        gui.opmltree.SetBackgroundColour(DIRECTORY_BG)
    if DIRECTORY_FG:
        gui.opmltree.SetForegroundColour(DIRECTORY_FG)

