/***************************************************************************
 *   Copyright (C) 2004 by Michael Schulze                                 *
 *   mike.s@genion.de                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kdebug.h>

#include "slaveutils.h"

Job2SlaveSyncronizer::Job2SlaveSyncronizer(KIO::Job * job, KIO::SlaveBase * slave)
    : _slave( slave ), error(0) {
    connect( job, SIGNAL( result(KIO::Job *) ),
             this, SLOT( slotResult(KIO::Job *) ) );
    connect( job, SIGNAL( infoMessage(KIO::Job *, const QString &) ),
             this, SLOT( slotInfoMessage(KIO::Job *, const QString &) ) );
    connect( job, SIGNAL( totalSize(KIO::Job *, KIO::filesize_t) ),
             this, SLOT( slotTotalSize(KIO::Job *, KIO::filesize_t) ) );
    connect( job, SIGNAL( processedSize(KIO::Job *, KIO::filesize_t) ),
             this, SLOT( slotProcessedSize(KIO::Job *, KIO::filesize_t) ) );
    connect( job, SIGNAL( speed(KIO::Job *, unsigned long) ),
             this, SLOT( slotSpeed(KIO::Job *, unsigned long) ) );
    waitLock.lock();
}

void Job2SlaveSyncronizer::yield()  {
    kdDebug() << "Job2SlaveSyncronizer: waiting for job" << endl;
    waitLock.lock();
}

void Job2SlaveSyncronizer::slotResult( KIO::Job *job ) {
    kdDebug() << "Job2SlaveSyncronizer: job done" << endl;
    if ( job->error() != 0 ) {
        error = job->error();
        errorText = job->errorString();
    }
    waitLock.unlock();
}

void Job2SlaveSyncronizer::slotInfoMessage( KIO::Job *, const QString &msg ) {
    if ( _slave ) _slave->infoMessage(msg);
}

void Job2SlaveSyncronizer::slotTotalSize( KIO::Job *, KIO::filesize_t size ) {
    kdDebug() << "Job2SlaveSyncronizer: job totalSize " << size  << endl;
    if ( _slave ) _slave->totalSize( size );
}

void Job2SlaveSyncronizer::slotProcessedSize( KIO::Job *, KIO::filesize_t size ) {
    kdDebug() << "Job2SlaveSyncronizer: job processedSize " << size  << endl;
    if ( _slave ) _slave->processedSize( size );
}

void Job2SlaveSyncronizer::slotSpeed( KIO::Job *, unsigned long bytesPerSecond ) {
    kdDebug() << "Job2SlaveSyncronizer: job speed " << bytesPerSecond  << endl;
    if ( _slave ) _slave->speed( bytesPerSecond );
}

#include "slaveutils.moc"

