###########################################################################
# Arquivo do idioma Portugus (do Brasil) traduo por ROD_NOKEY.
# Nome:   Rodrigo Teles Calado.
# E-mail: <rodrigo@brirc.com.br>.
###########################################################################

# Services  protegido por direitos autorais (c) 1996-1999 Andy Church.
#     E-mail: <achurch@dragonfire.net>
# Este programa  grtis, porm registrado; veja o arquivo COPYING
# para detalhes.

# Quando traduzindo este programa para outro idioma, lembre-se que a
# ordem dos parmetros para sprintf()  fixado no cdigo de fonte, ento
# suas mensagens precisam ter os mesmos parmetros nos mesmos padres das
# mensagens em ingls. (Obviamente, isto no  vlido para linhas no formato
# strftime() que ficam uma abaixo das outras). No se pode adquirir uma
# traduo das mensagens naturalmente sem mudar as ordens dos parmetros,
# avise-me (achurch@dragonfire.net) qual mensagem est causando o problema e
# eu verei o que posso fazer.
#
# Nas mensagens de ajuda, "%S" (S maisculo, no  minsculo) refere-se ao nome
# do servio que envia a mensagem; por exemplo, na mensagem de ajuda do
# NickServ, "%S"  substitudo por "NickServ" (ou outro nome definido
# no config.h). Os %S's no contam como sendo parmetros de sprintf(),
# assim podem ser reorganizados, removidos, ou adicionados se necessrio.
#
# Finalmente, lembre-se de colocar TAB no comeo de toda linha do texto
# (incluindo linhas vazias). Tem que ser TAB, no espaos.

###########################################################################
#
# Nome deste idioma
#
###########################################################################

# Para idiomas diferentes do ingls, essa string deve ter o seguinte formato:
#     language-name-in-language (language-name-in-English)
# Por exemplo, "Espaol (Spanish)" or "Franais (French)".

LANG_NAME
	Portugues BR (Portuguese Brazil)

###########################################################################
#
# Mensagens Gerais
#
###########################################################################

# Strings no formato strftime(). "man 3 strftime" para informaes sobre o
# significado da especificao do formato. Verso pequena:
#       %a = nome do dia da semana (pequeno)    %H = hora
#       %b = nome do ms (pequeno)              %M = minuto
#       %d = dia do ms                         %S = segundo
#       %Y = ano                                %Z = zona de fuso horrio

# O seguinte  usado para o formato de uma string da strftime(), com uma
# data e horrio mostrados juntamente.
STRFTIME_DATE_TIME_FORMAT
	%d %b %H:%M:%S %Y %Z
# O seguinte  usado para o formato de uma string da strftime(), com uma
# data sozinha de formato longo (Para o ingls inclui-se o dia da semana).
STRFTIME_LONG_DATE_FORMAT
	%a %d %b %Y
# O seguinte  usado para o formato de uma string da strftime(), com apenas
# a data em formato curto (Para o ingls: sem o dia da semana).
STRFTIME_SHORT_DATE_FORMAT
	%d %b %Y

# Estes especificam para a strftime() quais so os nomes dos dias e meses.
# Se no usar %a, %A, %b, or %B nas suas strings da strftime(), pode
# deixar essas partes vazias. No entanto, se colocar nomes, eles DEVEM
# ficar ordenados, um por linha, e a lista DEVE estar completa!

# %a
STRFTIME_DAYS_SHORT
	Dom
	Seg
	Ter
	Qua
	Qui
	Sex
	Sab
# %A
STRFTIME_DAYS_LONG
	Domingo
	Segunda
	Terca
	Quarta
	Quinta
	Sexta
	Sabado
# %b
STRFTIME_MONTHS_SHORT
	Jan
	Fev
	Mar
	Abr
	Mai
	Jun
	Jul
	Ago
	Set
	Out
	Nov
	Dez
# %B
STRFTIME_MONTHS_LONG
	Janeiro
	Fevereiro
	Marco
	Abril
	Maio
	Junho
	Julho
	Agosto
	Setembro
	Outubro
	Novembro
	Dezembro


# This is used in ChanServ/NickServ INFO displays.
COMMA_SPACE
	,


# Various error messages.
USER_RECORD_NOT_FOUND
	Erro interno - impossvel processar o pedido.
UNKNOWN_COMMAND
	Comando %s desconhecido.
UNKNOWN_COMMAND_HELP
	Comando %s desconhecido. "/%s HELP" para ajuda.
SYNTAX_ERROR
	Sintaxe: %s
MORE_INFO
	/%s HELP %s para mais informaes.
NO_HELP_AVAILABLE
	Ajuda no disponvel para %s.

BAD_USERHOST_MASK
	Hostnames devem estar no formato ident@host.

SERVICE_OFFLINE
	%s est atualmente desligado.
READ_ONLY_MODE
	Ateno: Services esto no modo read-only (somente-leitura). Mudanas no sero guardadas!
ACCESS_DENIED
	Acesso negado.
PERMISSION_DENIED
	Permisso negada.
PASSWORD_INCORRECT
	Senha incorreta.

MORE_OBSCURE_PASSWORD
	Tente novamente com uma SENHA mais difcil. As senhas devem ter no
	mnimo cinco caracteres, no devem ser algo deduzvel (ex: nome ou nick) e no podem conter espaos ou TAB.
PASSWORD_TRUNCATED
	Notice: A sua senha foi limitada a %d caracteres.

NICK_NOT_REGISTERED
	O nick utilizado no est registrado.
NICK_NOT_REGISTERED_HELP
	O nick utilizado no est registrado. Digite /%s HELP para mais
	informaes sobre como registr-lo.
NICK_X_NOT_REGISTERED
	Nick %s no est registrado.
NICK_X_NOT_IN_USE
	Nick %s no est em uso neste momento.
NICK_X_NOT_ON_CHAN
	Nick %s no est no canal %s.
NICK_X_FORBIDDEN
	Nick %s no pode ser utilizado ou registrado.
CHAN_X_NOT_REGISTERED
	Canal %s no est registrado.
CHAN_X_NOT_IN_USE
	Canal %s no existe.
CHAN_X_FORBIDDEN
	Canal %s no pode ser utilizado ou registrado.
NICK_IDENTIFY_REQUIRED
	Autenticao de senha  requerida para este comando.
	Tente novamente aps digitar /%s IDENTIFY senha.
CHAN_IDENTIFY_REQUIRED
	Autenticao de senha  requerida para este comando.
	Tente novamente aps digitar /%s IDENTIFY %s senha.

###########################################################################
#
# Mensagens do NickServ
#
###########################################################################

# Automatic messages
NICK_IS_REGISTERED
	Este nick est registrado. Se for seu identifique-o
	(/%s IDENTIFY senha). Se no for escolha outro.
NICK_IS_SECURE
	Este nick est registrado e protegido.
	Se o nick pertencer a voc, digite /%s IDENTIFY senha.
	Caso contrrio escolha um nick diferente com /NICK outro_nick.
NICK_MAY_NOT_BE_USED
	Este nick no pode ser utilizado. Por favor escolha outro.
DISCONNECT_IN_1_MINUTE
	Se no trocar de nick dentro de 1 minuto, este ser alterado.
DISCONNECT_IN_20_SECONDS
	Se no trocar de nick dentro de 20 segundos, ser desconectado.
DISCONNECT_NOW
	Este nick est registrado, voc no pode us-lo. Por favor
	escolha um outro nick antes de reconectar.

# REGISTER responses
NICK_REGISTER_SYNTAX
	REGISTER senha email
NICK_REGISTRATION_DISABLED
	Pedimos desculpa. O registro de nicks est temporariamente desativado.
NICK_REGISTRATION_FAILED
	Pedimos desculpa. Ocorreu uma falha na hora do registro.
NICK_REG_PLEASE_WAIT
	Aguarde %d segundos antes de usar o comando REGISTER novamente.
NICK_CANNOT_BE_REGISTERED
	Nick %s no pode ser registrado.
NICK_ALREADY_REGISTERED
	Nick %s est registrado!
NICK_REGISTERED
	Nick %s registrado a partir de sua conta: %s
NICK_PASSWORD_IS
	A sua senha  %s - lembre-se dela para uso posterior.

# IDENTIFY responses
NICK_IDENTIFY_SYNTAX
	IDENTIFY senha
NICK_IDENTIFY_FAILED
	Pedimos desculpa. A sua identificao falhou.
NICK_IDENTIFY_SUCCEEDED
	Senha aceita - voc est reconhecido.
# DROP responses
NICK_DROP_SYNTAX
	DROP
NICK_DROP_DISABLED
	Pedimos desculpa. Cancelamento do registro de nicks est temporariamente
	desativado.
NICK_DROPPED
	O registro do seu nick foi cancelado.
NICK_X_DROPPED
	O registro do nick %s foi cancelado.

# SET responses
NICK_SET_SYNTAX
	SET opo parmetros
NICK_SET_SERVADMIN_SYNTAX
	SET [nick] opo parmetros
NICK_SET_DISABLED
	Pedimos desculpa. A configurao de opes do nick est temporariamente
	desativada.
NICK_SET_UNKNOWN_OPTION
	Opo SET %s desconhecida.
NICK_SET_UNKNOWN_OPTION_OR_BAD_NICK
	Opo SET %s desconhecida, ou nick no registrado.

# SET PASSWORD responses
NICK_SET_PASSWORD_FAILED
	Pedimos desculpa.  impossvel trocar a senha.
NICK_SET_PASSWORD_CHANGED
	Senha alterada com xito.
NICK_SET_PASSWORD_CHANGED_TO
	Senha alterada para %s.

# SET URL responses
NICK_SET_URL_CHANGED
	URL modificado para %s .
NICK_SET_URL_UNSET
	Associao a URL foi apagada.

# SET EMAIL responses
NICK_SET_EMAIL_CHANGED
	E-mail modificado para %s.
NICK_SET_EMAIL_UNSET
	Associao ao endereco de e-mail foi apagada.

# SET ICQNUMBER responses
NICK_SET_ICQ_CHANGED
	Nmero ICQ alterado para #%s.
NICK_SET_ICQ_UNSET
	Nmero ICQ foi apagado.

# SET LOCATION responses
NICK_SET_LOCATION_CHANGED
	Local alterado para %s.
NICK_SET_LOCATION_UNSET
	Local foi apagado.

# SET LANGUAGE responses
NICK_SET_LANGUAGE_SYNTAX
	SET LANGUAGE nmero
NICK_SET_LANGUAGE_UNKNOWN
	Nmero de linguagem %d desconhecido. Digite /%s HELP SET LANGUAGE
	para uma lista de linguagens.
NICK_SET_LANGUAGE_CHANGED
	Linguagem modificada para Portugus (Brasil).

# SET KILL responses
NICK_SET_KILL_SYNTAX
	Esta proteo  agora obrigatria, no sendo por isso configurvel.
NICK_SET_KILL_IMMED_SYNTAX
	Esta proteo  agora obrigatria, no sendo por isso configurvel.
NICK_SET_KILL_ON
	Esta proteo  agora obrigatria, no sendo por isso configurvel.
NICK_SET_KILL_QUICK
	Esta proteo  agora obrigatria, no sendo por isso configurvel.
NICK_SET_KILL_IMMED
	Esta proteo  agora obrigatria, no sendo por isso configurvel.
NICK_SET_KILL_IMMED_DISABLED
	Esta proteo  agora obrigatria, no sendo por isso configurvel.
NICK_SET_KILL_OFF
	Esta proteo  agora obrigatria, no sendo por isso configurvel.

# SET PRIVATE responses
NICK_SET_PRIVATE_SYNTAX
	SET PRIVATE {ON | OFF}
NICK_SET_PRIVATE_ON
	Opo PRIVATE ativada.
NICK_SET_PRIVATE_OFF
	Opo PRIVATE desativada.

# SET HIDE responses
NICK_SET_HIDE_SYNTAX
	SET HIDE {EMAIL | QUIT} {ON | OFF}
NICK_SET_HIDE_EMAIL_ON
	O seu endereo de e-mail est agora oculto na exibio no %s INFO.
NICK_SET_HIDE_EMAIL_OFF
	O seu endereco de e-mail est agora visvel para exibio no %s INFO.
NICK_SET_HIDE_QUIT_ON
	A sua ltima mensagem de quit est agora oculta para exibio no %s INFO.
NICK_SET_HIDE_QUIT_OFF
	A sua ltima mensagem de quit est agora visvel para exibio no %s INFO.

# SET NOEXPIRE responses
NICK_SET_NOEXPIRE_SYNTAX
	SET [nick] NOEXPIRE {ON | OFF}
NICK_SET_NOEXPIRE_ON
	O nick %s no ir expirar.
NICK_SET_NOEXPIRE_OFF
	O nick %s ir expirar.

# LINK responses
NICK_LINK_SYNTAX
	LINK nick senha
NICK_LINK_DISABLED
	O comando LINK no est disponvel.
NICK_LINK_FAILED
	Pedimos desculpa. A ligao falhou.
NICK_NO_LINK_SAME
	No pode fazer uma ligao para o seu nick atual!
NICK_LINK_CIRCULAR
	Impossvel ligar o nick %s : ligao circular detectada.
NICK_LINKED
	Seu nick foi ligado ao nick %s.

# UNLINK responses
NICK_UNLINK_FAILED
	Pedimos desculpa, desligao de nicks falhou.
NICK_NOT_LINKED
	O seu nick no est ligado.
NICK_X_NOT_LINKED
	Nick %s no est ligado.
NICK_UNLINKED
	O seu nick foi desligado do nick %s.
NICK_X_UNLINKED
	O nick %s foi desligado do nick %s.

# LISTLINKS responses
NICK_LISTLINKS_SYNTAX
	LISTLINKS nick [ALL]
NICK_LISTLINKS_SYNTAX2
	LISTLINKS
NICK_LISTLINKS_HEADER
	Lista de nicks ligados ao nick %s:
NICK_LISTLINKS_FOOTER
	%d nicks ligados.

# INFO responses
NICK_INFO_SYNTAX
	INFO nick
NICK_INFO_REALNAME
	%s  %s
NICK_INFO_ADDRESS
	         ltimo endereo: %s
NICK_INFO_TIME_REGGED
	        Data de registro: %s [%s]
NICK_INFO_LAST_IDENTIFY
	 ltima vez identificado: %s [%s]
NICK_INFO_LAST_SEEN
	        ltima vez visto: %s [%s]
NICK_INFO_ONLINE
	      Tempo total online: %s
NICK_INFO_LAST_QUIT
	 ltima mensagem de quit: %s
NICK_INFO_URL
	                     URL: %s
NICK_INFO_EMAIL
	                  E-mail: %s
NICK_INFO_ICQ
	              Nmero ICQ: #%s
NICK_INFO_LOCATION
	                   Local: %s
NICK_INFO_OPTIONS
	                  Opes: %s
NICK_INFO_NO_EXPIRE
	Cancelamento do registro: Este nick no ir expirar.
NICK_INFO_OSUSPENDED
	  Suspenso de oline at: %s
# These strings MUST NOT be empty
NICK_INFO_OPT_KILL
	Proteo de Kill
NICK_INFO_OPT_PRIVATE
	Privado
NICK_INFO_OPT_NONE
	Nenhuma

# LIST responses
NICK_LIST_SYNTAX
	LIST padro
NICK_LIST_SERVADMIN_SYNTAX
	LIST padro [FORBIDDEN] [NOEXPIRE]
NICK_LIST_HEADER
	Lista das entradas que satisfazem  %s :
NICK_LIST_RESULTS
	Fim da listagem - %d/%d entradas mostradas.

NICK_RELEASED
	A proteo dos Services ao seu nick foi desligada.

# GHOST responses
NICK_GHOST_SYNTAX
	GHOST nick [senha]
NICK_NO_GHOST_SELF
	No pode utilizar um ghost em si mesmo!
NICK_GHOST_KILLED
	O ghost do seu nick foi desligado.

# GETPASS responses
NICK_GETPASS_SYNTAX
	GETPASS nick
NICK_GETPASS_UNAVAILABLE
	Comando invlido porque encriptao est em uso.
NICK_GETPASS_PASSWORD_IS
	Senha para %s  %s.

# FORBID responses
NICK_FORBID_SYNTAX
	FORBID nick
NICK_FORBID_SUCCEEDED
	Nick %s est proibido de ser usado.
NICK_FORBID_FAILED
	No se pode proibir o nick %s!

###########################################################################
#
# Mensagens do ChanServ
#
###########################################################################

# Access level descriptions
CHAN_LEVEL_AUTOOP
	Modo +o automtico
CHAN_LEVEL_AUTOVOICE
	Modo +v automtico
CHAN_LEVEL_AUTODEOP
	No pode ser operador deste canal
CHAN_LEVEL_NOJOIN
	No pode entrar no canal se este estiver restrito (opo RESTRICTED)
CHAN_LEVEL_INVITE
	Permitido usar o comando INVITE
CHAN_LEVEL_AKICK
	Permitido usar o comando AKICK
CHAN_LEVEL_SET
	Permitido usar o comando SET (no sendo FUNDADOR)
CHAN_LEVEL_CLEAR
	Permitido usar o comando CLEAR
CHAN_LEVEL_UNBAN
	Permitido usar o comando UNBAN
CHAN_LEVEL_OPDEOP
	Permitido usar os comandos OP/DEOP
CHAN_LEVEL_ACCESS_LIST
	Permitido ver a lista de acesso
CHAN_LEVEL_ACCESS_CHANGE
	Permitido modificar a lista de acesso
CHAN_LEVEL_MEMO_READ
	Permitido listar ou ler as mensagens do canal
CHAN_LEVEL_MEMO_SEND
	Permitido enviar mensagens para o canal
CHAN_LEVEL_MEMO_DEL
	Permitido apagar mensagens do canal
CHAN_LEVEL_KICK
	Permitido usar o comando KICK
# Automatic responses
CHAN_IS_REGISTERED
	Este canal est registrado com %s.
CHAN_NOT_ALLOWED_OP
	No tem permisso para ser operador deste canal %s.
CHAN_MAY_NOT_BE_USED
	Este canal no pode ser usado.
CHAN_NOT_ALLOWED_TO_JOIN
	No est com permisso para permanecer neste canal.

# REGISTER responses
CHAN_REGISTER_SYNTAX
	REGISTER canal senha descrio
CHAN_REGISTER_DISABLED
	Pedimos desculpa. Mas o registro de canal est temporariamente desativado.
CHAN_REGISTER_NOT_LOCAL
	Canais locais no podem ser registrados.
CHAN_MUST_REGISTER_NICK
	Primeiro tem de registrar o seu nick. Digite /%s HELP para obter
	informao sobre o registro de nicks.
CHAN_MUST_IDENTIFY_NICK
	Por favor, identique-se com %s primeiro utilizando o comando:
	/%s IDENTIFY senha.
CHAN_MAY_NOT_BE_REGISTERED
	O canal %s no pode ser registrado.
CHAN_ALREADY_REGISTERED
	O canal %s j est registrado!
CHAN_MUST_BE_CHANOP
	Tem que ser operador do canal para poder registrar o canal.
CHAN_REACHED_CHANNEL_LIMIT
	Pedimos desculpa. Mas j alcancou o limite de %d canais.
CHAN_EXCEEDED_CHANNEL_LIMIT
	Pedimos desculpa. Mas j ultrapassou o seu limite de %d canais.
CHAN_REGISTRATION_FAILED
	Pedimos desculpa. O registro falhou.
CHAN_REGISTERED
	O canal %s registrado com o seu nick: %s
	No se esquea de escolher o seu sucessor com
	/CHANSERV SET #canal SUCCESSOR nick
CHAN_PASSWORD_IS
	A senha do seu canal  %s - lembre-se dela para uso posterior.

# IDENTIFY responses
CHAN_IDENTIFY_SYNTAX
	IDENTIFY canal senha
CHAN_IDENTIFY_FAILED
	Pedimos desculpa. A identificao falhou.
CHAN_IDENTIFY_SUCCEEDED
	Senha aceita - voc est reconhecido como fundador do %s.

# DROP responses
CHAN_DROP_SYNTAX
	DROP canal
CHAN_DROP_DISABLED
	Pedimos desculpa. O cancelamento do registro de canal est temporariamente
	desativado.
CHAN_DROPPED
	O registro do canal %s foi apagado.

# SET responses
CHAN_SET_SYNTAX
	SET canal opo parmetros
CHAN_SET_DISABLED
	Pedimos desculpa. As opes do canal esto temporariamente desativadas.
CHAN_SET_UNKNOWN_OPTION
	Opo SET %s desconhecida.

# SET FOUNDER responses
CHAN_SET_FOUNDER_TOO_MANY_CHANS
	%s tem canais registrados em excesso.
CHAN_FOUNDER_CHANGED
	Fundador do canal %s alterado para %s.

# SET SUCCESSOR responses
CHAN_SUCCESSOR_CHANGED
	Sucessor de %s mudado para %s.
CHAN_SUCCESSOR_UNSET
	Sucessor para %s retirado.

# SET PASSWORD responses
CHAN_SET_PASSWORD_FAILED
	Pedimos desculpa. Mas no foi possivel alterar a senha.
CHAN_PASSWORD_CHANGED
	%s senha alterada.
CHAN_PASSWORD_CHANGED_TO
	Senha do canal %s alterada para %s.

# SET DESC responses
CHAN_DESC_CHANGED
	Descrio do canal %s alterada para %s.

# SET URL responses
CHAN_URL_CHANGED
	URL do canal %s alterado para %s.
CHAN_URL_UNSET
	Associao a URL para o canal %s foi apagada.

# SET EMAIL responses
CHAN_EMAIL_CHANGED
	Endereo de e-mail do canal %s foi mudado para %s.
CHAN_EMAIL_UNSET
	Associao ao e-mail do canal %s foi apagada.

# SET ENTRYMSG responses
CHAN_ENTRY_MSG_CHANGED
	Mensagem de entrada no canal %s alterada.
CHAN_ENTRY_MSG_UNSET
	A designao atual da mensagem de entrada do canal %s foi apagada.

# SET TOPIC responses
CHAN_SET_TOPIC_FAILED
	Pedimos desculpa. No foi possvel por o tpico escolhido.

# SET MLOCK responses
CHAN_SET_MLOCK_KEY_REQUIRED
	Parmetro requerido para MLOCK +k.
CHAN_SET_MLOCK_LIMIT_REQUIRED
	Parmetro requerido para MLOCK +l.
CHAN_SET_MLOCK_LIMIT_POSITIVE
	Parmetro para MLOCK +l deve ser um nmero positivo.
CHAN_SET_MLOCK_UNKNOWN_CHAR
	Modo %c  desconhecido e foi ignorado.
CHAN_MLOCK_CHANGED
	Modos do canal %s alterados para %s.
CHAN_MLOCK_REMOVED
	Modos do canal %s removidos.

# SET KEEPTOPIC responses
CHAN_SET_KEEPTOPIC_SYNTAX
	SET canal KEEPTOPIC {ON | OFF}
CHAN_SET_KEEPTOPIC_ON
	Opo de reteno de tpico est ativada.
CHAN_SET_KEEPTOPIC_OFF
	Opo de reteno de tpico est desativada.

# SET TOPICLOCK responses
CHAN_SET_TOPICLOCK_SYNTAX
	SET canal TOPICLOCK {ON | OFF}
CHAN_SET_TOPICLOCK_ON
	Opo de bloqueio do tpico est ativada.
CHAN_SET_TOPICLOCK_OFF
	Opo de bloqueio do tpico est desativada.

# SET PRIVATE responses
CHAN_SET_PRIVATE_SYNTAX
	SET canal PRIVATE {ON | OFF}
CHAN_SET_PRIVATE_ON
	Opo private est ativada.
CHAN_SET_PRIVATE_OFF
	Opo private est desativada.

# SET SECUREOPS responses
CHAN_SET_SECUREOPS_SYNTAX
	SET canal SECUREOPS {ON | OFF}
CHAN_SET_SECUREOPS_ON
	Opo Secure ops est ativada.
CHAN_SET_SECUREOPS_OFF
	Opo Secure ops est desativada.

# SET LEAVEOPS responses
CHAN_SET_LEAVEOPS_SYNTAX
	SET canal LEAVEOPS {ON | OFF}
CHAN_SET_LEAVEOPS_ON
	Opo LEAVE OPS est ativada.
CHAN_SET_LEAVEOPS_OFF
	Opo LEAVE OPS est desativada.

# SET RESTRICTED responses
CHAN_SET_RESTRICTED_SYNTAX
	SET canal RESTRICTED {ON | OFF}
CHAN_SET_RESTRICTED_ON
	Opo de acesso restrito est ativada.
CHAN_SET_RESTRICTED_OFF
	Opo de acesso restrito est desativada.

# SET OPNOTICE responses
CHAN_SET_OPNOTICE_SYNTAX
	SET canal OPNOTICE {ON | OFF}
CHAN_SET_OPNOTICE_ON
	Opo Op-Notice foi ativada.
CHAN_SET_OPNOTICE_OFF
	Opo Op-Notice foi desativada.

# SET NOLINKS responses
CHAN_SET_NOLINKS_SYNTAX
	SET canal NOLINKS {ON | OFF}
CHAN_SET_NOLINKS_ON
	Opo NOLINKS foi ativada.
CHAN_SET_NOLINKS_OFF
	Opo NOLINKS foi desativada.

# SET NOEXPIRE responses
CHAN_SET_NOEXPIRE_SYNTAX
	SET canal NOEXPIRE {ON | OFF}
CHAN_SET_NOEXPIRE_ON
	Canal %s no ir expirar.
CHAN_SET_NOEXPIRE_OFF
	Canal %s ir expirar.

# ACCESS messages
CHAN_ACCESS_SYNTAX
	ACCESS canal {ADD|DEL|LIST} [nick [nvel] | nmero_de_entrada]
CHAN_ACCESS_DISABLED
	Pedimos desculpa. A modificao da lista de acesso do canal est
	temporariamente desativada.
CHAN_ACCESS_LEVEL_NONZERO
	Nvel de acesso deve ser diferente de zero.
CHAN_ACCESS_LEVEL_RANGE
	Nvel de acesso deve estar entre %d e %d.
CHAN_ACCESS_NICKS_ONLY
	Listas de acesso de canais devem conter apenas nicks registrados.
CHAN_ACCESS_REACHED_LIMIT
	Pedimos desculpa. Mas s pode ter %d entradas de acesso num canal.
CHAN_ACCESS_LEVEL_UNCHANGED
	Nvel de acesso de %s no canal %s no foi mudado de %d.
CHAN_ACCESS_LEVEL_CHANGED
	Nvel de acesso para %s no canal %s mudado de %d para %d.
CHAN_ACCESS_ADDED
	%s adicionado a lista de acesso do canal %s com nvel %d.
CHAN_ACCESS_NO_SUCH_ENTRY
	Entrada desconhecida (#%d) na lista de acesso do canal %s.
CHAN_ACCESS_NOT_FOUND
	%s no foi encontrado na lista de acesso do canal %s.
CHAN_ACCESS_NO_MATCH
	Nenhuma entrada encontrada na lista de acesso do %s.
CHAN_ACCESS_DELETED
	%s apagado da lista de acesso do canal %s.
CHAN_ACCESS_DELETED_ONE
	Apagada uma entrada da lista de acesso do %s.
CHAN_ACCESS_DELETED_SEVERAL
	Apagadas %d entradas da lista de acesso do %s.
CHAN_ACCESS_LIST_EMPTY
	Lista de acesso do %s est vazia.
CHAN_ACCESS_LIST_HEADER
	Lista de acesso do canal %s:
	  Nm   Nv  Nick
CHAN_ACCESS_LIST_FORMAT
	  %3d  %4d  %s%s%s%s


# AOP/SOP error response
CHAN_NO_AOP_SOP
	Para designar privilgios de um canal para um usurio, utilize o
	comando ACCESS; digite /%s HELP ACCESS para mais informaes.

# AKICK responses
CHAN_AKICK_SYNTAX
	AKICK canal {ADD | DEL | LIST} [nick-ou-hostname]
CHAN_AKICK_DISABLED
	Pedimos desculpa. A alterao da lista de autokicks do canal est
	temporariamente desativada.
CHAN_AKICK_ALREADY_EXISTS
	%s j existe na lista de autokicks do canal %s.
CHAN_AKICK_REACHED_LIMIT
	Pedimos desculpa. Mas deve ter %d hostnames na lista de autokicks do canal.
CHAN_AKICK_ADDED
	%s adicionado a lista de autokicks do canal %s.
CHAN_AKICK_NO_SUCH_ENTRY
	Entrada desconhecida (#%d) na lista de autokicks do canal %s.
CHAN_AKICK_NOT_FOUND
	%s no foi encontrado na lista de autokicks do canal %s.
CHAN_AKICK_NO_MATCH
	Nenhuma entrada encontrada na lista de autokick do %s.
CHAN_AKICK_DELETED
	%s retirado da lista de autokicks do canal %s.
CHAN_AKICK_DELETED_ONE
	Apagada uma entrada da lista de autokick do %s.
CHAN_AKICK_DELETED_SEVERAL
	Apagada %d entradas da lista de autokick do %s.
CHAN_AKICK_LIST_EMPTY
	Lista de autokick do %s est vazia.
CHAN_AKICK_LIST_HEADER
	Lista de autokicks do canal %s:
CHAN_AKICK_LIST_FORMAT
	  %3d %s%s
CHAN_AKICK_LIST_FORMAT2
	  %3d %s por %s : %s

# LEVELS responses
CHAN_LEVELS_SYNTAX
	LEVELS canal {SET | DIS[ABLE] | LIST | RESET} [item [nvel]]
CHAN_LEVELS_RANGE
	Nvel deve estar entre %d e %d.
CHAN_LEVELS_CHANGED
	Nvel de %s no canal %s alterado para %d.
CHAN_LEVELS_UNKNOWN
	Opo %s desconhecida. Digite /%s HELP LEVELS DESC para uma lista
	vlida de opes.
CHAN_LEVELS_DISABLED
	%s desabilitado no canal %s.
CHAN_LEVELS_LIST_HEADER
	Configurao dos nveis de acesso do canal %s:
CHAN_LEVELS_LIST_DISABLED
	    %-*s  (desabilitado)
CHAN_LEVELS_LIST_FOUNDER
	    %-*s  (somente fundador)
CHAN_LEVELS_LIST_NORMAL
	    %-*s  %d
CHAN_LEVELS_RESET
	Nveis de acesso do canal %s foram refeitos usando os padres.

# INFO responses
CHAN_INFO_SYNTAX
	INFO canal
CHAN_INFO_HEADER
	Informao sobre o canal %s :
CHAN_INFO_FOUNDER
	           Fundador: %s (%s)
CHAN_INFO_NO_FOUNDER
	           Fundador: %s
CHAN_INFO_DESCRIPTION
	          Descrio: %s
CHAN_INFO_TIME_REGGED
	         Registrado: %s [%s]
CHAN_INFO_LAST_USED
	         ltima utilizao: %s [%s]
CHAN_INFO_LAST_TOPIC
	      ltimo tpico: %s
CHAN_INFO_TOPIC_SET_BY
	Tpico inserido por: %s
CHAN_INFO_RECORD
	            Recorde: %d usurio(s) em %s [%s]
CHAN_INFO_USERS
	     Ocupao atual: %d usurio(s)
CHAN_INFO_URL
	                URL: %s
CHAN_INFO_EMAIL
	             E-mail: %s
CHAN_INFO_OPTIONS
	             Opes: %s
CHAN_INFO_NO_EXPIRE
	  Canc. do registro: Este canal no ir expirar.
CHAN_INFO_OPT_PRIVATE
	Privado
CHAN_INFO_OPT_KEEPTOPIC
	Reteno de tpico
CHAN_INFO_OPT_TOPICLOCK
	Bloqueamento do tpico
CHAN_INFO_OPT_SECUREOPS
	Proteo de ops
CHAN_INFO_OPT_LEAVEOPS
	LEAVE OPS
CHAN_INFO_OPT_RESTRICTED
	Acesso restrito
CHAN_INFO_OPT_NOLINKS
	Ignorar nick links
CHAN_INFO_OPT_NONE
	Nenhuma
CHAN_INFO_MODE_LOCK
	          Bloqueio dos modos: %s

# LIST responses
CHAN_LIST_SYNTAX
	LIST padro
CHAN_LIST_HEADER
	Listas das entradas que satisfazem %s :
CHAN_LIST_FORMAT
	    %-20s  %s
CHAN_LIST_END
	Fim da listagem - %d/%d entradas mostradas.

# INVITE responses
CHAN_INVITE_SYNTAX
	INVITE canal

# OP responses
CHAN_OP_SYNTAX
	OP canal nick

# DEOP responses
CHAN_DEOP_SYNTAX
	DEOP canal nick

# KICK responses
CHAN_KICK_SYNTAX
	KICK canal nick

# UNBAN responses
CHAN_UNBAN_SYNTAX
	UNBAN canal
CHAN_UNBANNED
	Foi desbanido do canal %s.

# CLEAR responses
CHAN_CLEAR_SYNTAX
	CLEAR canal tipo
CHAN_CLEARED_BANS
	Todos os bans do canal %s foram removidos.
CHAN_CLEARED_MODES
	Todos os modos do canal %s foram removidos.
CHAN_CLEARED_OPS
	Modo +o dos operadores do canal %s foi retirado.
CHAN_CLEARED_VOICES
	Modo +v dos utilizadores do canal %s foi retirado.
CHAN_CLEARED_USERS
	Todos os utilizadores foram kickados do canal %s.

# GETPASS responses
CHAN_GETPASS_SYNTAX
	GETPASS canal
CHAN_GETPASS_UNAVAILABLE
	Comando GETPASS no est disponvel porque a encriptao est em uso.
CHAN_GETPASS_PASSWORD_IS
	Senha do canal %s  %s.

# FORBID responses
CHAN_FORBID_SYNTAX
	FORBID canal
CHAN_FORBID_SUCCEEDED
	Canal %s est proibido de ser utilizado.
CHAN_FORBID_FAILED
	No foi possvel proibir o canal %s!

###########################################################################
#
# Mensagens do MemoServ
#
###########################################################################

# Automatic messages
MEMO_HAVE_NEW_MEMO
	Tem uma mensagem nova.
MEMO_HAVE_NEW_MEMOS
	Tem %d mensagens novas.
MEMO_TYPE_READ_LAST
	Digite /%s READ LAST para ler.
MEMO_TYPE_READ_NUM
	Digite /%s READ %d para ler.
MEMO_TYPE_LIST_NEW
	Digite /%s LIST NEW para listar todas as mensagens.
MEMO_AT_LIMIT
	Ateno: Atingiu o limite mximo de mensagens (%d).
	No poder receber mais nenhuma mensagem antes de apagar alguma das suas
	atuais.
MEMO_OVER_LIMIT
	Ateno: Est acima do limite mximo de mensagens (%d).
	No poder receber mais nenhuma mensagem antes de apagar alguma das suas
	atuais.
MEMO_NEW_MEMO_ARRIVED
	Tem uma nova mensagem de %s.
	Digite /%s READ %d  para ler.

# Multi-use responses
MEMO_HAVE_NO_MEMOS
	No tem mensagens.
MEMO_X_HAS_NO_MEMOS
	%s no tem mensagens.
MEMO_DOES_NOT_EXIST
	Mensagem %d no existe!
MEMO_LIST_NOT_FOUND
	Nenhuma mensagem encontrada.

# SEND responses
MEMO_SEND_SYNTAX
	SEND {nick | canal} mensagem-texto
MEMO_SEND_DISABLED
	Pedimos desculpa. O envio de mensagens est temporariamente desativado.
MEMO_SEND_PLEASE_WAIT
	Por favor espere %d segundos antes de usar o comando SEND novamente.
MEMO_X_GETS_NO_MEMOS
	%s no pode receber mensagens.
MEMO_X_HAS_TOO_MANY_MEMOS
	%s atualmente tem muitas mensagens e no pode receber mais.
MEMO_SENT
	Mensagem enviada para %s.

# LIST responses
MEMO_LIST_SYNTAX
	LIST [canal] [list | NEW]
MEMO_HAVE_NO_NEW_MEMOS
	No tem novas mensagens.
MEMO_X_HAS_NO_NEW_MEMOS
	%s no tem novas mensagens.
MEMO_LIST_MEMOS
	Mensagens para %s. Para ler, digite: /%s READ nmero
MEMO_LIST_NEW_MEMOS
	Novas mensagens para %s. Para ler, digite: /%s READ nmero
MEMO_LIST_CHAN_MEMOS
	Mensagens para o canal %s. Para ler, digite: /%s READ %s nmero
MEMO_LIST_CHAN_NEW_MEMOS
	Novas mensagens para o canal %s. Para ler, digite: /%s READ %s nmero
MEMO_LIST_HEADER
	 Nm  Remetente         Data/Hora
MEMO_LIST_FORMAT
	%c%3d  %-16s  %s "%s..."

# READ responses
MEMO_READ_SYNTAX
	READ [canal] {list | LAST | NEW}
MEMO_HEADER
	Mensagem %d de %s (%s). Para apagar, digite: /%s DEL %d
MEMO_CHAN_HEADER
	Mensagem %d de %s (%s). Para apagar, digite: /%s DEL %s %d
MEMO_TEXT
	%s

# DEL responses
MEMO_DEL_SYNTAX
	DEL [canal] {nm | list | ALL}
MEMO_DELETED_NONE
	Sem mensagens a serem apagadas.
MEMO_DELETED_ONE
	Mensagem %d foi apagada.
MEMO_DELETED_SEVERAL
	%s mensagens foram apagadas.
MEMO_DELETED_ALL
	Todas as suas mensagens foram apagadas.

# SET responses
MEMO_SET_SYNTAX
	SET opo parmetros
MEMO_SET_DISABLED
	Pedimos desculpa. O sistema de mensagens est temporariamente desativado.
MEMO_SET_UNKNOWN_OPTION
	Opo SET %s desconhecida.

# SET NOTIFY responses
MEMO_SET_NOTIFY_SYNTAX
	SET NOTIFY {ON | LOGON | NEW | OFF}
MEMO_SET_NOTIFY_ON
	%s notificar sobre mensagens quando se conectar e quando enviadas 
	voc.
MEMO_SET_NOTIFY_LOGON
	%s notificar sobre as suas mensagens quando se conectar ou sair de um
	/AWAY.
MEMO_SET_NOTIFY_NEW
	%s notificar sobre as suas mensagens quando elas lhe forem enviadas.
MEMO_SET_NOTIFY_OFF
	%s no notificar sobre qualquer aviso de mensagens.

# SET LIMIT responses
MEMO_SET_LIMIT_SYNTAX
	SET LIMIT [canal] limite
MEMO_SET_LIMIT_SERVADMIN_SYNTAX
	SET LIMIT [usurio | canal] {limit | NONE} [HARD]
MEMO_SET_YOUR_LIMIT_FORBIDDEN
	No est apto a alterar o limite de mensagens.
MEMO_SET_LIMIT_FORBIDDEN
	O limite de mensagens para %s no pode ser alterado.
MEMO_SET_YOUR_LIMIT_TOO_HIGH
	No pode alterar o seu limite de mensagens acima de %d.
MEMO_SET_LIMIT_TOO_HIGH
	No pode alterar o limite de mensagens de %s acima de %d.
MEMO_SET_LIMIT_OVERFLOW
	Limite de mensagens muito alto; limitado para %d.
MEMO_SET_YOUR_LIMIT
	O limite de mensagens foi alterado para %d.
MEMO_SET_YOUR_LIMIT_ZERO
	No est apto a receber mensagens.
MEMO_UNSET_YOUR_LIMIT
	O limite de mensagens foi desativado.
MEMO_SET_LIMIT
	Limite de mensagens para %s alterado para %d.
MEMO_SET_LIMIT_ZERO
	Limite de mensagens para %s alterado para 0.
MEMO_UNSET_LIMIT
	Limite de mensagens para %s est desativado.

# INFO responses
MEMO_INFO_SYNTAX
	INFO [canal]
MEMO_INFO_SERVADMIN_SYNTAX
	INFO [nick | canal]
MEMO_INFO_NO_MEMOS
	No tem mensagens.
MEMO_INFO_MEMO
	Tem uma mensagem.
MEMO_INFO_MEMO_UNREAD
	Atualmente tem uma mensagem, que ainda no foi lida.
MEMO_INFO_MEMOS
	Atualmente tem %d mensagens.
MEMO_INFO_MEMOS_ONE_UNREAD
	Atualmente tem %d mensagens, das quais uma no foi lida.
MEMO_INFO_MEMOS_SOME_UNREAD
	Atualmente tem %d mensagens, das quais %d no foram lidas.
MEMO_INFO_MEMOS_ALL_UNREAD
	Tem %d mensagens; nenhuma lida.
MEMO_INFO_LIMIT
	O seu limite de mensagens  %d.
MEMO_INFO_HARD_LIMIT
	O seu limite de mensagens  %d, e no pode ser mudado.
MEMO_INFO_LIMIT_ZERO
	O seu limite de mensagens  0 ; no pode receber nenhuma mensagem.
MEMO_INFO_HARD_LIMIT_ZERO
	O seu limite de mensagens  0 ; no pode receber nenhuma mensagem, e no
	pode mudar este limite.
MEMO_INFO_NO_LIMIT
	No tem limite para as mensagens que poder possuir.
MEMO_INFO_X_NO_MEMOS
	%s no tem mensagens.
MEMO_INFO_X_MEMO
	%s tem atualmente uma mensagem.
MEMO_INFO_X_MEMO_UNREAD
	%s tem atualmente uma mensagem, ainda no lida.
MEMO_INFO_X_MEMOS
	%s tem atualmente %d mensagens.
MEMO_INFO_X_MEMOS_ONE_UNREAD
	%s tem atualmente %d mensagens,  uma  no lida.
MEMO_INFO_X_MEMOS_SOME_UNREAD
	%s tem atualmente %d mensagens,  %d  no lidas.
MEMO_INFO_X_MEMOS_ALL_UNREAD
	%s tem atualmente %d mensagens; nenhuma lida.
MEMO_INFO_X_LIMIT
	O limite de mensagens de %s  %d.
MEMO_INFO_X_HARD_LIMIT
	O limite de mensagens de %s  %d e no pode ser mudado.
MEMO_INFO_X_NO_LIMIT
	%s no tem limite de mensagens.

###########################################################################
#
# Mensagens do OperServ
#
###########################################################################

# General messages
OPER_BOUNCY_MODES
	Services no esto a conseguir mudar modos.
	Servidores esto configurados corretamente?
OPER_BOUNCY_MODES_U_LINE
	Services no esto a conseguir mudar modos.
	As U:lines dos seus servidores esto configuradas corretamente?

# GLOBAL responses
OPER_GLOBAL_SYNTAX
	GLOBAL mensagem

# STATS responses
OPER_STATS_UNKNOWN_OPTION
	Opo STATS %s desconhecida.
OPER_STATS_CURRENT_USERS
	Usurios atuais   :  %d  (%d  IRCops, %d Helpers, %d Bots)
OPER_STATS_MAX_USERS
	Mximo de usurios:  %d
# This is ugly, but at least it's language-portable...
OPER_STATS_UPTIME_DHMS
	Services ativos h %d dias, %02d:%02d
OPER_STATS_UPTIME_1DHMS
	Services ativos h %d dia, %02d:%02d
OPER_STATS_UPTIME_HMS
	Services ativos h %d horas, %d minutos
OPER_STATS_UPTIME_HM1S
	Services ativos h %d horas, %d minutos
OPER_STATS_UPTIME_H1MS
	Services ativos h %d horas, %d minuto
OPER_STATS_UPTIME_H1M1S
	Services ativos h %d horas, %d minuto
OPER_STATS_UPTIME_1HMS
	Services ativos h %d hora, %d minutos
OPER_STATS_UPTIME_1HM1S
	Services ativos h %d hora, %d minutos
OPER_STATS_UPTIME_1H1MS
	Services ativos h %d hora, %d minuto
OPER_STATS_UPTIME_1H1M1S
	Services ativos h %d hora, %d minuto
OPER_STATS_UPTIME_MS
	Services ativos h %d minutos, %d segundos
OPER_STATS_UPTIME_M1S
	Services ativos h %d minutos, %d segundo
OPER_STATS_UPTIME_1MS
	Services ativos h %d minuto, %d segundos
OPER_STATS_UPTIME_1M1S
	Services ativos h %d minuto, %d segundo
OPER_STATS_USER_MEM
	Usurios: %6d registros, %5d kB
OPER_STATS_CHANNEL_MEM
	Canal   : %6d registros, %5d kB
OPER_STATS_NICKSERV_MEM
	NickServ: %6d registros, %5d kB
OPER_STATS_CHANSERV_MEM
	ChanServ: %6d registros, %5d kB
OPER_STATS_OPERSERV_MEM
	OperServ: %6d registros, %5d kB
OPER_STATS_AKILL_COUNT
	Nmero atual de AKILLs: %d
OPER_STATS_AKILL_EXPIRE_DAYS
	Tempo default para expirar AKILL: %d dias
OPER_STATS_AKILL_EXPIRE_DAY
	Tempo default para expirar AKILL: 1 dia
OPER_STATS_AKILL_EXPIRE_HOURS
	Tempo default para expirar AKILL: %d horas
OPER_STATS_AKILL_EXPIRE_HOUR
	Tempo default para expirar AKILL: 1 hora
OPER_STATS_AKILL_EXPIRE_MINS
	Tempo default para expirar AKILL: %d minutos
OPER_STATS_AKILL_EXPIRE_MIN
	Tempo default para expirar AKILL: 1 minuto
OPER_STATS_AKILL_EXPIRE_NONE
	Tempo default para expirar AKILL: No ir expirar.

# ADMIN responses
OPER_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [nick]
OPER_ADMIN_ADD_SYNTAX
	ADMIN ADD nick
OPER_ADMIN_DEL_SYNTAX
	ADMIN DEL nick
OPER_ADMIN_SKELETON
	Services esto no modo skeleton; o comando ADMIN no est disponvel.
OPER_ADMIN_EXISTS
	%s j est na lista de Administradores dos Services.
OPER_ADMIN_ADDED
	%s adicionado a lista de Administradores dos Services.
OPER_ADMIN_TOO_MANY
	Muitas entradas (%d) na lista dos Administradores dos Services  impossvel
	adicionar mais.
OPER_ADMIN_REMOVED
	%s foi removido da lista dos Administradores dos Services.
OPER_ADMIN_NOT_FOUND
	%s no foi encontrado na lista dos Administradores dos Services.
OPER_ADMIN_LIST_HEADER
	Lista de Administradores dos Services:

# OPER responses
OPER_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [nick]
OPER_OPER_ADD_SYNTAX
	OPER ADD nick
OPER_OPER_DEL_SYNTAX
	OPER DEL nick
OPER_OPER_SKELETON
	Services esto no modo skeleton, o comando OPER no est disponvel.
OPER_OPER_EXISTS
	%s j existe na lista dos Operadores dos Services.
OPER_OPER_ADDED
	%s adicionado a lista de Operadores dos Services.
OPER_OPER_TOO_MANY
	Muitas entradas (%d) na lista dos Operadores dos Services  impossvel
	adicionar mais.
OPER_OPER_REMOVED
	%s removido da lista de Operadores dos Services.
OPER_OPER_NOT_FOUND
	%s no encontrado na lista de Operadores dos Services.
OPER_OPER_LIST_HEADER
	Lista de Operadores dos Services:

# MODE responses
OPER_MODE_SYNTAX
	MODE canal modos

# CLEARMODES responses
OPER_CLEARMODES_SYNTAX
	CLEARMODES canal [ALL]
OPER_CLEARMODES_DONE
	Bans e modos binrios do canal %s foram limpos.
OPER_CLEARMODES_ALL_DONE
	Todos os modos do canal %s foram limpos.

# KICK responses
OPER_KICK_SYNTAX
	KICK canal usurio razo

# AKILL responses
OPER_AKILL_SYNTAX
	AKILL {ADD | DEL | LIST | VIEW} [[+tempo] hostname [razo]]
OPER_AKILL_ADD_SYNTAX
	AKILL ADD [+tempo] hostname razo
OPER_AKILL_DEL_SYNTAX
	AKILL DEL hostname
OPER_AKILL_NO_NICK
	Lembre-se : hostnames de AKILL no podem conter nicks;
	tenha a certeza que no incluiu uma poro do nick no hostname.
OPER_TOO_MANY_AKILLS
	Lista de AKILL est cheia!
OPER_AKILL_ADDED
	%s adicionado na lista de AKILL.
OPER_AKILL_REMOVED
	%s removido da lista de AKILL.
OPER_AKILL_NOT_FOUND
	%s no encontrado na lista de AKILL.
OPER_AKILL_LIST_HEADER
	Lista de AKILL atual:
# mask, reason
OPER_AKILL_LIST_FORMAT
	%-32s  %s
# mask, set-by, set-time, expires, reason
OPER_AKILL_VIEW_FORMAT
	%s (pelo %s em %s; %s)
	    %s
OPER_AKILL_NO_EXPIRE
	No ir expirar.
OPER_AKILL_EXPIRES_SOON
	expira na prxima atualizao do banco de dados
OPER_AKILL_EXPIRES_M
	expira em %d minutos
OPER_AKILL_EXPIRES_1M
	expira em %d minuto
OPER_AKILL_EXPIRES_HM
	expira em %d horas, %d minutos
OPER_AKILL_EXPIRES_H1M
	expira em %d horas, %d minuto
OPER_AKILL_EXPIRES_1HM
	expira em %d hora, %d minutos
OPER_AKILL_EXPIRES_1H1M
	expira em %d hora, %d minuto
OPER_AKILL_EXPIRES_D
	expira em %d dias
OPER_AKILL_EXPIRES_1D
	expira em %d dia

# SET responses
OPER_SET_SYNTAX
	SET opo seleo
OPER_SET_IGNORE_ON
	Ignore code ser usado.
OPER_SET_IGNORE_OFF
	Ignore code no ser usado.
OPER_SET_IGNORE_ERROR
	Parmetro para IGNORE deve ser ON ou OFF.
OPER_SET_READONLY_ON
	Services esto agora no modo read-only (somente-leitura).
OPER_SET_READONLY_OFF
	Services agora esto no modo leitura-escrita (read-write).
OPER_SET_READONLY_ERROR
	Parmetro para READONLY deve ser ON ou OFF.
OPER_SET_DEBUG_ON
	Services esto agora no modo de debug.
OPER_SET_DEBUG_OFF
	Services esto no modo de non-debug.
OPER_SET_DEBUG_LEVEL
	Services esto no modo de debug (nvel %d).
OPER_SET_DEBUG_ERROR
	Parmetro para DEBUG deve ser ON, OFF ou um nmero positivo.
OPER_SET_UNKNOWN_OPTION
	Opo %s desconhecida.

# JUPE responses
OPER_JUPE_SYNTAX
	JUPE nome-do-servidor [razo]

# RAW responses
OPER_RAW_SYNTAX
	RAW texto

# UPDATE responses
OPER_UPDATING
	Atualizando banco de dados.

# RESTART responses
OPER_CANNOT_RESTART
	SERVICES_BIN no definido, no  possvel reiniciar.
	Execute novamente o script CONFIGURE e recompile os Services para
	habilitar o comando RESTART.

# LISTIGNORE responses
OPER_IGNORE_LIST
	Lista de ignore dos Services:
OPER_IGNORE_LIST_EMPTY
	Lista de ignore est vazia.

###########################################################################
#
# News system messages
#
###########################################################################

NEWS_LOGON_TEXT
	[Logon News - %s] %s
NEWS_OPER_TEXT
	[Oper News - %s] %s
NEWS_LOGON_SYNTAX
	LOGONNEWS {ADD|DEL|LIST} [texto|nmero]
NEWS_LOGON_LIST_HEADER
	Mensagens de entrada:
NEWS_LOGON_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_LOGON_LIST_NONE
	No existe nenhuma mensagem de entrada.
NEWS_LOGON_ADD_SYNTAX
	LOGONNEWS ADD texto
NEWS_LOGON_ADD_FULL
	Lista de mensagens est cheia!
NEWS_LOGON_ADDED
	Adicionada nova mensagem de entrada (#%d).
NEWS_LOGON_DEL_SYNTAX
	LOGONNEWS DEL {nmero | ALL}
NEWS_LOGON_DEL_NOT_FOUND
	Mensagem de entrada nmero %d no encontrada!
NEWS_LOGON_DELETED
	Mensagem de entrada nmero %d apagada.
NEWS_LOGON_DEL_NONE
	No h mensagem de entrada para apagar!
NEWS_LOGON_DELETED_ALL
	Todas as mensagens de entrada apagadas.

NEWS_OPER_SYNTAX
	OPERNEWS {ADD|DEL|LIST} [texto|nmero]
NEWS_OPER_LIST_HEADER
	Oper news itens:
NEWS_OPER_LIST_ENTRY
	%5d (%s por %s)
	    %s
NEWS_OPER_LIST_NONE
	No h oper news.
NEWS_OPER_ADD_SYNTAX
	OPERNEWS ADD texto
NEWS_OPER_ADD_FULL
	Lista de oper news est cheia!
NEWS_OPER_ADDED
	Adicionada nova oper news (#%d).
NEWS_OPER_DEL_SYNTAX
	OPERNEWS DEL {nmero | ALL}
NEWS_OPER_DEL_NOT_FOUND
	Oper news nmero %d no encontrada!
NEWS_OPER_DELETED
	Oper news nmero %d apagada.
NEWS_OPER_DEL_NONE
	No h oper news para apagar!
NEWS_OPER_DELETED_ALL
	Todas as oper news foram apagadas.

NEWS_HELP_LOGON
	Sintaxe:  LOGONNEWS ADD texto
	          LOGONNEWS DEL {nmero | ALL}
	          LOGONNEWS LIST

	Edita ou mostra a lista de logon news. Quando um usurio
	se conecta  rede, estas mensagens so enviadas para o mesmo.
	(No entanto, no mais que trs mensagens sero enviadas
	simultaneamente para evitar flood. Se houver mais que trs
	mensagens novas, apenas essas mais novas sero mostradas.)

	LOGONNEWS LIST pode ser usado por qualquer IRC operator
	para listar as mensagens atuais. ADD e DEL s podem
	ser usados pelos Administradores dos Services.

NEWS_HELP_OPER
	Sintaxe:  OPERNEWS ADD texto
	          OPERNEWS DEL {nmero | ALL}
	          OPERNEWS LIST

	Edita ou mostra a lista de oper news. Quando um usurio
	se torna operador (pelo comando /OPER), estas mensagens
	sero enviadas. (No entanto, no mais que trs
	mensagens sero enviadas simultaneamente para evitar
	flood. Se houver mais que trs mensagens novas, apenas
	as trs mais novas sero mostradas.)

	OPERNEWS LIST pode ser usado por qualquer IRC operator
	para listar as oper news. ADD e DEL s podem ser usados
	pelos Administradores dos Services.

###########################################################################
#
# Mensagens de help do NickServ
#
###########################################################################

NICK_HELP
	%S permite que "registre" um nick evitando que
	outras pessoas o utilizem. Se o nick no for usado por %d
	dias, o registro ser removido. Os seguintes comandos
	permitem o registro e a manuteno dos nicks, para
	utiliz-los, digite /%S comando. Para mais informaes
	sobre um comando, digite /%S HELP comando.

	    AJOIN      Modifica a lista de canais com entrada automtica
	    REGISTER   Registra um nick
	    IDENTIFY   Identifica o seu nick com a sua senha
	    LINK       Faz uma ligao do seu nick com outro
	    SET        Altera opes do seu nick
	    DROP       Cancela o registro de um nick
	    LISTLINKS  Lista os nicks ligados ao seu nick
	    NOTES      Permite guardar anotaes
	    GHOST      Cancela uma ligao do nick

	Outros comandos: UNLINK, INFO, LIST, STATUS

	NOTA: Este servio tem a inteno de proporcionar um modo para
	que os usurios desta rede no tenham a identidade comprometida.
	Isto NO tem como fim facilitar o "roubo" dos nicks ou
	outras atitudes consideradas ilcitas. O abuso do %S
	resultar em, no mnimo, perda do(s) nick(s) abusivo(s).

NICK_HELP_EXPIRE_ZERO
	%S permite "registrar" um nick e impede que
	outros o utilizem. Os comandos seguintes permitem o
	registro e a manuteno dos nicks, para us-los, digite
	/%S comando. Para mais informaes sobre um
	comando especfico, digite /%S HELP comando.

	   REGISTER  Registra um nick
	   IDENTIFY  Identifica o seu nick com a sua senha
	   LINK      Faz uma ligao do seu nick com outro
	   SET       Altera opes do seu nick
	   DROP      Cancela o registro de um nick

	Outros comandos: UNLINK, GHOST, INFO, LIST, STATUS

	NOTA: Este servio tem a inteno de proporcionar um modo para que
	os usurios desta rede no tenham a sua identidade comprometida.
	Isto NO tem como fim facilitar o "roubo" dos nicks ou
	outras atitudes consideradas ilticas. O abuso do %S resultar
	em, no mnimo, perda do(s) nick(s) abusivos.

NICK_HELP_REGISTER
	Sintaxe:  REGISTER senha email

	Registra o nick no banco de dados do %S.
	Se no possuir uma conta de email indique NOMAIL como email.
	Depois de ter o nick registrado, pode usar o comando
	SET para configurar as opes do seu nick como
	preferir. Certifique-se que guarda a sua senha durante
	o registro, precisar dela para fazer alteraes no
	nick futuramente. (Lembre-se que maisculas diferem : FIDO,
	Fido, e fido so senhas diferentes!)

	Sugestes ao escolher sua senha:

	As senhas no devem ser de fcil acesso aleatrio. Por exemplo,
	usar o nome como senha  uma pssima idia. Utilizar o
	nick como senha  ainda uma idia muito pior e, de fato, o %S
	no permitir isso. Da mesma maneira, senhas curtas so
	vulnerveis a testes de brute-force, deve
	escolher uma senha com pelo menos 5 caracteres. Finalmente,
	o caracter "ESPAO" no pode ser usado em SENHAS.

NICK_HELP_IDENTIFY
	Sintaxe:  IDENTIFY senha

	Diz ao %S que realmente  o dono do nick.
	Muitos comandos exigem que se identifique com este
	comando antes de os poder usar. A senha  a mesma que
	enviou com o comando REGISTER.

NICK_HELP_DROP
	Sintaxe:  DROP

	Retira o seu nick do banco de dados do %S. O nick que
	foi retirado est livre para qualquer pessoa registrar
	novamente.

	Para utilizar este comando, tem que se identificar
	com a senha primeiro ( /%S HELP IDENTIFY para mais
	informaes).

NICK_HELP_LINK
	Sintaxe: LINK nick senha

	Liga o seu nick a outro, efetivamente, fazendo uma ligao
	do nick atual com um outro nick especificado. Quando
	emite este comando, a lista de acesso do seu nick
	atualmente em uso  apagada e substituda pelo nick a
	que est a ligar-se, todos os memos do nick atual so
	adicionados na lista de memos do nick alvo (isso pode
	causar um excesso no limite de memos do nick, em alguns
	casos vai precisar de apagar alguns memos antes de poder
	receber mais de outra pessoa).

	Uma vez que a ligao seja estabilizada, o seu nick ser
	transparentemente convertido para o nick alvo em todos
	os lugares dos Services, exceto para os comandos %S
	UNLINK e DROP.
	Por exemplo, pode usar um nick ou outro para ler
	o mesmo conjunto de memos (e mensagens enviadas para um nick
	ou outro iro para a mesma lista). Se voc identificar
	para um nick, estar automaticamente identificado para o
	outro. Se um nick ou outro est na lista de acesso de um
	canal, ambos os nicks tero os mesmos privilgios de acesso.

	Para usar este comando, deve identificar o nick atual
	(usando o comando  IDENTIFY ), e deve fornecer a
	senha para o nick que deseja linkar.

NICK_HELP_UNLINK
	Sintaxe:  UNLINK [nick senha]

	Remove a ligao com outro nick. Quando uma ligao 
	removida, os modos de um nick e a lista de acesso do nick
	previamente ligado so copiados para o nick atual e podem
	ser independetemente alterados. As suas mensagens no so
	copiadas, todas as mensagens permanecero armazenadas no
	nick anteriormente ligado.

	Informando nick e senha como parmetros, pode desligar o seu
	nick do nick especificado.

NICK_HELP_SET
	Sintaxe:  SET opo parmetros

	Altera vrias opes do nick. A opo pode ser:

	    PASSWORD   Altera a senha do seu nick.
	    LANGUAGE   Altera a linguagem dos Services quando
	                  lhe so enviadas mensagens
	    URL        Associa um endereo URL ao seu nick
	    EMAIL      Associa um endereo de e-mail ao seu nick
	    LOCATION   Associa um local ao seu nick.
	    ICQNUMBER  Associa um nmero ICQ ao seu nick.
	    KILL       Esta proteo  agora obrigatria, no sendo
	               por isso configurvel.
	    PRIVATE    Previne o seu nick de aparecer num /%S LIST.
	    HIDE       Esconde certas informaes sobre o seu nick.
	    NEWSLETTER Ativa/desativa recepo de newsletter.

	Para usar este comando, deve primeiro estar identificado
	com a sua SENHA ( /%S HELP IDENTIFY para mais
	informaes).

	Digite /%S HELP SET opo para mais informaes
	sobre um comando especfico.

NICK_HELP_SET_PASSWORD
	Sintaxe:  SET PASSWORD nova-senha

	Muda a senha que  utilizada para identificar o dono do
	nick.

NICK_HELP_SET_LANGUAGE
	Sintaxe:  SET LANGUAGE nmero

	Muda a linguagem que os Services usam ao enviar mensagens
	(por exemplo, quando responde a um comando que
	emite). O nmero deve ser escolhido da seguinte lista
	de lnguas de apoio.


NICK_HELP_SET_URL
	Sintaxe:  SET URL url

	Associa um dado URL ao seu nick. Este URL ser mostrado
	sempre que alguem solicitar informaes sobre o seu nick
	atravs do comando INFO.

NICK_HELP_SET_EMAIL
	Sintaxe:  SET EMAIL endereo

	Associa um endereo de e-mail ao seu nick. Este
	endereo ser sempre mostrado quando alguem solicitar
	informao sobre o seu nick atravs do comando INFO.

NICK_HELP_SET_KILL
	Sintaxe:  SET KILL {}

	Possibilita a proteo de KILL no seu nick. Com a proteo
	de KILL acionada, se outro utilizador tentar usar o seu nick,
	ser dado 1 minuto para que este o mude, aps isso, ser
	foradamente removido do IRC pelo %S.

	NOTA:
	Esta proteo  agora obrigatria, no sendo por isso configurvel.

NICK_HELP_SET_SECURE
	Sintaxe:  SET SECURE {ON | OFF}

	Torna os recursos de segurana do %S ativos (ON) ou
	desativos (OFF) sobre um nick. Com o SECURE acionado,
	deve entrar com a sua senha antes de ser reconhecido
	como utilizador do nick, independentemente do fato do
	endereo constar na lista de acesso. Entretanto, se
	est na lista de acesso, o %S no ir dar auto-kill
	de acordo com os ajustes da opo KILL.

NICK_HELP_SET_PRIVATE
	Sintaxe:  SET PRIVATE {ON | OFF}

	Torna a opo de privacidade do %S sobre o seu nick
	ativa (ON) ou desativa (OFF). Com PRIVATE acionado,
	o seu nick no aparecer nas listagens de nicks geradas com
	o comando %S LIST. (Entretanto, algum que saiba o seu
	nick ainda pode obter informaes utilizando o comando INFO ).

NICK_HELP_SET_HIDE
	Sintaxe:  SET HIDE {EMAIL | QUIT} {ON | OFF}

	Permite que previnir que certas informaes sejam mostradas
	quando algum faz um INFO ao seu nick. Pode esconder
	o endereo de e-mail (EMAIL), e a ltima mensagem de sada
	(QUIT). O segundo parmetro especifica quando a informao
	deve ser ou no mostrada (OFF) (ON).

NICK_HELP_GHOST
	Sintaxe:  GHOST nick [senha]

	Elimina uma sesso "fantasma" de IRC que esteja utilizando o seu
	nick. A sesso "fantasma"  aquela que no est realmente
	conectada, mas que o servidor de IRC acredita estar ainda
	ativa por qualquer razo. Isso acontece normalmente quando o
	computador crasha ou se a sua ligao Internet ou modem cair
	por um perodo curto de tempo enquanto estiver no IRC.

	Para usar o comando GHOST num nick, o seu endereo atual
	como mostrado no /WHOIS deve pertencer a lista de acesso do
	nick, ou deve fornecer a senha correta para o nick.

NICK_HELP_INFO
	Sintaxe:  INFO nick

	Mostra a informao sobre o nick dado, como, o dono do nick,
	ltimo endereo utilizado, tempo e opes.

NICK_HELP_LIST
	Sintaxe:  LIST padro

	Lista todos os nicks registrados que combinam com o padro
	fornecido no formato nick!ident@host. Nicks com a opo
	PRIVATE ligada no sero mostrados.

	Exemplos:

	     LIST *!bond@*.meuip.com.br
	        Lista todos os nicks de bond@*.meuip.com.br.

	     LIST *Bot*!*@*
	        Lista todos os nicks registados com Bot nos seus nomes.

	     LIST *!*@*.meuip.com.br
	        Lista todos os nicks do domnio meuip.com.br.

NICK_HELP_STATUS
	Sintaxe:  STATUS nick

	Retorna se o utilizador que est a utilizar um determinado nick
	 reconhecido como dono do nick. A resposta tem este formato:

	    nickname cdigo-de-status

	onde nickname e o nick enviado com o comando, e
	cdigo-de-status  um dos seguintes:

	    0 - utilizador no est conectado ou o nick no est registrado
	    1 - utilizador no reconhecido como dono do nick
	    2 - utilizador reconhecido como dono s pela lista de acesso
	    3 - utilizador reconhecido como dono via identificao por senha

	At dezesseis nicks podem ser enviados com cada comando, o
	resto ser ignorado. No  gerada mensagem de erro se nenhum
	nick for fornecido.

NICK_SERVADMIN_HELP

	Os comandos abaixo esto disponveis para Administradores dos
	Services :

	     GETPASS     Recupera a senha de um nick
	                   (se a encriptao est desativada)
	     FORBID      Previne um nick de ser usado
	     LISTLINKS   Lista os nicks ligados a um determinado nick.

	Administradores dos Services podem tambm cancelar registro
	de qualquer nick sem a necessidade de identificao e podem
	ver a lista de ajoin de qualquer nick
	( /%S AJOIN LIST nick ).

NICK_SERVADMIN_HELP_DROP
	Sintaxe:  DROP [nick]

	Sem parmetros, cancela o registro do seu nick no banco de
	dados do %S.

	Com parmetros, cancela o registro de um nick especificado
	do banco de dados.
	Este comando  restrito aos Administradores dos Services.

NICK_SERVADMIN_HELP_UNLINK

	Os Administradores dos Services podem desfazer uma ligao sem
	precisar da senha.

NICK_HELP_LISTLINKS
	Sintaxe:  LISTLINKS

	Lista os nicks ligados a um determinado nick.

NICK_SERVADMIN_HELP_LISTLINKS
	Sintaxe:  LISTLINKS nick [ALL]

	Lista os nicks ligados a um determinado nick. Se ALL 
	fornecido, lista todos os nicks com os mesmos privilgios de
	um determinado nick, caso contrrio, lista apenas os nicks
	que esto ligados ao nick especificado.

NICK_SERVADMIN_HELP_SET

	Administradores dos Services podem ajustar a opo NOEXPIRE,
	com a qual os nicks podem ser protegidos de expirar.
	E ainda, Administradores dos Services, podem ajustar opes
	para qualquer nick sem se identificar com a senha, usando o
	SET nick opo parmetros.

NICK_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxe:  SET nick NOEXPIRE {ON | OFF}

	Determina se um nick fornecido poder ser expirado.
	Ajustando este para ON, evita que o nick seja expirado.

	Limitado aos Administradores dos Services.

NICK_SERVADMIN_HELP_LIST
	Sintaxe:  LIST padro [FORBIDDEN] [NOEXPIRE]

	Lista todos os nicks registrados que combinem com o padro
	fornecido (formato nick!user@host). Nicks com opo PRIVATE
	sero somente exibidos para os Administradores dos Services.
	Nicks com opo NOEXPIRE ajustada tero um ! preposto ao nick
	na lista quando for a pedido de Administrador dos Services.
	Se as opes FORBIDDEN ou NOEXPIRE forem fornecidas, somente os
	nicks proibidos (forbidden) ou os que tem a flag NOEXPIRE sero
	exibidos, respectivamente. Se ambas as opes so fornecidas,
	ambos os tipos de nicks sero exibidos.

	Essas opes so limitadas aos Administradores dos Services.

	Exemplos:

	     LIST *!bond@ab1-23.meuip.com.br
	        Lista todos os nicks de bond@ab1-23.meuip.com.br.

	     LIST *Bot*!*@*
	        Lista todos os nicks registrados com Bot em seus nomes.

	     LIST * NOEXPIRE
	        Lista todos os nicks registrados cujos registros foram
	        ajustados para no expirar.

NICK_SERVADMIN_HELP_GETPASS
	Sintaxe:  GETPASS nick

	Mostra a senha de um nick especificado.
	Note que sempre que este comando for usado, uma mensagem
	incluindo o nick da pessoa que emitiu o comando o nick
	requisitado ser gravado e enviado para WALLOPS/GLOBOPS.

	Limitado aos Administradores dos Services.

	Este comando no  disponvel quando a encriptao est habilitada.

NICK_SERVADMIN_HELP_FORBID
	Sintaxe:  FORBID nick

	No permite que um nick seja registrado ou usado por
	ningum. Pode ser cancelado desregistrando o nick.

	Limitado aos Administradores dos Services.

###########################################################################
#
# Mensagens de help do ChanServ
#
###########################################################################

CHAN_HELP
	%S permite que registre e controle vrios
	aspectos do canal. %S pode prevenir o "take over"
	do canal de users maliciosos limitando quem possui
	o privilgio de OP do canal. Os comandos disponveis
	esto listados abaixo.
	Para us-los, digite /%S comando.
	Para mais informaes de um comando, digite
	/%S HELP comando.

	    REGISTER   Registra um canal
	    IDENTIFY   Identifica com uma senha
	    SET        Altera as opes e informaes do canal
	    ACCESS     Modifica a lista de users privilegiados
	    AOP/SOP    Aliases para gesto da lista de acesso
	    LEVELS     Redefine os nveis de acesso
	    AKICK      Faz a manuteno da Lista de Autokick
	    DROP       Cancela o registro de um canal

	Outros comandos: INFO, LIST, INVITE, OP, DEOP, UNBAN,
	                 KICK, CLEAR

CHAN_HELP_EXPIRES

	Note que qualquer canal no utilizado por %d dias
	(entenda como se nenhum usurio da lista de acesso
	desse canal entrar neste perodo de tempo) ter
	automaticamente cancelado o seu registro.

CHAN_HELP_REGISTER
	Sintaxe:  REGISTER canal senha descrio

	Registra um canal no banco de dados do %S. Para
	utilizar este comando, deve primeiro ser OP do
	canal que est a tentar registrar. A senha  usada
	com o comando IDENTIFY e permitir que faa
	mudanas nas opes do canal futuramente. O ltimo
	parmetro que deve ser includo,  uma breve
	descrio do propsito do canal.

	Quando registra um canal, ser registrado
	como o "fundador" do canal. O fundador do canal tem
	permisso para mudar todas as opes do canal, o %S
	tambm ir dar ao fundador automaticamente o privilgio
	de OP do canal quando ele/ela entra no canal. Veja o
	comando ACCESS ( /%S HELP ACCESS ) para
	informaes dos subconjuntos destes privilgios para
	outros users do canal.

	IMPORTANTE: Para registrar um canal, deve antes ter
	registrado seu nick. Se ainda no, digite /%s HELP
	para mais informaes de como faz-lo.

CHAN_HELP_IDENTIFY
	Sintaxe:  IDENTIFY canal senha

	Identifica no %S como fundador do canal fornecido.
	Muitos comandos exigem que use este comando antes
	de us-los. A senha dever ser a mesma que usou
	no comando REGISTER.

CHAN_HELP_DROP
	Sintaxe:  DROP #canal

	Cancela o registro do canal. S poder ser usado pelo
	fundador do canal, que primeiramente dever usar o
	comando IDENTIFY.

CHAN_HELP_SET
	Sintaxe:  SET canal opo parmetros

	Permite ao fundador do canal alterar as vrias opes do
	canal e outras informaes. O fundador deve utilizar o
	comando IDENTIFY antes de usar o SET.

	Comandos disponveis:

	    FOUNDER     Altera o fundador do canal
	    SUCCESSOR   Altera o sucessor do canal
	    PASSWORD    Altera a senha do fundador
	    DESC        Altera a descrio do canal
	    URL         Associa uma URL a um canal
	    EMAIL       Associa um e-mail a um canal
	    ENTRYMSG    Altera a mensagem que deve ser mandada
	                aos usurios quando eles entram no canal.
	    TOPIC       Altera o tpico do canal
	    KEEPTOPIC   Mantem o tpico quando o canal
	                no est em uso.
	    TOPICLOCK   O tpico pode ser mudado apenas
	                com o SET TOPIC.
	    MLOCK       Liga ou desliga o bloqueio dos modos do canal
	    PRIVATE     Esconde o canal do comando LIST
	    RESTRICTED  Acesso restrito ao canal
	    SECUREOPS   Rigoroso controle de status de OP
	    LEAVEOPS    Nunca tira (de-op) op dos users exceto com
	                o comando DEOP.
	    OPNOTICE    Envia uma notice quando os comandos OP/DEOP
	                so usados.
	    NOLINKS     Ignora reconhecimento de nvel de acesso no canal
	                por nick links.

	Digite /%S HELP SET opes para maiores informaes
	sobre uma opo em particular.

CHAN_HELP_SET_FOUNDER
	Sintaxe:  SET canal FOUNDER nick

	Muda o fundador do canal. O novo nick deve estar
	registrado.

CHAN_HELP_SET_SUCCESSOR
	Sintaxe:  SET canal SUCCESSOR nick

	Muda o sucessor de um canal. Se o nick do founder expirar
	ou estiver dropado enquanto o canal ainda estiver registrado,
	o sucessor se tornar o novo founder do canal.
	No entanto, se o sucessor possuir muitos canais registrados
	(%d), o canal ser dropado, como se nenhum sucessor tivesse
	sido ajustado. O novo nick dever estar registrado.

CHAN_HELP_SET_PASSWORD
	Sintaxe:  SET canal PASSWORD senha

	Altera a senha utilizada para identificao do
	fundador do canal.

CHAN_HELP_SET_DESC
	Sintaxe:  SET canal DESC descrio

	Altera a descrio para o canal, que  mostrada com
	os comandos LIST e INFO.

CHAN_HELP_SET_URL
	Sintaxe:  SET canal URL [url]

	Associa um URL ao canal. Este URL ser mostrado
	sempre que algum solicitar informao sobre o canal
	com o comando INFO. Se nenhum parmetro for fornecido,
	apaga qualquer URL atualmente designada para o canal.

CHAN_HELP_SET_EMAIL
	Sintaxe:  SET canal EMAIL [endereo]

	Associa um endereo de e-mail fornecido ao canal.
	Este endereo ser mostrado sempre que algum solicitar
	informao sobre o canal com o comando INFO. Se nenhum
	parmetro for fornecido, apaga qualquer endereo de e-mail
	do canal.

CHAN_HELP_SET_ENTRYMSG
	Sintaxe:  SET canal ENTRYMSG [mensagem]

	Altera a mensagem que ser enviada via /notice para
	os users quando eles entrarem no canal. Se nenhum
	parmetro  fornecido, nenhuma mensagem ser enviada
	ao entrar no canal.

CHAN_HELP_SET_TOPIC
	Sintaxe:  SET canal TOPIC tpico

	Faz o %S mudar o tpico do canal pelo tpico dado.
	Este comando  muito mais til em conjunto com o
	SET TOPICLOCK.

CHAN_HELP_SET_KEEPTOPIC
	Sintaxe:  SET canal KEEPTOPIC {ON|OFF}

	Ativa ou desativa a opo de reteno de tpico para
	um canal. Quando a reteno de tpico est acionada,
	o tpico para o canal ser relembrado pelo %S mesmo
	depois de os users deixarem o canal, e ser
	restaurado na prxima vez que o canal for re-aberto.

CHAN_HELP_SET_TOPICLOCK
	Sintaxe:  SET canal TOPICLOCK {ON|OFF}

	Ativa ou desativa a opo que bloqueia o tpico de um canal.
	Quando o Bloqueio do tpico est ativado, o %S no permitir
	a mudana do tpico do canal exceto pelo comando SET TOPIC.


CHAN_HELP_SET_MLOCK
	Sintaxe:  SET canal MLOCK modos

	Ajusta o parmetro de bloqueio do modo para um canal. O %S
	permite que defina certos modos no canal a serem sempre ativos
	(ou desativos). Os modos podem ser i, k, l, m, n,
	p, s e t, cada um desses bloqueado como ativo, desativo
	ou no bloqueado. O parmetro modos  usado exatamente do
	mesmo modo como o comando /MODE, isto , modos seguidos
	de + so bloqueados como ativos, e modos seguidos de - so
	bloqueados como desativos.

	Cuidado: Se bloqueia uma senha, como no segundo exemplo
	abaixo, deveria tambm ajustar a opo RESTRICTED para
	o canal (veja HELP SET RESTRICTED), ou qualquer usurio
	que entra no canal que est vazio ser capaz de ver a senha!

	Exemplos:

	     SET #canal MLOCK +nt-iklps
	        Bloqueia os modos n e t ativados, e os modos
	        i, k, l, p, s desligados. Modo m  livremente
	        deixado para ser ligado(on) ou desligado(off).

	     SET #canal MLOCK +knst-ilmp minha-senha
	        Bloqueia os modos k, n, s, t como ligados e os
	        modos i, l, m, p como desligados. Tambm bloqueia
	        a senha do canal como "minha-senha".

	     SET #canal MLOCK +
	        Elimina o bloqueio dos modos, todos os modos do
	        canal ficam livres para ser ativados ou desativados.

CHAN_HELP_SET_PRIVATE
	Sintaxe:  SET canal PRIVATE {ON|OFF}

	Ativa ou desativa a opo private para um canal. Quando
	private est ativada, um /%S LIST no ir incluir
	o canal em qualquer listagem.

CHAN_HELP_SET_RESTRICTED
	Sintaxe:  SET canal RESTRICTED {ON|OFF}

	Ativa ou desativa a opo de acesso restrito para um canal.
	Quando o acesso restrito estiver ativado, users que
	normalmente no possuem privilgios de OP no canal
	(users com nvel negativo de acesso e, se secure ops
	estiver ativado, users que no pertencem a lista de
	acesso) sero imediatamente kickados e banidos do canal.

CHAN_HELP_SET_SECUREOPS
	Sintaxe:  SET canal SECUREOPS {ON|OFF}

	Ativa ou desativa a opo de segurana de ops para um canal.
	Quando secure-ops estiver ativada, os usurios que no
	estiverem na lista de acesso no podero ter o status de OP.

CHAN_HELP_SET_LEAVEOPS
	Sintaxe:  SET canal LEAVEOPS {ON | OFF}

	Ativa e desativa a opo LEAVE OPS para um canal. Quando
	LEAVE OPS estiver ativado, o ChanServ nunca ir retirar op
	(de-op) do usurio no canal, exceto se o comando DEOP for
	usado.

CHAN_HELP_SET_OPNOTICE
	Sintaxe:  SET canal OPNOTICE {ON | OFF}

	Ativa e desativa a opo Op-Notice para um canal. Quando
	Op-Notice estiver ativado, o ChanServ enviar uma notice para
	o canal sempre que os comandos OP ou DEOP forem usados em
	um usurio no canal.

CHAN_HELP_SET_NOLINKS
	Sintaxe:  SET canal NOLINKS {ON | OFF}

	Ativa e desativa a opo NOLINKS para um canal. Quando
	NOLINKS estiver ativado, o ChanServ apenas reconhecer o
	nick real com acesso no canal. Se o nick estiver linkado
	a outro presente na access list no ser reconhecido como
	tal.

CHAN_HELP_ACCESS
	Sintaxe:  ACCESS canal ADD nick nvel
	          ACCESS canal DEL {nick | entry-num | list | ALL}
	          ACCESS canal LIST [hostname | list]

	Faz manuteno da lista de acesso de um canal. A lista
	de acesso especifica que usurios tem permisso para
	o status de OP ou tem acesso aos comandos do %S em um
	canal. Nveis diferentes de usurios permitem acesso a
	diferentes subnveis de privilgios; /%S HELP ACCESS
	LEVELS para mais informaes especficas. Por padro,
	qualquer nick no presente na lista de acesso possui
	nvel 0.

	O comando ACCESS ADD adiciona um nick ou hostname de um
	user na lista de acesso com o nvel especificado, se o
	nick ou hostname j estiver presente na lista, o seu nvel
	de acesso ser alterado para o nvel especificado.
	O nvel especificado deve ser menor do que o user
	que emitiu o comando.

	O comando ACCESS DEL remove um nick especificado da lista
	de acesso. Se uma lista de nmeros  fornecida, essas
	entradas so apagadas. (Veja o exemplo para LIST abaixo.)
	A utilizao de ALL apagar todos os registros, esta opo
	apenas pode ser usada por utilizador com nvel de founder.

	O comando ACCESS LIST mostra a lista de acesso do canal. Se
	uma hostname for fornecida, somente as entradas que combinarem
	com o padro especificado na hostname sero mostradas. Se uma
	lista de numeros  fornecida, somente essas entradas sero
	mostradas, por exemplo:

	ACCESS #canal LIST 2-5,7-9
	   Lista as entradas de acesso numeradas de 2 a 5 e 7 a 9.

CHAN_HELP_ACCESS_LEVELS
	 Nveis de Acesso do Usurio

	Por padro, os seguintes nveis de acesso so definidos:

	    Founder     Acesso total as funes do %S, OP automtico
	                     quando entrar no canal. Note que
	                     somente uma pessoa pode ter o status
	                     fundador (no pode ser dado usando
	                     o comando ACCESS).
	         10       Acesso ao comando AKICK, OP automtico.
	          5       OP automtico.
	          3       Voice automtico.
	          0       Sem privilgios especiais, pode-se tornar OP
	                     atravs de outros ops (a menos que
	                     secure-ops esteja ativada).
	         <0       No pode ser OP.

	Esses nveis podem ser mudados, ou adicionar novos, usando o
	comando LEVELS; digite /%S HELP LEVELS para informaes.

CHAN_HELP_AKICK
	Sintaxe:  AKICK canal ADD hostname [razo]
	          AKICK canal DEL [ hostname | ALL ]
	          AKICK canal LIST [hostname]

	Faz a manuteno da lista de AutoKick de um canal.
	Se um user que estiver na lista de AutoKick tentar
	entrar no canal, o %S banir este user do canal,
	e depois o kickar.

	O comando AKICK ADD adiciona o usurio especificado ou
	hostname na lista de AutoKick. Se uma razo  dada com
	o comando, esta razo ser usada quando o user for
	kickado, seno, a razo padro ser "Voc foi banido deste
	canal.".

	O comando AKICK DEL remove um nick ou hostname da lista
	de AutoKick. Isso, entretanto, no remove qualquer ban
	colocado pelo AutoKick estes devem ser removidos
	manualmente. A opo ALL eliminar todas as entradas da
	lista de AutoKick, esta opo pode apenas ser utilizada
	por utilizadores com nvel de founder.

	O comando AKICK LIST mostra a lista de AutoKick, ou
	opcionalmente, s os registros de AutoKick quem se
	encaixam com o padro de uma hostname dada.

CHAN_HELP_LEVELS
	Sintaxe:  LEVELS canal SET tipo nvel
	          LEVELS canal {DIS | DISABLE} tipo
	          LEVELS canal LIST
	          LEVELS canal RESET

	O comando LEVELS permite ajuste detalhado sobre o
	significado nmerico dos nveis de acesso usados pelos
	canais. Com esse comando, pode definir o nvel de
	acesso requerido pela maioria das funes do %S.
	(Os comandos SET FOUNDER e SET PASSWORD, assim como este
	comando, so sempre restritos ao fundador do canal).

	LEVELS SET permite que o nvel de acesso para uma funo ou
	grupo de funes sejam alterados. LEVELS DISABLE (ou DIS
	para encurtar) desabilita automaticamente os dispositivos ou
	no permite o acesso a funes para qualquer outra pessoa
	que no seja o fundador do canal. LEVELS LIST mostra os
	nveis atuais para cada funo ou para um grupo de funes.
	LEVELS RESET  recoloca os nveis de acordo com o padro de um
	canal recm-criado (veja HELP ACCESS LEVELS).

	Para lista de recursos e funes cujo nveis podem ser
	ajustados, veja HELP LEVELS DESC.

CHAN_HELP_LEVELS_DESC
	As seguintes caractersticas/funes so entendidas. Note
	que estes nveis para AUTODEOP e NOJOIN so os nveis mximos,
	enquanto que todos os outros so nveis mnimos.

CHAN_HELP_LEVELS_DESC_FORMAT
	    %-*s  %s

CHAN_HELP_INFO
	Sintaxe:  INFO canal

	Lista os dados referentes ao canal registrado dado, incluindo
	seu fundador, data do registro, ltima vez que foi usado,
	descrio e bloqueio dos modos (se existirem).

CHAN_HELP_LIST
	Sintaxe:  LIST padro 

	Lista todos os canais registrados que combinam com o padro
	dado. (Canais com opo PRIVATE ativada no sero listados).

CHAN_HELP_OP
	Sintaxe:  OP #canal nick

	Atribui status de Operador (modo +o) para o nick dado
	num determinado canal. Limitado aos users de nvel 5,
	no mnino, do canal especificado.

CHAN_HELP_DEOP
	Sintaxe:  DEOP #canal nick 

	Remove o status de Operador (modo +o) do nick dado para
	um determinado canal. Limitado aos users de nvel 5,
	no mnino, do canal especificado.

CHAN_HELP_KICK
	Sintaxe:  KICK #canal nick motivo

	Retira um utilizador de um canal, aplicando um KICK
	com o ChanServ especifificando o motivo.
	Por defeito est limitado aos users com nvel 5
	no mnimo.

CHAN_HELP_INVITE
	Sintaxe:  INVITE #canal

	Manda o %S dar um invite para o canal dado.
	Somente funcionar se seu nvel de acesso for maior
	que zero.
CHAN_HELP_UNBAN
	Sintaxe:  UNBAN #canal

	Diz ao %S para remover todos os bans permitindo que
	voc entre num canal. Por padro, somente funciona
	se seu nvel de acesso no canal for maior que zero.

CHAN_HELP_CLEAR
	Sintaxe:  CLEAR canal opo

	Diz ao %S para remover certas colocaes de um canal.
	A opo pode ser uma das seguintes:

	     MODES    Anula todos os modos do canal (isto , remove
	                  os modos i,k,l,m,n,p,s,t).
	     BANS     Remove todos os bans do canal.
	     OPS      Remove o status de Operador do canal (mode +o)
	                  de todos os Operadores do canal.
	     VOICES   Remove o status "voice" (mode +v) de qualquer
	                  pessoa que tenha esse modo.
	     USERS    Remove (kicka) todos os usurios do canal.

	Por padrao, seu nvel de acesso no canal dever ser no
	mnimo 10 para usar este comando.

CHAN_SERVADMIN_HELP

	Os seguintes comandos esto disponveis para
	os  Administradores dos Services :

	    GETPASS    Recupera a senha de fundador de um canal
	               (somente se a encriptao est desativada).
	    FORBID     Probe um canal de ser usado.
	    STATUS     Fornece o atual nvel de acesso de um
	               usurio num canal.

	Administradores do Services podem tambm cancelar o registro sem
	a necessidade de identificao atravs da senha, podem ver os
	acessos, AKICK, e ajuste da lista de nveis de qualquer canal.

CHAN_SERVADMIN_HELP_DROP
	Sintaxe:  DROP canal

	Cancela o registro de um canal. Somente Administradores dos
	Services podem cancelar canais para os quais eles no tenham
	sido identificados.

CHAN_SERVADMIN_HELP_SET

	Administradores dos Services tambm podem ajustar a opo
	NOEXPIRE, fazendo com que canais sejam impedidos de ter seu
	registro expirado. Administradores dos Services ainda podem
	ajustar opes para qualquer canal sem precisar da identificao
	do canal atravs da SENHA.

CHAN_SERVADMIN_HELP_SET_NOEXPIRE
	Sintaxe:  SET canal NOEXPIRE {ON | OFF}

	Determina se o canal poder ter seu registro expirado.
	Ajustando para ON, evita que o canal seja desregistrado
	por passar do tempo de expirao.

	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_LIST
	Sintaxe:  LIST padro

	Lista todos os canais registrados que combinam com o
	padro fornecido. Canais com opo PRIVATE ativada
	s sero mostrados aos Administradores dos Services.

CHAN_SERVADMIN_HELP_GETPASS
	Sintaxe:  GETPASS canal

	Mostra a SENHA de um canal. Note que toda a vez que esse
	este comando for usado, uma mensagem incluindo o nick da
	pessoa que emitiu o comando e o canal que foi dado sero
	gravados e enviados para WALLOPS/GLOBOPS.

	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_FORBID
	Sintaxe:  FORBID canal

	Probe que qualquer pessoa registre e utilize o canal
	dado. Pode ser cancelado pelo desregistro do canal.

	Limitado aos Administradores dos Services.

CHAN_SERVADMIN_HELP_STATUS
	Mostra o nvel de acesso atual de um determinado nick
	em um determinado canal. A resposta ser no formato:

	    STATUS canal nick nvel-de-acesso

	Se um erro ocorrer, a resposta ser no formato:

	    STATUS ERROR mensagem-de-erro

###########################################################################
#
# Mensagens de help do MemoServ
#
###########################################################################

MEMO_HELP
	%S  um utilitrio que permite aos usurios de IRC
	enviar curtas mensagens a outros users, mesmo
	que eles no estejam conectados no momento; ou
	aos canais(*). Ambos, destinatrios e remetentes,
	devem possuir seu nick (ou canal) registrados para
	que possam enviar uma mensagem (memo).
	Os comandos do %S so:

	    SEND   Envia uma mensagem para um nick ou para um canal
	    LIST   Lista suas mensagens
	    READ   L a(s) mensagem(ns)
	    DEL    Apaga a(s) mensagem(ns)
	    SET    Altera opes relacionadas com as mensagens

	Digite /%S HELP <comando> para ajuda em qualquer um dos
	comandos acima.

	(*) Por padro, qualquer usurio com no mnimo
	    nvel 10 pode ler as mensagens do canal. Isto
	    pode ser alterado com o comando /%s LEVELS.

MEMO_HELP_SEND
	Sintaxe:  SEND {nick | canal} [?]mensagem

	Envia um memo ao nick ou ao canal determinado contendo
	a mensagem. Quando enviada para o destinatrio, este
	receber um aviso que possui uma nova mensagem. O nick/
	/canal de destino dever estar registrado.
	A utilizao do sinal ? no incio da mensagem indica que
	pretende receber uma notificao quando o destinatrio ler
	a sua mensagem. A notificao consiste num memo automtico
	vindo do destinatrio com a mensagem que enviou, entre
	os delimitadores -( )-

MEMO_HELP_LIST
	Sintaxe:  LIST [canal] [list | NEW]

	Lista quaisquer mensagens que tiver. Com NEW, lista apenas
	as novas mensagens (no lidas). Mensangens no lidas so marcadas
	com "*" a esquerda do nmero. Voc tambm pode especificar uma
	lista de nmeros, como no exemplo abaixo:
	LIST 2-5,7-9
	   Lista mensagens numeradas de 2 a 5 e de 7 a 9.

MEMO_HELP_READ
	Sintaxe: READ [canal] {num | list | LAST | NEW}

	Mostra as mensagens especificadas. Se LAST  fornecido, envia
	a mensagem recebida mais recentemente. Se NEW  fornecido,
	envia a todas as suas novas mensagens. Caso contrrio, envia
	a uma mensagem numerada. Voc tambm pode fornecer uma lista
	de nmeros, como por exemplo:

	READ 2-5,7-9
	   Mostra as mensagens numeradas de 2 a 5 e 7 a 9.

MEMO_HELP_DEL
	Sintaxe: DEL [canal] {num | list | ALL}

	Apaga a(s) mensagem(ns) especificada(s). Voc pode fornecer
	vrios nmeros de mensagens ou seqncias de nmeros ao invs
	de um nico nmero, como no segundo exemplo abaixo.

	Se ALL  fornecido, apaga todas suas mensagens.

	Exemplos:

	    DEL 1
	      Apaga a primeira mensagem.

	    DEL 2-5,7-9
	      Apaga as mensagens numeradas de 2 a 5 e de 7 a 9.

MEMO_HELP_SET
	Sintaxe:  SET opo parmetros

	Altera vrias opes de mensagens. Opo pode ser uma dessas:

	    NOTIFY      Muda quando for notificado sobre novas
	                    mensagens (s para nicks)
	    LIMIT       Altera o nmero maximo de mensagens que voc
	                    pode receber.

	Digite /%S HELP SET <comando>, para mais informaes sobre
	um comando especfico.

MEMO_HELP_SET_NOTIFY
	Sintaxe:  SET NOTIFY {ON | LOGON | NEW | OFF}

	Mudanas que ocorrem quando for notificado sobre novas
	mensagens:

	    ON      S ser notificado sobre mensagens quando voc
	                se conectar, quando voltar de um /AWAY e quando
	                so enviadas  voc.
	    LOGON   S ser notificado sobre mensagens quando voc
	                se conectar ou quando voltar de um /AWAY.
	    NEW     S ser notificado sobre mensagens quando
	                estiverem a enviar mensagens a voc.
	    OFF     No receber nenhuma notificao sobre mensagens.

	    ON  essencialmente a combinao de LOGON e NEW.

MEMO_HELP_SET_LIMIT
	Sintaxe:  SET LIMIT [canal] limite

	Altera o nmero mximo de mensagens que pode ter
	(ou do canal fornecido). Se alterar para 0, ningum
	lhe poder enviar mensagens. Entretanto, no pode
	alterar este limite para mais que %d.

MEMO_HELP_INFO
	Sintaxe:  INFO [canal]

	Informa o nmero de mensagens que tem, quantas
	mensagens no foram lidas e o total de quantas
	mensagens pode receber.
	Com o parmetro, mostra a mesma informao para o canal
	fornecido.

MEMO_SERVADMIN_HELP_SET_LIMIT
	Sintaxe:  SET LIMIT [usurio | canal] {limite | NONE} [HARD]

	Altera o nmero mximo de mensagens que um nick ou canal podem
	ter. Alterando o limite para 0, previne o user de receber
	qualquer mensagem, colocando o limite em NONE permite que o
	usurio receba e mantenha quantas mensagens quiser. Se voc
	no fornecer o nick ou canal, o limite do seu nick ser alterado.

	Adicionando HARD previne que o user mude o limite.
	No colocar HARD tem o efeito contrrio, permitindo
	que o user mude o limite (mesmo se um limite anterior
	foi ajustado com HARD).

	O uso do comando SET LIMIT  limitado aos  Administradores
	dos Services. Outros users somente alteraro seus
	prprios limites ou de um canal onde tenham privilgios
	para isso, no podem remover seu prprio limite, no
	podem alterar o limite acima de %d e no podem alterar
	um limite mximo (HARD).

MEMO_SERVADMIN_HELP_INFO
	Sintaxe:  INFO [nick | canal]

	Sem um parmetro, informa o nmero de mensagens que tm,
	quantas mensagens ainda no foram lidas e o total
	de quantas mensagens pode receber.

	Com o parmetro do canal, mostra a mesma informao sobre
	um canal.

	Com o parmetro de nick, mostra a mesma informao sobre
	um nick. Esta derivao do comando  limitada aos
	Administradores dos Services.


###########################################################################
#
# Mensagens de help do OperServ
#
###########################################################################

OPER_HELP
	%S comandos:
	    GLOBAL      Manda mensagens a todos os usurios.
	    STATS       Mostra o status dos Services e da Rede.
	    OPER LIST   Lista todos os Operadores dos Services.
	    ADMIN LIST  Lista todos os Administradores dos Services.

	Comandos disponveis somente para Operadores e Administradores dos
	Services:
	    MODE        Muda os modos de um canal.
	    KICK        Kicka um usurio de um canal.
	    AKILL       Manipula a lista de AKILL.
	    VLINE       Manipula a lista de VLINEs.
	    BOT         Manipula a lista de BOTs.
	    SESSION     Informao relativa ao controle de sesses.

	Comandos disponveis somente para Administradores dos Services:
	    SQLINE      Manipula a lista de SQLINEs.
	    OPER        Modifica a lista de Operadores dos Services.
	    LOGONNEWS   Define mensagens a serem mostradas aos usurios
	                quando estiverem conectando.
	    OPERNEWS    Define mensagens a serem mostradas aos IRCops.
	    JUPE        Desconecta um servidor da rede.

	    SET         Altera opes globais dos Services.
	    UPDATE      Fora a atualizao imediata do banco de dados
	                dos Services no disco.
	    QUIT        Termina o programa dos Services.
	    RESTART     Salva o banco de dados e reinicia os Services.
	    REHASH      Rel o arquivo de configurao dos Services.
	    GETFOUNDER  Atribui privilgios de founder para um canal.

	Comandos disponveis para Administradores dos Services:
	    ADMIN       Modifica a lista de Administradores dos Services.
	    RAW         Manda uma srie de texto ao servidor IRC.

	AVISO: Todos os comandos enviados ao %S so gravados!

OPER_HELP_GLOBAL
	Sintaxe:  GLOBAL mensagem

	Permite os IRCops mandarem mensagens a todos os usurios da rede.
	Esta mensagem ser enviada pelo %s.

OPER_HELP_STATS
	Sintaxe:  STATS [RECORD AKILL | ALL]

	Sem nenhuma opo, mostra o nmero atual de usurios e
	IRCops online (excluindo Services), o nmero mximo de
	usurios online conectados simultaneamente e o tempo
	de durao desde que a sesso dos Services comeou a
	funcionar.

	Com a opo AKILL, mostra o tamanho atual da lista de
	AKILL e o tempo default para um AKILL expirar.

	A opo ALL  disponvel somente para os Administradores
	dos Services, e mostra informaes sobre o consumo de memria
	dos Services. Usando este comando, pode-se congelar os
	Services por um curto perodo de tempo em redes grandes,
	portanto no abuse deste comando!

	A opo RECORD mostra a data e o valor dos recordes para
	o nmero total de utilizadores, ops, helpers e bots na rede.

	UPTIME pode ser usado como um sinnimo para STATS.

OPER_HELP_OPER
	Sintaxe:  OPER ADD nick
	          OPER DEL nick
	          OPER LIST

	Permite aos Administradores dos Services adicionar ou remover
	nicks da lista de Operadores dos Services. O usurio que
	tem o nick na lista de Operadores dos Services e que est
	identificado no %s  capaz de usar os comandos de
	Operador dos Services.

	Qualquer IRCop pode usar o OPER LIST.
	Todos as outras derivaes do comando OPER so limitados
	aos Administradores dos Services.

OPER_HELP_ADMIN
	Sintaxe:  ADMIN ADD nick
	          ADMIN DEL nick
	          ADMIN LIST

	Permite que os Administradores dos Services adicionem ou
	removam nicks da lista de Administradores dos Services.
	Os usurios que tem o nick na lista de Administradores dos
	Services e que j se tenham identificado no %s ser
	capaz de ter acesso aos comandos de Administradores dos
	Services.

	Qualquer IRCop pode usar o comando ADMIN LIST.
	Todas as outras derivaes do ADMIN so limitadas ao
	Services root.

OPER_HELP_MODE
	Sintaxe:  MODE canal modos

	Permite que os Operadores dos Services ajustem os modos de
	qualquer canal. Os parmetros so os mesmos que o do
	comando /MODE padro.

	Limitado aos Operadores dos Services.

OPER_HELP_CLEARMODES
	Sintaxe:  CLEARMODES canal [ALL]

	Limpa todos os modos binrios (i,k,l,m,n,p,s,t) e bans de um
	canal. Se ALL  fornecido, limpa tambm todos os ops e
	voices (modos +o e +v) de um canal.

	Limitado aos Operadores dos Services.

OPER_HELP_KICK
	Sintaxe:  KICK canal usurio razo

	Permite IRCops kickar qualquer usurio de um canal.
	OS parmetros so os mesmos que comando /KICK padro.
	A mensagem do kick tem o nick do IRCop que envia o
	comando KICK, por exemplo:

	*** SpamMan has been kicked off from channel #my_channel by %S (ROD_NOKEY       (Flood))

	Limitado aos Operadores dos Services.

OPER_HELP_AKILL
	Sintaxe:  AKILL ADD [+tempo] hostname razo
	          AKILL DEL hostname
	          AKILL LIST [hostname]
	          AKILL VIEW [hostname]

	Permite que Operadores dos Services manipulem a lista de
	AKILL. Se um user que tenta conectar possui uma hostname
	prevista na lista de AKILL, os Services emitem um KILL para
	aquele usurio, para servidores que suporta, e instrui todos
	os servidores da rede a adicionar um ban (K-line) para a
	hostname do user encontrado.

	AKILL ADD adiciona uma hostname ident@host na lista de AKILL
	para uma dada razo (deve ser posta obrigatoriamente).
	AKILL DEL remove uma dada hostname da lista de AKILL, se est
	estiver presente. AKILL LIST mostra todos os AKILLs atuais;
	se uma hostname opcional for fornecida, a listagem ser
	limitada aquela hostname. AKILL VIEW  uma verso mais
	detalhada do AKILL LIST e mostrar quem adicionou o AKILL, a
	data que foi adicionado e quando ser expirado, como tambm
	a hostname (ident@host) e a razo.

	Opcionalmente, um tempo para o akill expirar pode ser
	fornecido com o comando AKILL ADD. O tempo precede a
	hostname ident@host e  especificado como um nmero inteiro
	seguido por um dos d (dias), h (horas) ou m (minutos).
	Combinaes (como de 1h30m) no so permitidas. Se uma
	unidade especfica no  includa, o default  em dias
	(ento +30 significa 30 dias). Para adicionar um AKILL que
	no expira, use  +0 . Se a hostname a ser adicionada comear
	com um +, o tempo do AKILL deve ser fornecido, at mesmo se
	este tempo for igual ao default. O atual tempo de expirao
	de AKILLs pode ser encontrado com o comando STATS AKILL.

	A razo existe apenas para uso dos IRCops, e no ser
	mostrada aos users nas mensagens de KILL.

	Este comando  limitado aos Operadores dos Services.

OPER_HELP_JUPE
	Sintaxe:  JUPE servidor

	Diz aos Services para desconectar um servidor, isto , criar
	um falso servidor conectado aos Services que previne que o
	servidor real com aquele nome se conecte na rede. O jupe
	pode ser removido usando um simples SQUIT.

	Limitado aos Administradores dos Services.

OPER_HELP_RAW
	Sintaxe:  RAW texto

	Envia uma srie de texto diretamente ao servidor onde os
	Services esto conectados. Este comando tem vrias
	limitaes de uso, e pode criar confuses e problemas na
	rede se usado impropriamente. NO USE ESTE COMANDO a menos
	que tenha a certeza do que esteja fazendo!

	Limitado aos Administradores dos Services.

OPER_HELP_SET
	Sintaxe:  SET opo seleo

	Altera vrias opes globais dos Services. Nomes de opo
	atualmente definidas so:
	     READONLY    Determina o modo read-only ou read-write.
	     DEBUG       Ativa ou desativa o modo de depurao (debug).

	Limitado aos Administradores dos Services.

OPER_HELP_SET_READONLY
	Sintaxe:  SET READONLY {ON | OFF}

	Ativa ou desativa o modo read-only. No modo read-only,
	usurios normais no sero capazes de modificar nenhum dado
	nos Services, incluindo lista de acesso de canais e nick,
	etc. IRCops com privilgios suficientes nos Services sero
	capazes de mudar a lista de AKILL e de proibir e cancelar o
	registro de canais ou nicks, embora quaisquer mudanas no
	sero salvas no banco de dados a menos que o modo read-only
	seja desativado antes dos Services serem terminados ou
	reiniciados.

	Esta opo  equivalente a opo da linha de comando
	"-readonly".

OPER_HELP_SET_DEBUG
	Sintaxe:  SET DEBUG {ON | OFF | nmero}

	Ativa ou desativa o modo de depurao (debug). No modo de
	depurao, todos os dados enviados para os Services, assim
	como todas as outras mensagens de depurao so enviadas a
	um arquivo de log. Se nmero  fornecido, o modo de depurao
	 ativado, com o nvel de debug fornecido.

	Esta opo  equivalente a opo da linha de comando
	"-debug".

OPER_HELP_UPDATE
	Sintaxe:  UPDATE

	Faz com que os Services atualizem o banco de dados logo que
	voc envia este comando.

	Limitado aos Administradores dos Services.

OPER_HELP_QUIT
	Sintaxe:  QUIT

	Faz com que desligue os Services imediatamente, o banco de
	dados no  salvo. Este comando no deve ser usado a menos
	que haja um dano da cpia do banco de dados na memria e por
	isso eles no devem ser salvos. Para desligar normalmente,
	use o comando SHUTDOWN.

	Limitado aos Administradores dos Services.

OPER_HELP_SHUTDOWN
	Sintaxe:  SHUTDOWN

	Salva o banco de dados dos Services e os desliga.

	Limitado aos Administradores dos Services.

OPER_HELP_RESTART
	Sintaxe:  RESTART

	Salva o banco de dados dos Services e os reinicia.
	(sai e executa imediatamente o executvel).

	Limitado aos Administradores dos Services.
OPER_HELP_REHASH
	Sintaxe:  REHASH

	Rel o arquivo de configurao dos services.
	Nota: Os parmetros do tipo string no sero alterados
	para manter a integridade dos services.

	Limitado aos Administradores dos Services.
OPER_REHASH_DONE
	Leitura da nova configurao foi efetuada com xito.
OPER_REHASH_ERROR
	Ocorreu um erro lendo o arquivo de configurao.
CHAN_LEVEL_PROTECT
	Protege um usurio contra deops/kicks.
NICK_AUTORECON
	Nick reconhecido automaticamente.
NICK_HELP_SET_AUTOJOIN
	Sintaxe:  SET AUTOJOIN {ON | OFF}

	Ativa ou desativa a entrada automtica em canais do %S.
	Quando ativada o utilizador entrar nos canais
	inseridos na sua AJOIN LIST quando se identificar.
NICK_SET_AUTOJOIN_ON
	Entrada automtica nos canais ativada.
NICK_SET_AUTOJOIN_OFF
	Entrada automtica nos canais desativada.
NICK_SET_AUTOJOIN_SYNTAX
	Sintaxe:  SET AUTOJOIN {ON | OFF}
NICK_HELP_AJOIN
	Sintaxe: AJOIN { ADD | DEL | LIST } [#canal]

	Permite adicionar/retirar/listar a lista de entrada
	automtica de canais.
	Quando voc se identificar, entrar automaticamente
	nos canais existentes nesta lista.

	A qualquer momento podes utilizar o comando
	/%S AJOIN NOW para entrares em todos os canais
	da tua lista de entrada automtica.
NICK_AJOIN_LIST_X
	Lista de canais com entrada automtica para  %s :
NICK_AJOIN_SYNTAX
	Sintaxe: AJOIN { ADD | DEL | LIST } [#canal]
NICK_AJOIN_REACHED_LIMIT
	Pedimos desculpa, s pode ter %d canais na lista
	de entrada automtica
NICK_AJOIN_ALREADY_PRESENT
	Canal  %s  j existe na sua lista de canais.
NICK_AJOIN_ADDED
	%s adicionado a sua lista de canais.
NICK_AJOIN_NOT_FOUND
	%s no encontrado na sua lista de canais.
NICK_AJOIN_DELETED
	%s apagado da sua lista de canais.
NICK_AJOIN_LIST
	Lista de canais com entrada automtica:
NICK_INFO_OPT_AUTOJOIN
	Entrada automtica
BAD_CHAN_NAME
	O canal deve estar no formato #canal.
OPER_IDENTIFY_REQUIRED
	O novo sistema de segurana s permite o funcionamento
	de IRC Operadores registrados nos servios.
	Procure o Administrador do seu servidor para maiores informaes.
NICK_ALREADY_IDENTIFIED
	Este nick j est identificado.
TODAYSTATS
	Estatsticas para o dia de hoje (%s):

STATS_TOTAL
	Total      : %d
STATS_REGISTERED
	Registrados: %d
STATS_DROPPED
	Libertos   : %d
STATS_EXPIRED
	Eliminados : %d
STATS_BALANCE
	Saldo      : %s
OPER_HELP_BOTLIST
	Syntax:
	   BOT ADD hostname maxcon motivo
	   BOT DEL hostname
	   BOT LIST [mscara]
	   BOT VIEW [mscara]

	Permite aos IRC Operadores manipular a lista de BOTs.
	Esta lista define o limite de ligaes para um determinado
	host.
OPER_TOO_MANY_BOTLIST
	A lista est cheia.
OPER_BOTLIST_NO_NICK
	Lista de BOTs pode apenas conter hostnames absolutos!
OPER_BOTLIST_ADDED
	Nova entrada na lista de bots para %s
OPER_BOTLIST_ADD_SYNTAX
	BOT ADD host maxcon motivo
OPER_BOTLIST_DEL_SYNTAX
	BOT DEL hostname motivo
BOTLIST_REMOVED
	O hostname %s foi eliminado da lista de BOTs.
OPER_BOTLIST_NOT_FOUND
	O hostname %s no foi encontrado na lista de BOTs.
OPER_BOTLIST_HEADER
	BotList atual:
# mask, reason
OPER_BOTLIST_FORMAT
	%-32s %d : %s
#mask, set-by, set-time, reason
OPER_BOTLIST_VIEW_FORMAT
	%s (pelo %s em %s)
	   %s
OPER_BOTLIST_SYNTAX
	BOTLIST {ADD | DEL | LIST | VIEW} hostname [motivo]
CHAN_INFO_SUCCESSOR
	           Sucessor: %s (%s)
CHAN_INFO_NO_SUCCESSOR
	           Sucessor: %s
NICK_SHOULD_REGISTER
	Neste momento voc est utilizando um nick no registrado,
	basta registr-lo para que voc possa us-lo com exclusividade,
	registre este nick com o comando /%s REGISTER senha email.
	Se no possuir email utilize NOMAIL no campo email.
CHANGE_IN_1_MINUTE
	Se no mudar de nick, dentro de um minuto este ser alterado.
NICK_AJOIN_EMPTY
	Lista de canais est vazia.
FEATURE_DISABLED
	Funcionalidade inexistente neste servidor.
CHAN_ACCESS_LIST_FORMAT2
	  %3d  %4d  %s%s%s%s por %s
NICK_AUTORECON_R
	Reconhecimento automtico de nick por modo +r.
NICK_STATUS_0
	STATUS de %s : 0 - utilizador no est conectado ou o nick no est registrado
NICK_STATUS_1
	STATUS de %s : 1 - utilizador no reconhecido como dono do nick
NICK_STATUS_2
	STATUS de %s : 2 - utilizador reconhecido como dono s pela lista de acesso
NICK_STATUS_3
	STATUS de %s : 3 - utilizador reconhecido como dono via identificao por senha
OPER_HELP_SQLINE
	Syntax: SQLINE ADD nick reason
	        SQLINE DEL  nick
	        SQLINE LIST [mask]
	        SQLINE VIEW [mask]

	Permite que os Operadores dos Servios manipulem a lista de SQLINE.
	Um nick na SQLINE no poder ser utilizado nesta rede.
OPER_TOO_MANY_SQLINE
	Pedimos desculpas, mas a lista de SQLINE est cheia.
OPER_SQLINE_JUST_NICK
	Voc pode usar somente nick/wildcards na lista de SQLINE.
OPER_SQLINE_ADDED
	Nova SQLINE adicionada para %s.
OPER_SQLINE_ADD_SYNTAX
	SQLINE ADD nick razo
OPER_SQLINE_DEL_SYNTAX
	SQLINE DEL nick razo
OPER_SQLINE_REMOVED
	Removida SQLINE %s da lista de SQLINE.
OPER_SQLINE_NOT_FOUND
	SQLINE para %s no foi encontrada na lista.
OPER_SQLINE_HEADER
	Lista atual de SQLINE:
# mask, reason
OPER_SQLINE_FORMAT
	%-32s %s
#mask, set-by, set-time, reason
OPER_SQLINE_VIEW_FORMAT
	%s (by %s at %s)
	   %s
OPER_SQLINE_SYNTAX
	SQLINE {ADD | DEL | LIST | VIEW} nick [razo]
BAD_EMAIL_ADDRESS
	Email invlido!
	Utilize usurio@servidor-de-email ou NOMAIL se no pretender indicar
	o seu email.
CHAN_DROP_CANCEL
	O pedido de DROP do canal efetuado em %s foi cancelado.
CHAN_DROP_AT
	O registro do canal ser cancelado dentro de %d dia(s).
NICK_DROP_CANCEL
	O pedido de DROP do nick efetuado em %s foi cancelado.
NICK_DROP_AT
	O registro do nick ser cancelado dentro de %d dia(s).
OPER_STATS_USERS_RECORD
	Recorde de usurios foi %d em %s
	Neste momento existe(m) %d usurio(s) (%d%)
	-
OPER_STATS_OPERS_RECORD
	Recorde de IRCops foi %d em %s
	Neste momento existe(m) %d IRCop(s) (%d%)
	-
OPER_STATS_HELPERS_RECORD
	Recorde de helpers foi %d em %s
	Neste momento existe(m) %d helper(s) (%d%)
	-
OPER_STATS_BOTS_RECORD
	Recorde de bots foi %d em %s
	Neste momento existe(m) %d bot(s) (%d%)
	-
NEWSS_HELP
	O servio %S permite receber notcias em tempo real
	de acordo com os temas subscritos.
	Existem vrios comandos que pode utilizar
	digite /%S comando.
	Para mais informaes sobre um determinado comando
	digite /%S HELP comando.

	    LIST         Lista os vrios temas e o seu estado de subscrio
	    SUBSCRIBE    Subscreve um tema
	    UNSUBESCRIBE Cancela a subscrio de um tema
	    SET          Define opes
	    RECENT       Lista as notcias enviadas recentemente
NEWSS_HELP_OPER

	Comandos de Operadores de Notcias:
	    SEND         Envia uma notcia
	    VIEW         Ver as notcias recentes com infor. detalhada
	    DEL          Apaga uma entrada das notcias recentes
	    OPER LIST    Lista os operadores de notcias
	    ADMIN LIST   Lista os administradores de notcias
NEWSS_HELP_ADMIN

	Comandos de Administradores de Notcias:
	    SUBJECT      Altera a lista de temas
	    OPER         Adiciona/Remove operador de notcias
NEWSS_HELP_SADMIN

	Comando de Operadore de Servios:
	    ADMIN        Adiciona/Remove administrador de notcias
NEWSS_OPER_SYNTAX
	OPER {ADD | DEL | LIST} [nick]
NEWSS_OPER_ADD_SYNTAX
	OPER ADD nick
NEWSS_OPER_DEL_SYNTAX
	OPER DEL nick
NEWSS_OPER_SKELETON
	Os servios esto no modo SKELETON; o comando OPER est indisponvel.
NEWSS_OPER_EXISTS
	%s j existe na lista de Operadores de notcias.
NEWSS_OPER_ADDED
	%s adicionado a lista de Operadores de notcias.
NEWSS_OPER_TOO_MANY
	Demasiadas entradas (%d) na lista de Operadores de notcias,
	no pode adicionar mais.
NEWSS_OPER_REMOVED
	%s removido da lista de Operadores de notcias.
NEWSS_OPER_NOT_FOUND
	%s no foi encontrado na lista de Operadores de notcias.
NEWSS_OPER_LIST_HEADER
	Lista de Operadores de notcias:

NEWSS_OPER_HELP
	Syntax: OPER ADD nick
	        OPER DEL nick
	        OPER LIST

	Permite aos administradores de notcias, adicionar ou
	remover nicks de ou a lista de Operadores de notcias
	Um usurio cujo nick esteja na lista de Operadores
	de notcias e se tenha identificado pelo %s ter acesso
	aos comandos de Operador de notcias.

	Qualquer operador pode usar o comando OPER LIST
	Todos os outros comando esto limitados aos
	administradores de notcias.

# News Server ADMIN responses
NEWSS_ADMIN_SYNTAX
	ADMIN {ADD | DEL | LIST} [nick]
NEWSS_ADMIN_ADD_SYNTAX
	ADMIN ADD nick
NEWSS_ADMIN_DEL_SYNTAX
	ADMIN DEL nick
NEWSS_ADMIN_SKELETON
	Os servios esto no modo SKELETON; o comando ADMIN est indisponvel.
NEWSS_ADMIN_EXISTS
	%s j existe na lista de Administradores de notcias.
NEWSS_ADMIN_ADDED
	%s adicionado a lista de Administradores de notcias.
NEWSS_ADMIN_TOO_MANY
	Demasiadas entradas (%d) na lista de Administradores de notcias,
	no pode adicionar mais!
NEWSS_ADMIN_REMOVED
	%s removido da lista de Administradores de notcias.
NEWSS_ADMIN_NOT_FOUND
	%s no encontrado na lista de Administradores de notcias.
NEWSS_ADMIN_LIST_HEADER
	Lista de Administradores de notcias:

NEWSS_SUBJECT_HELP
	Permite alterar/criar uma entrada na lista de temas
	do %S.

	Sintaxe: SUBJECT nmero tema
NEWSS_SUBJECT_SYNTAX
	SUBJECT nmero tema
NEWSS_SUBJECT_ERROR
	O nmero tem de estar entre 1 e %d.
NEWSS_LIST_HELP
	O comando LIST exibe a lista de assuntos disponveis
	e o seu estado de subsrio.

	Os marcados com um X esto subscritos.
	Para subscrever/cancelar subscrio utilize os comandos:
	    SUBCRIBE/UNSUBSCRIBE

NEWSS_LIST_HEADER
	No Subs Tema

NEWSS_LIST
	%2d  %c   %s
NEWSS_LIST_END
	Fim da lista de temas
NEWSS_SUBJECT_NOTFOUND
	O tema nmero %d no existe!
NEWSS_SUBJECT_CHANGED
	Tema alterado de %s para %s.
NEWSS_SUBJECT_CREATED
	Tema %s criado.
NEWSS_SUBSCRIBE_SYNTAX
	SUBSCRIBE  nmero [,nmero] | ALL
NEWSS_SUBSCRIBE_HELP
	Este comando permite subscrever um tema.

	Sintaxe: SUBSCRIBE  nmero [,nmero] | ALL 

	Pode subscrever vrios temas num s comando
	usando nmeros separados com vrgulas.
	Indicando ALL subscreve todos os temas.
NEWSS_SUBSCRIBE_SUBSCRIBED
	Subscreveu %d tema(s).
NEWSS_UNSUBSCRIBE_SYNTAX
	UNSUBSCRIBE  nmero [,nmero] | ALL
NEWSS_UNSUBSCRIBE_HELP
	Este comando permite cancelar a subscrio de um tema.

	Sintaxe: UNSUBSCRIBE nmero [,nmero] |  ALL

	Pode cancelar a subsrio de vrios temas num s comando,
	usando nmeros separados por vrgulas.
	Indicando ALL cancelar subscrio de todos os temas.
NEWSS_UNSUBSCRIBE_UNSUBSCRIBED
	Cancelou a subscrio de %d tema(s).
NEWSS_SEND_SYNTAX
	SEND nmero notcia
NEWSS_SEND_HELP
	Permite enviar uma notcia.

	Sintaxe: SEND nmero notcia
NEWSS_SEND_SENT
	Notcia foi enviada.
NEWSS_SET_SYNTAX
	SET opo valor
NEWSS_SET_HELP
	Sintaxe: SET opo valor

	Define as opes do %S.  Opo pode ser:
	    NOTICE    Recebe as notcias por notice ou por msg.
NEWSS_SET_NOTICE_SYNTAX
	SET NOTICE [ON | OFF]
NEWSS_SET_NOTICE_HELP
	Sintaxe: SET NOTICE [ON | OFF]

	Se a opo NOTICE estiver ligada (ON) as notcias
	sero recebidas via NOTICE caso contrrio sero
	enviadas por mensagem em privado.
NEWSS_SET_NOTICE_ON
	Opo de NOTICE est agora ligada (ON)
NEWSS_SET_NOTICE_OFF
	Opo de NOTICE est agora desligada (OFF)
NEWSS_RECENT_HELP
	Sintaxe: RECENT

	Lista as notcias mais recentes.
NEWSS_RECENT_HEADER
	Lista das notcias mais recentes
NEWSS_RECENT_LIST
	%s : %s
NEWSS_RECENT_END
	Fim da lista das notcias mais recentes
NEWSS_VIEW_HELP
	Sintaxe: VIEW

	Lista as notcias mais recentes com infor. detalhada,
	o tema nmero 0 indica notcias eliminadas.
NEWSS_VIEW_HEADER
	Nr. : Sub. : Data : notcia (emissor)
NEWSS_VIEW_LIST
	%s%2d : %2d : %s : %s (%s)%s
NEWSS_DEL_SYNTAX
	DEL nmero
NEWSS_DEL_HELP
	Syntax: DEL nmero

	Este comando elimina um item da lista das notcias
	mais recentes. O item apenas desparece da lista
	apresentada com o comando /%S RECENT.
	O nmero do item dever ser escolhido da primeira
	coluna da lista obtida com /%S VIEW.
NEWSS_DEL_NOTEXIST
	A notcia nmero %d no existe.
NEWSS_DEL_DELETED
	A notcia nmero %d foi eliminada.
NICK_INFO_PRIVATE
	A informao sobre %s  privada.
CHAN_INFO_PRIVATE
	A informao sobre %s  privada.
CHAN_NEED_REGNICK
	Neste canal s so permitidos nicks registrados!
CHAN_MODE_PROTECTED
	Este canal utiliza modos de entrada protegida.
NEWS_REC_PLEASE_WAIT
	Aguarde %d segundos antes de usar o comando RECENT novamente.
NICK_HELP_NOTES
	Permite-lhe guardar algumas anotaes.

	Para guardar uma anotao utilize /%S NOTES ADD texto
	Para eliminar uma anotao utilize /%S NOTES DEL number
	Para listar todas as anotaes /%S NOTES LIST
NICK_NOTES_SYNTAX
	LIST | ADD texto | DEL number
NICK_NOTES_ADDED
	Anotao foi guardada com o nmero %d.
NICK_NOTES_NOADD
	Atingiu o nmero mximo de anotaes (%d) disponveis para
	o seu nick, apague alguma anotao mais antiga para poder
	adicionar esta.
NICK_NOTES_DELETED
	Anotao nmero %d foi eliminada.
NICK_NOTES_NOTFOUND
	A anotao nmero %d no existe.
NICK_NOTES_LIST_HEADER
	No  Anotao
NICK_NOTES_LIST
	%2d %s
NICK_NOTES_NONOTES
	Lista de anotaes vazia.
CHAN_ACCESS_CLEARALL
	Todos os elementos da lista de acesso foram eliminados.
CHAN_AKICK_CLEARALL
	Todos os elementos da lista de AKICKS foram eliminados.
NICK_STATUS_SYNTAX
	STATUS nick
NICK_X_ISFOUNDER
	O nick %s  fundador do canal, no pode ser defenido
	como sucessor.
NICK_X_ISSUCCESSOR
	O nick %s  sucessor do canal, no pode ser defenido
	como fundador.
AGO_TIME_D
	H %d dia(s), %d hora(s), %d minuto(s) e %d segundo(s)
AGO_TIME
	H %d hora(s), %d minuto(s) e %d segundo(s)
TOTAL_TIME
	%d dia(s), %d hora(s), %d minuto(s) e %d segundo(s).
OPER_OPER_SUSPENDED
	O operador %s est agora suspenso durante %d dias.
OPER_OPER_UNSUSPEND
	Suspenso do operador %s foi cancelada.
OPER_OPER_SUSPEND_SYNTAX
	OPER SUSPEND nick dias
CHAN_HELP_AOP
	Alias para gesto da lista de AUTOOPs de um canal.
	AOP ADD   Adiciona um usurio com nvel de AUTOOP no #canal
	AOP LIST  Lista todos os usurios com nvel de AUTOOP no #canal
CHAN_AOP_SYNTAX
	AOP ADD nick | DEL nick | LIST
CHAN_HELP_SOP
	Alias para gesto da lista de utilizadores com permisso
	para mudana da lista de acessos do canal.
	SOP ADD  Adiciona um utilizador com nvel de ACC-CHANGE no #canal.
	SOP LIST Lista todos os utilizadores com nvel de ACC-CHANGE no #canal
CHAN_SOP_SYNTAX
	SOP ADD nick | DEL nick | LIST
CHAN_AJOIN_ADD
	Dever adicionar o canal a sua lista de AJOIN com /%s AJOIN ADD %s
# SENDPASS responses
OPER_SENDPASS_SYNTAX
	SENDPASS nickname
OPER_SENDPASS_UNAVAILABLE
	O comando SENDPASS est indisponvel porque o modo de encriptao est em uso.
OPER_SENDPASS_SUBJECT
	Senha de nick (%s)
OPER_SENDPASS_HEAD
	Ol,
OPER_SENDPASS_LINE_1
	Foi pedido que lhe fosse enviada via e-mail a senha para o nick %s.
OPER_SENDPASS_LINE_2
	A senha para este nick  %s. Como medida de seguranca mude a senha assim que a utilizar.
OPER_SENDPASS_LINE_3
	Se desconhece o assunto em causa, ignore este email.
OPER_SENDPASS_LINE_4
	Por favor no responda a este email.
OPER_SENDPASS_LINE_5
	PTlink Services - http://www.ptlink.net/
OPER_SENDPASS_OK
	Senha para o nick %s foi enviada.
CHAN_RESTRICT_REGISTER
	O registro de canais nesta rede est restrito a Services Operators.
MEMO_WILL_EXPIRE
	O(s) seu(s) memo(s):%s ser(o) eliminado(s) em breve,
	por ser(em) demasiado antigo(s).
MEMO_HAVE_EXPIRED
	O(s) seu(s) memo(s):%s foram eliminados.
NICK_INFO_IS_ONLINE
	O usurio est online.
CHAN_LIST_SERVADMIN_SYNTAX
	LIST pattern [FORBIDDEN] [NOEXPIRE]
NICK_AUTH_SENT
	Uma curta mensagem foi enviada para o seu endereo de email
	com instrues detalhadas para completar o registro do nick.
	At que finalize o registro com a autenticao pelo cdigo
	enviado para o email no lhe ser possvel enviar memos
	ou registrar novos canais.
NICK_AUTH_INCORRET
	O cdigo utilizado no est correto para o nick/email
	deste nick.
NICK_AUTH_COMPLETED
	O cdigo est correto, o registro do seu nick/alterao de
	email est completo/a.
NICK_HELP_AUTH
	Sintaxe: AUTH cdigo

	Valida o e-mail associado associado seu seu nick.
AUTH_EMAIL_SUBJECT
	Registro de nick
SET_EMAIL_SUBJECT
	Alterao do e-mail de nick
NICK_SET_EMAIL_WAIT
	Por favor aguarde um dia antes de tentar alterar
	o seu endereo de email de novo.
NICK_SET_EMAIL_AUTH
	Verifique o seu email (%s) onde dever ter recebido
	instrues para que possa completar esta alterao.
NICK_AUTH_NEEDED
	Por favor complete o registro do seu nick com a
	autenticao do e-mail que indicou para registro.

	Se no indicou um email vlido durante o registro ou no
	recebeu o cdigo de autenticao faa a alterao
	do email associado a este nick com
	/%s SET EMAIL email
NICK_HELP_SET_NEWSLETTER
	Syntax: SET NEWSLETTER { ON | OFF }

	Ativa/desativa recepo da newsletter.
NICK_SET_NEWSLETTER_ON
	Recepo da Newsletter ativada.
NICK_SET_NEWSLETTER_OFF
	Recepo da Newsletter desativada.
NICK_SET_NEWSLETTER_SYNTAX
	SET NEWSLETTER { ON | OFF }
NICK_INFO_NEWSLETTER
	Receber newsletter.

