/*
 *  - Lightmap editor menu tab
 */

// NOTE!
// LTlist[0] does not exist and should NEVER BE ACCESSED
// It is a special case for no-tile-in-this-square
// The first one is LTlist[1]

#include <stdio.h>
#include "../ithelib.h"
#include "../gui/igui.hpp"
#include "../loadfile.h"
#include "../console.h"
#include "../core.hpp"
#include "../gamedata.h"
#include "../init.h"
#include "../gui/menusys.h"

// defines

#define VIEWX 64
#define VIEWY 112
#define STR_LEN 32
#define OVL_LEN 24

// variables

extern int focus,LT_Id,spr_total;
extern char **sprites;

static int curtil=1,offset=1,standunder=0;

static int Img_Id,Stu_Id;
static char ImgName[256];

static char str32[STR_LEN+1];

// functions

extern void Toolbar();
extern void Snap();
extern short exist(char *fname);
extern "C" BITMAP *load_lightmap(char *filename);


static void Nothing();
static void LgtUpdate();                       // Update the displays
static void AddTile();
static void DelTile();
static void PickTile();

static void Img();
static void ToggleStandUnder();

static void TLBl();
static void TLBr();
static void TLBll();
static void TLBrr();

// GoFocal - The menu tab function.  This is called from the toolbar

void LT_GoFocal()
{
if(focus==9)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;
memset(ImgName,' ',STR_LEN); ImgName[STR_LEN]=0;
//memset(behave_str,' ',STR_LEN); behave_str[STR_LEN]=0;

focus=9;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(LT_Id);     // And make the button stick inwards

IG_TextButton(32,80, " Add tile to end ",AddTile,NULL,NULL);
IG_AddKey(KEY_A,AddTile);

IG_TextButton(32,112," Delete from end ",DelTile,NULL,NULL);
IG_AddKey(KEY_D,DelTile);

DrawScreenText(224,104,"Lightmap image:");
Img_Id = IG_InputButton(320,96,str32,Img,NULL,NULL);

IG_Region(32,400,576,32,PickTile,NULL,NULL);        // Tile selector

// Draw the VCR buttons on the Tile selector

IG_TextButton(8,410,__left,TLBl,NULL,NULL);     // Normal speed
IG_TextButton(616,410,__right,TLBr,NULL,NULL);

IG_TextButton(8,440,__left2,TLBll,NULL,NULL);   // Fast Forward
IG_TextButton(608,440,__right2,TLBrr,NULL,NULL);

LgtUpdate();
}

void AddTile()
{
BITMAP *b;
char filename[1024];
if(LTtot == 255)
    {
    Notify(-1,-1,"There is a maximum of 255 lightmap tiles.",NULL);
    return;
    }

if(!loadfile(LTlist[LTtot-1].fname,filename))
	{
	Notify(-1,-1,"Error loading file",filename);
	return;
	}

LTlist[LTtot].fname = (char *)M_get(1,256);
strcpy(LTlist[LTtot].fname,LTlist[LTtot-1].fname);

LTlist[LTtot].image = load_lightmap(filename);
LTtot++;

LgtUpdate();
IG_WaitForRelease();
}

void DelTile()
{
if(LTtot == 1)
    {
    Notify(-1,-1,"You must have at least one tile.",NULL);
    return;
    }

LTtot--;
if(LTlist[LTtot].image)
	{
	destroy_bitmap(LTlist[LTtot].image);
    LTlist[LTtot].image=NULL;
	}
LTlist[LTtot].fname = NULL;

// If it's onscreen, make it go away

curtil=LTtot-1;
if(offset>(LTtot-17))
    offset=(LTtot-17);
if(offset<1) offset=1;

LgtUpdate();
IG_WaitForRelease();
}

// Callback for a null event

void Nothing()
{
return;
}


// Function for updating the display

void LgtUpdate()
{
int co,ctr;

//if(curtil>LTtot)
//	curtil=LTtot-1;
strcpy(ImgName,LTlist[curtil].fname);
for(ctr=strlen(ImgName);ctr<32;ctr++)
    ImgName[ctr]=' ';
ImgName[32]=0;
IG_UpdateText(Img_Id,ImgName);

co=17;
if(LTtot<17)
    co=LTtot;
co--;
IG_BlackPanel(31,399,578,34);
for(ctr=0;ctr<co;ctr++)
    {
//    RTlist[ctr+offset].image.block_put_sprite(33+(34*ctr),401,swapscreen);
	ilog_quiet("%d/%d[%d]\n",ctr,co,LTtot);
    draw_sprite(swapscreen,LTlist[ctr+offset].image,33+(34*ctr),401);
    if(curtil == ctr+offset)
        rect(swapscreen,33+(34*ctr),401,65+(34*ctr),432,ITG_WHITE);
    }
}

void Img()
{
char oldpath[256];

strcpy(oldpath,LTlist[curtil].fname);
InputNameFromListWithFunc(-1,-1,"Choose an image file:",spr_total-1,sprites,5,LTlist[curtil].fname,0,0,NULL);
if(!LTlist[curtil].fname[0])
    strcpy(LTlist[curtil].fname,oldpath);
else
    {
//    RTlist[curtil].image.free();
	destroy_bitmap(LTlist[curtil].image);
    Init_LightMap(curtil);
    }

//        if(!Confirm(-1,-1,"This object is not 32x32 and may crash the program.","Are you sure you want to use it?"))
//            return;
LgtUpdate();
}

void TLBr()
{
offset++;
if(offset>(LTtot-17))
    offset=(LTtot-17);
if(offset<1) offset=1;
LgtUpdate();
}

void TLBl()
{
offset--;
if(offset<1) offset=1;
LgtUpdate();
}

void TLBrr()
{
offset+=10;
if(offset>(LTtot-17))
    offset=(LTtot-17);
if(offset<1) offset=1;
LgtUpdate();
}

void TLBll()
{
offset-=10;
if(offset<1) offset=1;
LgtUpdate();
}

void PickTile()
{
int co,ctr;
co=17;
if(LTtot<17) co=LTtot;
co--;
for(ctr=0;ctr<co;ctr++)
	if(x>33+(34*ctr) && x<65+(34*ctr))
		{
		curtil=ctr+offset;
		LgtUpdate();
		return;
		}
}


