/*
 *  Which sound library are we going to use?
 */

#ifdef USE_FMOD
	// FMOD sound library, with full multithreaded Ogg streaming
	#include "audio/fmod.h"
#endif

#ifdef USE_ALSOUND
	// Allegro sound library, with optional ALOGG music support
	// For DOS, BeOS and other non-fmod systems.
	#include "audio/allegro.h"
#endif

#ifdef USE_SDLSOUND
	// SDL Mixer
	// For Linux, BeOS, Windows.  Almost as good as FMOD but Free
	#include "audio/sdl.h"
#endif

