<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'include/i18n.php';

AuthCheck("normal");

commonHeader(_("Computers"));
_("Welcome to the IRM Computer Tracking utility!  This is where you store information about your various computers scattered about your organization. Below are tools in which you can view your computers, as well as edit and add entries."); ?>

<hr noshade>
<table border=0 width=100%>
<tr>
<td align=center>
 <h4>
  <a href="<?php echo Config::AbsLoc('users/computers-add-select.php') ?>">
  <?php __("Add a computer"); ?>
  </a>
 </h4>
</td>
</tr>
</table>
<form method="GET" action="<?php echo Config::AbsLoc('users/computers-info.php'); ?>">
	<p><?php __("Select system by name:") ?></p>
	<SELECT NAME="ID" SIZE="1">
<?php
	$computers = $DB->getAll("SELECT ID, name FROM computers ORDER BY name");
	foreach ($computers as $c)
	{
		$id = $c['ID'];
		$name = $c['name'];
		echo "<OPTION VALUE=\"$id\">$name</OPTION>\n";
	}
?>
	</SELECT>
	<INPUT TYPE="submit" value="<?php __("Show") ?>">
</form>

<table border=1 width=100%><tr><th><?php __("View by Location") ?></th></tr>
<tr bgcolor=#DDDDDD><TD>
<form method=get action="<?php echo Config::AbsLoc('users/computers-search.php') ?>">
<?php Dropdown( "dropdown_locations",  "contains"); 
__("and show in"); ?>
<input type=hidden name=field value=location>
<select name=style>
<option value=list selected><?php __("list view"); ?></option>
<option value=full><?php __("full view"); ?></option>
</select> <?php __("sorted by"); 
#FIXME use function to generate select ?> 
<select name=sort size=1>
<option value="name"><?php __("Name"); ?></option>
<option value="ID"><?php __("IRM ID"); ?></option>
<option value="location"><?php __("Location"); ?></option>
<option value="type"><?php __("Type"); ?></option>
<option value="os"><?php __("Operating System"); ?></option>
<option value="osver"><?php __("Operating System Version"); ?></option>
<option value="processor"><?php __("Processor"); ?></option>
<option value="processor_speed"><?php __("Processor Speed"); ?></option>
<option value="serial"><?php __("Serial Number"); ?></option>
<option value="otherserial"><?php __("Other Number"); ?></option>
<option value="ramtype"><?php __("RAM Type"); ?></option>
<option value="ram"><?php __("RAM Amount (in MB)"); ?></option>
<option value="network"><?php __("Network Card Type/Brand"); ?></option>
<option value="ip"><?php __("IP Address"); ?></option>
<option value="mac"><?php __("MAC/Network Address"); ?></option>
<option value="hdspace"><?php __("Hard Drive Capacity"); ?></option>
<option value="comments"><?php __("Comments"); ?></option>
<option value="contact"><?php __("Contact Person"); ?></option>
<option value="contact_num"><?php __("Contact Number"); ?></option>
<option value="date_mod"><?php __("Date Last Modified"); ?></option>
</select>.
<input type=hidden name=phrasetype value=exact>
<input type=submit value=Show></form>
</TD>
</TR>
</TABLE>
<BR>
<table border=1 width=100%><tr><th><?php __("Detailed Search"); ?></th></tr>
<tr bgcolor=#DDDDDD><TD>
<form method=get action="<?php echo Config::AbsLoc('users/computers-search.php'); ?>">
<?php #FIXME use function to generate select ?>
<select name="field" size=1>
<option value="ID"><?php __("IRM ID"); ?></option>
<option value="name"><?php __("Name"); ?></option>
<option value="location"><?php __("Location"); ?></option>
<option value="type"><?php __("Type"); ?></option>
<option value="os"><?php __("Operating System"); ?></option>
<option value="osver"><?php __("Operating System Version"); ?></option>
<option value="processor"><?php __("Processor"); ?></option>
<option value="processor_speed"><?php __("Processor Speed"); ?></option>
<option value="serial"><?php __("Serial Number"); ?></option>
<option value="otherserial"><?php __("Other Number"); ?></option>
<option value="ramtype"><?php __("RAM Type"); ?></option>
<option value="ram"><?php __("RAM Amount (in MB)"); ?></option>
<option value="network"><?php __("Network Card Type/Brand"); ?></option>
<option value="ip"><?php __("IP Address"); ?></option>
<option value="mac"><?php __("MAC/Network Address"); ?></option>
<option value="hdspace"><?php __("Hard Drive Capacity"); ?></option>
<option value="comments"><?php __("Comments"); ?></option>
<option value="contact"><?php __("Contact Person"); ?></option>
<option value="contact_num"><?php __("Contact Number"); ?></option>
<option value="date_mod"><?php __("Date Last Modified"); ?></option>
<option value="flags_surplus"><?php __("Surplus"); ?></option>
<option value="flags_server"><?php __("Server"); ?></option>
</select> <?php __("where that field"); ?> 
<select name=phrasetype>
<option value=contains><?php __("contains"); ?></option>
<option value=exact><?php __("is the exact phrase"); ?></option>
</select>
<input type=text size=30 name="contains"> 
<?php __("and then show in"); ?> <select name=style>
<option value=list selected><?php __("list view"); ?></option>
<option value=full><?php __("full view"); ?></option>
</select> <?php __("and sort by"); ?>  <select name=sort size=1>
<?php #FIXME and another ugly monster select ?>
<option value="name"><?php __("Name"); ?></option>
<option value="ID"><?php __("IRM ID"); ?></option>
<option value="location"><?php __("Location"); ?></option>
<option value="type"><?php __("Type"); ?></option>
<option value="os"><?php __("Operating System"); ?></option>
<option value="osver"><?php __("Operating System Version"); ?></option>
<option value="processor"><?php __("Processor"); ?></option>
<option value="processor_speed"><?php __("Processor Speed"); ?></option>
<option value="serial"><?php __("Serial Number"); ?></option>
<option value="otherserial"><?php __("Other Number"); ?></option>
<option value="ramtype"><?php __("RAM Type"); ?></option>
<option value="ram"><?php __("RAM Amount (in MB)"); ?></option>
<option value="network"><?php __("Network Card Type/Brand"); ?></option>
<option value="ip"><?php __("IP Address"); ?></option>
<option value="mac"><?php __("MAC/Network Address"); ?></option>
<option value="hdspace"><?php __("Hard Drive Capacity"); ?></option>
<option value="comments"><?php __("Comments"); ?></option>
<option value="contact"><?php __("Contact Person"); ?></option>
<option value="contact_num"><?php __("Contact Number"); ?></option>
<option value="date_mod"><?php __("Date Last Modified"); ?></option>
</select>. <input type=submit value="<?php __("Search") ?>"></form>
</TD>
</TR>
</TABLE>

<?php
commonFooter();
