<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("post-only");
commonHeader(_("Help Desk") ." - " . _("Is this the computer?"));
__("Please confirm that you entered the correct IRM ID or name.  If the computer matches, simply click on the computer's name below.");
?>
<hr noshade>
<?php
$DB = Config::Database();
if (@$typeofsearch == "id") 
{
	$qID = $DB->getTextValue($ID);
	$query = "SELECT ID,name,type,location FROM computers WHERE (ID = $qID)";
}
else 
{
	$likename = $DB->getTextValue("%$name%");
	$query = "SELECT ID,name,type,location FROM computers WHERE (name LIKE $likename)";
}	

$data = $DB->getAll($query);

if(count($data) < 1) 
{
  	__("Bad IRM ID or search terms");
}
else if (count($data) > 5) 
{
	# Security, can't list all computers
	__("Your search terms were too vague, and yielded more than 5 results.  Please try again.");
}
else 
{
	foreach ($data as $result)
	{
  		$ID = $result["ID"];
  		$name = $result["name"];
  		$location = $result["location"];
  		$type = $result["type"];
  		PRINT '<a href="'
  			.Config::AbsLoc("users/helper-add.php?ID=$ID&is_group=no")
  			."\">$name ($ID)</a><br>Type: $type"
  			."<br>". _("Location") . ": $location<br>";
	}	
}

commonFooter();
