<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################
include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");

commonHeader(_("Networking"));

__("Welcome to the IRM Networking section.  This where you keep information about all
of your networking devices."); ?>

<a href="<?php echo Config::AbsLoc('users/networking-add-form.php') ?>">
<?php __("Click here to add a device")."</a>"; ?>

<hr noshade>

<?php
$query = "SELECT * FROM networking";
$DB = Config::Database();
$data = $DB->getAll($query);
PRINT "<table border=1 width=100%><tr bgcolor=#CCCCCC><th>".
		_("Name")."</th><th>"._("Location")."</th><th>"._("Type")."</th></tr>";
foreach ($data as $result)
{
  	$ID = $result["ID"];
  	$name = $result["name"];
  	$location = $result["location"];
  	$type = $result["type"];
  	PRINT "<tr bgcolor=#DDDDDD><td>";
  	PRINT '<a href="'.Config::AbsLoc("users/networking-info.php?ID=$ID").'">';
	PRINT "$name ($ID)</a></td><td>$location</td><td>";
	
  	PRINT "$type</td>";
  	PRINT "</tr>";
}
PRINT "</table>";

commonFooter();
