<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");

commonHeader(_("Software") . " - " . _("Search Results"));
printf(_("Showing results where %s contains [%s] in %s view."),$field,$contains,$style);
PRINT "<ht noshade>";

$DB = Config::Database();

if (!preg_match('/^[A-Za-z0-9_]+$/', $field))
{
	trigger_error(sprintf(_("invalid field name: %s"),$field), E_USER_ERROR);
	die(__FILE__.":".__LINE__.": dying with fatal error\n");
	exit;
}

$likecontains = $DB->getTextValue("%$contains%");

if ($style == "full")
{
	$query = "SELECT * FROM software WHERE ($field LIKE $likecontains) ORDER BY name";
	$data = $DB->getAll($query);
	$data = array_slice($data, $goto);
	if (count($data) > 5)
	{
		$nextpage = true;
		$data = array_slice($data, 0, 5);
	}
	else
	{
		$nextpage = false;
	}

	foreach ($data as $result)
	{
		$ID = $result["ID"];
		showSoftware($ID, 0);
	}
	
  	$backgoto = $goto - 5;
  	$forgoto = $goto + 5;
  	PRINT "<table border=0><tr><td>";
  	if ($backgoto > -1)
  	{
    		PRINT "<form><input type=hidden name=field value=\"$field\"><input 
		  type=hidden name=contains value=\"$contains\"><input 
		  type=hidden name=style value=\"$style\"><input type=hidden 
		  name=goto value=$backgoto><input type=submit 
		  value=\"Previous 5\"></form>";
  	}
  	PRINT "</td><td>";
  	PRINT "<form><input type=hidden name=field value=\"$field\"><input 
		type=hidden name=contains value=\"$contains\"><input 
		type=hidden name=style value=\"$style\"><input type=hidden 
		name=goto value=$forgoto><input type=submit 
		value=\"Next 5\"></form>";
  	PRINT "</td></tr></table>";
}
elseif ($style == "list")
{
	$query = "SELECT * FROM software WHERE ($field LIKE $likecontains)";
	$data = $DB->getAll($query);
	PRINT "<table border=1 width=100%><tr bgcolor=#CCCCCC><th>";
	__("Name");
	PRINT "</th><th>";
	__("Platform");
	PRINT "</th><th>";
	__("Licenses");
	PRINT "</th></tr>";
	foreach ($data as $result)
	{
		$ID = $result["ID"];
		$name = $result["name"];
		$platform = $result["platform"];
		$license = Count_licenses($ID);
		PRINT '<tr bgcolor=#DDDDDD><td><a href="'
		.Config::AbsLoc("users/software-info.php?ID=$ID").'">';
		PRINT "$name ($ID)</a></td><td>$platform</td><td>";
   	 
		$installed = Count_installations($ID);
		$remaining = $license - $installed;
		PRINT "<font face=\"Arial, Helvetica\">";
		__("Installed: ");
		PRINT "<b>$installed</b> ";
		__("Remaining: ");
		PRINT "<b>";
		if ($remaining <= 0) {
			PRINT "<font color=red>";
		}
		PRINT "$remaining</font></b> ";
		__("Total: ");
		PRINT "<b>$license</b></font></td></tr>";
	}
	PRINT "</table>";
}
commonFooter();
