/*      
 * iroffer by PMG
 * Copyright (C) 1998-2003 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 * If you received this file without documentation, it can be
 * downloaded from http://iroffer.org/
 * 
 * @(#) iroffer_defines.h 1.77@(#)
 * pmg@wellington.i202.centerclick.org|src/iroffer_defines.h|20030913195021|04211
 * 
 */

#if !defined _IROFFER_DEFINES
#define _IROFFER_DEFINES


/* options, these should be on */
/*       Send Flood Protection */
#define  SND_FPROT 1
/*       Receive Flood Protection */
#define  RCV_FPROT 1
/*       Ping The Server */
#define  PING_SRVR 1
/*       User Can't Request The Same File Twice */
#define  USER_MAXS 1
/*       Timeout Transfers */
#define  XFR_TMOUT 1
/*       XDCC SAVE on Shutdown */
#define  SAVEQUIT  1
/*       adminpass is encrypted */
#define  ENCRYPTPASS 1
/*       dont allow running as root */
#define  BLOCKROOT 1


/* size, length, etc.. */
/*       Max Servers */
#define  MAXSRVS   50
/*       Max Channels */
#define  MAXCHNLS  50
/*       Max Server Send Queue Lines */
#define  MAXSENDQ  300
/*       Max Queue Size */
#define  MAXQUEUE  100

/*
 * determine how many transfers we can have based on how
 * large FD_SETSIZE is:
 *
 * 6 FDs are reserved:
 * 0,1,2 for in/out/err
 * a,b,c for ircserver, dcc chat, and misc use (logs, accept(), etc...)
 * 
 * 2 FDs for each transfer and each upload
 *
 */


/*       Max Number of Uploads */
#define  MAXUPLDS  ((FD_SETSIZE <= 128) ? 2 : 5)

#define  MAX_FDS_TO_MAXTRANS(max_fds) (min2((int)(((max_fds)-6-(MAXUPLDS*2))/2),200))

/*       Max Number of Transfers */
#define  MAXTRANS  MAX_FDS_TO_MAXTRANS(FD_SETSIZE)

/*       actual running max transfers */
#define  ACTUAL_MAXTRANS  min2(MAX_FDS_TO_MAXTRANS(gdata.max_fds_from_rlimit),MAXTRANS)


/*       Max number of adminhosts */
#define  MAXAHOST  10
/*       Max XDCC's Offered */
#define  MAXXDCCS  500
/*       max size for xdcc list queue */
#define  MAXXLQUE  5
/*       max config files */
#define  MAXCONFIG  10
/*       meminfo hash size */
#define  MEMINFOHASHSIZE 256
/*       Max context log */
#define  MAXCONTEXTS 100
/*       Server Connection Timeout In Seconds */
#define  CTIMEOUT  5
/*       Server Connection Timeout Backoff In Seconds */
#define  CBKTIMEOUT 8
/*       How Long to Wait Until We Giveup On A Non-responding Server */
#define  SRVRTOUT  240

#if !defined(NO_CHROOT)
/*       Max Chroot Dir Name Length */
#define  MAXCHROOTDIR 256
#endif
#if !defined(NO_SETUID)
/*       Max Username Length */
#define  MAXRUNASUSER 15
#endif

/*       Defines for the routine using getopt() */
#define  PCL_OK		0
#define  PCL_BAD_OPTION	1
#define  PCL_GEN_PASSWORD	2
#define  PCL_SHOW_VERSION	3

/*       max number of people to keep track of in ignore list */
#define  MAXIGNL  80
/*       tollerance for ignore, seconds/request to decrement bucket */
#define  IGN_TL    10
/*       threshhold for ignore, number of requests in bucket */
#define  IGN_ON    8
/*       threshhold for un-ignore, number of requests in bucket */
#define  IGN_OFF   0

/*       weight for speed calcualtion in dcl initial */
#define  DCL_SPDW_I  0.5
/*       weight for speed calcualtion in dcl ongoing */
#define  DCL_SPDW_O  0.9
/*       time until minspeed checking becomes active */
#define  MIN_TL    60

/*       buffer size */
#define  BUFFERSIZE 4096
/*       max BUFFERSIZE blocks to write per cycle */
#define  tbufsize  30

/*       notify level for server queue */
#define  srvqnotify  60

/*       excess flood protection */
#define  EXCESS_LEVEL_0  15
#define  EXCESS_LEVEL_1   6
#define  EXCESS_LEVEL_2   4
#define  EXCESS_LEVEL_3   2

/* free'ing just leads to trouble if we dont check first and then make NULL */
#define mydelete(x) { mydelete2(x); x = NULL; }
#define mycalloc(x) mycalloc2(x, __FUNCTION__, __FILE__, __LINE__)

#define  maxtextlengthshort 60
#define  maxtextlength 512

/* type definitions for igninfo flags */
#define IGN_MANUAL      1
#define IGN_IGNORING    2

/* type definitions for channel_t flags */
#define CHAN_ONCHAN     1
#define CHAN_MINIMAL    2
#define CHAN_SUMMARY    4

/* type definistions: Screen, Log, DCC CHAT */
#define OUT_S    1
#define OUT_L    2
#define OUT_D    4

/* size of stdout buffer */
#define STDOUT_BUFFER_SIZE  (64*1024)

/* max write size from stdout buffer*/
#define STDOUT_WRITE_MAX_SIZE (1024)

/* color options */
#define COLOR_NO_COLOR   0
#define COLOR_BLACK      30
#define COLOR_RED        31
#define COLOR_GREEN      32
#define COLOR_YELLOW     33
#define COLOR_BLUE       34
#define COLOR_MAGENTA    35
#define COLOR_CYAN       36
#define COLOR_WHITE      37
#define COLOR_BOLD       0x80

/* it's up to the umask to prune away.. */
#define CREAT_PERMISSIONS ( S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH )


/* some os's (cygwin, cough, cough, ... ) require extra flags to open() */
#define ADDED_OPEN_FLAGS 0

#define FD_UNUSED (FD_SETSIZE*2)

/* where would we be without these? */
#define max2(a,b) ( (a > b) ? a : b )
#define min2(a,b) ( (a < b) ? a : b )
#define max3(a,b,c) ( max2(a,max2(b,c)) )
#define min3(a,b,c) ( min2(a,min2(b,c)) )
#define between(min,a,max) ( max2(min2(a,max),min) )
#define floor(v,f) ( (v) - ((v) % (c)) )
#define ceiling(v,c) ( (v) + (c) - ((v) % (c)) )


#define updatecontext() updatecontext_f(__FILE__,__FUNCTION__,__LINE__)

/* set os specific values */
/* linux */
#if defined(_OS_Linux)
#define _GNU_SOURCE

/* bsd */
#elif defined(_OS_FreeBSD)   || \
    defined(_OS_OpenBSD)     || \
    defined(_OS_NetBSD)      || \
    defined(_OS_BSDI)        || \
    defined(_OS_BSD_OS)      || \
    defined(_OS_Darwin)
#define _OS_BSD_ANY

/* sunos */
#elif defined(_OS_SunOS)

/* HP-UX */
#elif defined(_OS_HPUX)

/* IRIX */
#elif defined(_OS_IRIX)

/* IRIX64 */
#elif defined(_OS_IRIX64)

/* Digital UNIX */
#elif defined(_OS_OSF1)

/* MacOS X Server */
#elif defined(_OS_Rhapsody)

/* MacOS X */
#elif defined(_OS_Darwin)

/* CYGWIN */
#elif defined(_OS_CYGWIN)
#undef ADDED_OPEN_FLAGS
#define ADDED_OPEN_FLAGS O_BINARY

/* AIX */
#elif defined(_OS_AIX)

/* other */
#else
#error "*** ERROR: This OS Is Not Supported Or You Didn't Run Configure ***"
#endif

#endif

/* End of File */
