$VERSION = "1.1";
%IRSSI = (
    authors     =&gt;  "Roeland 'Trancer' Nieuwenhuis",
    contact     =&gt;  "irssi\@trancer.nl",
    name        =&gt;  "nickban",
    description =&gt;  "A simple nick banner. If it encounters a nick it bans its host",
    license     =&gt;  "Public Domain"
);

use strict;
use Irssi;

# The channels the nicks are banned on (on which this script is active)
my @channels = qw(#worldchat #chat-world #php);

# The banned nicks
my @nicks = qw(evildude evilgirl);

# Your kickreason
my $kickreason = "Not welcome here.";

sub nick_banner {

    my($server, $channel, $nick, $address) = @_;

    # Are we opped?
    return unless $server-&gt;channel_find($channel)-&gt;{chanop};
    
    # If the nick is a server, stop it.
    return if $nick eq $server-&gt;{nick};
    
    # Is the user a banned nick?
    my $nono = 0;
    foreach (@nicks) { $nono = 1 if lc($nick) eq lc($_) }
    return unless $nono;
       
    # Is the user on one of the banned channels?
    my $react = 0;
    foreach (@channels) { $react = 1 if lc($channel) eq lc($_) }
    return unless $react;
    
    # User voiced or op'd?
    # Pretty useless, but ok
    return if $server-&gt;channel_find($channel)-&gt;nick_find($nick)-&gt;{op} || $server-&gt;channel_find($channel)-&gt;nick_find($nick)-&gt;{voice};

    $server-&gt;command("kickban $channel $nick $kickreason");
    Irssi::print("Nick banning $nick on $channel. Banned.");
}

Irssi::signal_add_last('message join', 'nick_banner');