/*
 * side_bar_widget.h - base-class for all side-bar-widgets
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _SIDE_BAR_WIDGET_H
#define _SIDE_BAR_WIDGET_H

#include <qwidget.h>
#include <qpixmap.h>

class QVBox;


class sideBarWidget : public QWidget
{
	Q_OBJECT
public:
	sideBarWidget( const QString & _title, const QPixmap & _icon, QWidget * _parent );
	~sideBarWidget();
	inline const QPixmap & icon( void ) const
	{
		return( m_icon );
	}
	inline const QString & title( void ) const
	{
		return( m_title);
	}


protected:
	void paintEvent( QPaintEvent * _pe );
	void resizeEvent( QResizeEvent * _re );
	inline void contextMenuEvent( QContextMenuEvent * )
	{
	}

	inline QVBox * contentParent( void )
	{
		return( m_contents );
	}


private:
	QVBox * m_contents;
	QString m_title;
	QPixmap m_icon;

} ;


#endif
