/*
 * about_dialog.cpp - implementation of about-dialog
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qtextedit.h>
#include <qtabwidget.h>
#include <qlabel.h>
#include <qpushbutton.h>

#include "about_dialog.h"
#include "version.h"
#include "embed.h"

#include "about_dialog.moc"


extern const QString authors_txt;
extern const QString copying_txt;


aboutDialog::aboutDialog( QWidget * _parent ) :
	QDialog( _parent )
{
	setCaption( tr( "About iTALC..." ) );

	QLabel * icon_lbl = new QLabel( this );
	icon_lbl->setPixmap( embed::getIconPixmap( "splash", 82, 64 ) );
	icon_lbl->setGeometry( 10, 10, 82, 64 );

	QLabel * app_name_lbl = new QLabel( tr( "iTALC" )+" "+VER_STRING, this );
	app_name_lbl->setGeometry( 110, 30, 256, 20 );

	m_aboutTabs = new QTabWidget( this );

	QLabel * about_lbl = new QLabel( tr( "iTALC - Intelligent Teaching And Learning with Computers\n\nCopyright (c) 2004-2005 Tobias Doerffel and others" ), m_aboutTabs );
	about_lbl->setAlignment( Qt::AlignVCenter | Qt::AlignLeft );
	about_lbl->setIndent( 20 );


	QTextEdit * authors_lbl = new QTextEdit( m_aboutTabs );
	authors_lbl->setText( embed::getText( "AUTHORS" ) );
	authors_lbl->setReadOnly( TRUE );
	authors_lbl->setWordWrap( QTextEdit::NoWrap );


	QTextEdit * translation_lbl = new QTextEdit( m_aboutTabs );
	translation_lbl->setText( tr( "Current language not translated.\n\nIf you're interested in translating iTALC in another language or want to improve existing translations, you're welcome to help us! Just contact the maintainer!" ) );
	translation_lbl->setReadOnly( TRUE );


	QTextEdit * copying_lbl = new QTextEdit( m_aboutTabs );
	copying_lbl->setText( embed::getText( "COPYING" ) );
	copying_lbl->setReadOnly( TRUE );
	copying_lbl->setWordWrap( QTextEdit::NoWrap );


	m_aboutTabs->addTab( about_lbl, tr( "About" ) );
	m_aboutTabs->addTab( authors_lbl, tr( "Authors" ) );
	m_aboutTabs->addTab( translation_lbl, tr( "Translation" ) );
	m_aboutTabs->addTab( copying_lbl, tr( "License" ) );

	m_okBtn = new QPushButton( tr( "Close" ), this );
	connect( m_okBtn, SIGNAL( clicked() ), this, SLOT( accept() ) );

	resize( 560, 390 );

}




aboutDialog::~aboutDialog()
{
}




void aboutDialog::keyPressEvent( QKeyEvent * _ke )
{
	if( _ke->key() == Qt::Key_Escape )
	{
		accept();
	}
}




void aboutDialog::resizeEvent( QResizeEvent * _re )
{
	m_aboutTabs->setGeometry( 10, 90, _re->size().width()-20, _re->size().height()-140 );
	m_okBtn->setGeometry( _re->size().width()-110, _re->size().height()-40, 100, 30 );
}
