/*
 * overview_widget.cpp - implementation of overview-widget for side-bar
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include <qlabel.h>
#include <qvbox.h>

#include "overview_widget.h"
#include "embed.h"

#include "overview_widget.moc"


overviewWidget::overviewWidget( QWidget * _parent ) :
	sideBarWidget( tr( "Overview" ), embed::getIconPixmap( "overview" ), _parent )
{
	QFont f;

	QLabel * welcome = new QLabel( tr( "Welcome to iTALC!" )+"\n", contentParent() );
	f.setPixelSize( 14 );
	f.setBold( TRUE );
	f.setItalic( TRUE );
	welcome->setFont( f );
	f.setBold( FALSE );
	f.setItalic( FALSE );
	welcome->setAlignment( welcome->alignment() | WordBreak );

	f.setPixelSize( 12 );
	QLabel * here = new QLabel( contentParent() );
	here->setPixmap( embed::getIconPixmap( "back" ) ); 

	QLabel * workbar_desc = new QLabel( tr( "Here you see the working-bar which contains several buttons. Each button is connected "
						"with a workspace. Just take a look at the available workspaces by clicking on the "
						"corresponding button.\n\nIf you need help or want to get support from another person, "
						"take a look at the help-workspace!" )+"\n ", contentParent() );
	workbar_desc->setFont( f );
	workbar_desc->setAlignment( workbar_desc->alignment() | WordBreak );

	QLabel * cm_desc = new QLabel( tr( "With the client-manager you can add or remove clients (computers) and switch between "
						"client-groups (normally rooms)." )+"\n ", contentParent() );
	cm_desc->setFont( f );
	cm_desc->setAlignment( cm_desc->alignment() | WordBreak );

	QLabel * ul_desc = new QLabel( tr( "If you want to know, which users are logged in, you can open the user-list." )+"\n ",
					contentParent() );
	ul_desc->setFont( f );
	ul_desc->setAlignment( ul_desc->alignment() | WordBreak );

	QLabel * chat_desc = new QLabel( tr( "For managing chats, you can use the chat-management-system." )+"\n ", contentParent() );
	chat_desc->setFont( f );
	chat_desc->setAlignment( chat_desc->alignment() | WordBreak );

	QLabel * screenshot_desc = new QLabel( tr( "The screenshot-workspace is a very useful tool. It let's you manage the screenshots "
							"you made, that means you can watch and delete them." )+"\n ", contentParent() );
	screenshot_desc->setFont( f );
	screenshot_desc->setAlignment( screenshot_desc->alignment() | WordBreak );

	QLabel * config_desc = new QLabel( tr( "Of course you can configure iTALC. This is usually done with the "
						"configuration-workspace." )+"\n ", contentParent() );
	config_desc->setFont( f );
	config_desc->setAlignment( config_desc->alignment() | WordBreak );

	QLabel * filler = new QLabel( contentParent() );
	filler->setFixedHeight( 2048 );

}




overviewWidget::~overviewWidget()
{
}
