/****************************************************************************
 *                             LogInstance.h
 *
 * Author: Matthew Ballance
 * Desc:   Describes an instance of a logger... The instance may have
 *         sub-regions.
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_LOG_INSTANCE_H
#define INCLUDED_LOG_INSTANCE_H
#include "vector.h"
#include "LogMgr.h"
#include <stdarg.h>

class LogMgr;
class LogRegionType;
class LogDestination;
class LogInstLevel;
class LogInstance : public LogRegionType {
    public:
        LogInstance(LogRegionType *regionType, const char *instNameStr);
       ~LogInstance();

        int AddDestination(LogDestination *dest);
        int DestStateUpdate(LogDestination *dest, LogMgr::DebugLevel newState);

        int vprint(LogMgr::DebugLevel dbgLevel, const char *fmt, va_list ap);

        void venter(LogMgr::DebugLevel dbgLevel, const char *fmt, va_list ap);
        void vleave(LogMgr::DebugLevel dbgLevel, const char *fmt, va_list ap);

    private:
        LogRegionType             *d_regionType;
        String                     instName;
        Vector<LogDestination>    *destList;

        Uint32                     destRefCnt;
        String                     prvBuffer;
};

#endif /* INCLUDED_LOG_INSTANCE_H */

