/****************************************************************************
 *                               LogMgr.cc
 * Author: Matthew Ballance
 * Desc:   Implements the Manager portion of the logging sub-system. 
 *         Implements TCL commands for dealing with logging
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "LogMgr.h"
#include "LogRegionType.h"

LogMgr *LogMgr::Globl_LogMgr = 0;

/********************************************************************
 * LogMgr()
 ********************************************************************/
LogMgr::LogMgr(
        Tcl_Interp   *interp,
        Uint32        objc,
        Tcl_Obj      *const objv[]) : ObjWidgetBase(interp, objc, objv)
{
    logRegions          = new Vector<LogRegionType>();
    logInstances        = new Vector<LogInstance>();
    logDestinations     = new Vector<LogDestination>();
}

/********************************************************************
 * GetLogMgr()
 ********************************************************************/
LogMgr *LogMgr::GetLogMgr()
{
    if (!Globl_LogMgr) {
        fprintf(stderr, "ERROR: LogMgr not constructed\n");
        exit(1);
    }

    return Globl_LogMgr;
}
/********************************************************************
 * LogMgr_Init()
 ********************************************************************/
void LogMgr::LogMgr_Init(Tcl_Interp *interp, int argc, Tcl_Obj *const objv[])
{

    if (!Globl_LogMgr) {
        Globl_LogMgr = new LogMgr(interp, argc, objv);
    }
}

/********************************************************************
 * InstCmd()
 ********************************************************************/
int LogMgr::InstCmd(
        int               objc,
        Tcl_Obj          *const objv[])
{
    return TCL_OK;
}

/********************************************************************
 * AddRegionType
 ********************************************************************/
int LogMgr::AddRegionType(LogRegionType    *newRegion)
{
    LogMgr *mgr = LogMgr::GetLogMgr();

    mgr->logRegions->append(newRegion);

    return 0;
}

/********************************************************************
 * FindRegionType
 ********************************************************************/
int LogMgr::FindRegionType(const char *typeName, LogRegionType **region)
{
    LogMgr          *mgr = LogMgr::GetLogMgr();
    LogRegionType   *reg;
    Uint32    i;

    for (i=0; i<mgr->logRegions->length(); i++) {
        reg = mgr->logRegions->idx(i);

        if (reg->get_typeName() == typeName) {
            *region = reg; 
            return 0;
        }
    }

    if (region) {
        *region = 0;
    }
    return -1;
}

/********************************************************************
 * AddInstance
 *
 * Adds an instance of a LogRegionType. The region-type must be 
 * added before an instance of that region is created...
 ********************************************************************/
int LogMgr::AddInstance(LogInstance   *newInst)
{
    LogMgr  *mgr = LogMgr::GetLogMgr();

    return TCL_OK;
}

/********************************************************************
 * LogMgr_Init()
 ********************************************************************/
extern "C" int LogMgr_Init(Tcl_Interp *interp)
{
    Tcl_Obj   *objv[4];

    objv[0] = NULL;
    objv[1] = Tcl_NewStringObj("log_mgr", -1);

    LogMgr::LogMgr_Init(interp, 2, objv);

    return TCL_OK;
}


