/****************************************************************************
 *                     RemoteAppConnectionListener.h
 *
 * Author: Matthew Ballance
 * Desc:   This is a callback class. The Receive() method is called 
 *         whenever a valid packet for the specifed sub-channel is received
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_REMOTE_APP_CONNECTION_LISTENER_H
#define INCLUDED_REMOTE_APP_CONNECTION_LISTENER_H
#include "types.h"
#include <tcl.h>

class RemoteAppConnection;
class RemoteAppConnectionListener {

    /****************************************************************
     * Public Methods
     ****************************************************************/
    public:

        /************************************************************
         * RemoteAppConnectionListener()
         ************************************************************/
        RemoteAppConnectionListener(Uint32 subChanIdx);

        /************************************************************
         * ~RemoteAppConnectionListener()
         ************************************************************/
        virtual ~RemoteAppConnectionListener();

        /************************************************************
         * Receive()
         ************************************************************/
        virtual void Receive(Uint32 subChanIdx, Uint32 pkt_length, Uchar *data);

        /************************************************************
         * Send()
         ************************************************************/
        virtual int Send(Uint32 idx, Uint32 len, Uchar *data);

        /************************************************************
         * Connect()
         ************************************************************/
        virtual void Connect(RemoteAppConnection *conn);

        /************************************************************
         * getConnection()
         ************************************************************/
        RemoteAppConnection *getConnection() { return d_connection; }

        /************************************************************
         * getIdx()
         ************************************************************/
        Uint32 getIdx() { return d_subChanIdx; }

    /****************************************************************
     * Protected Data
     ****************************************************************/
    protected:
        RemoteAppConnection       *d_connection;

    /****************************************************************
     * Private Data
     ****************************************************************/
    private:
        Uint32                     d_subChanIdx;
};

#endif /* INCLUDED_REMOTE_APP_CONNECTION_LISTENER_H */


