/*****************************************************************************
 *                               string.h
 * Author: Matthew Ballance
 * Desc:   Simple string class..
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#ifndef INCLUDED_STRING_CLASS_H
#define INCLUDED_STRING_CLASS_H
#include "types.h"

class String {

public:

    String(const char *str);
    String(char *str, Uint32 len);
    String(String *tmpl);
    String(const String &cpy);
    String(Uint32 len);
    String(void);
   ~String(void);


    int equal(String *str) const;
    int equal(const char   *str) const;
    int equal(const char *str, Uint32 len) const;
    static int String::equal(const char *str1, const char *str2);

    void operator = (const String &rhs);
    void operator = (const Char   *str_in);
    int  operator == (const String &rhs) const;
    int  operator == (const char *str) const;
    void operator += (const Char  *str);
    void operator += (char  ch);

    inline char &operator [] (const Uint32 idx) const {
        return str[((idx<=str_max)?idx:0)];
    }

    inline char &operator [] (const Uint32 idx) {
        return str[((idx<=str_max)?idx:0)];
    }

    Int32 strchr(Char ch);
    Int32 strchr(Char ch, Uint32 idx);
    Int32 strrchr(Char ch);

    void mirror(void) {
        Uint32 i;
        Char   tmp;

        if (str_len) {
            for (i=0; i<(str_len/2); i++) {
                tmp = str[i];
                str[i] = str[str_len-i-1];
                str[str_len-i-1] = tmp;
            }
        }
    }

    void chkSize(Uint32 new_max);

    void setValue(char *newStr, Int32 in_len);
  
    inline Uint32 length(void) const { return str_len; }
    inline Uint32 max_len() const { return str_max; }
    void setLen(Int32 len);

    inline char *value(void) const { return str; }

    static Int32 match(char *string, char *pattern);
    Int32 match(char *pattern);

public:
    Char        *str;
    Uint32       str_len;
    Uint32       str_max;
};

#endif


