/*****************************************************************************
 *                            ValChgBlkVector.cc
 * 
 * Author: Matthew Ballance 
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#include "ValChgBlkVector.h"
#include <stdlib.h>
#include <memory.h>

ValChgBlkVector *ValChgBlkVector::prv_AllocList = 0;

/**********************************************************
 * operator new
 **********************************************************/
void *ValChgBlkVector::operator new (size_t size)
{
    ValChgBlkVector *new_vect = 0;

    if (prv_AllocList) {
        new_vect = prv_AllocList;
        prv_AllocList = prv_AllocList->next;
    } else {
        new_vect = (ValChgBlkVector *)malloc(size);
        memset(new_vect, 0, sizeof(ValChgBlkVector));
    }
    return new_vect;
}

/**********************************************************
 * operator delete
 **********************************************************/
void ValChgBlkVector::operator delete (void *ptr)
{
    ValChgBlkVector *vect = (ValChgBlkVector *)ptr;

    vect->next = prv_AllocList;
    prv_AllocList = vect;
}

/**********************************************************
 * ValChgBlkVector()
 **********************************************************/
ValChgBlkVector::ValChgBlkVector(Uint32 bitWidth)
{
    if (!blk_store) {
        blk_store = new Vector<ValChgBlock>();
    }
    elem_length = 0;
    blk_cache   = 0;
    init_idx    = 0;
    d_bitWidth  = bitWidth;
}


/**********************************************************
 * ~ValChgBlkVector()
 **********************************************************/
ValChgBlkVector::~ValChgBlkVector(void)
{
    blk_store->setLength(0);        
}

/**********************************************************
 * append(ValChgBlock)
 **********************************************************/
void ValChgBlkVector::append(ValChgBlock *blk)
{
    blk_size = blk->numChanges;
    blk_store->append(blk);    
    elem_length += (blk->currentChg+1);
}


/**********************************************************
 * idx()
 **********************************************************/
DFIOValChg *ValChgBlkVector::idx(Uint32 idx)
{
    ValChgBlock   *blk;
    DFIOValChg    *chg = 0;
    Uint32 i, cnt = 0, tmp_idx = idx, len, blk_try, idx_try;
 
    if (idx >= length()) {
        return 0;
    }

   /**** First, create a 'real' offset from the input
    ****/
    tmp_idx += init_idx;

    blk_try = tmp_idx / blk_size;
    idx_try = tmp_idx % blk_size;

    if (blk_cache && (blk_try == blk_try_cache)) {
        return DFIOValChg_Idx(blk_cache->valChanges, d_bitWidth, idx_try);
//        return &blk_cache->valChanges[idx_try];
    }

    blk_cache = blk_store->idx(blk_try);
    blk_try_cache = blk_try;

    if (blk_cache) {
        return DFIOValChg_Idx(blk_cache->valChanges, d_bitWidth, idx_try);
//        return &blk_cache->valChanges[idx_try];
    } else {
        return 0;
    }
}

