/* 
 * tkTableInitScript.h --
 *
 *	This file contains common init script for tkTable
 *
 * Copyright (c) 1998 Jeffrey Hobbs
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

/*
 * The following string is the startup script executed when the table is
 * loaded.  It looks on disk in several different directories for a script
 * "TBL_RUNTIME" (as defined in Makefile) that is compatible with this
 * version of tkTable.  The sourced script has all key bindings defined.
 */

#define TBL_RUNTIME "tkTable.tcl"
#define TBL_RUNTIME_DIR "[file join $IVI_HOME modules iviTktable]"

static char tkTableInitScript_orig[] = "if {[info proc tkTableInit]==\"\"} {\n\
  proc tkTableInit {} {\n\
    global tk_library tcl_pkgPath errorInfo env\n\
    global IVI_HOME\n\
    rename tkTableInit {}\n\
    set errors {}\n\
    if {![info exists env(TK_TABLE_LIBRARY_FILE)]} {\n\
	set env(TK_TABLE_LIBRARY_FILE) " TBL_RUNTIME "\n\
    }\n\
    if {[info exists env(TK_TABLE_LIBRARY)]} {\n\
	lappend dirs $env(TK_TABLE_LIBRARY)\n\
    }\n\
    lappend dirs " TBL_RUNTIME_DIR "\n\
    if {[info exists tcl_pkgPath]} {\n\
	foreach i $tcl_pkgPath {\n\
	    lappend dirs [file join $i Tktable" VERSION "] \\\n\
		[file join $i Tktable] $i\n\
	}\n\
    }\n\
    lappend dirs $tk_library [pwd]\n\
    foreach i $dirs {\n\
	set try [file join $i $env(TK_TABLE_LIBRARY_FILE)]\n\
	if {[file exists $try]} {\n\
	    if {![catch {uplevel #0 [list source $try]} msg]} {\n\
		set env(TK_TABLE_LIBRARY) $i\n\
		return\n\
	    } else {\n\
		append errors \"$try: $msg\n$errorInfo\n\"\n\
	    }\n\
	}\n\
    }\n"
#ifdef NO_EMBEDDED_RUNTIME
"    set msg \"Can't find a $env(TK_TABLE_LIBRARY_FILE) in the following directories: \n\"\n\
    append msg \"    $dirs\n\n$errors\n\n\"\n\
    append msg \"This probably means that TkTable wasn't installed properly.\"\n\
    return -code error $msg\n"
#else
"    set env(TK_TABLE_LIBRARY) EMBEDDED_RUNTIME\n"
#   ifdef MAC_TCL
"    source -rsrc tkTable"
#   else
"    uplevel #0 {"
#	include "tkTable.tcl.h"
"    }"
#   endif
#endif
"  }\n\
}\n\
tkTableInit";

static char tkTableInitScript_dbg[] = "if {[info proc tkTableInit]==\"\"} {\n\
  proc tkTableInit {} {\n\
    set pt 0 \n\
    global tk_library tcl_pkgPath errorInfo env\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    global IVI_HOME\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    rename tkTableInit {}\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    set errors {}\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    if {![info exists env(TK_TABLE_LIBRARY_FILE)]} {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	set env(TK_TABLE_LIBRARY_FILE) " TBL_RUNTIME "\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    }\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    if {[info exists env(TK_TABLE_LIBRARY)]} {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	lappend dirs $env(TK_TABLE_LIBRARY)\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    }\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    lappend dirs " TBL_RUNTIME_DIR "\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    if {[info exists tcl_pkgPath]} {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	foreach i $tcl_pkgPath {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	    lappend dirs [file join $i Tktable" VERSION "] \\\n\
		[file join $i Tktable] $i\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	}\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    }\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    lappend dirs $tk_library [pwd]\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    foreach i $dirs {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	set try [file join $i $env(TK_TABLE_LIBRARY_FILE)]\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	if {[file exists $try]} {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	    if {![catch {uplevel #0 [list source $try]} msg]} {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
		set env(TK_TABLE_LIBRARY) $i\n\
                puts \"tkTableInit pt [incr pt]\"\n\
		return\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	    } else {\n\
                puts \"tkTableInit pt [incr pt]\"\n\
		append errors \"$try: $msg\n$errorInfo\n\"\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	    }\n\
                puts \"tkTableInit pt [incr pt]\"\n\
	}\n\
                puts \"tkTableInit pt [incr pt]\"\n\
    }\n"
#ifdef NO_EMBEDDED_RUNTIME
"    set msg \"Can't find a $env(TK_TABLE_LIBRARY_FILE) in the following directories: \n\"\n\
    append msg \"    $dirs\n\n$errors\n\n\"\n\
    append msg \"This probably means that TkTable wasn't installed properly.\"\n\
    return -code error $msg\n"
#else
"    set env(TK_TABLE_LIBRARY) EMBEDDED_RUNTIME\n"
#   ifdef MAC_TCL
"    source -rsrc tkTable"
#   else
"    uplevel #0 {"
#	include "tkTable.tcl.h"
"    }"
#   endif
#endif
"  }\n\
}\n\
tkTableInit";

static char *tkTableInitScript = tkTableInitScript_orig;

/*
 * The init script can't make certain calls in a safe interpreter,
 * so we always have to use the embedded runtime for it
 */
static char tkTableSafeInitScript[] = "if {[info proc tkTableInit]==\"\"} {\n\
  proc tkTableInit {} {\n\
    set env(TK_TABLE_LIBRARY) EMBEDDED_RUNTIME\n"
#ifdef NO_EMBEDDED_RUNTIME
"    append msg \"tkTable requires embedded runtime to be compiled for\"\n\
    append msg \" use in safe interpreters\"\n\
    return -code error $msg\n"
#else
#   ifdef MAC_TCL
"    source -rsrc tkTable"
#   else
"    uplevel #0 {"
#	include "tkTable.tcl.h"
"    }"
#   endif
#endif
"  }\n\
}\n\
tkTableInit";

