/* --------------------------------------------------------------------------
 *
 * License
 *
 * The contents of this file are subject to the Jabber Open Source License
 * Version 1.0 (the "License").  You may not copy or use this file, in either
 * source code or executable form, except in compliance with the License.  You
 * may obtain a copy of the License at http://www.jabber.com/license/ or at
 * http://www.opensource.org/.
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright (c) 2000-2001 Schuyler Heath <sheath@jabber.org>
 *
 * Acknowledgements
 *
 * Special thanks to the Jabber Open Source Contributors for their
 * suggestions and support of Jabber.
 *
 * -------------------------------------------------------------------------- */

#include "sb.h"
#include <curl/curl.h>
#include <curl/types.h>


struct MemoryStruct {
	char *memory;
	size_t size;
};

int findSubStr(char *str, char *substr, uint index) {
	uint i = 0;
	uint found = 0;
	uint length1 = 0;
	uint length2 = 0;
	length1 = strlen(str);
	length2 = strlen(substr);

	if(str == 0 || substr == 0)
		return -1;

	for(i = index; i <= length1; i++) {
		if(str[i] == substr[found]) // If we find the char, increment the found counter, otherwise reset it
			found++;
		else
			if(found != 0) {
				found = 0;
				i--; // So we can try again
			}
			else
				found = 0;

		if(found == length2)
			break;
	}

	if(found == length2)
		return i - found + 1; // Return the start of the substr
	else
		return -1; // Not found
}

size_t WriteMemoryCallback(void *ptr, size_t size, size_t nmemb, void *data)
{
	register int realsize = size * nmemb;
	struct MemoryStruct *mem = (struct MemoryStruct *)data;

	mem->memory = (char *)realloc(mem->memory, mem->size + realsize + 1);
	if (mem->memory) {
		memcpy(&(mem->memory[mem->size]), ptr, realsize);
		mem->size += realsize;
		mem->memory[mem->size] = 0;
	}
	return realsize;
}


void mt_ssl_auth(session s, char *authdata, char *tp)
{
// Thanks to http://www.hypothetic.org/docs/msn/research/msnp8.php for the information to get this working

	CURL *curl;
	CURLcode res;
	char url[strlen(authdata) + 500];
	char lc[10];
	char id[10];
	char tw[10];
	char kv[10];
	char cookies[500];
	int i = 0;
	int pos = 0;
	int pos2 = 0;
	struct MemoryStruct chunk;
	char *passporthost = "login.passport.com";
	char errorbuffer[CURL_ERROR_SIZE+1];
    	mti ti = s->ti;

	strcpy(tp, "");

	chunk.memory = 0;
	chunk.size = 0;

	lowercase(s->user);

	if (strcmp(s->user + strlen(s->user) - strlen("@hotmail.com"), "@hotmail.com") == 0) {
	    passporthost = "loginnet.passport.com";
	} else if (strcmp(s->user + strlen(s->user) - strlen("@msn.com"), "@msn.com") == 0) {
	    passporthost = "msnialogin.passport.com";
	}

	strcpy(url, "https://");
	strcat(url, passporthost);
	strcat(url, "/login.srf?");
	strcat(url, authdata);

	curl = curl_easy_init();
	if(!curl) {
		log_debug(ZONE,"Session[%s], Curl init failed, bailing out",jid_full(s->id));
		return;
	}

	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteMemoryCallback);
//	curl_easy_setopt(curl, CURLOPT_COOKIEFILE, "/usr/local/jabber/spool/msn-cookies.txt");
	curl_easy_setopt(curl, CURLOPT_FILE, (void *)&chunk);
	curl_easy_setopt(curl, CURLOPT_HEADER, TRUE);
	curl_easy_setopt(curl, CURLOPT_URL, url);
	curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, errorbuffer);
	if (ti->is_insecure == 1) {
		curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);
	}
	log_debug(ZONE,"Session[%s], Retrieving URL %s\nIf this is the last message you see, you have a problem with Curl",jid_full(s->id),url);
	res = curl_easy_perform(curl);
	log_debug(ZONE,"Session[%s], Finished Curl call",jid_full(s->id));
	if(res != CURLE_OK) {
		log_warn(ZONE,"CURL result=%d, CURL error message=%s",res,errorbuffer);
	}

	if(chunk.memory == 0 || strcmp(chunk.memory, "") == 0) {
		log_debug(ZONE,"Session[%s], No data for first SSL Auth, bailing out",jid_full(s->id));
		return;
	}

	log_debug(ZONE,"----First SSL Auth\nRetrieved data from: %s\nFor session: %s\n%s\nFirst SSL Auth----",url,jid_full(s->id),chunk.memory);

	// Ok, we now have to parse chunk.memory the cookies, and authdata for the new URL
	pos = findSubStr(chunk.memory, "Set-Cookie:", 0);
	if(pos == -1) return;
	pos += 12;
	pos2 = pos;
	for(i = 0; chunk.memory[pos] != '\r' && chunk.memory[pos] != '\n'; i++, pos++)
		cookies[i] = chunk.memory[pos];
	cookies[i] = ';';
	i++;
	pos = findSubStr(chunk.memory, "Set-Cookie:", pos2);
	if(pos == -1) return;
	pos += 12;
	for(; chunk.memory[pos] != '\r' && chunk.memory[pos] != '\n'; i++, pos++)
		cookies[i] = chunk.memory[pos];
	cookies[i] = 0;
	i++;

	pos = findSubStr(authdata, "lc=", 0);
	if(pos == -1) return;
	pos += 3;
	for(i = 0; authdata[pos] >= '0' && authdata[pos] <= '9'; i++, pos++)
		lc[i] = authdata[pos];
	lc[i] = 0;

	pos = findSubStr(authdata, "id=", 0);
	if(pos == -1) return;
	pos += 3;
	for(i = 0; authdata[pos] >= '0' && authdata[pos] <= '9'; i++, pos++)
		id[i] = authdata[pos];
	id[i] = 0;

	pos = findSubStr(authdata, "tw=", 0);
	if(pos == -1) return;
	pos += 3;
	for(i = 0; authdata[pos] >= '0' && authdata[pos] <= '9'; i++, pos++)
		tw[i] = authdata[pos];
	tw[i] = 0;

	pos = findSubStr(authdata, "kv=", 0);
	if(pos == -1) return;
	pos += 3;
	for(i = 0; authdata[pos] >= '0' && authdata[pos] <= '9'; i++, pos++)
		kv[i] = authdata[pos];
	kv[i] = 0;

	// Build the URL
	strcpy(url, "https://");
	strcat(url, passporthost);
	strcat(url, "/ppsecure/post.srf?");
	strcat(url, "lc=");
	strcat(url, lc);
	strcat(url, "&id=");
	strcat(url, id);
	strcat(url, "&tw=");
	strcat(url, tw);
	strcat(url, "&cbid=");
	strcat(url, id);
	strcat(url, "&da=passport.com&login=");
	strcat(url, s->user);
	strcat(url, "&domain=passport.com&passwd=");
	strcat(url, s->pass);
	strcat(url, "&sec=&mspp_shared=&padding=");

	// Free the memory again...
	free(chunk.memory);
	chunk.memory = 0;
	chunk.size = 0;

	// Grab the next page..
	curl_easy_setopt(curl, CURLOPT_URL, url);
	curl_easy_setopt(curl, CURLOPT_COOKIE, cookies);
	res = curl_easy_perform(curl);
	if(res != CURLE_OK) {
		log_warn(ZONE,"CURL result=%d, CURL error message=%s",res,errorbuffer);
	}

	if(chunk.memory == 0 || strcmp(chunk.memory, "") == 0) {
		log_debug(ZONE,"Session[%s], No data for second SSL Auth, bailing out",jid_full(s->id));
		return;
	}

	log_debug(ZONE,"----Second SSL Auth\nRetrieved data from: %s\nFor session: %s\n%s\nSecond SSL Auth----",url,jid_full(s->id),chunk.memory);

	// Now we need to search for the "&t="

	pos = findSubStr(chunk.memory, "did=1&t=", 0);
	if(pos == -1) // There was no token, so we return leaving tp blank
		return;
	pos += 6;
	for(i = 0; chunk.memory[pos] != '"'; i++, pos++){
		tp[i] = chunk.memory[pos];
	}
	tp[i] = 0;

//	printf("tp: %s\n\n", tp);

	curl_easy_cleanup(curl);
}

void mt_ns_rng(mpacket mp, session s)
{
    sbchat sc;
    char *user = mt_packet_data(mp,5);
    char *sid, *chal, *host, *port;

    sc = xhash_get(s->chats,user);  /* is there already is a SB session? */
    if (sc != NULL)
    {
        if (sc->state == sb_START)
        {
            log_debug(ZONE,"SB Session with '%s' already started",user);
            return;
        }

        log_debug(ZONE,"Replacing SB session");
        mt_chat_end(sc);
    }

    sid = mt_packet_data(mp,1);
    host = mt_packet_data(mp,2);
    chal = mt_packet_data(mp,4);
    port = strchr(host,':');

    if (port != NULL)
    {
        *port = '\0';
        port++;
    }

    mt_chat_join(s,user,host,j_atoi(port,1863),chal,sid);
}

void mt_ns_msg(mpacket mp, session s)
{
    xmlnode msg, oob;
    char *body, *ctype, *ptr;

    if (s->ti->inbox_headlines == 0)
        return;

    ctype = strchr(mt_packet_data(mp,5),':') + 2;
    body = mt_packet_data(mp,mp->count - 1);

    /* this message is a Hotmail inbox notification */
    if ((strncmp(ctype,"text/x-msmsgsinitialemailnotification",37) != 0) &&
        (strncmp(ctype,"application/x-msmsgsemailnotification",37) != 0))
        return;

    /* cut off the junk at the end */
    if ((ptr = strstr(body,"Inbox-URL")) != NULL)
        *ptr = '\0';

    msg = xmlnode_new_tag("message");
    xmlnode_put_attrib(msg,"to",jid_full(s->id));
    xmlnode_put_attrib(msg,"from",s->host);
    xmlnode_put_attrib(msg,"type","headline");

    xmlnode_insert_cdata(xmlnode_insert_tag(msg,"subject"),"Hotmail",-1);
    xmlnode_insert_cdata(xmlnode_insert_tag(msg,"body"),body,-1);

    oob = xmlnode_insert_tag(msg,"x");
    xmlnode_put_attrib(oob,"xmlns","jabber:x:oob");
    xmlnode_insert_cdata(xmlnode_insert_tag(oob,"url"),"http://www.hotmail.com/cgi-bin/folders",-1);
    xmlnode_insert_cdata(xmlnode_insert_tag(oob,"desc"),"Login to your Hotmail e-mail account",-1);

    mt_deliver(s->ti,msg);
}

void mt_ns_iln(mpacket mp, session s)
{
    mt_user_update(s,mt_packet_data(mp,3),
                   mt_packet_data(mp,2),
                   mt_packet_data(mp,4));
}

void mt_ns_nln(mpacket mp, session s)
{
    mt_user_update(s,mt_packet_data(mp,2),
                   mt_packet_data(mp,1),
                   mt_packet_data(mp,3));
}

void mt_ns_fln(mpacket mp, session s)
{
    muser u;

    u = mt_user(s,mt_packet_data(mp,1));
    u->state = ustate_fln;
    mt_user_sendpres(s,u);
}

result mt_ns_add(mpacket mp, void *arg)
{
    session s = (session) arg;
    char *cmd = mt_packet_data(mp,0);

    if (j_strcmp(cmd,"ADD") != 0)
    {
        if (j_strcmp(cmd,"ILN") == 0)
        {
            mt_ns_iln(mp,s);
            return r_PASS;
        }
    }
    else if (j_strcmp(mt_packet_data(mp,2),"RL") == 0)
    {
        char *user = mt_packet_data(mp,4);

        if (user != NULL)
        {
            muser u;

            u = mt_user(s,user);
            u->list = u->list | LIST_RL;
            mt_user_subscribe(s,u);
            return r_DONE;
        }
    }
    return r_ERR;
}

result mt_ns_rem(mpacket mp, void *arg)
{
    if (j_strcmp(mt_packet_data(mp,0),"REM") == 0 && j_strcmp(mt_packet_data(mp,2),"RL") == 0)
    {
        session s = (session) arg;
        char *user = mt_packet_data(mp,4);

        if (user != NULL)
        {
            muser u = mt_user(s,user);
            u->list ^= LIST_RL;
            mt_user_unsubscribe(s,u);
            return r_DONE;
        }
    }
    return r_ERR;
}

result mt_ns_usr_P(mpacket mp, void *arg)
{
    session s = (session) arg;
    char *cmd = mt_packet_data(mp,0);

    if (j_strcmp(cmd,"USR") == 0) /* auth was successful */
    {
        log_debug(ZONE,"Auth successful for '%s' ",s->user);

        if (s->type == stype_register)
        {
            jpacket jp = mt_jpbuf_de(s->buff);
            s->type = stype_normal;
            jp->aux1 = (void *) s;
            mtq_send(s->q,jp->p,&mt_reg_success,(void *) jp);
        }
        else
            mt_user_sync(s);
    }
    else if (j_atoi(cmd,0) == 911)
        mt_session_kill(s,TERROR_AUTH);
    else if (j_atoi(cmd,0) != 0)
    {
        mt_ns_close(s);
        mt_ns_reconnect(s);     /* some other wierd error, try again */
    }
    else
        return r_ERR;

    return r_DONE;
}

void mt_ns_xfr(mpacket mp, session s)
{
    if (j_strcmp(mt_packet_data(mp,2),"NS") == 0)
    {
        char *host = mt_packet_data(mp,3);
        char *port = strchr(host,':');

        if (port != NULL)
        {
            *port = '\0';
            ++port;
        }

        mt_ns_close(s);
        mt_ns_connect(s,host,j_atoi(port,1863));
    }
    else
    {
        log_debug(ZONE,"Session[%s], NS XFR Error, %s",jid_full(s->id),mt_packet_data(mp,2));
    }
}

result mt_ns_usr_I(mpacket mp, void *arg)
{
    session s = (session) arg;
    char *cmd =  mt_packet_data(mp,0);

    if (j_strcmp(cmd,"USR") == 0)
    {
        char tp[500];
        char *authdata = mt_packet_data(mp,4);

        mt_ssl_auth(s, authdata, tp);

        if(strcmp(tp, "") == 0) {
            mt_session_kill(s,TERROR_EXTERNAL);
            return r_ERR;
        }

        mt_stream_register(s->st,&mt_ns_usr_P,(void *) s);
        mt_cmd_usr_P(s->st,tp);
    }
    else if (j_strcmp(cmd,"XFR") == 0)
        mt_ns_xfr(mp,s);
    else if (j_atoi(cmd,0) == 911)
        mt_session_kill(s,(terror) {406,"Invalid Username"});/* 911 at this point means the username doesn't exit */
    else if (j_atoi(cmd,0) != 0)
        mt_session_kill(s,TERROR_EXTERNAL);
    else
        return r_ERR;

    return r_DONE;
}

result mt_ns_cvr(mpacket mp, void *arg)
{
    session s = (session) arg;

    if (j_strcmp(mt_packet_data(mp,0),"CVR") == 0)
    {
        mt_stream_register(s->st,&mt_ns_usr_I,(void *) s);
        mt_cmd_usr_I(s->st,s->user);
        return r_DONE;
    }
    return r_ERR;
}

result mt_ns_ver(mpacket mp, void *arg)
{
    session s = (session) arg;
    char *cmd = mt_packet_data(mp,0);

    if (j_strcmp(cmd,"VER") == 0)
    {
        mt_stream_register(s->st,&mt_ns_cvr,(void *) s);
        mt_cmd_cvr(s->st, s->user);
    }
    else if (j_atoi(cmd,0) != 0)
    {
        /* The server is probably down */
        log_debug(ZONE,"Session[%s], Error code %s, retrying",jid_full(s->id),cmd);
        mt_ns_close(s);
        mt_ns_reconnect(s);
    }
    else
        return r_ERR;

    return r_DONE;
}

void mt_ns_end_rooms(xht h, const char *key, void *val, void *arg)
{
    sbroom r = (sbroom) val;

    if (r->st == NULL)
    { /* free any sessions waiting for an XFR now, since it won't be received */
        mt_con_remove(r);
        mt_con_free(r);
    }
    else
        mt_con_end(r);
}

void mt_ns_end_chats(xht h, const char *key, void *val, void *arg)
{
    sbchat sc = (sbchat) val;

    if (sc->st == NULL)
    {
        mt_chat_remove(sc);
        mt_chat_free(sc);
    }
    else
        mt_chat_end(sc);
}

void mt_ns_end_sbs(session s)
{
    if (s->chats != NULL)
        xhash_walk(s->chats,&mt_ns_end_chats,NULL);

    if (s->rooms != NULL)
        xhash_walk(s->rooms,&mt_ns_end_rooms,NULL);
}

void mt_ns_chl(mpacket mp, void *arg)
{
    session s = (session) arg;
    char *chalstr;
    char result[50];

    chalstr = mt_packet_data(mp,2);
    mt_md5hash(chalstr, "VT6PX?UQTM4WM%YR", result);

    mt_cmd_qry(s->st, result);
}

result mt_ns_packets(mpacket mp, void *arg)
{
    session s = (session) arg;

    if (mp == NULL)
    {
        s->connected = 0;
        s->st = NULL;
        mt_ns_end_sbs(s);

        if (s->exit_flag == 0)
        {
            log_debug(ZONE,"Session[%s], MSN server connection closed",jid_full(s->id));
            mt_ns_reconnect(s);
        }

        SREF_DEC(s);
    }
    else if (s->exit_flag == 0)
    {
        char *cmd = mt_packet_data(mp,0);

        if (j_strcmp(cmd,"NLN") == 0)
            mt_ns_nln(mp,s);
        else if (j_strcmp(cmd,"FLN") == 0)
            mt_ns_fln(mp,s);
        else if (j_strcmp(cmd,"ADD") == 0)
            mt_ns_add(mp,arg);
        else if (j_strcmp(cmd,"REM") == 0)
            mt_ns_rem(mp,arg);
        else if (j_strcmp(cmd,"RNG") == 0)
            mt_ns_rng(mp,s);
        else if (j_strcmp(cmd,"XFR") == 0)
            mt_ns_xfr(mp,s);
        else if (j_strcmp(cmd,"MSG") == 0)
            mt_ns_msg(mp,s);
        else if (j_strcmp(cmd,"ILN") == 0)
            mt_ns_iln(mp,s);
        else if (j_strcmp(cmd,"LST") == 0)
            mt_user_syn(mp,s);
        else if (j_strcmp(cmd,"CHL") == 0)
            mt_ns_chl(mp,s);
        else if (j_strcmp(cmd,"OUT") == 0)
        {
            s->connected = 0;
            if (j_strcmp(mt_packet_data(mp,1),"OTH") == 0)
                mt_session_kill(s,(terror){409,"Session was replaced"});
            else
                mt_session_kill(s,TERROR_EXTERNAL);
        }
        else if (j_strcmp(cmd,"REA") && j_strcmp(cmd,"CHG"))
            return r_ERR;
    }

    return r_DONE;
}

result mt_ns_closed(mpacket mp, void *arg)
{
    if (mp == NULL)
    {
        session s = (session) arg;
        mt_ns_end_sbs(s);
        SREF_DEC(s);
    }
    return r_DONE;
}

void mt_ns_close(session s)
{
    mpstream st = s->st;

    s->st = NULL;
    s->connected = 0;
    st->cb = &mt_ns_closed;
    mt_stream_close(st);
}

void mt_ns_reconnect(session s)
{
    log_debug(ZONE,"Session[%s] reconnecting",jid_full(s->id));

    if (s->attemps < s->ti->attemps_max)
    {
        ++s->attemps;
        mt_ns_start(s);
    }
    else
    {
        log_debug(ZONE,"Session[%s], connection attempts reached max",jid_full(s->id));
        mt_session_kill(s,TERROR_EXTERNAL);
    }
}

void mt_ns_connect(session s, char *server, int port)
{
    mti ti = s->ti;
    mpstream st;

    assert(s->st == NULL);

    log_debug(ZONE,"Session[%s], connecting to NS %s",jid_full(s->id),server);

    SREF_INC(s);

    st = s->st = mt_stream_connect(server,port,&mt_ns_packets,(void *) s);
    mt_stream_register(st,&mt_ns_ver,(void *) s);
    mt_cmd_ver(st);
}

void mt_ns_start(session s)
{
    mti ti = s->ti;
    char *server = ti->servers[ti->cur_server++];

    if (server == NULL)
    {
        server = ti->servers[0];
        ti->cur_server = 0;
    }

    mt_ns_connect(s,server,1863);
}
