/*  Copyright (C) 2003-2011 JabRef contributors.
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
package net.sf.jabref;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

/**
 * @author sarahspi
 *
 */
public class IconStringRenderer extends DefaultTableCellRenderer {

    String toolTip;

    public IconStringRenderer(String toolTip) {
	this.toolTip = toolTip;
    }

	  /*
	   * @see TableCellRenderer#getTableCellRendererComponent(JTable, Object, boolean, boolean, int, int)
	   */
	  public Component getTableCellRendererComponent(JTable table, Object value,
	                                                 boolean isSelected, boolean hasFocus, 
	                                                 int row, int column) {
	  	JLabel retval = (JLabel) super.getTableCellRendererComponent(table, value, isSelected, hasFocus,row,column);	  	
	  	if (value instanceof JLabel) {
	  		retval.setText(((JLabel)value).getText());
	  		retval.setIcon(((JLabel)value).getIcon());
	  		retval.setToolTipText(toolTip);
	  	}
	    return retval;
	  }
	
}
