#ifndef _JACK_C
#define _JACK_C

#include <unistd.h>
#include <sys/types.h>
#include <stdio.h>
#include <jack/jack.h>
#include <jack/ringbuffer.h>
#include "file.c"

typedef jack_default_audio_sample_t sample_t ;

void
jack_make_standard_ports ( jack_client_t *client , jack_port_t **ports , int n , int output ) 
{
  int i ;
  for ( i = 0 ; i < n ; i++ ) {
    char name[64] ;
    snprintf ( name , 64 , output ? "out_%d" : "in_%d" , i + 1 ) ;    
    ports[i] = jack_port_register ( client , name , JACK_DEFAULT_AUDIO_TYPE ,
				    output ? JackPortIsOutput : JackPortIsInput , 0 ) ;
    if ( ! ports[i] ) {
      fprintf ( stderr , "jack_port_register() failed\n" ) ;
      FAILURE ;
    }
  }
}

jack_client_t *
jack_client_uniq ( const char *name )
{
  int n = (int) getpid () ;
  char uniq[64] ;
  snprintf ( uniq , 64 , "%s-%d" , name , n ) ;
  jack_client_t *client = jack_client_new ( uniq ) ;
  if ( ! client ) {
    fprintf ( stderr , "jack_client_new() failed: %s\n" , uniq ) ;
    FAILURE ;
  }
  return client ;
}

int
jack_ringbuffer_wait_for_write ( jack_ringbuffer_t *r , int nbytes , int fd )
{
  int space = ( int ) jack_ringbuffer_write_space ( r ) ;
  while ( space < nbytes ) {
    char b ;
    xread ( fd , &b , 1 ) ;
    space = ( int ) jack_ringbuffer_write_space ( r ) ;
  }
  return space ;
}

void
jack_minimal_error_handler ( const char *desc )
{
  fprintf ( stderr , "jack error: %s\n" , desc ) ;
}

void
jack_minimal_shutdown_handler ( void *arg )
{
  fprintf ( stderr , "jack shutdown\n") ;
  FAILURE ;
}

int 
xjack_activate ( jack_client_t *client )
{
  int err = jack_activate ( client ) ;
  if ( err ) {
    fprintf ( stderr , "jack_activate() failed\n" ) ;
    FAILURE ;
  }
  return err ;
}

#endif
