#ifndef _SOUND_FILE_C
#define _SOUND_FILE_C

#include <sndfile.h>

SNDFILE * 	
xsf_open ( const char *path , int mode , SF_INFO *sfinfo )
{
  SNDFILE *s = sf_open ( path , mode , sfinfo ) ;
  if ( ! s ) {
    fprintf ( stderr , "sf_open() failed\n" ) ;
    sf_perror ( s ) ;
    FAILURE ;
  }
  return s ;
}

void
xsf_handle_error ( SNDFILE *sndfile )
{
  int errnum = sf_error ( sndfile ) ;
  const char *errstr = sf_error_number ( errnum ) ;
  fprintf ( stderr , "sndlib failed: %s\n" , errstr ) ;
  FAILURE ;
}

sf_count_t	
xsf_read_float ( SNDFILE *sndfile , float *ptr , sf_count_t items )
{
  sf_count_t err = sf_read_float ( sndfile , ptr , items ) ;
  if ( err < 0 ) {
    xsf_handle_error ( sndfile ) ;
  }
  return err ;
}

#endif
