/*
 *   Jackbeat - JACK sequencer
 *    
 *   Copyright (c) 2004-2005 Olivier Guilyardi <olivier@samalyse.com>
 *    
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <string.h>

#include "error.h"


char * error_to_string (int code)
{
  char *error_string;
  switch (code)
   {
    case ERR_SEQUENCE_MSQ :
     error_string = strdup ("Unable to allocate a new message queue. You may need" 
                            "to increase the MSGMNI Linux kernel parameter.");
     break;
    case ERR_SEQUENCE_JACK_CONNECT :
     error_string = strdup ("Unable to get on air. Is the JACK server up ?");
     break;
    case ERR_SEQUENCE_JACK_ACTIVATE :
     error_string = strdup ("Unable to activate the JACK client.");
     break;
    case ERR_JAB_XML :
     error_string = strdup ("The XML definition of your .jab file seems "
                            "corrupted. The operation can't complete.");
     break;
    case ERR_SEQUENCE_INTERNAL :
    default:
     error_string = strdup ("Sorry, an internal error occured. The operation can't" 
                            "complete.");
     break;
   }
  return error_string;
}
