#!/bin/sh

set -e 

# version 2.5.0+cvs means cvs snapshot sometime after 2.5.0 is released, but
# before 2.5.1
VERSION=2.6.0.1
APIVERSION=2.6

GTKVERSION=2.4.0.1
GTKAPIVERSION=2.4

VTEVERSION=0.11.10
VTEAPIVERSION=0.11



JAVADOC=javadoc

COMMON_DOCS="AUTHORS COPYING INSTALL NEWS README TODO THANKS"

if test ! -e tmp/java-gnome/; 
then
echo "You MUST run this script from a directory where a clean cvs checkout of
java-gnome can be found in tmp/java-gnome.";
exit 9;
fi;


cd tmp
cd java-gnome
make maintainer-clean || true
rm `find -name *.class` || true
rm `find -name *.o` || true
rm `find -name *.so.*` || true
rm `find -name *.jar` || true
cd ..

#cvs -d $CVSROOT co java-gnome

cd java-gnome
./genMakefile.in
./genConfigure.in
autoconf
cd ../

cp -r java-gnome java-gnome-$VERSION
cd  java-gnome-$VERSION
rm -rf `find -name "CVS"`

### IF YOU MODIFY JAVADOC CREATION, PLEASE ALSO MODIFY IT IN THE
###   doc-X/Makefile.in.in files.
JAVADOC_OPTIONS="-public -use -version -author"
mkdir -pv doc-core/api || true
rm -rf doc-core/api/* || true
$JAVADOC \
	-d doc-core/api \
	-sourcepath gtk/src/java:gdk/src/java:glib/src/java:pango/src/java:atk/src/java: \
	$JAVADOC_OPTIONS \
	-windowtitle "Java-Gnome $VERSION API Reference" \
	-doctitle "Java-Gnome $VERSION API Reference" \
	-footer "Please send any bug reports, comments, or suggestions for the API or documentation to <a href=\"mailto:java-gnome-developer@lists.sf.net\">java-gnome-developer@lists.sf.net</a>" \
	org.gnu.glib \
	org.gnu.pango \
	org.gnu.atk \
	org.gnu.gdk \
	org.gnu.gtk \
	org.gnu.gtk.event 
mkdir -pv doc-gnome/api || true
rm -rf doc-gnome/api/* || true
$JAVADOC \
	-d doc-gnome/api \
	-sourcepath gnome/src/java/:gtk/src/java:gdk/src/java:glib/src/java:pango/src/java:atk/src/java:  \
	$JAVADOC_OPTIONS \
	-windowtitle "Java-Gnome $VERSION GNOME API Reference" \
	-doctitle "Java-Gnome $VERSION GNOME API Reference" \
	-footer "Please send any bug reports, comments, or suggestions for the API or documentation to <a href=\"mailto:java-gnome-developer@lists.sf.net\">java-gnome-developer@lists.sf.net</a>" \
	-linkoffline /usr/local/doc/java-gnome-$APIVERSION/api/gtk/ doc-core/api/ \
	org.gnu.gnome \
	org.gnu.gnome.event
mkdir -pv doc-glade/api || true
rm -rf doc-glade/api/* || true
$JAVADOC \
	-d doc-glade/api \
	-sourcepath glade/src/java/:gnome/src/java/:gtk/src/java:gdk/src/java:glib/src/java:pango/src/java:atk/src/java:  \
	$JAVADOC_OPTIONS \
	-windowtitle "Java-Gnome $VERSION GLADE API Reference" \
	-doctitle "Java-Gnome $VERSION GLADE API Reference" \
	-footer "Please send any bug reports, comments, or suggestions for the API or documentation to <a href=\"mailto:java-gnome-developer@lists.sf.net\">java-gnome-developer@lists.sf.net</a>" \
	org.gnu.glade
	
	
cd ..

for DOC in $COMMON_DOCS; do
	cp java-gnome/common/$DOC java-gnome-$VERSION;
done;

tar -cjf java-gnome-$VERSION.tar.bz2 java-gnome-$VERSION
md5sum java-gnome-$VERSION.tar.bz2 > release-$VERSION.md5


echo --------------------------------------------------------------------------------
echo ---- Creating libgtk-java-$GTKVERSION.tar.bz2

mkdir libgtk-java-$GTKVERSION
for F in glib gdk gtk pango atk; do \
	cp -r java-gnome/$F libgtk-java-$GTKVERSION;
done;
# copy configure scripts
cp -r java-gnome-$VERSION/build/libgtk-java/* libgtk-java-$GTKVERSION
cp java-gnome-$VERSION/aclocal.m4 libgtk-java-$GTKVERSION
cp java-gnome-$VERSION/install-sh libgtk-java-$GTKVERSION

cd libgtk-java-$GTKVERSION
autoconf
cd ..

for DOC in $COMMON_DOCS; do
	cp java-gnome/common/$DOC libgtk-java-$GTKVERSION;
done;

tar -cjf libgtk-java-$GTKVERSION.tar.bz2 libgtk-java-$GTKVERSION
md5sum libgtk-java-$GTKVERSION.tar.bz2 >> release-$VERSION.md5


for MODULE in gnome gconf gtkhtml; 
do
echo --------------------------------------------------------------------------------
echo ---- Creating lib$MODULE-java-$VERSION.tar.bz2
cp -r java-gnome/$MODULE lib$MODULE-java-$VERSION
cp java-gnome-$VERSION/aclocal.m4 lib$MODULE-java-$VERSION
cp java-gnome-$VERSION/install-sh lib$MODULE-java-$VERSION
cd lib$MODULE-java-$VERSION
autoconf
cd ..
for DOC in $COMMON_DOCS; do
	cp java-gnome/common/$DOC lib$MODULE-java-$VERSION;
done;
tar -cjf lib$MODULE-java-$VERSION.tar.bz2 lib$MODULE-java-$VERSION
md5sum lib$MODULE-java-$VERSION.tar.bz2 >> release-$VERSION.md5
done;

for MODULE in glade; 
do
echo --------------------------------------------------------------------------------
echo ---- Creating lib$MODULE-java-$GTKVERSION.tar.bz2
cp -r java-gnome/$MODULE lib$MODULE-java-$GTKVERSION
cp java-gnome-$VERSION/aclocal.m4 lib$MODULE-java-$GTKVERSION
cp java-gnome-$VERSION/install-sh lib$MODULE-java-$GTKVERSION
cd lib$MODULE-java-$GTKVERSION
autoconf
cd ..
for DOC in $COMMON_DOCS; do
	cp java-gnome/common/$DOC lib$MODULE-java-$GTKVERSION;
done;
tar -cjf lib$MODULE-java-$GTKVERSION.tar.bz2 lib$MODULE-java-$GTKVERSION
md5sum lib$MODULE-java-$GTKVERSION.tar.bz2 >> release-$VERSION.md5
done;

for MODULE in vte; 
do
echo --------------------------------------------------------------------------------
echo ---- Creating lib$MODULE-java-$VTEVERSION.tar.bz2
cp -r java-gnome/$MODULE lib$MODULE-java-$VTEVERSION
cp java-gnome-$VERSION/aclocal.m4 lib$MODULE-java-$VTEVERSION
cp java-gnome-$VERSION/install-sh lib$MODULE-java-$VTEVERSION
cd lib$MODULE-java-$VTEVERSION
autoconf
cd ..
for DOC in $COMMON_DOCS; do
	cp java-gnome/common/$DOC lib$MODULE-java-$VTEVERSION;
done;
tar -cjf lib$MODULE-java-$VTEVERSION.tar.bz2 lib$MODULE-java-$VTEVERSION
md5sum lib$MODULE-java-$VTEVERSION.tar.bz2 >> release-$VERSION.md5
done;


for MODULE in doc-core doc-gnome doc-glade; 
do
echo --------------------------------------------------------------------------------
echo ---- Creating $MODULE-java-$VERSION.tar.bz2

cp -r java-gnome/$MODULE java-gnome-$MODULE-$VERSION
cp java-gnome-$VERSION/aclocal.m4 java-gnome-$MODULE-$VERSION
cp java-gnome-$VERSION/install-sh java-gnome-$MODULE-$VERSION
cd java-gnome-$MODULE-$VERSION
autoconf
cd ..

for DOC in $COMMON_DOCS; do
	cp java-gnome/common/$DOC java-gnome-$MODULE-$VERSION;
done;

tar -cjf java-gnome-$MODULE-$VERSION.tar.bz2 java-gnome-$MODULE-$VERSION
md5sum java-gnome-$MODULE-$VERSION.tar.bz2 >> release-$VERSION.md5

done;


ls . 
cat release-$VERSION.md5

