/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>

#ifndef _Included_org_gnu_gdk_Screen
#define _Included_org_gnu_gdk_Screen
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1type
  (JNIEnv *env, jclass cls)
{
	return (jint)gdk_screen_get_type();
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_default_colormap
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1default_1colormap
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_default_colormap((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_set_default_colormap
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1set_1default_1colormap
  (JNIEnv *env, jclass cls, jint screen, jint colormap)
{
	gdk_screen_set_default_colormap((GdkScreen*)screen, (GdkColormap*)colormap);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_system_colormap
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1system_1colormap
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_system_colormap((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_system_visual
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1system_1visual
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_system_visual((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_rgb_colormap
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1rgb_1colormap
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_rgb_colormap((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_rgb_visual
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1rgb_1visual
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_rgb_visual((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_root_window
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1root_1window
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_root_window((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_display
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1display
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_display((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_number
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1number
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_number((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_height
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1height
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_height((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_width
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1width
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_width((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_height_mm
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1height_1mm
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_height_mm((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_width_mm
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1width_1mm
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_width_mm((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_list_visuals
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1list_1visuals
  (JNIEnv *env, jclass cls, jint screen)
{
	GList* list;
	GList* item;
	jintArray array;
	guint len;
	guint index;
	
	list = gdk_screen_list_visuals((GdkScreen*)screen);
	if (NULL == list)
		return NULL;
	len = g_list_length(list);
	array = (*env)->NewIntArray(env, len);
	for (index = 0; index < len; index++) {
		item = g_list_nth(list, index);
		(*env)->SetIntArrayRegion(env, array, index, len, (jint*)(GdkVisual*)item->data);
	}
	return array;
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_toplevel_windows
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1toplevel_1windows
  (JNIEnv *env, jclass cls, jint screen)
{
	GList* list;
	GList* item;
	jintArray array;
	guint len;
	guint index;
	
	list = gdk_screen_get_toplevel_windows((GdkScreen*)screen);
	if (NULL == list)
		return NULL;
	len = g_list_length(list);
	array = (*env)->NewIntArray(env, len);
	for (index = 0; index < len; index++) {
		item = g_list_nth(list, index);
		(*env)->SetIntArrayRegion(env, array, index, len, (jint*)(GdkWindow*)item->data);
	}
	return array;
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_make_display_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1make_1display_1name
  (JNIEnv *env, jclass cls, jint screen)
{
	gchar* name = gdk_screen_make_display_name((GdkScreen*)screen);
	return (*env)->NewStringUTF(env, name);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_n_monitors
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1n_1monitors
  (JNIEnv *env, jclass cls, jint screen)
{
	return (jint)gdk_screen_get_n_monitors((GdkScreen*)screen);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_monitor_geometry
 * Signature: (II[I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1monitor_1geometry
  (JNIEnv *env, jclass cls, jint screen, jint monitorNum, jintArray rect)
{
	GdkRectangle* r = (GdkRectangle*)(*env)->GetIntArrayElements(env, rect, NULL);
	gdk_screen_get_monitor_geometry((GdkScreen*)screen, (gint)monitorNum, r);
	(*env)->ReleaseIntArrayElements(env, rect, (jint*)r, 0);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_monitor_at_point
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1monitor_1at_1point
  (JNIEnv *env, jclass cls, jint screen, jint x, jint y)
{
	return (jint)gdk_screen_get_monitor_at_point((GdkScreen*)screen, (gint)x, (gint)y);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_monitor_at_window
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1monitor_1at_1window
  (JNIEnv *env, jclass cls, jint screen, jint window)
{
	return (jint)gdk_screen_get_monitor_at_window((GdkScreen*)screen, (GdkWindow*)window);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_broadcast_client_message
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1broadcast_1client_1message
  (JNIEnv *env, jclass cls, jint screen, jint event)
{
	gdk_screen_broadcast_client_message((GdkScreen*)screen, (GdkEvent*)event);
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_default
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1default
  (JNIEnv *env, jclass cls)
{
	return (jint)gdk_screen_get_default();
}

/*
 * Class:     org_gnu_gdk_Screen
 * Method:    gdk_screen_get_setting
 * Signature: (ILjava/lang/String;I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Screen_gdk_1screen_1get_1setting
  (JNIEnv *env, jclass cls, jint screen, jstring name, jint value)
{
	const gchar* n = (*env)->GetStringUTFChars(env, name, NULL);
	jboolean bool = (jboolean)gdk_screen_get_setting((GdkScreen*)screen, n, (GValue*)value);
	(*env)->ReleaseStringUTFChars(env, name, n);
	return bool;
}

#ifdef __cplusplus
}
#endif
#endif
