/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.glib;

/**
 * Base class for all classes resulting from a <code>define-boxed</code>
 * in a <code>.defs</code> file.
 */
public class Boxed {
	/** holder for the raw GLib/GTK pointer */
	protected int handle;

	/**
	 * This class is only instantiable via subclasses.
	 */
	protected Boxed() {
		// nothing to do
	}

	/**
	 * Get the raw handle value.
	 * @return the handle value.
	 */
	public final int getHandle() {
		return handle;
	}

	/**
	 * Check if two objects refer to the same (native) object.
	 *
	 * @param other the reference object with which to compare.
	 * @return true if both objects refer to the same object.
	 */
	public boolean equals( Object other ){
		return other instanceof Boxed && handle == ((Boxed) other).getHandle();
	}
	
	/**
	 * Returns a hash code value for the object. This allows for
	 * using Boxed objects as keys in hashmaps.
	 *
	 * @return a hash code value for the object.
	 */
	public int hashCode() {
		return getHandle();
	 }
}
