/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.Boxed;
public class Util extends Boxed {
	/**
	 * Pass in a string, and it will prepend $HOME/.gnome2/ to it.
	 */
	static String getHomeFile(String afile) {
		return gnome_util_home_file(afile);
	}

	/**
	 * Returns the name of the user's shell.
	 */
	static String getUserShell() {
		return gnome_util_user_shell();
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected String gnome_util_home_file(String afile);
	native static final protected String gnome_util_user_shell();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
