/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
/**
 * This interface is used in combination with some methods of this class to
 * iterate over a number of items in the selection. 
 * @see TreeSelection#forEachSelected(TreeSelectionForEach)
 */
public interface TreeSelectionForEach {
	/**
	 * This is called for each of the items.
	 * @param model The TreeModel being viewed
	 * @param path The TreePath of a selected row
	 * @param iter A TreeIter pointing to a selected row
	 */
	public void forEach(TreeModel model, TreePath path, TreeIter iter);
}


