
package org.gnu.gtk.event;

/**
 * Represents a particular type of an event. Each {@link GtkEvent} has an
 * associated type. 
 */
public class GtkEventType{
	/** Event type identifier */
	private int id;

	/** Name for the event type. This is used in the event.toString method */
	private String name;

	/**
	 * @return {@link #id}
	 */
	public int getID(){
		return id;
	}

	/**
	 * @return {@link #name}
	 */
	public String getName(){
		return name;
	}

	/**
	 * Constructs a new event type
	 * @param typeID Type Identifier
	 * @param typeName String to be displayed as part of the event.toString
	 * method.
	 */
	public GtkEventType(int typeID, String typeName){
		id = typeID;
		name = typeName;
	}
}
