/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
	
/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    getSelection
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_SelectionData_getSelection
  (JNIEnv *env, jclass cls, jint data)
{
	return (jint)((GtkSelectionData*)data)->selection;
}
                                                                                
/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    getTarget
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_SelectionData_getTarget
  (JNIEnv *env, jclass cls, jint data)
{
	return (jint)((GtkSelectionData*)data)->target;
}
                                                                                
/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    getType
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_SelectionData_getType
  (JNIEnv *env, jclass cls, jint data)
{
	return (jint)((GtkSelectionData*)data)->type;
}
                                                                                
/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    getFormat
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_SelectionData_getFormat
  (JNIEnv *env, jclass cls, jint data)
{
	return (jint)((GtkSelectionData*)data)->format;
}
                                                                                
/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    getData
 * Signature: (I)/java/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_SelectionData_getData
  (JNIEnv *env, jclass cls, jint data)
{
	return (*env)->NewStringUTF(env, ((GtkSelectionData*)data)->data);
}

/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    getLength
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_SelectionData_getLength
	(JNIEnv *env, jclass cls, jint sel) 
{
	GtkSelectionData *sel_g = (GtkSelectionData *) sel;
	return (jint) sel_g->length;
}

/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    getDisplay
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_SelectionData_getDisplay
  (JNIEnv *env, jclass cls, jint data)
{
	return (jint)((GtkSelectionData*)data)->display;
}

/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    gtk_selection_data_get_text
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gtk_SelectionData_gtk_1selection_1data_1get_1text
	(JNIEnv *env, jclass cls, jint sel) 
{
	guchar *txt;
	jstring retval;
	txt = gtk_selection_data_get_text ( (GtkSelectionData *) sel);
	if (txt != NULL){
		retval = (*env)->NewStringUTF( env, txt );
		g_free(txt);
	}else
		retval = (*env)->NewStringUTF( env, "" );
	return retval;
}

/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    gtk_selection_data_set_text
 * Signature: (ILjava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_SelectionData_gtk_1selection_1data_1set_1text
	(JNIEnv *env, jclass cls, jint sel, jstring text) 
{
	const gchar * text_g = (*env)->GetStringUTFChars(env, text, NULL);
	jboolean retval =  (jboolean) gtk_selection_data_set_text( (GtkSelectionData *) sel, text_g, -1 );
	(*env)->ReleaseStringUTFChars( env, text, text_g );
	return retval;
}

/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    gtk_selection_data_get_targets
 * Signature: (I)[I
 */
JNIEXPORT jintArray JNICALL Java_org_gnu_gtk_SelectionData_gtk_1selection_1data_1get_1targets
  (JNIEnv *env, jclass cls, jint data)
{
	gboolean success;
	GdkAtom** entries = NULL;
	gint numEntries;
	int index;
	jintArray array;
	
	success = gtk_selection_data_get_targets((GtkSelectionData*)data, entries, &numEntries);
	if (FALSE == success)
		return NULL;
	array = (*env)->NewIntArray(env, numEntries);
	for (index = 0; index < numEntries; index++) {
		(*env)->SetIntArrayRegion(env, array, index, 1, (jint*)entries[index]);		
	}
	return array;
}
                                                                                
/*
 * Class:     org_gnu_gtk_SelectionData
 * Method:    gtk_selection_data_targets_include_text
 * Signature: (I)Z
 */ JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_SelectionData_gtk_0selection_1data_1targets_1include_1text
  (JNIEnv *env, jclass cls, jint data)
{
	return (jboolean)gtk_selection_data_targets_include_text((GtkSelectionData*)data);
}
                                                                                


#ifdef __cplusplus
}

#endif
